/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3d;
import pyrosim.PyroSim;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.APyroTool;
import pyrosim.mv.tools.DefaultIsectFilter;
import pyrosim.mv.tools.DrawProps;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;

public abstract class ADrawTool
extends APyroTool
implements ValueEditor.IListener {
    private final List<Listener> d_listeners = new ArrayList<Listener>();

    public ADrawTool(IToolController iToolController, DrawProps drawProps, DrawProps.GeomSpace geomSpace) {
        this(iToolController, drawProps, new APyroTool.ToolFunc(), geomSpace);
    }

    public ADrawTool(IToolController iToolController, DrawProps drawProps, IToolFunction iToolFunction, DrawProps.GeomSpace geomSpace) {
        super(iToolController, drawProps, iToolFunction);
        drawProps.set(DrawProps.GEOM_SPACE, geomSpace);
        this.setSnapInfo(SnapMode.FILTERED_ONE_PASS, ADrawTool.getDefaultFilter());
        drawProps.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ADrawTool.this.fireUpdateProps();
            }
        });
    }

    public static DefaultIsectFilter getDefaultFilter() {
        DefaultIsectFilter defaultIsectFilter = new DefaultIsectFilter();
        defaultIsectFilter.obj = object -> TVEntryPoints.ep(object).isDrawingSnappable(PyroSim.getApp().getMediator(), object);
        return defaultIsectFilter;
    }

    public abstract Class<? extends IGeom> getGeomType();

    @Override
    public Point3d getAngledSnapBasis() {
        return this.getClickHistory().getLastCommitted();
    }

    public void addListener(Listener listener) {
        if (!this.d_listeners.contains(listener)) {
            this.d_listeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        this.d_listeners.remove(listener);
    }

    protected void fireRemove(int n) {
        for (Listener listener : this.d_listeners) {
            listener.remove(n);
        }
    }

    protected void fireUpdate(int n, IGeomNode iGeomNode, IPropsSrc iPropsSrc) {
        for (Listener listener : this.d_listeners) {
            listener.updateGeom(n, iGeomNode, iPropsSrc);
        }
    }

    protected void fireUpdateProps() {
        for (Listener listener : this.d_listeners) {
            listener.updateProps();
        }
    }

    protected void fireFinish(boolean bl) {
        for (Listener listener : this.d_listeners) {
            listener.finish(bl);
        }
    }

    protected boolean useQuickRepaint() {
        return true;
    }

    @Override
    public void finish() {
        this.reset();
        super.finish();
    }

    @Override
    public void cancel() {
        this.reset();
        super.cancel();
    }

    @Override
    protected void initValueEditor(ValueEditor valueEditor) {
        ValueEditorUtil.configure(valueEditor, "LOCATION", "OFFSET");
    }

    @Override
    protected String getStatusMessage() {
        return this.getValueEditor().getStatusMessage();
    }

    public static interface Listener {
        public void updateGeom(int var1, IGeomNode var2, IPropsSrc var3);

        public void updateProps();

        public void remove(int var1);

        public void finish(boolean var1);
    }
}

