/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.snappers;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.mv.snappers.IGridSnapper;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.GridSnapperDisp;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.Pair;

public class SnapToGrid
extends GridSnapperDisp
implements IGridSnapper,
Modifiable {
    private static final long serialVersionUID = 208355739999371334L;
    private View d_view;
    private boolean d_modified = false;

    public SnapToGrid(View view, double d) {
        super(d);
        this.d_view = view;
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.d_modified = bl;
    }

    @Override
    public AABox getBounds() {
        return new AABox(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        boolean bl = iIsectFilter.acceptGeomType(this, GeomType.EDGE);
        boolean bl2 = iIsectFilter.acceptGeomType(this, GeomType.VERTEX);
        if (!bl && !bl2) {
            return;
        }
        int n = Util3D.getClosestAxis(vector3d);
        if (bl) {
            this.getClosestPoints(iIsectCollector, GeomType.EDGE, n, point3d, point3d2, vector3d);
        }
        if (bl2) {
            this.getClosestPoints(iIsectCollector, GeomType.VERTEX, n, point3d, point3d2, vector3d);
        }
    }

    private void getClosestPoints(IIsectCollector iIsectCollector, GeomType geomType, int n, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        switch (n) {
            case 0: {
                iIsectCollector.addInfinite(this, this.getXPlaneSnapPoint(geomType, point3d, point3d2, vector3d), geomType, null);
                break;
            }
            case 1: {
                iIsectCollector.addInfinite(this, this.getYPlaneSnapPoint(geomType, point3d, point3d2, vector3d), geomType, null);
                break;
            }
            case 2: {
                iIsectCollector.addInfinite(this, this.getZPlaneSnapPoint(geomType, point3d, point3d2, vector3d), geomType, null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public Point3d getXPlaneSnapPoint(GeomType geomType, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Point3d point3d3 = new Point3d();
        if (!Inter3D.lineXPlaneIntersection(point3d3, point3d, vector3d, 0.0, 0.0)) {
            return null;
        }
        Point2d point2d = this.getPlaneSnapPoint(geomType, point3d3.y, point3d3.z);
        return point2d == null ? null : new Point3d(point3d3.x, point2d.x, point2d.y);
    }

    public Point3d getYPlaneSnapPoint(GeomType geomType, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Point3d point3d3 = new Point3d();
        if (!Inter3D.lineYPlaneIntersection(point3d3, point3d, vector3d, 0.0, 0.0)) {
            return null;
        }
        Point2d point2d = this.getPlaneSnapPoint(geomType, point3d3.x, point3d3.z);
        return point2d == null ? null : new Point3d(point2d.x, point3d3.y, point2d.y);
    }

    public Point3d getZPlaneSnapPoint(GeomType geomType, Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Point3d point3d3 = new Point3d();
        if (!Inter3D.lineZPlaneIntersection(point3d3, point3d, vector3d, 0.0, 0.0)) {
            return null;
        }
        Point2d point2d = this.getPlaneSnapPoint(geomType, point3d3.x, point3d3.y);
        return point2d == null ? null : new Point3d(point2d.x, point2d.y, point3d3.z);
    }

    private Point2d getPlaneSnapPoint(GeomType geomType, double d, double d2) {
        double d3 = this.getSpacing();
        double d4 = (double)Math.round(d / d3) * d3;
        double d5 = (double)Math.round(d2 / d3) * d3;
        if (geomType == GeomType.VERTEX) {
            return new Point2d(d4, d5);
        }
        double d6 = d - d4;
        double d7 = d6 * d6;
        double d8 = d2 - d5;
        double d9 = d8 * d8;
        if (d7 <= d9) {
            return new Point2d(d4, d2);
        }
        return new Point2d(d, d5);
    }

    @Override
    public void pickCells(IIsectCollector iIsectCollector, Point3d point3d, Vector3d vector3d, ITest<AABox> iTest) {
        Point3d point3d2 = null;
        Pair pair = null;
        if (this.d_view.getCamera() instanceof OrthoCamera) {
            Pair[] pairArray;
            for (Pair pair2 : pairArray = new Pair[]{new Pair<Plane3d, Byte>(new Plane3d(0.0, 0.0, 1.0, 0.0), (byte)2), new Pair<Plane3d, Byte>(new Plane3d(0.0, 1.0, 0.0, 0.0), (byte)1), new Pair<Plane3d, Byte>(new Plane3d(1.0, 0.0, 0.0, 0.0), (byte)0)}) {
                Point3d point3d3 = Inter3D.linePlaneIntersection(point3d, vector3d, (Plane3d)pair2.v1, 1.0E-6);
                if (point3d3 == null) continue;
                point3d2 = point3d3;
                pair = pair2;
                break;
            }
        }
        if (point3d2 == null) {
            return;
        }
        double d = this.getSpacing();
        double d2 = 1.0 / d;
        double d3 = point3d2.x * d2;
        double d4 = point3d2.y * d2;
        double d5 = point3d2.z * d2;
        double d6 = Math.floor(d3) * d;
        double d7 = Math.floor(d4) * d;
        double d8 = Math.floor(d5) * d;
        double d9 = Math.ceil(d3) * d;
        double d10 = Math.ceil(d4) * d;
        double d11 = Math.ceil(d5) * d;
        if (d6 == d9) {
            d9 += 1.0;
        }
        if (d7 == d10) {
            d10 += 1.0;
        }
        if (d8 == d11) {
            d11 += 1.0;
        }
        AARectangle aARectangle = null;
        switch ((Byte)pair.v2) {
            case 0: {
                aARectangle = new AARectangle(0, 0.0, d7, d8, d10, d11, false);
                break;
            }
            case 1: {
                aARectangle = new AARectangle(1, 0.0, d6, d8, d9, d11, false);
                break;
            }
            case 2: {
                aARectangle = new AARectangle(2, 0.0, d6, d7, d9, d10, false);
            }
        }
        if (aARectangle == null) {
            return;
        }
        AARectangle aARectangle2 = aARectangle;
        iIsectCollector.addFace(this, point3d2, () -> aARectangle2, () -> aARectangle2.getNormal(true), IPrimProps.DEF);
    }
}

