/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.snappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.mv.displays.GridDisplay;
import pyrosim.mv.displays.GridDisplayManager;
import pyrosim.mv.snappers.IGridSnapper;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Quad;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.theUtil;

public class ModelGridSnapper
implements IGridSnapper {
    private final GridDisplayManager d_dispMgr;
    private final Grid d_grid;
    private double[] d_xSnaps;
    private double[] d_ySnaps;
    private double[] d_zSnaps;
    private Floor d_activeFloor;

    public ModelGridSnapper(GridDisplayManager gridDisplayManager, Grid grid) {
        this.d_dispMgr = gridDisplayManager;
        this.d_grid = grid;
        this.d_activeFloor = null;
        this.resetData();
    }

    public void setActiveFloor(Floor floor) {
        this.d_activeFloor = floor;
    }

    public void resetData() {
        Unit unit = Geometry.LU;
        Point3d point3d = this.d_grid.getMinPoint().getValue(unit);
        Point3d point3d2 = this.d_grid.getMaxPoint().getValue(unit);
        UnitDouble[] unitDoubleArray = this.d_grid.getXLinePositions();
        this.d_xSnaps = new double[unitDoubleArray.length];
        for (int i = 0; i < unitDoubleArray.length; ++i) {
            this.d_xSnaps[i] = unitDoubleArray[i].getValue(unit);
        }
        if (unitDoubleArray.length > 0) {
            this.d_xSnaps[0] = point3d.x;
            this.d_xSnaps[this.d_xSnaps.length - 1] = point3d2.x;
        }
        UnitDouble[] unitDoubleArray2 = this.d_grid.getYLinePositions();
        this.d_ySnaps = new double[unitDoubleArray2.length];
        for (int i = 0; i < unitDoubleArray2.length; ++i) {
            this.d_ySnaps[i] = unitDoubleArray2[i].getValue(unit);
        }
        if (unitDoubleArray2.length > 0) {
            this.d_ySnaps[0] = point3d.y;
            this.d_ySnaps[this.d_ySnaps.length - 1] = point3d2.y;
        }
        UnitDouble[] unitDoubleArray3 = this.d_grid.getZLinePositions();
        this.d_zSnaps = new double[unitDoubleArray3.length];
        for (int i = 0; i < unitDoubleArray3.length; ++i) {
            this.d_zSnaps[i] = unitDoubleArray3[i].getValue(unit);
        }
        if (unitDoubleArray3.length > 0) {
            this.d_zSnaps[0] = point3d.z;
            this.d_zSnaps[this.d_zSnaps.length - 1] = point3d2.z;
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return DisplayGeom.EMPTY;
    }

    public boolean[] getVisibility() {
        GridDisplay gridDisplay = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid);
        if (gridDisplay == null) {
            return new boolean[]{false, false, false};
        }
        return gridDisplay.getVisibility();
    }

    @Override
    public boolean isVisible() {
        boolean[] blArray = this.getVisibility();
        return blArray[0] || blArray[1] || blArray[2];
    }

    @Override
    public void setVisible(boolean bl) {
    }

    public Grid getGrid() {
        return this.d_grid;
    }

    @Override
    public AABox getBounds() {
        return this.d_grid.getBounds();
    }

    protected void pickBox(Object object, IIsectFilter iIsectFilter, ConvexHull convexHull, thunderheadeng.geometry.objs.IBoxCollector iBoxCollector) throws CancelledException {
        Object object2;
        GridDisplay gridDisplay;
        boolean bl = iIsectFilter.acceptGeomType(this, GeomType.VERTEX);
        boolean bl2 = iIsectFilter.acceptGeomType(this, GeomType.EDGE);
        boolean bl3 = iIsectFilter.acceptGeomType(this, GeomType.FACE) || iIsectFilter.acceptGeomType(this, GeomType.FACE_EDGE) || iIsectFilter.acceptGeomType(this, GeomType.FACE_VERTEX);
        boolean[] blArray = this.getVisibility();
        if (blArray[1] && bl3 && (gridDisplay = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid)) != null) {
            object2 = new DefaultFilter(GeomType.FACE);
            Mesh mesh = gridDisplay.getSurfaceMesh();
            mesh.pickBox(object, (IIsectFilter)object2, convexHull, iBoxCollector);
        }
        if (blArray[2] && bl2 && (gridDisplay = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid)) != null) {
            object2 = gridDisplay.getOutlineMesh();
            ((Mesh)object2).pickBox(object, iIsectFilter, convexHull, iBoxCollector);
        }
        if (!blArray[0] || bl || bl2) {
            // empty if block
        }
    }

    @Override
    public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        try {
            this.pickBox(this, iIsectFilter, convexHull, IPickable.convertCollector(iBoxCollector, DEF_PROPS));
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (!iIsectFilter.acceptPickObject(this)) {
            return;
        }
        this.pickPoints(this, IPickable.convertCollector(iIsectCollector, DEF_PROPS), iIsectFilter, point3d, point3d2, vector3d, iTest);
    }

    protected void pickPoints(Object object, thunderheadeng.geometry.objs.IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        Cloneable cloneable;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = iIsectFilter.acceptGeomType(this, GeomType.VERTEX);
        boolean bl2 = iIsectFilter.acceptGeomType(this, GeomType.EDGE);
        boolean bl3 = iIsectFilter.acceptGeomType(this, GeomType.FACE) || iIsectFilter.acceptGeomType(this, GeomType.FACE_EDGE) || iIsectFilter.acceptGeomType(this, GeomType.FACE_VERTEX);
        boolean[] blArray = this.getVisibility();
        if (blArray[1] && bl3 && (object4 = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid)) != null) {
            object3 = new DefaultFilter(GeomType.FACE);
            object2 = this.d_dispMgr.getMV().getMainView().getCamera().getViewVector(point3d);
            cloneable = ((GridDisplay)object4).getSurfaceMesh();
            int n = 0;
            while (n < ((Mesh)((Object)cloneable)).indices.length) {
                Point3d point3d3 = ((Mesh)((Object)cloneable)).vertices[((Mesh)((Object)cloneable)).indices[n++]];
                Point3d point3d4 = ((Mesh)((Object)cloneable)).vertices[((Mesh)((Object)cloneable)).indices[n++]];
                int n2 = n++;
                Point3d point3d5 = ((Mesh)((Object)cloneable)).vertices[((Mesh)((Object)cloneable)).indices[n2]];
                Triangle triangle = new Triangle(point3d3, point3d4, point3d5);
                if (!(((Vector3d)object2).dot(triangle.getNormal(true)) >= 0.0)) continue;
                triangle.pickPoints(iIsectCollector, (IIsectFilter)object3, this, point3d, point3d2, vector3d, iTest);
            }
        }
        if (blArray[2] && bl2 && (object4 = (GridDisplay)this.d_dispMgr.getDisplay(this.d_grid)) != null) {
            object3 = ((GridDisplay)object4).getOutlineMesh();
            ((Mesh)object3).pickPoints(iIsectCollector, iIsectFilter, this, point3d, point3d2, vector3d, iTest);
        }
        if (blArray[0] && (bl || bl2)) {
            object4 = this.getPlaneIsect(true, point3d, vector3d);
            if (object4 == null) {
                return;
            }
            object3 = ModelGridSnapper.getIsectDivs(((PlaneIsect)object4).lxdiv, ((PlaneIsect)object4).lx);
            object2 = ModelGridSnapper.getIsectDivs(((PlaneIsect)object4).lydiv, ((PlaneIsect)object4).ly);
            if (bl) {
                for (ArrayList arrayList : object3) {
                    for (Object object5 : object2) {
                        Point3d point3d6 = ((PlaneIsect)object4).localToWorld((double)arrayList, (double)object5);
                        iIsectCollector.addNonFace(this, point3d6, GeomType.VERTEX);
                    }
                }
            }
            if (bl2) {
                if (((Object)object3).length == 1 && ((Object)object2).length == 1) {
                    cloneable = ((PlaneIsect)object4).localToWorld((double)object3[0], (double)object2[0]);
                    iIsectCollector.addNonFace(this, (Point3d)cloneable, GeomType.EDGE);
                } else {
                    cloneable = new ArrayList(4);
                    if (((Object)object3).length == 2) {
                        for (Object object6 : object2) {
                            ((ArrayList)cloneable).add(new double[]{(double)object3[0], (double)object6, (double)object3[1], (double)object6});
                        }
                    }
                    if (((Object)object2).length == 2) {
                        for (Object object7 : object3) {
                            ((ArrayList)cloneable).add(new double[]{(double)object7, (double)object2[0], (double)object7, (double)object2[1]});
                        }
                    }
                    Iterator iterator = ((ArrayList)cloneable).iterator();
                    while (iterator.hasNext()) {
                        double[] dArray = (double[])iterator.next();
                        Point2d point2d = Inter2D.nearestToLineSeg(new Point2d(((PlaneIsect)object4).lx, ((PlaneIsect)object4).ly), new Point2d(dArray[0], dArray[1]), new Point2d(dArray[2], dArray[3]));
                        iIsectCollector.addNonFace(this, ((PlaneIsect)object4).localToWorld(point2d.x, point2d.y), GeomType.EDGE);
                    }
                }
            }
        }
    }

    @Override
    public void pickCells(IIsectCollector iIsectCollector, Point3d point3d, Vector3d vector3d, ITest<AABox> iTest) {
        if (!this.getVisibility()[0]) {
            return;
        }
        PlaneIsect planeIsect = this.getPlaneIsect(false, point3d, vector3d);
        if (planeIsect == null) {
            return;
        }
        double[] dArray = ModelGridSnapper.getIsectDivs(planeIsect.lxdiv, planeIsect.lx);
        double[] dArray2 = ModelGridSnapper.getIsectDivs(planeIsect.lydiv, planeIsect.ly);
        if (dArray.length < 2 || dArray2.length < 2) {
            return;
        }
        Quad quad = new Quad(planeIsect.localToWorld(dArray[0], dArray2[0]), planeIsect.localToWorld(dArray[1], dArray2[0]), planeIsect.localToWorld(dArray[1], dArray2[1]), planeIsect.localToWorld(dArray[0], dArray2[1]));
        if (quad.getNormal(true).dot(planeIsect.planeEq.getNormal()) < 0.0) {
            quad = new Quad(quad.p4, quad.p3, quad.p3, quad.p1);
        }
        Quad quad2 = quad;
        iIsectCollector.addFace(this, planeIsect.localToWorld(planeIsect.lx, planeIsect.ly), () -> quad2, () -> quad2.getNormal(true), IPrimProps.DEF);
    }

    private static double[] getIsectDivs(double[] dArray, double d) {
        int n = Arrays.binarySearch(dArray, d);
        if (n < 0) {
            n = -n - 2;
        }
        int n2 = n + 1;
        if (n >= 0 && n2 < dArray.length) {
            return new double[]{dArray[n], dArray[n2]};
        }
        if (n2 == 0) {
            return new double[]{dArray[0]};
        }
        if (n == dArray.length - 1) {
            return new double[]{dArray[n]};
        }
        return new double[0];
    }

    private PlaneIsect getPlaneIsect(boolean bl, Point3d point3d, Vector3d vector3d) {
        AABox aABox = this.getActiveBounds();
        Plane3d[] plane3dArray = new Plane3d[]{new Plane3d(0.0, 0.0, 1.0, -aABox.getMinZ()), new Plane3d(0.0, 1.0, 0.0, -aABox.getMinY()), new Plane3d(1.0, 0.0, 0.0, -aABox.getMinX()), new Plane3d(0.0, 0.0, -1.0, aABox.getMaxZ()), new Plane3d(0.0, -1.0, 0.0, aABox.getMaxY()), new Plane3d(-1.0, 0.0, 0.0, aABox.getMaxX())};
        PlaneIsect planeIsect = null;
        double d = Double.MAX_VALUE;
        Vector3d vector3d2 = bl ? this.d_dispMgr.getMV().getMainView().getCamera().getViewVector(point3d) : null;
        block5: for (int i = 0; i < 6; ++i) {
            double d2;
            Plane3d plane3d = plane3dArray[i];
            if (bl && vector3d2.dot(plane3d.getNormal()) > 0.0 || Double.isNaN(d2 = Inter3D.linePlaneIntersectionT(point3d, vector3d, plane3d, 1.0E-6)) || theUtil.lt0(d2, 1.0E-6) || d2 > d) continue;
            d = d2;
            Point3d point3d2 = Util3D.linePoint(point3d, vector3d, d2);
            int n = i % 3;
            switch (n) {
                case 0: {
                    planeIsect = new PlaneIsect(plane3d, n, this.d_xSnaps, this.d_ySnaps, point3d2.x, point3d2.y, point3d2.z);
                    continue block5;
                }
                case 1: {
                    planeIsect = new PlaneIsect(plane3d, n, this.d_xSnaps, this.d_zSnaps, point3d2.x, point3d2.z, point3d2.y);
                    continue block5;
                }
                case 2: {
                    planeIsect = new PlaneIsect(plane3d, n, this.d_ySnaps, this.d_zSnaps, point3d2.y, point3d2.z, point3d2.x);
                }
            }
        }
        return planeIsect;
    }

    private AABox getActiveBounds() {
        Point3d point3d = this.d_grid.getMinPoint().getPoint3dValue(Geometry.LU);
        Point3d point3d2 = this.d_grid.getMaxPoint().getPoint3dValue(Geometry.LU);
        if (this.d_activeFloor != null) {
            double d = this.d_activeFloor.getSlabBottom().getValue(Geometry.LU);
            double d2 = this.d_activeFloor.getCeilingLoc().getValue(Geometry.LU);
            if (theUtil.gt(d, point3d.z, 1.0E-9)) {
                point3d.z = d;
            }
            if (theUtil.lt(d2, point3d2.z, 1.0E-9)) {
                point3d2.z = d2;
            }
            if (point3d2.z < point3d.z) {
                point3d.z = point3d2.z;
            }
        }
        return new AABox(point3d, point3d2);
    }

    private static class PlaneIsect {
        public final Plane3d planeEq;
        public final int plane;
        public final double[] lxdiv;
        public final double[] lydiv;
        public final double lx;
        public final double ly;
        public final double lz;

        public PlaneIsect(Plane3d plane3d, int n, double[] dArray, double[] dArray2, double d, double d2, double d3) {
            this.planeEq = plane3d;
            this.plane = n;
            this.lxdiv = dArray;
            this.lydiv = dArray2;
            this.lx = d;
            this.ly = d2;
            this.lz = d3;
        }

        public Point3d localToWorld(double d, double d2) {
            switch (this.plane) {
                case 0: {
                    return new Point3d(d, d2, this.lz);
                }
                case 1: {
                    return new Point3d(d, this.lz, d2);
                }
                case 2: {
                    return new Point3d(this.lz, d, d2);
                }
            }
            return null;
        }
    }
}

