/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.snappers;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.mv.displays.GridDisplayManager;
import pyrosim.mv.snappers.IGridSnapper;
import pyrosim.mv.snappers.ModelGridSnapper;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;

public class CompositeModelGridSnapper
implements IGridSnapper {
    private final GridDisplayManager d_dispMgr;
    private final Map<Grid, ModelGridSnapper> d_snappers;
    private boolean d_visible;
    private boolean d_cellPickingEnabled;
    private Floor d_activeFloor;

    public CompositeModelGridSnapper(GridDisplayManager gridDisplayManager) {
        this.d_dispMgr = gridDisplayManager;
        this.d_snappers = new IdentityHashMap<Grid, ModelGridSnapper>();
        this.d_visible = true;
        this.d_cellPickingEnabled = false;
        this.d_activeFloor = null;
    }

    @Override
    public void setVisible(boolean bl) {
        this.d_visible = bl;
    }

    @Override
    public boolean isVisible() {
        if (!this.d_visible) {
            return false;
        }
        for (ModelGridSnapper modelGridSnapper : this.d_snappers.values()) {
            if (!modelGridSnapper.isVisible()) continue;
            return true;
        }
        return false;
    }

    public void setActiveFloor(Floor floor) {
        this.d_activeFloor = floor;
        for (ModelGridSnapper modelGridSnapper : this.d_snappers.values()) {
            modelGridSnapper.setActiveFloor(floor);
        }
    }

    @Override
    public AABox getBounds() {
        AABox aABox = new AABox();
        for (ModelGridSnapper modelGridSnapper : this.d_snappers.values()) {
            aABox.add(modelGridSnapper.getBounds());
        }
        return aABox;
    }

    public void removeAll() {
        this.d_snappers.clear();
        this.update();
    }

    public void addAll(PyroMod pyroMod) {
        for (Grid grid : pyroMod.getGridManager().flatten()) {
            this.d_snappers.put(grid, this.create(grid));
        }
        this.update();
    }

    private ModelGridSnapper create(Grid grid) {
        ModelGridSnapper modelGridSnapper = new ModelGridSnapper(this.d_dispMgr, grid);
        modelGridSnapper.setActiveFloor(this.d_activeFloor);
        return modelGridSnapper;
    }

    protected void update() {
        this.d_dispMgr.getMediator().getGeomLocator().update(this);
    }

    public void processEvents(Events events) {
        boolean bl = false;
        IEventRecord<Grid> iEventRecord = events.getEvents(Grid.class, new Class[0]);
        for (Grid grid : iEventRecord.getChangedObjs(EventChannel.EVT_GENERAL)) {
            this.d_snappers.get(grid).resetData();
            bl = true;
        }
        for (Grid grid : iEventRecord.getAddedObjs()) {
            this.d_snappers.put(grid, this.create(grid));
            bl = true;
        }
        for (Grid grid : iEventRecord.getRemovedObjs()) {
            this.d_snappers.remove(grid);
            bl = true;
        }
        if (bl) {
            this.update();
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return DisplayGeom.EMPTY;
    }

    @Override
    public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (!iIsectFilter.acceptPickObjType(ModelGridSnapper.class)) {
            return;
        }
        for (ModelGridSnapper modelGridSnapper : this.d_snappers.values()) {
            modelGridSnapper.pickBox(iBoxCollector, iIsectFilter, convexHull);
        }
    }

    @Override
    public void getAll(Consumer<Object> consumer, IIsectFilter iIsectFilter) {
        if (!iIsectFilter.acceptPickObjType(ModelGridSnapper.class)) {
            return;
        }
        for (ModelGridSnapper modelGridSnapper : this.d_snappers.values()) {
            modelGridSnapper.getAll(consumer, iIsectFilter);
        }
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (!iIsectFilter.acceptPickObjType(ModelGridSnapper.class)) {
            return;
        }
        for (ModelGridSnapper modelGridSnapper : this.d_snappers.values()) {
            if (!modelGridSnapper.isVisible()) continue;
            AABox aABox = modelGridSnapper.getBounds();
            if (!iTest.test((AABox)aABox).positive) continue;
            modelGridSnapper.pickPoints(iIsectCollector, iIsectFilter, point3d, point3d2, vector3d, iTest);
        }
    }

    @Override
    public void pickCells(IIsectCollector iIsectCollector, Point3d point3d, Vector3d vector3d, ITest<AABox> iTest) {
        for (ModelGridSnapper modelGridSnapper : this.d_snappers.values()) {
            if (!modelGridSnapper.isVisible()) continue;
            AABox aABox = modelGridSnapper.getBounds();
            if (!iTest.test((AABox)aABox).positive) continue;
            modelGridSnapper.pickCells(iIsectCollector, point3d, vector3d, iTest);
        }
    }
}

