/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.manip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Matrix4d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.gui.actions.Actions;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import pyrosim.util.GeomUtil;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Task;

public class TransformMgr {
    private final PyroMod d_domain;
    private final DisplayManager d_dispMgr;
    private final DisplayManager d_xformDispMgr;
    private Collection<IPyroObject> d_xformObjs;
    private Set<IPyroGeomSrc> d_objSet;
    private ITransform d_xform;
    private boolean d_copyMode;
    private IDOF d_dof;

    public TransformMgr(PyroMod pyroMod, DisplayManager displayManager, DisplayManager displayManager2) {
        this.d_domain = pyroMod;
        this.d_dispMgr = displayManager;
        this.d_xformDispMgr = displayManager2;
        this.d_xformObjs = Collections.EMPTY_LIST;
        this.d_objSet = Collections.EMPTY_SET;
        this.d_xform = null;
        this.d_copyMode = false;
    }

    public PyroMod getDomain() {
        return this.d_domain;
    }

    public Collection<IPyroObject> getXformObjects() {
        return this.d_xformObjs;
    }

    public boolean canTransform() {
        return !this.d_domain.getSelectionModel().flatten(IPyroGeomSrc.class).isEmpty();
    }

    public boolean isTransforming() {
        return !this.d_xformObjs.isEmpty();
    }

    public boolean isTransforming(Object object) {
        return this.isTransforming() && !this.getCopyMode() && this.d_objSet.contains(object);
    }

    public boolean isTransformValid() {
        return this.isTransforming() && this.d_xform != null && !this.d_xform.isIdentity();
    }

    public IDOF getDOF() {
        if (this.d_dof == null) {
            this.begin();
            this.d_dof = GeomUtil.getDOF(Hierarchy.flatten(this.getXformObjects(), IPyroGeomSrc.class));
        }
        return this.d_dof;
    }

    public void setCopyMode(boolean bl) {
        if (this.d_copyMode == bl) {
            return;
        }
        this.d_copyMode = bl;
        if (this.isTransforming()) {
            this.setOriginalsVisible(this.d_copyMode);
        }
    }

    public boolean getCopyMode() {
        return this.d_copyMode;
    }

    public void begin() {
        if (this.isTransforming()) {
            return;
        }
        PyroSim pyroSim = PyroSim.getApp();
        Collection<IPyroObject> collection = Actions.getTransformObjs(pyroSim, pyroSim.getMediator(), new ArrayList<IPyroObject>(this.d_domain.getSelectionModel().getSelected(IPyroObject.class)));
        this.d_dispMgr.d_dispFilter.filterAllOfType(IHandle.class);
        this.d_xformObjs = collection;
        Collection<IPyroGeomSrc> collection2 = Hierarchy.flatten(this.d_xformObjs, IPyroGeomSrc.class);
        this.d_objSet = new IdentityHashSet<IPyroGeomSrc>(collection2);
        this.d_xformDispMgr.add(collection2);
        this.setOriginalsVisible(this.d_copyMode);
    }

    public void modify(ITransform iTransform) {
        try {
            iTransform.invert();
        }
        catch (Throwable throwable) {
            System.err.println("Cannot invert matrix.  Skipping transform.");
            return;
        }
        this.d_xform = iTransform;
        Matrix4d matrix4d = this.d_xform.toMatrix(false);
        this.applyToScenes(modelScene -> modelScene.setTransform(matrix4d));
        if (!this.d_xform.isIdentity() && !this.isTransforming()) {
            this.begin();
        }
    }

    public void end(boolean bl) {
        TransformTask transformTask = null;
        if (bl && this.d_xform != null && !this.d_xform.isIdentity()) {
            final ITransform object = this.d_xform;
            int n = this.d_copyMode ? 1 : 0;
            transformTask = new TransformTask(this.d_domain, this.d_xformObjs, n){

                @Override
                public ITransform getXFormForIteration(int n) {
                    return object;
                }
            };
        }
        for (IPyroDisplayMgr iPyroDisplayMgr : this.d_xformDispMgr.getDispManagers()) {
            iPyroDisplayMgr.removeAll();
        }
        this.applyToScenes(modelScene -> modelScene.setTransform(null));
        this.setOriginalsVisible(true);
        this.d_xform = null;
        this.d_xformObjs = Collections.EMPTY_LIST;
        this.d_objSet = Collections.EMPTY_SET;
        this.d_copyMode = false;
        this.d_dof = null;
        this.d_dispMgr.d_dispFilter.removeFilter(IHandle.class);
        if (transformTask != null) {
            this.d_domain.getTaskManager().exec((Task)transformTask, Intl.intl("Transform Objects"), 1);
        }
    }

    private void applyToScenes(Consumer<ModelScene> consumer) {
        for (IPyroDisplayMgr iPyroDisplayMgr : this.d_xformDispMgr.getDispManagers()) {
            for (RenderTarget renderTarget : RenderTarget.values()) {
                iPyroDisplayMgr.getScenes().apply(renderTarget).ifPresent(consumer);
            }
        }
    }

    private void setOriginalsVisible(boolean bl) {
        Collection<IPyroGeomSrc> collection = Hierarchy.flatten(this.d_xformObjs, IPyroGeomSrc.class);
        if (!bl) {
            this.d_dispMgr.removeFromScene(collection);
        } else {
            this.d_dispMgr.addToScene(collection);
        }
    }
}

