/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.manip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.geom.Geometry;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.HandleDispMgr;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.manip.IManipListener;
import thunderheadeng.scene3d.manip.ManipEvent;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Task;

public class ManipHook
implements IManipListener,
IEventObserver {
    private final PyroMod d_domain;
    private final ModelView d_mv;
    private final ManipMgr d_manipMgr;
    private final HandleDispMgr d_dispMgr;
    private HandleSearcher d_handleSearcher;

    public ManipHook(PyroMod pyroMod, ModelView modelView, ManipMgr manipMgr, ModelScene modelScene, DisplayFilter displayFilter) {
        this.d_domain = pyroMod;
        this.d_mv = modelView;
        this.d_manipMgr = manipMgr;
        this.d_dispMgr = new HandleDispMgr(pyroMod, modelScene, displayFilter);
        this.d_handleSearcher = null;
        pyroMod.getEvents().addObserver(this);
        manipMgr.addListener(this);
    }

    @Override
    public void update(Events events) {
        IFilteredCollection<IMutableGeomSrc> iFilteredCollection;
        IMutableGeomSrc iMutableGeomSrc;
        IEventRecord<PyroMod> iEventRecord = events.getEvents(PyroMod.class, new Class[0]);
        IEventRecord<IPyroGeomSrc> iEventRecord2 = events.getEvents(IPyroGeomSrc.class, new Class[0]);
        if (iEventRecord.containsChange(PyroMod.EVT_MODEL_CHANGED) || iEventRecord2.hasAddedObjs() || iEventRecord2.hasRemovedObjs() || iEventRecord2.containsChange(PyroMod.EVT_SEL)) {
            IMutableGeomSrc iMutableGeomSrc2;
            iMutableGeomSrc = null;
            iFilteredCollection = this.d_domain.getSelectionModel().getSelected(IMutableGeomSrc.class);
            if (iFilteredCollection.size() == 1 && ManipMgr.canManipulate(iMutableGeomSrc2 = (IMutableGeomSrc)iFilteredCollection.iterator().next())) {
                iMutableGeomSrc = iMutableGeomSrc2;
            }
            this.d_manipMgr.setSource(iMutableGeomSrc);
        }
        if (this.d_manipMgr.getCurrentManipObj() != null && (iFilteredCollection = events.getEvents((iMutableGeomSrc = this.d_manipMgr.getCurrentManipObj()).getClass(), new Class[0])).isChanged(iMutableGeomSrc)) {
            this.d_manipMgr.updateSource(iMutableGeomSrc);
        }
    }

    @Override
    public void manipChanged(ManipEvent manipEvent) {
        ManipEvent.Type type = manipEvent.getType();
        switch (type) {
            case MANIP_STARTED: {
                this.begin();
                break;
            }
            case HANDLES_MODIFIED: {
                this.updateHandles();
                break;
            }
            case ACTIVE_HANDLE_CHANGED: {
                this.updateActiveHandle(manipEvent.getOldHandle());
                break;
            }
            case MANIP_ENDED: {
                this.end();
                if (!manipEvent.isCommitted()) break;
                this.commit(this.d_manipMgr.getCurrentManipObj(), manipEvent.getNewNode());
            }
        }
    }

    protected void updateHandles() {
        Collection<IHandle> collection;
        if (this.d_handleSearcher != null) {
            this.d_dispMgr.removeDisplays(this.d_handleSearcher.d_handles);
            this.d_domain.getGeomLocator().remove(this.d_handleSearcher);
            this.d_handleSearcher = null;
        }
        if (!(collection = this.d_manipMgr.getCurrentHandles()).isEmpty()) {
            this.d_handleSearcher = new HandleSearcher(collection);
            this.d_domain.getGeomLocator().add(this.d_handleSearcher);
            this.d_dispMgr.addDisplays(collection);
            this.updateActiveHandle(null);
        }
    }

    protected void updateActiveHandle(IHandle iHandle) {
        IHandle iHandle2 = this.d_manipMgr.getSelectedHandle();
        if (iHandle != null) {
            this.d_dispMgr.updateSelected(iHandle, false);
        }
        if (iHandle2 != null) {
            this.d_dispMgr.updateSelected(iHandle2, true);
        }
    }

    protected void begin() {
    }

    protected void end() {
    }

    protected void commit(final IMutableGeomSrc iMutableGeomSrc, IGeomNode iGeomNode) {
        iGeomNode = Geometry.finalize(iGeomNode, true);
        AReplaceRefTask<IGeomNode> aReplaceRefTask = new AReplaceRefTask<IGeomNode>((Object)iMutableGeomSrc.getGeom(), (Object)iGeomNode){

            @Override
            protected void set(IGeomNode iGeomNode) {
                iMutableGeomSrc.setGeom(iGeomNode);
            }
        };
        this.d_domain.getTaskManager().exec((Task)aReplaceRefTask, Intl.intl("Edit Object"), 1);
    }

    protected static class HandleSearcher
    implements IDisplayableGeomSrc,
    IPickable {
        private final List<IHandle> d_handles;
        private final AABox d_bounds;

        public HandleSearcher(Collection<? extends IHandle> collection) {
            this.d_handles = new ArrayList<IHandle>(collection);
            this.d_bounds = new AABox();
            for (IHandle iHandle : this.d_handles) {
                iHandle.getGeom().getBoundingBox(this.d_bounds);
            }
        }

        @Override
        public AABox getBounds() {
            return this.d_bounds;
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
            return DisplayGeom.EMPTY;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean bl) {
        }

        private DisplayGeom getPickGeom(IHandle iHandle) {
            return new DisplayGeom(iHandle.getGeom(), DEF_PROPS);
        }

        @Override
        public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
            if (!iIsectFilter.acceptPickObjType(IHandle.class)) {
                return;
            }
            for (IHandle iHandle : this.d_handles) {
                IPickable.pickPoints(iHandle, () -> this.getPickGeom(iHandle), iIsectCollector, iIsectFilter, point3d, point3d2, vector3d, iTest);
            }
        }

        @Override
        public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
            if (!iIsectFilter.acceptPickObjType(IHandle.class)) {
                return;
            }
            for (IHandle iHandle : this.d_handles) {
                IPickable.pickBox(iHandle, () -> this.getPickGeom(iHandle), iBoxCollector, iIsectFilter, convexHull);
            }
        }

        @Override
        public void getAll(Consumer<Object> consumer, IIsectFilter iIsectFilter) {
            if (!iIsectFilter.acceptPickObjType(IHandle.class)) {
                return;
            }
            for (IHandle iHandle : this.d_handles) {
                IPickable.getAll(iHandle, consumer, iIsectFilter);
            }
        }
    }
}

