/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.gui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JSeparator;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Property;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.devices.IAttachedPointDevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ParticleComboBox;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.devices.DevcEditorFactory;
import pyrosim.gui.devices.DevicePnl;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.geom.InitEditor;
import pyrosim.gui.geom.PartCloudEditor;
import pyrosim.mv.tools.DrawProps;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.Util;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.theUtil;

public class ToolPropertiesDlg
extends guiDialog {
    private static final long serialVersionUID = 5542101197693312041L;
    private static final String COLOR_FROM_SURF = Intl.intl("From Surface");
    private static final String COLOR_SPECIFY = Intl.intl("Specify");
    private guiTextField d_nameFld;
    private ValueField<UnitDouble> d_location;
    private ValueField<UnitDouble> d_thick;
    private ValueField<UnitDouble> d_height;
    private guiCheckBox d_cbSpecifySurf;
    private SurfaceComboBox d_surfCombo;
    private ParticleComboBox d_partCombo;
    private JButton d_editPartButton;
    private guiCheckBox d_cbSpecifyColor;
    private guiComboBox<String> d_cbColorSpec;
    private ColorButton d_cbColor;
    private guiCheckBox d_cbThicken = new guiCheckBox(Intl.intl("Thicken"), false);
    private guiCheckBox d_cbPermitHoles = new guiCheckBox(Intl.intl("Permit Holes"), true);
    private MultiLineLabel d_smoothBurnAwayWarning;
    private guiComboBox<DevicePnl<? extends IDevice>> d_devcTypeCB;
    private guiComboBox<Geometry.Axis> d_axisCB;
    private QuantityComboBox d_sliceQuantityCB;
    private guiCheckBox d_sliceVectorCB;
    private guiCheckBox d_sliceCenteredCB;
    private guiRadioButton d_fixedCellSizeRB;
    private guiRadioButton d_fixedCellCountRB;
    private ValueField<UnitDouble> d_cellSizeX;
    private ValueField<UnitDouble> d_cellSizeY;
    private ValueField<UnitDouble> d_cellSizeZ;
    private ValueField<Integer> d_cellCountX;
    private ValueField<Integer> d_cellCountY;
    private ValueField<Integer> d_cellCountZ;
    private PartCloudEditor.InsertionPanel d_massDensPanel;
    private TitleSeparator d_movementTitle;
    private PartCloudEditor.DropletCountPanel d_dropCountPanel;
    private InitEditor d_initEditor;
    private final Set<DrawProps.Prop<?>> d_propTypes;
    private final DrawProps d_props;
    private final String d_nameKey;
    private final int d_axis;

    public ToolPropertiesDlg(JFrame jFrame, PyroMod pyroMod, Camera camera, String string, String string2, Predicate<Surface> predicate, DrawProps drawProps, Collection<DrawProps.Prop<?>> collection) {
        super((Window)jFrame, Intl.intl("Tool Properties"), 9);
        Object object;
        JComponent jComponent;
        Serializable serializable;
        Serializable serializable2;
        String string3;
        this.d_props = drawProps;
        this.d_nameKey = string;
        this.d_propTypes = collection instanceof Set ? (Set<Object>)collection : new HashSet(collection);
        this.d_axis = camera instanceof OrthoCamera ? Util.getClosestAxis(camera.getViewVector()) : 2;
        switch (this.d_axis) {
            case 0: {
                string3 = Intl.intl("X Location:");
                break;
            }
            case 1: {
                string3 = Intl.intl("Y Location:");
                break;
            }
            case 2: {
                string3 = Intl.intl("Z Location:");
                break;
            }
            default: {
                assert (false);
                string3 = null;
            }
        }
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridBagLayout());
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        if (this.propsAffected(DrawProps.NAME)) {
            this.d_nameFld = new guiTextField((String)drawProps.get(new DrawProps.Prop(string)));
            gridBagHelper.addRow(Intl.intl("Name:"), this.d_nameFld, 1.0, 0);
        }
        if (this.propsAffected(DrawProps.LOCATION)) {
            this.d_location = ValueFields.udFld(drawProps.get(DrawProps.LOCATION), UnitSystem.getSource(0));
            gridBagHelper.addRow(string3, this.d_location, 0);
        }
        if (this.propsAffected(DrawProps.HEIGHT)) {
            serializable2 = drawProps.get(DrawProps.HEIGHT);
            this.d_height = ValueFields.udFld(((UnitDouble)serializable2).getValueNoUnit(), DoubleVR.above(0.0, true), ((UnitDouble)serializable2).getUnit(), UnitSystem.getSource(0));
            gridBagHelper.addRow(Intl.intl("Height:"), this.d_height, 0);
        }
        if (this.propsAffected(DrawProps.THICKNESS)) {
            this.d_thick = ValueFields.udFld(drawProps.get(DrawProps.THICKNESS), UnitSystem.getSource(0));
            gridBagHelper.addRow(string2 + ":", this.d_thick, 0);
        }
        if (this.propsAffected(DrawProps.SURFACE)) {
            this.d_surfCombo = new SurfaceComboBox(pyroMod.getSurfaceMgr(), drawProps.get(DrawProps.SURFACE));
            this.d_surfCombo.setFilter(predicate);
            if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
                this.d_cbSpecifySurf = new guiCheckBox(Intl.intl("Apply Surface"), (boolean)drawProps.get(DrawProps.SPECIFY_SURFACE));
                LinkStatus.link((AbstractButton)this.d_cbSpecifySurf, this.d_surfCombo);
            }
            serializable2 = this.d_cbSpecifySurf != null ? this.d_cbSpecifySurf : new guiLabel(Intl.intl("Surface:"));
            gridBagHelper.addRow(serializable2, this.d_surfCombo, 0);
        } else if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
            this.d_cbSpecifySurf = new guiCheckBox(Intl.intl("Pick Surface"), (boolean)drawProps.get(DrawProps.SPECIFY_SURFACE));
            gridBagHelper.addRow(this.d_cbSpecifySurf, 0);
        }
        if (this.propsAffected(DrawProps.COLOR)) {
            this.d_cbColorSpec = new guiComboBox<Object>((T[])new Object[]{COLOR_FROM_SURF, COLOR_SPECIFY});
            this.d_cbColorSpec.setSelectedItem(drawProps.get(DrawProps.COLOR) == null ? COLOR_FROM_SURF : COLOR_SPECIFY);
            this.d_cbColor = new ColorButton();
            this.d_cbColor.setVisible(drawProps.get(DrawProps.COLOR) != null);
            if (drawProps.get(DrawProps.COLOR) != null) {
                this.d_cbColor.setColor(drawProps.get(DrawProps.COLOR));
            }
            this.d_cbColorSpec.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        ToolPropertiesDlg.this.d_cbColor.setVisible(((String)ToolPropertiesDlg.this.d_cbColorSpec.getSelectedItem()).equals(COLOR_SPECIFY));
                        if (ToolPropertiesDlg.this.d_cbColor.isVisible()) {
                            ToolPropertiesDlg.this.d_cbColor.editColor();
                            ToolPropertiesDlg.this.pack();
                        }
                    }
                }
            });
            if (this.propsAffected(DrawProps.SPECIFY_COLOR)) {
                this.d_cbSpecifyColor = new guiCheckBox(Intl.intl("Apply Color"), (boolean)drawProps.get(DrawProps.SPECIFY_COLOR));
                LinkStatus.link((AbstractButton)this.d_cbSpecifyColor, this.d_cbColorSpec, this.d_cbColor);
            }
            serializable2 = this.d_cbSpecifyColor != null ? this.d_cbSpecifyColor : new guiLabel(Intl.intl("Color:"));
            gridBagHelper.addRow(serializable2, this.d_cbColorSpec, this.d_cbColor);
        } else if (this.propsAffected(DrawProps.SPECIFY_COLOR)) {
            this.d_cbSpecifyColor = new guiCheckBox(Intl.intl("Pick Color"), (boolean)drawProps.get(DrawProps.SPECIFY_COLOR));
            this.d_cbColor = new ColorButton();
            LinkStatus.link((AbstractButton)this.d_cbSpecifyColor, this.d_cbColor);
            gridBagHelper.addRow(this.d_cbSpecifyColor, this.d_cbColor, 0);
        }
        if (this.propsAffected(DrawProps.THICKEN)) {
            this.d_cbThicken.setSelected(drawProps.get(DrawProps.THICKEN));
            gridBagHelper.addRow(this.d_cbThicken);
        }
        if (this.propsAffected(DrawProps.PERMIT_HOLES)) {
            this.d_cbPermitHoles.setSelected(drawProps.get(DrawProps.PERMIT_HOLES));
            gridBagHelper.addRow(this.d_cbPermitHoles);
        }
        if (this.propsAffected(DrawProps.PARTICLES)) {
            this.d_editPartButton = new JButton(Intl.intl("Edit Particles") + "...");
            this.d_editPartButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Actions.editParticles((Particle)ToolPropertiesDlg.this.d_partCombo.getSelectedItem());
                    if (ToolPropertiesDlg.this.d_partCombo.getSelectedItem() == null && ToolPropertiesDlg.this.d_partCombo.getItemCount() > 0) {
                        ToolPropertiesDlg.this.d_partCombo.setSelectedIndex(0);
                    }
                    ToolPropertiesDlg.this.updatePartCloudFields();
                }
            });
            this.d_partCombo = new ParticleComboBox(pyroMod.getPartList(), drawProps.get(DrawProps.PARTICLES), null);
            this.d_partCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ToolPropertiesDlg.this.updatePartCloudFields();
                }
            });
            if (this.d_partCombo.getSelectedItem() == null && this.d_partCombo.getItemCount() > 0) {
                this.d_partCombo.setSelectedIndex(0);
            }
            gridBagHelper.addRow(Intl.intl("Particle:"), this.d_partCombo, 1.0, this.d_editPartButton, 0);
        }
        if (this.propsAffected(DrawProps.DROP_COUNT)) {
            this.d_dropCountPanel = new PartCloudEditor.DropletCountPanel(false);
            this.d_dropCountPanel.loadData(Property.of(drawProps.get(DrawProps.DROP_COUNT)));
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Droplet Count")));
            gridBagHelper.addIdentRow(this.d_dropCountPanel, 0, 1.0);
        }
        if (this.propsAffected(DrawProps.INSERTION)) {
            this.d_massDensPanel = new PartCloudEditor.InsertionPanel(pyroMod, stream -> Stream.of(this.d_nameFld.getText()), false);
            this.d_massDensPanel.loadData((PartCloud.IInsertion)drawProps.get(DrawProps.INSERTION).v1, (ControlBridge)drawProps.get(DrawProps.INSERTION).v2);
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Insertion")));
            gridBagHelper.addIdentRow(this.d_massDensPanel, 0, 1.0);
        }
        if (this.propsAffected(DrawProps.INIT)) {
            this.d_initEditor = new InitEditor(pyroMod);
            this.d_initEditor.load(PyroSim.getApp().getMediator(), (Collection<? extends InitRegion>)Arrays.asList(this.d_props.get(DrawProps.INIT)));
            this.d_initEditor.add(gridBagHelper);
        }
        if (this.propsAffected(DrawProps.SURFACE)) {
            this.d_smoothBurnAwayWarning = new MultiLineLabel(Intl.intl("FDS does not allow smoothed obstructions to burn away.  Change the surface to fix."));
            this.d_smoothBurnAwayWarning.setForeground(Color.RED);
            serializable2 = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ToolPropertiesDlg.this.updateWarningVis();
                }
            };
            this.d_surfCombo.addItemListener((ItemListener)((Object)serializable2));
            gridBagHelper.addRow(this.d_smoothBurnAwayWarning, 1.0, 0);
            this.pack();
            this.pack();
            this.d_smoothBurnAwayWarning.setPreferredSize(this.d_smoothBurnAwayWarning.getPreferredSize());
            this.updateWarningVis();
        }
        if (this.propsAffected(DrawProps.DEVC)) {
            serializable2 = ToolPropertiesDlg.getDevicePanels(pyroMod, drawProps);
            serializable = new CardLayout();
            jComponent = new guiPanel((LayoutManager)((Object)serializable));
            for (DevicePnl object2 : serializable2) {
                jComponent.add((Component)object2, object2.getDevcType().getName());
                object2.setEnabled(false);
            }
            this.d_devcTypeCB = new guiComboBox(serializable2);
            this.d_devcTypeCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -1242870236787131484L;

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    DevicePnl devicePnl = (DevicePnl)object;
                    this.setText(devicePnl.getDevcEditor().getDesc());
                    return this;
                }
            });
            this.d_devcTypeCB.addItemListener(new ItemListener((CardLayout)serializable, (guiPanel)jComponent){
                final /* synthetic */ CardLayout val$devcPnlCards;
                final /* synthetic */ guiPanel val$devcPnl;
                {
                    this.val$devcPnlCards = cardLayout;
                    this.val$devcPnl = guiPanel2;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    boolean bl;
                    boolean bl2 = bl = itemEvent.getStateChange() == 1;
                    if (itemEvent.getItem() != null) {
                        ((DevicePnl)itemEvent.getItem()).setEnabled(bl);
                    }
                    if (itemEvent.getStateChange() == 1) {
                        DevicePnl devicePnl = (DevicePnl)ToolPropertiesDlg.this.d_devcTypeCB.getSelectedItem();
                        this.val$devcPnlCards.show(this.val$devcPnl, devicePnl.getDevcType().getName());
                    }
                }
            });
            object = drawProps.get(DrawProps.DEVC);
            if (object != null) {
                for (DevicePnl devicePnl : serializable2) {
                    if (!devicePnl.getDevcType().isInstance(object)) continue;
                    devicePnl.load(object);
                    this.d_devcTypeCB.setSelectedItem(devicePnl);
                    break;
                }
            }
            gridBagHelper.addRow(Intl.intl("Device Type:"), this.d_devcTypeCB, 0);
            gridBagHelper.addFilledRow(new JSeparator());
            gridBagHelper.addFilledRow(jComponent);
        }
        if (this.propsAffected(DrawProps.CELL_TYPE, DrawProps.CELL_SIZE, DrawProps.CELL_COUNT)) {
            this.d_fixedCellCountRB = new guiRadioButton(Intl.intl("Fixed Count:"));
            this.d_fixedCellSizeRB = new guiRadioButton(Intl.intl("Fixed Size:"));
            this.d_cellCountX = ValueFields.intFld(drawProps.get(DrawProps.CELL_COUNT)[0], IntVR.above(0, false));
            this.d_cellCountY = ValueFields.intFld(drawProps.get(DrawProps.CELL_COUNT)[1], IntVR.above(0, false));
            this.d_cellCountZ = ValueFields.intFld(drawProps.get(DrawProps.CELL_COUNT)[2], IntVR.above(0, false));
            this.d_cellSizeX = ValueFields.udFld(drawProps.get(DrawProps.CELL_SIZE)[0], UnitDoubleVR.above(0.0, SI.METER, false), UnitSystem.getSource(0));
            this.d_cellSizeY = ValueFields.udFld(drawProps.get(DrawProps.CELL_SIZE)[1], UnitDoubleVR.above(0.0, SI.METER, false), UnitSystem.getSource(0));
            this.d_cellSizeZ = ValueFields.udFld(drawProps.get(DrawProps.CELL_SIZE)[2], UnitDoubleVR.above(0.0, SI.METER, false), UnitSystem.getSource(0));
            serializable2 = new guiLabel(Intl.intl("X:"));
            serializable = new guiLabel(Intl.intl("Y:"));
            jComponent = new guiLabel(Intl.intl("Z:"));
            object = new guiLabel(Intl.intl("X:"));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Y:"));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Z:"));
            new guiButtonGroup(this.d_fixedCellCountRB, this.d_fixedCellSizeRB);
            LinkStatus.link((AbstractButton)this.d_fixedCellCountRB, new Component[]{serializable2, this.d_cellCountX, serializable, this.d_cellCountY, jComponent, this.d_cellCountZ});
            LinkStatus.link((AbstractButton)this.d_fixedCellSizeRB, new Component[]{object, this.d_cellSizeX, guiLabel2, this.d_cellSizeY, guiLabel3, this.d_cellSizeZ});
            guiPanel guiPanel3 = new guiPanel();
            GridBagHelper gridBagHelper2 = new GridBagHelper(guiPanel3);
            gridBagHelper2.addFilledRow(new TitleSeparator(Intl.intl("Cells")));
            gridBagHelper2.addIdentRow(this.d_fixedCellSizeRB, object, this.d_cellSizeX, guiLabel2, this.d_cellSizeY, guiLabel3, this.d_cellSizeZ, 0);
            gridBagHelper2.addIdentRow(this.d_fixedCellCountRB, serializable2, this.d_cellCountX, serializable, this.d_cellCountY, jComponent, this.d_cellCountZ, 0);
            gridBagHelper2.finalizeRows();
            gridBagHelper.addFilledRow(guiPanel3);
            if (drawProps.get(DrawProps.CELL_TYPE) == DrawProps.MeshCellType.FIXED_COUNT) {
                this.d_fixedCellCountRB.setSelected(true);
            } else {
                this.d_fixedCellSizeRB.setSelected(true);
            }
        }
        if (this.propsAffected(DrawProps.AXIS)) {
            serializable2 = new ArrayList<Geometry.Axis>();
            serializable2.add(null);
            serializable2.addAll(Arrays.asList(Geometry.Axis.values()));
            this.d_axisCB = new guiComboBox(serializable2);
            this.d_axisCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -5308765187220589086L;

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object == null) {
                        this.setText(Intl.intl("Automatic"));
                    }
                    return this;
                }
            });
            gridBagHelper.addRow(Intl.intl("Axis:"), this.d_axisCB, 0);
            this.d_axisCB.setSelectedItem((Object)drawProps.get(DrawProps.AXIS));
        }
        if (this.propsAffected(DrawProps.SLICE_QUANTITY)) {
            this.d_sliceQuantityCB = new QuantityComboBox(128, new QuantityType[0]);
            this.d_sliceQuantityCB.setSelectedItem(drawProps.get(DrawProps.SLICE_QUANTITY));
            gridBagHelper.addRow(Intl.intl("Quantity:"), this.d_sliceQuantityCB, 0);
        }
        if (this.propsAffected(DrawProps.SLICE_VECTOR)) {
            this.d_sliceVectorCB = new guiCheckBox(Intl.intl("Include Vectors"), (boolean)drawProps.get(DrawProps.SLICE_VECTOR));
            gridBagHelper.addRow(this.d_sliceVectorCB, 0);
        }
        if (this.propsAffected(DrawProps.SLICE_CENTERED)) {
            this.d_sliceCenteredCB = new guiCheckBox(Intl.intl("Cell Centered"), (boolean)drawProps.get(DrawProps.SLICE_CENTERED));
            gridBagHelper.addRow(this.d_sliceCenteredCB, 0);
        }
        gridBagHelper.finalizeRows();
        if (this.d_partCombo != null) {
            this.updatePartCloudFields();
        }
    }

    private void updateWarningVis() {
        if (this.d_smoothBurnAwayWarning != null) {
            this.d_smoothBurnAwayWarning.setVisible(this.isBurnAway(this.d_surfCombo));
        }
    }

    private boolean isBurnAway(SurfaceComboBox surfaceComboBox) {
        Surface surface = (Surface)surfaceComboBox.getSelectedItem();
        if (surface != null && surface.getSurfDesc() instanceof LayeredSurfDesc) {
            LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
            return layeredSurfDesc.d_burnAway;
        }
        return false;
    }

    private static List<DevicePnl<? extends IDevice>> getDevicePanels(PyroMod pyroMod, DrawProps drawProps) {
        ArrayList<DevicePnl<? extends IDevice>> arrayList = new ArrayList<DevicePnl<? extends IDevice>>();
        for (Class<? extends IDevice> clazz : ToolPropertiesDlg.getPointDevcTypes(pyroMod)) {
            IDevcEditor<? extends IDevice> iDevcEditor = DevcEditorFactory.create(pyroMod, clazz, IDevcEditor.Mode.CREATE, 0);
            if (iDevcEditor == null) continue;
            DevicePnl<? extends IDevice> devicePnl = new DevicePnl<IDevice>(pyroMod, clazz, iDevcEditor, 0);
            arrayList.add(devicePnl);
        }
        Collections.sort(arrayList, new Comparator<DevicePnl<? extends IDevice>>(){

            @Override
            public int compare(DevicePnl<? extends IDevice> devicePnl, DevicePnl<? extends IDevice> devicePnl2) {
                return devicePnl.getDevcEditor().getDesc().compareToIgnoreCase(devicePnl2.getDevcEditor().getDesc());
            }
        });
        return arrayList;
    }

    protected static Collection<Class<? extends IDevice>> getPointDevcTypes(PyroMod pyroMod) {
        return theUtil.filter(DevcEditorFactory.getAllDevcTypes(), Class.class, new Predicate<Class>(){

            @Override
            public boolean test(Class clazz) {
                return IFreePointDevice.class.isAssignableFrom(clazz) || IAttachedPointDevice.class.isAssignableFrom(clazz);
            }
        });
    }

    private boolean propsAffected(DrawProps.Prop ... propArray) {
        return this.d_propTypes.containsAll(Arrays.asList(propArray));
    }

    protected void updatePartCloudFields() {
        boolean bl;
        boolean bl2 = this.d_partCombo.getSelectedItem() != null && ((Particle)this.d_partCombo.getSelectedItem()).isType(Particle.Type.TRACER);
        boolean bl3 = bl = this.d_props.get(DrawProps.GEOM_SPACE) == DrawProps.GeomSpace.S3D;
        if (this.d_massDensPanel != null) {
            this.d_massDensPanel.updateEnabled(Property.of(bl2), Property.of(bl));
        }
        if (this.d_dropCountPanel != null) {
            this.d_dropCountPanel.updateEnabled(Property.of(bl2), Property.of(bl));
        }
        if (this.d_movementTitle != null) {
            this.d_movementTitle.setEnabled(!bl2);
        }
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (this.propsAffected(DrawProps.NAME) && this.d_nameFld.getText().trim().isEmpty()) {
            if (bl) {
                this.showMessageBox(Intl.intl("The name must not be empty."));
            }
            if (bl2) {
                this.d_nameFld.selectAll();
                this.d_nameFld.requestFocus();
            }
            return false;
        }
        if (this.propsAffected(DrawProps.PARTICLES) && this.d_partCombo.getSelectedItem() == null) {
            this.showMessageBox(Intl.intl("A particle must be chosen."));
            return false;
        }
        return true;
    }

    public void saveProps() {
        Object[] objectArray;
        Object object;
        if (this.propsAffected(DrawProps.NAME)) {
            this.d_props.set(new DrawProps.Prop(this.d_nameKey), this.d_nameFld.getText());
        }
        if (this.propsAffected(DrawProps.LOCATION)) {
            this.d_props.set(DrawProps.LOCATION, this.d_location.getValue());
        }
        if (this.propsAffected(DrawProps.HEIGHT)) {
            this.d_props.set(DrawProps.HEIGHT, this.d_height.getValue());
        }
        if (this.propsAffected(DrawProps.THICKNESS)) {
            this.d_props.set(DrawProps.THICKNESS, this.d_thick.getValue());
        }
        if (this.propsAffected(DrawProps.SPECIFY_SURFACE)) {
            this.d_props.set(DrawProps.SPECIFY_SURFACE, this.d_cbSpecifySurf.isSelected());
        }
        if (this.propsAffected(DrawProps.SURFACE)) {
            this.d_props.set(DrawProps.SURFACE, this.d_surfCombo.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.SPECIFY_COLOR)) {
            this.d_props.set(DrawProps.SPECIFY_COLOR, this.d_cbSpecifyColor.isSelected());
            if (this.d_cbSpecifyColor.isSelected()) {
                this.d_props.set(DrawProps.COLOR, this.d_cbColor.getColor());
            } else {
                this.d_props.set(DrawProps.COLOR, null);
            }
        }
        if (this.propsAffected(DrawProps.COLOR)) {
            if (this.d_cbColorSpec.getSelectedItem() == COLOR_FROM_SURF) {
                this.d_props.set(DrawProps.COLOR, null);
            } else {
                this.d_props.set(DrawProps.COLOR, this.d_cbColor.getColor());
            }
        }
        if (this.propsAffected(DrawProps.THICKEN)) {
            this.d_props.set(DrawProps.THICKEN, this.d_cbThicken.isSelected());
        }
        if (this.propsAffected(DrawProps.PERMIT_HOLES)) {
            this.d_props.set(DrawProps.PERMIT_HOLES, this.d_cbPermitHoles.isSelected());
        }
        if (this.propsAffected(DrawProps.PARTICLES)) {
            this.d_props.set(DrawProps.PARTICLES, this.d_partCombo.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.INSERTION)) {
            this.d_props.set(DrawProps.INSERTION, this.d_massDensPanel.saveData());
        }
        if (this.propsAffected(DrawProps.DROP_COUNT)) {
            this.d_props.set(DrawProps.DROP_COUNT, this.d_dropCountPanel.saveData().get());
        }
        if (this.propsAffected(DrawProps.INIT)) {
            this.d_initEditor.save(PyroSim.getApp().getMediator(), (Collection<? extends InitRegion>)Arrays.asList(this.d_props.get(DrawProps.INIT)));
        }
        if (this.propsAffected(DrawProps.DEVC)) {
            object = this.d_devcTypeCB.getSelectedItem();
            objectArray = object.save(null);
            objectArray.setName(object.getDevcEditor().getDefName());
            this.d_props.set(DrawProps.DEVC, objectArray);
        }
        if (this.propsAffected(DrawProps.CELL_TYPE, DrawProps.CELL_SIZE, DrawProps.CELL_COUNT)) {
            object = this.d_fixedCellCountRB.isSelected() ? DrawProps.MeshCellType.FIXED_COUNT : DrawProps.MeshCellType.FIXED_SIZE;
            this.d_props.set(DrawProps.CELL_TYPE, object);
            if (object == DrawProps.MeshCellType.FIXED_COUNT) {
                objectArray = new int[]{(Integer)this.d_cellCountX.getValue(), (Integer)this.d_cellCountY.getValue(), (Integer)this.d_cellCountZ.getValue()};
                this.d_props.set(DrawProps.CELL_COUNT, objectArray);
            } else {
                objectArray = new UnitDouble[]{(UnitDouble)this.d_cellSizeX.getValue(), (UnitDouble)this.d_cellSizeY.getValue(), (UnitDouble)this.d_cellSizeZ.getValue()};
                this.d_props.set(DrawProps.CELL_SIZE, objectArray);
            }
        }
        if (this.propsAffected(DrawProps.AXIS)) {
            this.d_props.set(DrawProps.AXIS, this.d_axisCB.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.SLICE_QUANTITY)) {
            this.d_props.set(DrawProps.SLICE_QUANTITY, this.d_sliceQuantityCB.getSelectedItem());
        }
        if (this.propsAffected(DrawProps.SLICE_VECTOR)) {
            this.d_props.set(DrawProps.SLICE_VECTOR, this.d_sliceVectorCB.isSelected());
        }
        if (this.propsAffected(DrawProps.SLICE_CENTERED)) {
            this.d_props.set(DrawProps.SLICE_CENTERED, this.d_sliceCenteredCB.isSelected());
        }
    }
}

