/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSimColors;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.IHvacGeomComp;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.GeomDisplayMgr;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.NameDisplay;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.nativebuffered.StringRenderer;
import thunderheadeng.scene3d.nativebuffered.TextRenderer;

public class LabelMgr
extends APyroDisplayMgr<IPyroGeomSrc, NameDisplay> {
    private final GeomDisplayMgr[] d_baseMgrs;
    private final TextRenderer d_tr;

    public LabelMgr(PyroMod pyroMod, ModelView modelView, ModelScene modelScene, DisplayFilter displayFilter, IPyroDisplayMgr.ObjFilter<IPyroGeomSrc> objFilter, GeomDisplayMgr ... geomDisplayMgrArray) {
        super(pyroMod, modelView, LabelMgr.newSceneMap(modelScene), displayFilter, objFilter);
        this.d_baseMgrs = geomDisplayMgrArray;
        this.d_tr = new TextRenderer();
        this.d_tr.setFontSize(12.0f);
        this.d_tr.setFontColor(Color.GREEN);
        this.d_tr.setPadding(new int[]{10, 10, 10, 10});
    }

    public void updateColors(PyroSimColors pyroSimColors) {
        Color color = pyroSimColors.getColor(PyroSimColors.TEXT_COLOR);
        this.d_tr.setFontColor(color);
    }

    @Override
    protected Collection<? extends Class<?>> getFilterTypes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(Filter.class);
        arrayList.addAll(super.getFilterTypes());
        return arrayList;
    }

    @Override
    protected void filterChanged(DisplayFilter displayFilter, Class clazz) {
        this.updateAll();
    }

    @Override
    public void addAll() {
        Predicate predicate = this.getObjFilter().toArbitraryPredicate();
        this.addDisplays(this.getMediator().getDevices().flatten(predicate));
        this.addDisplays(this.getMediator().getObstructions().flatten(IHvacGeomComp.class, predicate));
    }

    @Override
    protected NameDisplay createDisplay(IPyroGeomSrc iPyroGeomSrc, boolean bl, boolean bl2) {
        GeomDisplayMgr geomDisplayMgr;
        assert (iPyroGeomSrc instanceof INamed);
        NameDisplay nameDisplay = iPyroGeomSrc instanceof HvacDuct ? new DuctDisplay((HvacDuct)iPyroGeomSrc) : new NameDisplay((INamed)((Object)iPyroGeomSrc));
        GeomDisplayMgr.CapDisplay capDisplay = null;
        Object object = this.d_baseMgrs;
        int n = ((GeomDisplayMgr[])object).length;
        for (int i = 0; i < n && (capDisplay = (GeomDisplayMgr.CapDisplay)(geomDisplayMgr = object[i]).getDisplay(iPyroGeomSrc)) == null; ++i) {
        }
        assert (capDisplay != null);
        object = new ArrayList(1);
        capDisplay.getDisplayObjs(RenderTarget.NORMAL, (Collection<? super IDisplayable>)object);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            IDisplayable iDisplayable = (IDisplayable)iterator.next();
            if (!(iDisplayable instanceof Object3D)) continue;
            nameDisplay.setLocation(GeomConstants.PNT3D_ORIGIN, (Object3D)((Object)iDisplayable));
            break;
        }
        nameDisplay.setRenderer(this.d_tr);
        nameDisplay.setVisible(bl);
        nameDisplay.setSelected(bl2);
        return nameDisplay;
    }

    @Override
    protected boolean isFiltered(Object object) {
        return this.getFilter().isFilteringAllOf(Filter.class) || this.getFilter().isFilteringAllOf(object.getClass());
    }

    @Override
    protected boolean isVisible(IPyroGeomSrc iPyroGeomSrc) {
        return iPyroGeomSrc.isEnabled() && iPyroGeomSrc.isVisible() && !this.isFiltered(iPyroGeomSrc);
    }

    protected static class DuctDisplay
    extends NameDisplay {
        private static final long serialVersionUID = -5491893122417485607L;

        public DuctDisplay(HvacDuct hvacDuct) {
            super(hvacDuct);
            this.setOffset(StringRenderer.Offset.CENTER);
        }

        @Override
        public void update() {
            HvacDuct hvacDuct = (HvacDuct)this.getObject();
            String string = hvacDuct.getName();
            HvacDuct.AirflowObj airflowObj = (HvacDuct.AirflowObj)((Object)hvacDuct.getProp("opt_none_damper_fan"));
            if (airflowObj != HvacDuct.AirflowObj.NONE) {
                string = string + "/";
                switch (airflowObj) {
                    case AIRCOIL: {
                        string = string + ((HvacAircoil)hvacDuct.getProp("AIRCOIL_ID")).getName();
                        break;
                    }
                    case FAN: {
                        string = string + ((HvacFan)hvacDuct.getProp("FAN_ID")).getName();
                        break;
                    }
                    case DAMPER: {
                        string = string + Intl.intl("Damper");
                        break;
                    }
                    case VOLFLOW: {
                        string = string + Intl.intl("Volume Flow");
                    }
                }
            }
            this.setString(string);
        }
    }

    public static class Filter {
    }
}

