/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Vent;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.GridVis;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.GridDisplay;
import pyrosim.mv.displays.GridRenderer;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.gui.colorscheme.ColorChangedEvent;
import thunderheadeng.gui.colorscheme.ColorChangedListener;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.NativeMaterial;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IdentityHashSet;

public class GridDisplayManager
extends APyroDisplayMgr<Grid, GridDisplay>
implements ColorChangedListener {
    private Map<Grid, GridMergeUtil.BoundaryInfo> d_gridFaces;
    private final GridRenderer d_renderer;

    public GridDisplayManager(PyroMod pyroMod, ModelScene modelScene, ModelView modelView, DisplayFilter displayFilter) {
        super(pyroMod, modelView, GridDisplayManager.newSceneMap(modelScene), Grid.class, displayFilter);
        modelView.getColors().addColorChangedListener(this);
        this.d_gridFaces = null;
        this.d_renderer = new GridRenderer();
        modelScene.addRenderableObjects(Arrays.asList(this.d_renderer));
    }

    public void setActiveFloor(Floor floor) {
        for (GridDisplay gridDisplay : this.getDisplayMap().values()) {
            gridDisplay.setActiveFloor(floor);
        }
        this.repaint();
    }

    public Floor getActiveFloor() {
        return this.getMV().getCurrentFloor();
    }

    @Override
    protected Collection<? extends Class<?>> getFilterTypes() {
        return Arrays.asList(GridVis.Boundary.class, GridVis.Outline.class, GridVis.Divisions.class);
    }

    @Override
    protected void filterChanged(DisplayFilter displayFilter, Class clazz) {
        this.updateAll();
    }

    @Override
    public void colorChanged(ColorChangedEvent colorChangedEvent) {
        this.updateDisplays(this.getMediator().getGridManager().flatten());
    }

    private Surface getSurface() {
        return this.getMediator().getSimParams().getMisc().getSurfDefault();
    }

    private NativeMaterial getBoundarySurf() {
        Surface surface = this.getSurface();
        return this.getMV().getDrawProps().getNativeMat(surface);
    }

    @Override
    protected boolean isVisible(Grid grid) {
        return grid.isVisible();
    }

    @Override
    protected GridDisplay createDisplay(Grid grid, boolean bl, boolean bl2) {
        GridDisplay gridDisplay = new GridDisplay(grid, this.getBoundarySurf(), this.getSurface());
        this.updateDisplay(grid, gridDisplay);
        return gridDisplay;
    }

    @Override
    protected void addDisplays(Function<RenderTarget, Optional<ModelScene>> function, Collection<? extends Grid> collection, Collection<GridDisplay> collection2) {
        for (IDisplayable iDisplayable : collection2) {
            this.d_renderer.addDisplay((GridDisplay)iDisplayable);
        }
    }

    @Override
    protected void removeDisplays(Function<RenderTarget, Optional<ModelScene>> function, Collection<GridDisplay> collection) {
        for (IDisplayable iDisplayable : collection) {
            this.d_renderer.removeDisplay((GridDisplay)iDisplayable);
        }
    }

    @Override
    public void addAll() {
        this.d_gridFaces = null;
        this.addDisplays(this.getMediator().getGridManager().flatten());
    }

    @Override
    public void processEvents(Events events, EventResult eventResult) {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        IdentityHashSet identityHashSet = new IdentityHashSet();
        IdentityHashSet identityHashSet2 = new IdentityHashSet();
        IdentityHashSet identityHashSet3 = new IdentityHashSet();
        IdentityHashSet identityHashSet4 = new IdentityHashSet();
        boolean bl = false;
        boolean bl2 = false;
        for (EventChannel<Grid> object5 : events.getAffectedChannels(Grid.class, new Class[0])) {
            this.repaint();
            object42 = object5.getAddedObjs();
            object3 = object5.getRemovedObjs();
            object2 = object5.getChangedObjs(EventChannel.EVT_GENERAL);
            object = object5.getChangedObjs(PyroMod.EVT_SEL);
            Set<Grid> set = object5.getChangedObjs(PyroMod.EVT_VISIBILITY_CHANGED);
            Set<Grid> set2 = object5.getChangedObjs(PyroMod.EVT_ENABLED_CHANGED);
            identityHashSet.addAll(object42);
            identityHashSet2.addAll(object3);
            identityHashSet3.addAll(object2);
            identityHashSet4.addAll(object);
            identityHashSet4.addAll(set);
            identityHashSet4.addAll(set2);
            bl |= !object2.isEmpty() || !object42.isEmpty() || !object3.isEmpty() || !set2.isEmpty();
        }
        bl2 |= !events.getAffectedChannels(SimParams.Misc.class, new Class[0]).isEmpty();
        block1: for (EventChannel<NamedPyroObject> eventChannel : events.getAffectedChannels(Surface.class, new Class[0])) {
            object42 = this.getMediator().getSimParams().getMisc().getSurfDefault();
            object3 = eventChannel.getChangedObjs(Surface.EVT_APPEARANCE);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Surface)object2.next();
                if (object != object42) continue;
                bl2 = true;
                continue block1;
            }
        }
        for (EventChannel<NamedPyroObject> eventChannel : events.getAffectedChannels(Vent.class, new Class[0])) {
            if (!eventChannel.hasAddedObjs() && !eventChannel.hasRemovedObjs() && (!eventChannel.hasChangedObjs() || eventChannel.areChangesExclusiveTo(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED))) continue;
            bl = true;
            break;
        }
        if (bl) {
            this.d_gridFaces = null;
        }
        if (bl || bl2) {
            identityHashSet3.addAll(this.getMediator().getGridManager().flatten());
            identityHashSet3.removeAll(identityHashSet);
        }
        identityHashSet4.removeAll(identityHashSet3);
        boolean bl3 = !identityHashSet.isEmpty() || !identityHashSet2.isEmpty() || !identityHashSet3.isEmpty();
        this.addDisplays(identityHashSet);
        this.removeDisplays(identityHashSet2);
        for (Object object42 : identityHashSet3) {
            object3 = (GridDisplay)this.getDisplay(object42);
            if (object3 == null) continue;
            this.updateDisplay((Grid)object42, (GridDisplay)object3);
        }
        for (Object object42 : identityHashSet4) {
            object3 = (GridDisplay)this.getDisplay(object42);
            if (object3 == null) continue;
            bl3 = true;
            ((GridDisplay)object3).setSelected(this.isSelected(object42));
            object2 = this.getVisibility((Grid)object42);
            ((GridDisplay)object3).setVisible((boolean)object2[0], (boolean)object2[1], (boolean)object2[2]);
        }
        if (bl3) {
            this.getMV().getRenderComp().repaint();
        }
    }

    @Override
    public void updateDisplay(Grid grid, GridDisplay gridDisplay) {
        this.updateBoundaries();
        gridDisplay.pauseUpdates();
        gridDisplay.setActiveFloor(this.getActiveFloor());
        boolean bl = false;
        GridMergeUtil.BoundaryInfo boundaryInfo = this.d_gridFaces.get(grid);
        if (boundaryInfo == null) {
            boundaryInfo = GridMergeUtil.mergeGrids(Arrays.asList(new Grid[]{grid}), (Collection<? extends IPyroGeomSrc>)Collections.EMPTY_LIST).faces.get(grid);
            assert (boundaryInfo != null);
            bl = true;
        }
        gridDisplay.updateBoundarySurface(this.getBoundarySurf(), this.getSurface());
        gridDisplay.setData(boundaryInfo.faces, boundaryInfo.boundaryEdges);
        gridDisplay.updateActiveCamera(this.getScenes().apply(RenderTarget.NORMAL).get().getCamera());
        gridDisplay.updateColors();
        gridDisplay.updateSelected(this.isSelected(grid));
        boolean[] blArray = this.getVisibility(grid, bl);
        gridDisplay.updateOutlineVisible(blArray[0]);
        gridDisplay.updateBoundaryVisible(blArray[1]);
        gridDisplay.updateMeshVisible(blArray[2]);
        gridDisplay.resumeUpdates();
    }

    private boolean[] getVisibility(Grid grid) {
        return this.getVisibility(grid, false);
    }

    private boolean[] getVisibility(Grid grid, boolean bl) {
        boolean bl2;
        boolean bl3;
        Camera camera = this.getScenes().apply(RenderTarget.NORMAL).get().getCamera();
        boolean bl4 = camera instanceof OrthoCamera;
        boolean bl5 = bl3 = grid.isVisible() && grid.isEnabled();
        if (bl4) {
            bl3 &= bl || this.getMV().getCurrentSnapper() == 2;
            bl2 = true;
        } else {
            bl2 = !this.getFilter().isFilteringAllOf(GridVis.Divisions.class);
        }
        return new boolean[]{bl3 && !this.getFilter().isFilteringAllOf(GridVis.Outline.class), bl3 && !bl4 && !this.getFilter().isFilteringAllOf(GridVis.Boundary.class), bl3 && bl2};
    }

    private void updateBoundaries() {
        if (this.d_gridFaces != null) {
            return;
        }
        GridList gridList = this.getMediator().getGridManager();
        Collection<Vent> collection = ((APyroObject)this.getMediator().getObstructions()).flatten(Vent.class);
        Collection collection2 = gridList.flatten(new EnabledFilter());
        this.d_gridFaces = GridMergeUtil.mergeGrids(collection2, collection).faces;
        assert (collection2.size() == this.d_gridFaces.size());
    }
}

