/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.PyroSim;
import pyrosim.PyroSimColors;
import pyrosim.domain.Floor;
import pyrosim.domain.Grid;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.geom.Geometry;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.geom.Util;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.elem.ElementMesh;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.Application;
import thunderheadeng.io.nativexfer.INativeObject;
import thunderheadeng.io.nativexfer.INativeStream;
import thunderheadeng.io.nativexfer.INativelyMirrored;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.io.nativexfer.NativeMirroredHelper;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.NativeMaterial;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Keyable;
import thunderheadeng.util.theUtil;

public class GridDisplay
extends Object3D
implements IPyroDisplay,
IDisplayable,
INativelyMirrored {
    private static final long serialVersionUID = -8831175380220269835L;
    private static final int method_setSelected = 0;
    private static final int method_setVisible = 1;
    private static final Point3d[] s_emptyP3dArr = new Point3d[0];
    private static final int[] s_emptyIntArr = new int[0];
    private final Grid d_grid;
    private Floor d_activeFloor;
    private NativeMaterial d_boundaryDisp;
    private Surface d_surface;
    private boolean d_outlineVis;
    private boolean d_meshVis;
    private boolean d_boundaryVis;
    private Color d_outlineColor;
    private Color d_meshColor;
    private Camera d_activeCamera;
    private boolean d_selected = false;
    private final NativeMirroredHelper d_mirrorHelper = new NativeMirroredHelper(this);
    private DisplayData d_dispData;

    public GridDisplay(Grid grid, NativeMaterial nativeMaterial, Surface surface) {
        this.d_grid = grid;
        this.d_activeFloor = null;
        this.d_boundaryDisp = nativeMaterial;
        this.d_surface = surface;
        this.d_meshVis = true;
        this.d_outlineVis = true;
        this.d_dispData = new DisplayData();
        this.updateColors();
        this.nativeConstructed(GridDisplay.class);
    }

    @Override
    public Class resolveNativeClass() {
        return GridDisplay.class;
    }

    @Override
    public void getDisplayObjs(RenderTarget renderTarget, Collection<? super IDisplayable> collection) {
        switch (renderTarget) {
            case NORMAL: {
                collection.add(this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeNativeData(INativeStream iNativeStream) {
        void object;
        iNativeStream.writeBoolean(this.d_selected);
        Unit unit = Geometry.LU;
        Point3d point3d = this.d_grid.getMinPoint().getPoint3dValue(unit);
        Point3d point3d2 = this.d_grid.getMaxPoint().getPoint3dValue(unit);
        if (this.d_activeFloor != null) {
            double d = this.d_activeFloor.getSlabBottom().getValue(Geometry.LU);
            double d2 = this.d_activeFloor.getCeilingLoc().getValue(Geometry.LU);
            if (theUtil.gt(d, point3d.z, 1.0E-9)) {
                point3d.z = d;
            }
            if (theUtil.lt(d2, point3d2.z, 1.0E-9)) {
                point3d2.z = d2;
            }
            if (point3d2.z < point3d.z) {
                point3d.z = point3d2.z;
            }
        }
        iNativeStream.writeDoubles(point3d.x, point3d.y, point3d.z);
        iNativeStream.writeDoubles(point3d2.x, point3d2.y, point3d2.z);
        double[] dArray = Util.convertArray(this.d_grid.getXLinePositions(), unit);
        double[] dArray2 = Util.convertArray(this.d_grid.getYLinePositions(), unit);
        double[] dArray3 = Util.convertArray(this.d_grid.getZLinePositions(), unit);
        iNativeStream.writeInt(dArray.length);
        iNativeStream.writeDoubles(dArray);
        iNativeStream.writeInt(dArray2.length);
        iNativeStream.writeDoubles(dArray2);
        iNativeStream.writeInt(dArray3.length);
        iNativeStream.writeDoubles(dArray3);
        iNativeStream.write((Keyable)this.d_boundaryDisp);
        iNativeStream.writeInt(this.d_dispData.verts.length);
        boolean i = false;
        while (object < this.d_dispData.verts.length) {
            GridDisplay.writeAsP3f(iNativeStream, this.d_dispData.verts[object]);
            ++object;
        }
        iNativeStream.writeInt(this.d_dispData.tris.length);
        iNativeStream.writeInts(this.d_dispData.tris);
        iNativeStream.writeInt(this.d_dispData.texuv.length);
        for (Point2d point2d : this.d_dispData.texuv) {
            iNativeStream.writeFloat((float)point2d.x);
            iNativeStream.writeFloat((float)point2d.y);
        }
        iNativeStream.writeInt(this.d_dispData.boundaryLines.length);
        iNativeStream.writeInts(this.d_dispData.boundaryLines);
        iNativeStream.writeBooleans(this.d_boundaryVis, this.d_outlineVis, this.d_meshVis);
        Color color = this.d_grid.getColor();
        Color color2 = color != null ? color : this.d_outlineColor;
        Color color3 = color != null ? color : this.d_meshColor;
        Color color4 = this.d_surface.getColor();
        iNativeStream.writeFloats(color2.getComponents(new float[4]));
        iNativeStream.writeFloats(color3.getComponents(new float[4]));
        iNativeStream.writeFloats(color4.getComponents(new float[4]));
        iNativeStream.write((Keyable)this.d_activeCamera);
    }

    private static void writeAsP3f(INativeStream iNativeStream, Point3d point3d) {
        iNativeStream.writeFloats((float)point3d.x, (float)point3d.y, (float)point3d.z);
    }

    @Override
    public void update() {
        this.markNativeDirty();
    }

    @Override
    public void markNativeDirty() {
        this.d_mirrorHelper.markNativeDirty();
    }

    public void pauseUpdates() {
        this.d_mirrorHelper.pauseUpdates();
    }

    public void resumeUpdates() {
        this.d_mirrorHelper.resumeUpdates();
    }

    @Override
    public void markNativeClean() {
        this.d_mirrorHelper.markNativeClean();
    }

    public void setActiveFloor(Floor floor) {
        if (this.d_activeFloor == floor) {
            return;
        }
        this.d_activeFloor = floor;
        this.update();
    }

    public void updateColors() {
        PyroSimColors pyroSimColors = ((PyroSim)Application.getApp()).getColorManager();
        this.d_outlineColor = pyroSimColors.getColor(PyroSimColors.BOUNDARY_LINE_COLOR);
        this.d_meshColor = pyroSimColors.getColor(PyroSimColors.SNAP_TO_GRID_COLOR);
        this.markNativeDirty();
    }

    public Mesh getSurfaceMesh() {
        return new Mesh(this.d_dispData.verts, this.d_dispData.tris, 2);
    }

    public Mesh getOutlineMesh() {
        return new Mesh(this.d_dispData.verts, this.d_dispData.boundaryLines, 1);
    }

    public static DisplayData generateDisplayData(Collection<Face> collection, Collection<Edge> collection2, Surface surface) {
        LinkedHashMap<Point3d, Integer> linkedHashMap = new LinkedHashMap<Point3d, Integer>();
        if (!collection.isEmpty() || !collection2.isEmpty()) {
            Object[] objectArray;
            Object object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Face point3dArray : collection) {
                point3dArray.triangulate(0.0, linkedHashMap, arrayList);
            }
            ArrayList arrayList2 = new ArrayList(collection2.size());
            for (Edge edge : collection2) {
                object = GridDisplay.getIx(linkedHashMap, edge.v1.loc);
                objectArray = GridDisplay.getIx(linkedHashMap, edge.v2.loc);
                arrayList2.add(object);
                arrayList2.add(objectArray);
            }
            if (!(linkedHashMap.isEmpty() || arrayList.isEmpty() && arrayList2.isEmpty())) {
                Point3d[] point3dArray = linkedHashMap.keySet().toArray(new Point3d[linkedHashMap.size()]);
                int[] nArray = theUtil.toIntArray(arrayList);
                object = theUtil.toIntArray(arrayList2);
                objectArray = new Point2d[]{};
                if (surface.getAppearance() != null && surface.getAppearance().getAttributes().getTexture(MatChannel.DIFFUSE) != null) {
                    IPrimProps.Face face;
                    UniformProps uniformProps;
                    Mesh mesh;
                    PlanarCoordMapper planarCoordMapper = TexCoordGenerator.newGenerator(new Point3d(0.0, 0.0, 0.0));
                    ElementMesh<Point2d> elementMesh = planarCoordMapper.generate(Point2d.class, mesh = new Mesh(point3dArray, nArray, 2), Elements.CW, (IPropsSrc)(uniformProps = new UniformProps(face = new IPrimProps.Face(surface.getColor(), surface, 0))));
                    if (elementMesh != null) {
                        if (elementMesh.indices == ElementMesh.DIRECT && elementMesh.mapping == ElementMesh.Mapping.PER_PRIM_VERTEX) {
                            assert (((Point2d[])elementMesh.elements).length == nArray.length);
                            objectArray = (Point2d[])elementMesh.elements;
                        } else {
                            objectArray = new Point2d[nArray.length];
                            int n = mesh.getNumPrims(7);
                            assert (n == nArray.length);
                            int n2 = 0;
                            for (int i = 0; i < n; ++i) {
                                for (int j = 0; j < 3; ++j) {
                                    objectArray[n2++] = elementMesh.getPrimVertElement(i, j);
                                }
                            }
                        }
                    } else {
                        assert (false);
                        objectArray = new Point2d[nArray.length];
                        Arrays.fill(objectArray, GeomConstants.PNT3D_ORIGIN);
                    }
                }
                return new DisplayData(point3dArray, nArray, (Point2d[])objectArray, (int[])object);
            }
        }
        return new DisplayData();
    }

    public void setData(Collection<Face> collection, Collection<Edge> collection2) {
        this.d_dispData = GridDisplay.generateDisplayData(collection, collection2, this.d_surface);
        this.markNativeDirty();
    }

    private static Integer getIx(Map<Point3d, Integer> map, Point3d point3d) {
        Integer n = map.get(point3d);
        if (n == null) {
            n = map.size();
            map.put(point3d, n);
        }
        return n;
    }

    public void updateActiveCamera(Camera camera) {
        this.d_activeCamera = camera;
        this.markNativeDirty();
    }

    public void updateOutlineVisible(boolean bl) {
        this.d_outlineVis = bl;
        this.markNativeDirty();
    }

    public void updateMeshVisible(boolean bl) {
        this.d_meshVis = bl;
        this.markNativeDirty();
    }

    public void updateBoundaryVisible(boolean bl) {
        this.d_boundaryVis = bl;
        this.markNativeDirty();
    }

    public void updateSelected(boolean bl) {
        this.d_selected = bl;
        this.markNativeDirty();
    }

    public boolean[] getVisibility() {
        return new boolean[]{this.d_meshVis, this.d_boundaryVis, this.d_outlineVis};
    }

    public void setVisible(boolean bl, boolean bl2, boolean bl3) {
        this.d_outlineVis = bl;
        this.d_meshVis = bl3;
        this.d_boundaryVis = bl2;
        Native.manager.execMethod(GridDisplay.class, (INativeObject)this, 1, this.d_outlineVis, this.d_boundaryVis, this.d_meshVis);
    }

    @Override
    public void setSelected(boolean bl) {
        this.d_selected = bl;
        Native.manager.execMethod(GridDisplay.class, (INativeObject)this, 0, this.d_selected);
    }

    public void updateBoundarySurface(NativeMaterial nativeMaterial, Surface surface) {
        this.d_boundaryDisp = nativeMaterial;
        this.d_surface = surface;
        this.markNativeDirty();
    }

    public Grid getObject() {
        return this.d_grid;
    }

    public Object getSelectionObject() {
        return this.d_grid;
    }

    public static class DisplayData {
        public final Point3d[] verts;
        public final int[] tris;
        public final Point2d[] texuv;
        public final int[] boundaryLines;

        public DisplayData() {
            this(s_emptyP3dArr, s_emptyIntArr, new Point2d[0], s_emptyIntArr);
        }

        public DisplayData(Point3d[] point3dArray, int[] nArray, Point2d[] point2dArray, int[] nArray2) {
            this.verts = point3dArray;
            this.tris = nArray;
            this.texuv = point2dArray;
            this.boundaryLines = nArray2;
        }

        public IGeomNode getGeom(boolean bl) {
            Object object;
            Mesh mesh = this.getSurfaceMesh();
            IElemSource<Point2d> iElemSource = this.getUV();
            IElemSource<Boolean> iElemSource2 = Elements.ALL_CREASE;
            if (bl) {
                int n;
                object = new HashSet();
                int n2 = 0;
                while (n2 < this.boundaryLines.length) {
                    n = this.boundaryLines[n2++];
                    int n3 = this.boundaryLines[n2++];
                    object.add(new HashableEdge(n, n3));
                }
                Boolean[] booleanArray = new Boolean[mesh.indices.length];
                n = 0;
                int[] nArray = new int[3];
                int n4 = 0;
                while (n4 < mesh.indices.length) {
                    nArray[0] = mesh.indices[n4++];
                    nArray[1] = mesh.indices[n4++];
                    nArray[2] = mesh.indices[n4++];
                    for (int i = 0; i < 3; ++i) {
                        int n5 = nArray[i];
                        int n6 = nArray[GeomUtil.PLUS1MOD3[i]];
                        booleanArray[n++] = object.contains(new HashableEdge(n5, n6));
                    }
                }
                iElemSource2 = new ElementMesh<Boolean>(ElementMesh.Mapping.PER_PRIM_VERTEX, booleanArray, 3);
            }
            object = Elements.newElements("teciuv0x193fa", iElemSource, Elements.CREASE, iElemSource2);
            return GeomNodeUtil.newNode(mesh, (IPropertySet)object);
        }

        public Mesh getSurfaceMesh() {
            return new Mesh(this.verts, this.tris, 2);
        }

        public IElemSource<Point2d> getUV() {
            return new ElementMesh<Point2d>(ElementMesh.Mapping.PER_PRIM_VERTEX, this.texuv, 3);
        }

        public Mesh getOutlineMesh() {
            return new Mesh(this.verts, this.boundaryLines, 1);
        }

        private static class HashableEdge {
            public final int i1;
            public final int i2;

            public HashableEdge(int n, int n2) {
                this.i1 = n;
                this.i2 = n2;
            }

            public int hashCode() {
                return this.i1 ^ this.i2;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object == null || !object.getClass().equals(this.getClass())) {
                    return false;
                }
                HashableEdge hashableEdge = (HashableEdge)object;
                return this.i1 == hashableEdge.i1 && this.i2 == hashableEdge.i2 || this.i1 == hashableEdge.i2 && this.i2 == hashableEdge.i1;
            }
        }
    }
}

