/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.PyroDisplayGeom;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.io.fds.EnabledFilter;
import pyrosim.mv.ModelView;
import pyrosim.mv.PyroDrawProps;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.theTimer;

public class GeomDisplayMgr
extends APyroDisplayMgr<IPyroGeomSrc, CapDisplay> {
    private final PyroDrawProps d_drawProps;
    private GridMergeUtil.MergeResult d_gridBoundaries;
    private final Predicate<IPyroGeomSrc> d_filter;
    private final boolean d_capsEnabled;

    public GeomDisplayMgr(PyroMod pyroMod, ModelView modelView, APyroDisplayMgr.TargetSceneMap targetSceneMap, PyroDrawProps pyroDrawProps, DisplayFilter displayFilter, Predicate<IPyroGeomSrc> predicate) {
        super(pyroMod, modelView, targetSceneMap, displayFilter, new IPyroDisplayMgr.ObjFilter<IPyroGeomSrc>(IPyroGeomSrc.class, predicate, Grid.class));
        this.d_drawProps = pyroDrawProps;
        this.d_filter = predicate;
        this.d_capsEnabled = ((Optional)targetSceneMap.apply(RenderTarget.CLIP_CAPS)).isPresent();
    }

    protected Composite<? extends IPyroObject>[] getManagers(PyroMod pyroMod) {
        return new Composite[]{pyroMod.getObstructions(), pyroMod.getZoneMgr(), pyroMod.getDevices(), pyroMod.getMsrStatMgr(), pyroMod.getSlcfList(), pyroMod.getSlcf3dList(), pyroMod.getViews()};
    }

    @Override
    protected boolean isSelected(IPyroGeomSrc iPyroGeomSrc) {
        return this.getMediator().getSelectionModel().isSelected(iPyroGeomSrc);
    }

    @Override
    public void addAll() {
        for (Composite<? extends IPyroObject> composite : this.getManagers(this.getMediator())) {
            this.addDisplays(composite.flatten(IPyroGeomSrc.class, this.getObjFilter().toTypedPredicate()));
        }
    }

    @Override
    protected CapDisplay createDisplay(IPyroGeomSrc iPyroGeomSrc, boolean bl, boolean bl2) {
        PyroDrawProps pyroDrawProps = this.getDrawProps();
        IDisplayableGeomSrc iDisplayableGeomSrc = this.getSource(iPyroGeomSrc);
        CapDisplay capDisplay = new CapDisplay(pyroDrawProps, iDisplayableGeomSrc, this.d_capsEnabled);
        capDisplay.setSelected(bl2);
        capDisplay.setVisible(bl);
        return capDisplay;
    }

    @Override
    public void updateDisplay(IPyroGeomSrc iPyroGeomSrc, CapDisplay capDisplay) {
        this.updateSelection(iPyroGeomSrc, capDisplay);
        this.updateVisibility(iPyroGeomSrc, capDisplay);
        IDisplayableGeomSrc iDisplayableGeomSrc = this.getSource(iPyroGeomSrc);
        capDisplay.setSource(iDisplayableGeomSrc);
    }

    protected IDisplayableGeomSrc getSource(IPyroGeomSrc iPyroGeomSrc) {
        return iPyroGeomSrc instanceof Vent ? new VentProxy((Vent)iPyroGeomSrc, this) : iPyroGeomSrc;
    }

    @Override
    protected boolean isVisible(IPyroGeomSrc iPyroGeomSrc) {
        return iPyroGeomSrc.isEnabled() && iPyroGeomSrc.isVisible() && !this.isFiltered(iPyroGeomSrc);
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.d_gridBoundaries = null;
    }

    @Override
    protected Set<? extends IPyroGeomSrc> getUpdateObjs(Events events, IEventRecord<IPyroGeomSrc> iEventRecord) {
        Set<IPyroGeomSrc> set = iEventRecord.getChangedObjs(EventChannel.EVT_GENERAL, PyroMod.EVT_APPEARANCE);
        IdentityHashSet identityHashSet = new IdentityHashSet();
        IEventRecord<Grid> iEventRecord2 = events.getEvents(Grid.class, new Class[0]);
        Set<Grid> set2 = GeomDisplayMgr.getChangedDependedOn(events, Grid.class, new Object[0]);
        if (iEventRecord2.hasAddedObjs() || iEventRecord2.hasRemovedObjs() || !set2.isEmpty()) {
            identityHashSet.addAll(this.getMediator().getSlcfList().flatten(PlanarSlice.class, this.getObjFilter().toTypedPredicate()));
            identityHashSet.addAll(this.getMediator().getSlcf3dList().flatten(VolumeSlice.class, this.getObjFilter().toTypedPredicate()));
            identityHashSet.addAll(this.getMediator().getObstructions().flatten(Vent.class, this.getObjFilter().toTypedPredicate()));
        }
        if (!identityHashSet.isEmpty()) {
            set = new IdentityHashSet<IPyroGeomSrc>(set);
            set.addAll(identityHashSet);
        }
        return set;
    }

    private static <T extends IPyroObject> Set<T> getChangedDependedOn(Events events, Class<T> clazz, Object ... objectArray) {
        IEventRecord<T> iEventRecord = events.getEvents(clazz, new Class[0]);
        Set<T> set = objectArray.length > 0 ? iEventRecord.getChangedObjs(objectArray) : iEventRecord.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_PARENT_CHANGED);
        return set;
    }

    @Override
    public void processEvents(Events events, EventResult eventResult) {
        IEventRecord<Grid> iEventRecord = events.getEvents(Grid.class, new Class[0]);
        Set<Grid> set = iEventRecord.getChangedNotOfType(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_PARENT_CHANGED);
        if (iEventRecord.hasAddedObjs() || iEventRecord.hasRemovedObjs() || !set.isEmpty()) {
            this.d_gridBoundaries = null;
        }
        super.processEvents(events, eventResult);
    }

    @Override
    public void updateClipping(ClippingManager clippingManager) {
        Object object2;
        if (!this.d_capsEnabled) {
            return;
        }
        theTimer theTimer2 = new theTimer();
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        for (Object object2 : this.getDisplayMap().values()) {
            if (!((CapDisplay)object2).containsCaps) continue;
            linkedIdentityHashSet.add(object2);
        }
        ConvexHull convexHull = clippingManager.getClipRegion();
        object2 = (iDisplayableGeomSrc, containment) -> {
            CapDisplay capDisplay;
            if (containment == Containment.INTERSECTS && iDisplayableGeomSrc instanceof IPyroGeomSrc && (capDisplay = (CapDisplay)this.getDisplay((IPyroGeomSrc)iDisplayableGeomSrc)) != null) {
                linkedIdentityHashSet.add(capDisplay);
            }
        };
        this.getMediator().getGeomLocator().find(convexHull, (IResult<? super IDisplayableGeomSrc>)object2, true);
        System.out.printf("Updating clip caps for %d/%d displays...", linkedIdentityHashSet.size(), this.getDisplayMap().size());
        System.out.flush();
        for (CapDisplay capDisplay : linkedIdentityHashSet) {
            capDisplay.update();
        }
        System.out.printf("done (%g s)%n", theTimer2.curr());
    }

    public GridMergeUtil.MergeResult getGridBoundaries() {
        if (this.d_gridBoundaries == null) {
            Collection collection = this.getMediator().getGridManager().flatten(new EnabledFilter());
            this.d_gridBoundaries = GridMergeUtil.mergeGrids(collection, Collections.EMPTY_LIST);
        }
        return this.d_gridBoundaries;
    }

    protected PyroDrawProps getDrawProps() {
        return this.d_drawProps;
    }

    private static class GeomSource
    implements IDisplayableGeomSrc {
        private DisplayGeom d_nextDisplay;

        public void update(DisplayGeom displayGeom) {
            this.d_nextDisplay = displayGeom;
        }

        @Override
        public AABox getBounds() {
            return null;
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
            DisplayGeom displayGeom = this.d_nextDisplay;
            this.d_nextDisplay = null;
            return displayGeom;
        }
    }

    public static class CapDisplay
    implements IPyroDisplay {
        private IDisplayableGeomSrc d_src;
        private final GeomSource d_uncappedSrc;
        private final GeomSource d_cappedSrc;
        private final GeomDisplay d_uncappedDisp;
        private final GeomDisplay d_cappedDisp;
        public boolean containsCaps = false;

        public CapDisplay(INativeDisplayProps iNativeDisplayProps, IDisplayableGeomSrc iDisplayableGeomSrc, boolean bl) {
            this.d_src = iDisplayableGeomSrc;
            GeomSource geomSource = this.d_uncappedSrc = iDisplayableGeomSrc instanceof VentProxy ? ((VentProxy)this.d_src).clone() : new GeomSource();
            this.d_cappedSrc = bl ? (iDisplayableGeomSrc instanceof VentProxy ? ((VentProxy)this.d_src).clone() : new GeomSource()) : null;
            this.updateSources(iNativeDisplayProps);
            this.d_uncappedDisp = new GeomDisplay(iNativeDisplayProps, this.d_uncappedSrc);
            this.d_cappedDisp = bl ? new GeomDisplay(iNativeDisplayProps, this.d_cappedSrc) : null;
        }

        public void setSource(IDisplayableGeomSrc iDisplayableGeomSrc) {
            this.d_src = iDisplayableGeomSrc;
            this.update();
        }

        @Override
        public void getDisplayObjs(RenderTarget renderTarget, Collection<? super IDisplayable> collection) {
            switch (renderTarget) {
                case NORMAL: {
                    collection.add(this.d_uncappedDisp);
                    break;
                }
                case CLIP_CAPS: {
                    if (this.d_cappedDisp == null) break;
                    collection.add(this.d_cappedDisp);
                }
            }
        }

        private void apply(Consumer<GeomDisplay> consumer) {
            consumer.accept(this.d_uncappedDisp);
            if (this.d_cappedDisp != null) {
                consumer.accept(this.d_cappedDisp);
            }
        }

        @Override
        public void setSelected(boolean bl) {
            this.apply(geomDisplay -> geomDisplay.setSelected(bl));
        }

        @Override
        public void setVisible(boolean bl) {
            this.apply(geomDisplay -> geomDisplay.setVisible(bl));
        }

        private void updateSources(INativeDisplayProps iNativeDisplayProps) {
            PyroDrawProps pyroDrawProps;
            ClippingManager clippingManager;
            DisplayGeom displayGeom = this.d_src.getDisplayGeom(iNativeDisplayProps);
            DisplayGeom displayGeom2 = DisplayGeom.EMPTY;
            if (this.d_cappedSrc != null && iNativeDisplayProps instanceof PyroDrawProps && (clippingManager = (pyroDrawProps = (PyroDrawProps)iNativeDisplayProps).getClippingManager()) != null && !clippingManager.getClipRegion().acceptsAll()) {
                IElemSource<Point2d> iElemSource = TexCoordGenerator.DEFAULT_OBJ;
                IPropsSrc iPropsSrc = null;
                boolean bl = false;
                iPropsSrc = clippingManager.getClipProps();
                bl = true;
                displayGeom2 = GeomUtil.generateClipCaps(pyroDrawProps, displayGeom, clippingManager.getClipRegion(), iPropsSrc, bl, iElemSource);
                boolean bl2 = this.containsCaps = displayGeom2.node.getNumPrims(7) != 0;
            }
            if (displayGeom instanceof PyroDisplayGeom && (((PyroDisplayGeom)displayGeom).options & 1) != 0) {
                displayGeom = GeomUtil.convertToOutline(displayGeom);
                displayGeom2 = GeomUtil.convertToOutline(displayGeom2);
            }
            this.d_uncappedSrc.update(displayGeom);
            if (this.d_cappedSrc != null) {
                this.d_cappedSrc.update(displayGeom2);
            }
        }

        @Override
        public void update() {
            this.updateSources(this.d_uncappedDisp.getDisplayProps());
            this.apply(geomDisplay -> geomDisplay.update());
        }
    }

    public static class VentProxy
    extends GeomSource
    implements IPickable,
    Cloneable {
        private final Vent d_vent;
        private final GeomDisplayMgr d_mgr;

        public VentProxy(Vent vent, GeomDisplayMgr geomDisplayMgr) {
            this.d_vent = vent;
            this.d_mgr = geomDisplayMgr;
        }

        public VentProxy clone() {
            return new VentProxy(this.d_vent, this.d_mgr);
        }

        @Override
        public AABox getBounds() {
            return this.d_vent.getBounds();
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
            return this.d_vent.getDisplayGeom(iDisplayProps);
        }

        @Override
        public boolean isVisible() {
            return this.d_vent.isVisible();
        }

        @Override
        public void setVisible(boolean bl) {
            this.d_vent.setVisible(bl);
        }

        private DisplayGeom getPickGeom() {
            return this.getDisplayGeom(this.d_mgr.getDrawProps());
        }

        @Override
        public void getAll(Consumer<Object> consumer, IIsectFilter iIsectFilter) {
            IPickable.getAll(this.d_vent, consumer, iIsectFilter);
        }

        @Override
        public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
            IPickable.pickBox(this.d_vent, this::getPickGeom, iBoxCollector, iIsectFilter, convexHull);
        }

        @Override
        public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
            IPickable.pickPoints(this.d_vent, this::getPickGeom, iIsectCollector, iIsectFilter, point3d, point3d2, vector3d, iTest);
        }
    }
}

