/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.Arrays;
import java.util.Collection;
import pyrosim.PyroMod;
import pyrosim.domain.Floor;
import pyrosim.domain.ModelImage;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.FloorDisplay;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.util.Events;

public class FloorDisplayManager
extends APyroDisplayMgr<Floor, FloorDisplay> {
    public FloorDisplayManager(PyroMod pyroMod, ModelScene modelScene, ModelView modelView, DisplayFilter displayFilter) {
        super(pyroMod, modelView, FloorDisplayManager.newSceneMap(modelScene), Floor.class, displayFilter);
    }

    @Override
    protected Collection<? extends Class<?>> getFilterTypes() {
        return Arrays.asList(ModelImage.class);
    }

    @Override
    public void addAll() {
        this.addDisplays(this.getMediator().getFloorManager().flatten());
    }

    @Override
    protected FloorDisplay createDisplay(Floor floor, boolean bl, boolean bl2) {
        FloorDisplay floorDisplay = new FloorDisplay(floor);
        floorDisplay.setSelected(bl2);
        floorDisplay.setVisible(bl);
        return floorDisplay;
    }

    @Override
    protected void filterChanged(DisplayFilter displayFilter, Class clazz) {
        this.updateAll();
    }

    @Override
    protected boolean isVisible(Floor floor) {
        if (this.getMV() == null) {
            return false;
        }
        ModelImage modelImage = floor.getBgImage();
        boolean bl = modelImage != null && !this.isFiltered(modelImage);
        boolean bl2 = this.getScenes().apply(RenderTarget.NORMAL).get().getCamera() instanceof PerspectiveCamera;
        return bl && (bl2 || floor == this.getMV().getCurrentFloor());
    }

    @Override
    public void processEvents(Events events, EventResult eventResult) {
        super.processEvents(events, eventResult);
    }
}

