/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import pyrosim.PyroMod;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.APyroDisplayMgr;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.FloorDisplayManager;
import pyrosim.mv.displays.GeomDisplayMgr;
import pyrosim.mv.displays.GridDisplayManager;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.LabelMgr;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class DisplayManager
implements IPyroDisplayMgr<Object> {
    private final PyroMod d_domain;
    private final ModelView d_mv;
    private final ModelScene d_scene;
    private final ModelScene d_capsScene;
    private final ModelScene d_patchScene;
    private final ModelScene d_backgroundScene;
    private final ModelScene d_gridScene;
    public final DisplayFilter d_dispFilter;
    public final GridDisplayManager d_gridDispMan;
    public final FloorDisplayManager d_floorDispMan;
    public final GeomDisplayMgr d_geomDispMan;
    public final LabelMgr d_labelMan;
    public final GeomDisplayMgr d_patchDispMan;
    public final GeomDisplayMgr d_clipDispMan;
    public final GeomDisplayMgr d_exClipDispMan;
    private IPyroDisplayMgr<?>[] d_allManagers;

    public DisplayManager(PyroMod pyroMod, ModelView modelView, ModelScene modelScene, ModelScene modelScene2, ModelScene modelScene3, ModelScene modelScene4, ModelScene modelScene5, ModelScene modelScene6, ModelScene modelScene7) {
        this.d_domain = pyroMod;
        this.d_mv = modelView;
        this.d_scene = modelScene;
        this.d_capsScene = modelScene2;
        this.d_patchScene = modelScene3;
        this.d_backgroundScene = modelScene4;
        this.d_gridScene = modelScene5;
        this.d_dispFilter = new DisplayFilter();
        this.d_gridDispMan = new GridDisplayManager(pyroMod, modelScene, modelView, this.d_dispFilter);
        this.d_floorDispMan = new FloorDisplayManager(pyroMod, modelScene3, modelView, this.d_dispFilter);
        TypeFilter<IPyroGeomSrc> typeFilter = new TypeFilter<IPyroGeomSrc>(Vent.class, FlowMeasurer.class);
        TypeFilter<IPyroGeomSrc> typeFilter2 = new TypeFilter<IPyroGeomSrc>(SectionBox.class);
        TypeFilter<IPyroGeomSrc> typeFilter3 = new TypeFilter<IPyroGeomSrc>(CameraState.class);
        Predicate<IPyroGeomSrc> predicate = typeFilter.or(typeFilter2).or(typeFilter3).negate();
        APyroDisplayMgr.TargetSceneMap targetSceneMap = renderTarget -> {
            switch (renderTarget) {
                case NORMAL: {
                    return Optional.of(modelScene);
                }
                case CLIP_CAPS: {
                    return Optional.ofNullable(modelScene2);
                }
            }
            return Optional.empty();
        };
        this.d_geomDispMan = new GeomDisplayMgr(pyroMod, modelView, targetSceneMap, modelView.getDrawProps(), this.d_dispFilter, predicate);
        APyroDisplayMgr.TargetSceneMap targetSceneMap2 = GeomDisplayMgr.newSceneMap(modelScene3);
        this.d_patchDispMan = new GeomDisplayMgr(pyroMod, modelView, targetSceneMap2, modelView.getDrawProps(), this.d_dispFilter, typeFilter);
        APyroDisplayMgr.TargetSceneMap targetSceneMap3 = GeomDisplayMgr.newSceneMap(modelScene6);
        this.d_clipDispMan = new GeomDisplayMgr(pyroMod, modelView, targetSceneMap3, modelView.getDrawProps(), this.d_dispFilter, typeFilter2);
        APyroDisplayMgr.TargetSceneMap targetSceneMap4 = GeomDisplayMgr.newSceneMap(modelScene7);
        this.d_exClipDispMan = new GeomDisplayMgr(pyroMod, modelView, targetSceneMap4, modelView.getDrawProps(), this.d_dispFilter, typeFilter3);
        IPyroDisplayMgr.ObjFilter<IPyroGeomSrc> objFilter = new IPyroDisplayMgr.ObjFilter<IPyroGeomSrc>(IPyroGeomSrc.class, new TypeFilter(IDevice.class, HvacNode.class, HvacDuct.class), HvacDevice.class, DryPipe.class);
        this.d_labelMan = new LabelMgr(pyroMod, modelView, modelScene, this.d_dispFilter, objFilter, this.d_geomDispMan, this.d_patchDispMan);
        ArrayList<APyroDisplayMgr> arrayList = new ArrayList<APyroDisplayMgr>();
        arrayList.addAll(Arrays.asList(this.d_gridDispMan, this.d_floorDispMan, this.d_geomDispMan, this.d_patchDispMan, this.d_clipDispMan, this.d_exClipDispMan, this.d_labelMan));
        this.d_allManagers = theUtil.toArray(arrayList, IPyroDisplayMgr.class);
    }

    public GridMergeUtil.MergeResult getMergedGrids() {
        return this.d_geomDispMan.getGridBoundaries();
    }

    public void updateMode(ModelView.IViewMode iViewMode) {
        if (iViewMode instanceof ModelView.ViewMode2D) {
            this.d_floorDispMan.setScene(FloorDisplayManager.newSceneMap(this.d_backgroundScene));
            this.d_gridDispMan.setScene(GridDisplayManager.newSceneMap(this.d_gridScene));
        } else {
            this.d_floorDispMan.setScene(FloorDisplayManager.newSceneMap(this.d_patchScene));
            this.d_gridDispMan.setScene(GridDisplayManager.newSceneMap(this.d_scene));
        }
    }

    @Override
    public IPyroDisplayMgr.ObjFilter<Object> getObjFilter() {
        return new IPyroDisplayMgr.ObjFilter<Object>(Object.class, Filters.acceptAll(), new Class[0]);
    }

    @Override
    public void removeAll() {
        this.d_mv.getNativeDrawProps().removeAllMats(this.d_domain);
        for (IPyroDisplayMgr iPyroDisplayMgr : this.getDispManagers()) {
            iPyroDisplayMgr.removeAll();
        }
    }

    @Override
    public void addAll() {
        this.d_mv.getNativeDrawProps().addAllMats(this.d_domain);
        for (IPyroDisplayMgr iPyroDisplayMgr : this.getDispManagers()) {
            iPyroDisplayMgr.addAll();
        }
    }

    @Override
    public void processEvents(Events events, EventResult eventResult) {
        this.d_mv.getNativeDrawProps().update(events);
        for (IPyroDisplayMgr iPyroDisplayMgr : this.getDispManagers()) {
            iPyroDisplayMgr.processEvents(events, eventResult);
        }
    }

    @Override
    public void updateClipping(ClippingManager clippingManager) {
        for (IPyroDisplayMgr iPyroDisplayMgr : this.getDispManagers()) {
            iPyroDisplayMgr.updateClipping(clippingManager);
        }
    }

    public IPyroDisplayMgr[] getDispManagers() {
        return this.d_allManagers;
    }

    public void add(Object ... objectArray) {
        this.add(Arrays.asList(objectArray));
    }

    public void add(Collection<?> collection) {
        for (IPyroDisplayMgr<?> iPyroDisplayMgr : this.d_allManagers) {
            iPyroDisplayMgr.addDisplays(theUtil.filter(collection, iPyroDisplayMgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    public void remove(Object ... objectArray) {
        this.remove(Arrays.asList(objectArray));
    }

    public void remove(Collection<?> collection) {
        for (int i = this.d_allManagers.length - 1; i >= 0; --i) {
            IPyroDisplayMgr<?> iPyroDisplayMgr = this.d_allManagers[i];
            iPyroDisplayMgr.removeDisplays(theUtil.filter(collection, iPyroDisplayMgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    @Override
    public void removeFromScene(Collection<?> collection) {
        for (int i = this.d_allManagers.length - 1; i >= 0; --i) {
            IPyroDisplayMgr<?> iPyroDisplayMgr = this.d_allManagers[i];
            iPyroDisplayMgr.removeFromScene(theUtil.filter(collection, iPyroDisplayMgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    @Override
    public void addToScene(Collection<?> collection) {
        for (IPyroDisplayMgr<?> iPyroDisplayMgr : this.d_allManagers) {
            iPyroDisplayMgr.addToScene(theUtil.filter(collection, iPyroDisplayMgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    public Collection<IDisplayable> getDisplayObjs(Object ... objectArray) {
        return this.getDisplayObjs(Arrays.asList(objectArray));
    }

    public Collection<IDisplayable> getDisplayObjs(Collection<?> collection) {
        ArrayList<IDisplayable> arrayList = new ArrayList<IDisplayable>(collection.size());
        for (RenderTarget renderTarget : RenderTarget.values()) {
            for (Object obj : collection) {
                IPyroDisplay iPyroDisplay = this.getDisplay(obj);
                if (iPyroDisplay == null) continue;
                iPyroDisplay.getDisplayObjs(renderTarget, arrayList);
            }
        }
        return arrayList;
    }

    @Override
    public IPyroDisplay getDisplay(Object object) {
        for (IPyroDisplayMgr<?> iPyroDisplayMgr : this.d_allManagers) {
            IPyroDisplay iPyroDisplay = iPyroDisplayMgr.getDisplay(object);
            if (iPyroDisplay == null) continue;
            return iPyroDisplay;
        }
        return null;
    }

    public void updateDisplays(Object ... objectArray) {
        this.updateDisplays((Collection<?>)Arrays.asList(objectArray));
    }

    @Override
    public void updateDisplays(Collection<?> collection) {
        for (IPyroDisplayMgr<?> iPyroDisplayMgr : this.d_allManagers) {
            iPyroDisplayMgr.updateDisplays(theUtil.filter(collection, iPyroDisplayMgr.getObjFilter().toArbitraryPredicate()));
        }
    }

    @Override
    public Function<RenderTarget, Optional<ModelScene>> getScenes() {
        return renderTarget -> {
            switch (renderTarget) {
                case NORMAL: {
                    return Optional.of(this.d_scene);
                }
            }
            return Optional.empty();
        };
    }

    private IPyroDisplayMgr getFirstMgr(Object object) {
        for (IPyroDisplayMgr<?> iPyroDisplayMgr : this.d_allManagers) {
            if (!iPyroDisplayMgr.getObjFilter().toArbitraryPredicate().test(object)) continue;
            return iPyroDisplayMgr;
        }
        return null;
    }

    @Override
    public void addDisplays(Collection<? extends Object> collection) {
        for (Object object : collection) {
            IPyroDisplayMgr iPyroDisplayMgr = this.getFirstMgr(object);
            if (iPyroDisplayMgr == null) continue;
            iPyroDisplayMgr.addDisplays(Arrays.asList(object));
        }
    }

    @Override
    public void removeDisplays(Collection<? extends Object> collection) {
        for (Object object : collection) {
            IPyroDisplayMgr iPyroDisplayMgr = this.getFirstMgr(object);
            if (iPyroDisplayMgr == null) continue;
            iPyroDisplayMgr.removeDisplays(Arrays.asList(object));
        }
    }

    @Override
    public void updateAll() {
        for (IPyroDisplayMgr iPyroDisplayMgr : this.getDispManagers()) {
            iPyroDisplayMgr.updateAll();
        }
    }

    @Override
    public void setTransform(Matrix4d matrix4d) {
        for (IPyroDisplayMgr iPyroDisplayMgr : this.getDispManagers()) {
            iPyroDisplayMgr.setTransform(matrix4d);
        }
    }
}

