/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theObservable;

public class DisplayFilter
extends theObservable {
    private final Map<Class<?>, Predicate<?>> d_filters = new HashMap();
    private final Map<Class<?>, Predicate<?>[]> d_cachedFilters = new HashMap();

    public void changed(Class clazz) {
        this.clearCache();
        this.setChanged();
        this.tryFireNotification(clazz);
    }

    public <T> void registerFilter(Class<T> clazz, Predicate<? super T> predicate) {
        assert (predicate != null) : "Filter must not be null. To remove a filter, use the method, removeFilter.";
        Predicate<? super T> predicate2 = this.d_filters.put(clazz, predicate);
        if (!predicate.equals(predicate2)) {
            this.changed(clazz);
        }
    }

    public <T> void filterAllOfType(Class<T> clazz) {
        this.registerFilter(clazz, Filters.rejectAll(clazz));
    }

    public <T> void removeFilter(Class<T> clazz) {
        Predicate<?> predicate = this.d_filters.remove(clazz);
        if (predicate != null) {
            this.changed(clazz);
        }
    }

    public <T> boolean isFilteringAllOf(Class<T> clazz) {
        Predicate[] predicateArray;
        for (Predicate predicate : predicateArray = this.getHierarchyFilters(clazz)) {
            if (predicate != Predicates.alwaysFalse()) continue;
            return true;
        }
        return false;
    }

    private void clearCache() {
        this.d_cachedFilters.clear();
    }

    public boolean filter(Object object) {
        return this.filter(object, object.getClass());
    }

    private boolean filter(Object object, Class clazz) {
        Predicate[] predicateArray;
        for (Predicate predicate : predicateArray = this.getHierarchyFilters(clazz)) {
            if (predicate.test(object)) continue;
            return true;
        }
        return false;
    }

    private Predicate[] getHierarchyFilters(Class clazz) {
        Predicate[] predicateArray = this.d_cachedFilters.get(clazz);
        if (predicateArray == null) {
            ArrayList<Predicate> arrayList = new ArrayList<Predicate>();
            this.getHierarchyFilters(clazz, arrayList);
            predicateArray = arrayList.toArray(new Predicate[arrayList.size()]);
            this.d_cachedFilters.put(clazz, predicateArray);
        }
        return predicateArray;
    }

    private void getHierarchyFilters(Class clazz, List<Predicate> list) {
        Class clazz2;
        Predicate<?> predicate = this.d_filters.get(clazz);
        if (predicate != null) {
            list.add(predicate);
        }
        if ((clazz2 = clazz.getSuperclass()) != null) {
            this.getHierarchyFilters(clazz2, list);
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            this.getHierarchyFilters(clazz3, list);
        }
    }
}

