/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.Floor;
import pyrosim.domain.view.ClipPlane;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewMgr;
import pyrosim.geom.Geometry;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IProxyGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;

public class ClippingManager
implements Observer {
    private final PyroMod d_mod;
    private final ModelView d_mv;
    private UnitDouble[] d_floorClipping = null;
    private ConvexHull d_cachedHull = null;
    private IPropsSrc d_cachedClipProps = null;
    private ConvexHull d_currHull = new ConvexHull(new Plane3d[0]);
    private IPropsSrc d_currClipProps;
    private static final Predicate<Object> s_changeFilter = Filters.reject(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED);

    public ClippingManager(PyroMod pyroMod, ModelView modelView, DisplayFilter displayFilter) {
        this.d_currClipProps = DisplayGeom.EMPTY.props;
        this.d_mod = pyroMod;
        this.d_mv = modelView;
        displayFilter.addObserver(this);
    }

    @Override
    public void update(Observable observable, Object object) {
        if (object == EnableClipping.class) {
            System.out.println("updating filter");
            this.d_cachedHull = null;
            this.updateSceneClipping();
        }
    }

    public IPropsSrc getClipProps() {
        this.updateCache();
        return this.d_cachedClipProps;
    }

    public ConvexHull getClipRegion() {
        this.updateCache();
        return this.d_cachedHull;
    }

    private void updateCache() {
        if (this.d_cachedHull == null || this.d_cachedClipProps == null) {
            boolean bl = !this.d_mv.getDisplayManager().d_dispFilter.isFilteringAllOf(EnableClipping.class);
            Pair<ConvexHull, IPropsSrc> pair = this.calcClipRegion(bl);
            this.d_cachedHull = (ConvexHull)pair.v1;
            this.d_cachedClipProps = (IPropsSrc)pair.v2;
        }
    }

    private Pair<ConvexHull, IPropsSrc> calcClipRegion(boolean bl) {
        PropsBuilder propsBuilder = new PropsBuilder();
        ArrayList<Plane3d> arrayList = new ArrayList<Plane3d>();
        this.getFloorClipPlanes(arrayList, propsBuilder);
        this.getViewClipPlanes(arrayList, propsBuilder);
        if (bl) {
            this.getSectionBoxClipPlanes(arrayList, propsBuilder, 6);
        }
        ConvexHull convexHull = new ConvexHull(arrayList);
        int n = convexHull.getPlanes().length;
        convexHull = convexHull.optimize();
        IPropsSrc iPropsSrc = propsBuilder.finalizeProps();
        if (convexHull.getPlanes().length != n) {
            iPropsSrc = convexHull.getPlanes().length > 0 ? new UniformProps(iPropsSrc.get(0)) : DisplayGeom.EMPTY.props;
        }
        return new Pair<ConvexHull, IPropsSrc>(convexHull, iPropsSrc);
    }

    private static double getFloorTolerance() {
        return 1.0E-4;
    }

    private void getFloorClipPlanes(List<Plane3d> list, PropsBuilder propsBuilder) {
        UnitDouble[] unitDoubleArray = this.getFloorClipping();
        if (unitDoubleArray[0] == null && unitDoubleArray[1] == null) {
            return;
        }
        double d = ClippingManager.getFloorTolerance();
        Color color = Floor.DEFAULT_COLOR;
        Floor floor = this.d_mv.getCurrentFloor();
        if (floor != null) {
            color = floor.getClipColor();
        }
        list.add(new Plane3d(0.0, 0.0, 1.0, -unitDoubleArray[1].getValue(Geometry.LU) + d));
        list.add(new Plane3d(0.0, 0.0, -1.0, unitDoubleArray[0].getValue(Geometry.LU) - d));
        propsBuilder.add(new IPrimProps.Face(color, null, 0), 2);
    }

    private UnitDouble[] getFloorClipping() {
        if (this.d_floorClipping == null) {
            this.d_floorClipping = this.calculateFloorClipping();
        }
        return this.d_floorClipping;
    }

    private UnitDouble[] calculateFloorClipping() {
        Collection collection = this.d_mod.getFloorManager().flatten();
        Floor floor = this.d_mv.getCurrentFloor();
        if (floor == null) {
            return new UnitDouble[]{null, null};
        }
        List<Floor> list = Util.sort(collection, new Floor.CompareLevel());
        int n = list.indexOf(floor);
        Floor floor2 = n > 0 ? list.get(n - 1) : null;
        UnitDouble unitDouble = null;
        unitDouble = floor2 != null && this.d_mv.getMainView().getCamera() instanceof OrthoCamera && Util3D.normalize(this.d_mv.getMainView().getCamera().getViewVector()).equals(GeomConstants.VEC3D_ZNEG) ? floor2.getElevation() : floor.getSlabBottom();
        UnitDouble unitDouble2 = floor.getCeilingLoc();
        return new UnitDouble[]{unitDouble, unitDouble2};
    }

    private void getViewClipPlanes(List<Plane3d> list, PropsBuilder propsBuilder) {
        View view = this.d_mod.getViews().getActiveView();
        if (view == null) {
            return;
        }
        IPrimProps.Face face = new IPrimProps.Face(Color.ORANGE, null, 0);
        for (ClipPlane clipPlane : view.getClipPlanes()) {
            list.add(clipPlane.getPlane().get());
            propsBuilder.add(face);
        }
    }

    private void getSectionBoxClipPlanes(List<Plane3d> list, PropsBuilder propsBuilder, int n) {
        View view = this.d_mod.getViews().getActiveView();
        if (view == null) {
            return;
        }
        SectionBox sectionBox = view.get(View.PROP_SECTION_BOX);
        if (sectionBox == null) {
            return;
        }
        IGeomNode iGeomNode = sectionBox.getGeom();
        List list2 = GeomUtil.explode(iGeomNode.flatten().getLocalGeom(), IPolygon.class);
        IPrimProps.Face face = new IPrimProps.Face(sectionBox.getColor(), null, 0);
        Consumer<IPolygon> consumer = iPolygon -> {
            list.add(iPolygon.getPlane(true));
            propsBuilder.add(face);
        };
        if (list2.size() + list.size() <= n) {
            list2.stream().forEach(consumer);
            return;
        }
        AABoxGeom aABoxGeom = ClippingManager.findGeomType(iGeomNode, AABoxGeom.class);
        if (aABoxGeom != null) {
            int[] nArray = new int[]{0, 1, 2, 3, 4, 5};
            int[] nArray2 = aABoxGeom.getNameToIndexFaceOrder();
            for (int i = 0; i < nArray.length && list.size() < n; ++i) {
                IPolygon iPolygon2 = (IPolygon)list2.get(nArray2[nArray[i]]);
                consumer.accept(iPolygon2);
            }
            return;
        }
        ExtrudedPoly extrudedPoly = ClippingManager.findGeomType(iGeomNode, ExtrudedPoly.class);
        if (extrudedPoly != null) {
            int n2;
            for (n2 = 0; n2 < list2.size() - 2 && list.size() < n; ++n2) {
                consumer.accept((IPolygon)list2.get(n2 + 2));
            }
            for (n2 = 0; n2 < 2 && list.size() < n; ++n2) {
                consumer.accept((IPolygon)list2.get(n2));
            }
            return;
        }
        int n3 = n - list.size();
        for (int i = 0; i < n3; ++i) {
            consumer.accept((IPolygon)list2.get(i));
        }
    }

    private static <T extends IGeom> T findGeomType(IGeomNode iGeomNode, Class<T> clazz) {
        T t = ClippingManager.findGeomType(iGeomNode.getLocalGeom(), clazz);
        if (t != null) {
            return t;
        }
        for (IGeomNode iGeomNode2 : iGeomNode.getChildren()) {
            t = ClippingManager.findGeomType(iGeomNode2, clazz);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    private static <T extends IGeom> T findGeomType(IGeom iGeom, Class<T> clazz) {
        while (iGeom instanceof IProxyGeom) {
            iGeom = ((IProxyGeom)iGeom).getBase();
        }
        return (T)(clazz.isInstance(iGeom) ? (IGeom)clazz.cast(iGeom) : null);
    }

    private void markDirty(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.d_cachedHull = null;
        }
        if (bl2) {
            this.d_cachedClipProps = null;
        }
        if (bl3) {
            this.d_floorClipping = null;
        }
    }

    public void processEvents(Events events) {
        if (this.getFloorChanged(events)) {
            this.markDirty(true, true, true);
        }
        if (this.getUpdateClipping(events)) {
            this.markDirty(true, true, false);
            this.updateSceneClipping();
            this.d_mv.getRenderComp().repaint();
        }
    }

    private boolean getFloorChanged(Events events) {
        return this.d_mv.getCurrentFloor() != null && events.getEvents(Floor.class, new Class[0]).isChanged(this.d_mv.getCurrentFloor());
    }

    private boolean getUpdateClipping(Events events) {
        if (this.getFloorChanged(events)) {
            return true;
        }
        IEventRecord<ViewMgr> iEventRecord = events.getEvents(ViewMgr.class, new Class[0]);
        if (iEventRecord.containsChange(ViewMgr.EVT_ACTIVE_VIEW)) {
            return true;
        }
        View view = this.d_mod.getViews().getActiveView();
        if (view != null) {
            IEventRecord<View> iEventRecord2 = events.getEvents(View.class, new Class[0]);
            if (iEventRecord2.getChangedObjs(s_changeFilter).contains(view)) {
                return true;
            }
            IEventRecord<ClipPlane> iEventRecord3 = events.getEvents(ClipPlane.class, new Class[0]);
            for (ClipPlane object : iEventRecord3.getChangedObjs(s_changeFilter)) {
                if (object.getParent() != view) continue;
                return true;
            }
            IEventRecord<SectionBox> iEventRecord4 = events.getEvents(SectionBox.class, new Class[0]);
            for (SectionBox sectionBox : iEventRecord4.getChangedObjs(s_changeFilter)) {
                if (sectionBox.getParent() != view) continue;
                return true;
            }
        }
        return false;
    }

    public void forceSceneClippingUpdate() {
        this.markDirty(true, true, true);
        this.updateSceneClipping();
    }

    private static boolean equal(IPropsSrc iPropsSrc, IPropsSrc iPropsSrc2, int n) {
        for (int i = 0; i < n; ++i) {
            if (iPropsSrc.get(i).equals(iPropsSrc2.get(i))) continue;
            return false;
        }
        return true;
    }

    private void updateSceneClipping() {
        this.updateCache();
        ConvexHull convexHull = this.getClipRegion();
        IPropsSrc iPropsSrc = this.getClipProps();
        if (!convexHull.equals(this.d_currHull) || !ClippingManager.equal(iPropsSrc, this.d_currClipProps, convexHull.getPlanes().length)) {
            this.d_currHull = convexHull;
            this.d_currClipProps = iPropsSrc;
            for (ModelScene modelScene : this.getClippingScenes()) {
                modelScene.removeAllCullBoxes();
            }
            if (!convexHull.acceptsAll()) {
                for (ModelScene modelScene : this.getClippingScenes()) {
                    modelScene.addCullBox(convexHull);
                }
            }
            this.d_mv.getDrawProps().setClippingManager(this);
            this.d_mv.getDisplayManager().updateClipping(this);
        }
    }

    public AABox getUnclippedBounds() {
        BoundsCalculator boundsCalculator = new BoundsCalculator();
        for (ModelScene modelScene : this.getClippingScenes()) {
            modelScene.removeAllCullBoxes();
            modelScene.getBounds(boundsCalculator);
        }
        AABox aABox = boundsCalculator.getBounds();
        if (!this.d_currHull.acceptsNone()) {
            for (ModelScene modelScene : this.getClippingScenes()) {
                modelScene.addCullBox(this.d_currHull);
            }
        }
        return aABox;
    }

    public ModelScene[] getClippingScenes() {
        return new ModelScene[]{this.d_mv.getMainScene(), this.d_mv.getPatchScene()};
    }

    public List<IPyroDisplayMgr<?>> getClippedDisplayMgrs() {
        ArrayList arrayList = new ArrayList();
        IdentityHashSet<ModelScene> identityHashSet = Sets.fromArrayIHS(this.getClippingScenes());
        block0: for (IPyroDisplayMgr iPyroDisplayMgr : this.d_mv.getDisplayManager().getDispManagers()) {
            for (RenderTarget renderTarget : RenderTarget.values()) {
                Optional<ModelScene> optional = iPyroDisplayMgr.getScenes().apply(renderTarget);
                if (!optional.filter(modelScene -> identityHashSet.contains(modelScene)).isPresent()) continue;
                arrayList.add(iPyroDisplayMgr);
                continue block0;
            }
        }
        return arrayList;
    }

    public static final class EnableClipping {
    }
}

