/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.displays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.vecmath.Matrix4d;
import pyrosim.PyroMod;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.IPyroDisplay;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IdentityHashSet;

public abstract class APyroDisplayMgr<T, D extends IPyroDisplay>
implements IPyroDisplayMgr<T>,
Observer {
    private final PyroMod d_mediator;
    private final ModelView d_mv;
    private TargetSceneMap d_scenes;
    private final Map<T, D> d_displayMap;
    private final Map<Class<?>, Count> d_typeCounts;
    private final DisplayFilter d_displayFilter;
    private final IPyroDisplayMgr.ObjFilter<T> d_filter;

    protected abstract D createDisplay(T var1, boolean var2, boolean var3);

    protected abstract boolean isVisible(T var1);

    public static TargetSceneMap newSceneMap(ModelScene modelScene) {
        return renderTarget -> {
            switch (renderTarget) {
                case NORMAL: {
                    return Optional.of(modelScene);
                }
            }
            return Optional.empty();
        };
    }

    public APyroDisplayMgr(PyroMod pyroMod, ModelView modelView, TargetSceneMap targetSceneMap, Class<T> clazz, DisplayFilter displayFilter) {
        this(pyroMod, modelView, targetSceneMap, displayFilter, new IPyroDisplayMgr.ObjFilter<T>(clazz));
    }

    public APyroDisplayMgr(PyroMod pyroMod, ModelView modelView, TargetSceneMap targetSceneMap, DisplayFilter displayFilter, IPyroDisplayMgr.ObjFilter<T> objFilter) {
        this.d_mediator = pyroMod;
        this.d_mv = modelView;
        this.d_scenes = targetSceneMap;
        this.d_displayMap = new IdentityHashMap<T, D>();
        this.d_typeCounts = new HashMap();
        this.d_displayFilter = displayFilter;
        if (this.d_displayFilter != null) {
            this.d_displayFilter.addWeakObserver(this);
        }
        this.d_filter = objFilter;
    }

    @Override
    public IPyroDisplayMgr.ObjFilter<T> getObjFilter() {
        return this.d_filter;
    }

    @Override
    public void updateClipping(ClippingManager clippingManager) {
    }

    protected Collection<? extends Class<?>> getFilterTypes() {
        return this.d_typeCounts.keySet();
    }

    public ModelView getMV() {
        return this.d_mv;
    }

    protected void repaint() {
        this.d_mv.getRenderComp().repaint();
    }

    protected List<D> getDisplays(Collection<? extends T> collection) {
        ArrayList<IPyroDisplay> arrayList = new ArrayList<IPyroDisplay>(collection.size());
        for (T t : collection) {
            IPyroDisplay iPyroDisplay = (IPyroDisplay)this.d_displayMap.get(t);
            if (iPyroDisplay == null) continue;
            arrayList.add(iPyroDisplay);
        }
        return arrayList;
    }

    protected List<IDisplayable> getDisplays(RenderTarget renderTarget, Collection<D> collection) {
        ArrayList<IDisplayable> arrayList = new ArrayList<IDisplayable>(collection.size());
        for (IPyroDisplay iPyroDisplay : collection) {
            iPyroDisplay.getDisplayObjs(renderTarget, arrayList);
        }
        return arrayList;
    }

    @Override
    public void addToScene(Collection<? extends T> collection) {
        this.addDisplays(this.d_scenes, collection, (Collection<D>)this.getDisplays(collection));
    }

    @Override
    public void removeFromScene(Collection<? extends T> collection) {
        this.removeDisplays(this.d_scenes, (Collection<D>)this.getDisplays(collection));
    }

    protected void addDisplays(Function<RenderTarget, Optional<ModelScene>> function, Collection<? extends T> collection, Collection<D> collection2) {
        for (RenderTarget renderTarget : RenderTarget.values()) {
            function.apply(renderTarget).ifPresent(modelScene -> modelScene.addObjects(this.getDisplays(renderTarget, collection2)));
        }
    }

    protected void removeDisplays(Function<RenderTarget, Optional<ModelScene>> function, Collection<D> collection) {
        for (RenderTarget renderTarget : RenderTarget.values()) {
            function.apply(renderTarget).ifPresent(modelScene -> modelScene.removeObjects(this.getDisplays(renderTarget, collection)));
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (this.d_displayFilter != null && observable == this.d_displayFilter && object != null) {
            Class clazz = (Class)object;
            for (Class<?> clazz2 : this.getFilterTypes()) {
                if (!clazz.isAssignableFrom(clazz2) && !clazz2.isAssignableFrom(clazz)) continue;
                this.filterChanged(this.d_displayFilter, clazz);
                break;
            }
        }
    }

    protected void filterChanged(DisplayFilter displayFilter, Class clazz) {
        for (Map.Entry<T, D> entry : this.d_displayMap.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey().getClass())) continue;
            this.updateVisibility(entry.getKey(), (IPyroDisplay)entry.getValue());
        }
    }

    protected DisplayFilter getFilter() {
        return this.d_displayFilter;
    }

    protected boolean isFiltered(Object object) {
        return this.d_displayFilter != null && this.d_displayFilter.filter(object);
    }

    public D getDisplay(T t) {
        return (D)((IPyroDisplay)this.d_displayMap.get(t));
    }

    public PyroMod getMediator() {
        return this.d_mediator;
    }

    @Override
    public Function<RenderTarget, Optional<ModelScene>> getScenes() {
        return this.d_scenes;
    }

    protected Map<T, D> getDisplayMap() {
        return this.d_displayMap;
    }

    public void setScene(TargetSceneMap targetSceneMap) {
        if (targetSceneMap == this.d_scenes) {
            return;
        }
        this.removeDisplays(this.d_scenes, this.d_displayMap.values());
        this.d_scenes = targetSceneMap;
        this.addDisplays(this.d_scenes, (Collection<? extends T>)this.d_displayMap.keySet(), this.d_displayMap.values());
    }

    @Override
    public void removeAll() {
        this.removeDisplays(this.d_scenes, this.d_displayMap.values());
        this.disposeDisplays(this.d_displayMap.values());
        this.d_displayMap.clear();
        this.d_typeCounts.clear();
    }

    private void disposeDisplays(Collection<D> collection) {
        ArrayList arrayList = new ArrayList(1);
        for (RenderTarget renderTarget : RenderTarget.values()) {
            ((Optional)this.d_scenes.apply(renderTarget)).ifPresent(modelScene -> {
                for (IPyroDisplay iPyroDisplay : collection) {
                    iPyroDisplay.getDisplayObjs(renderTarget, arrayList);
                    for (IDisplayable iDisplayable : arrayList) {
                        iDisplayable.dispose();
                    }
                    arrayList.clear();
                }
            });
        }
    }

    @Override
    public void updateAll() {
        this.updateDisplays(this.getObjs());
    }

    public Collection<T> getObjs() {
        return this.d_displayMap.keySet();
    }

    @Override
    public void processEvents(Events events, EventResult eventResult) {
        IEventRecord iEventRecord = events.getEvents(this.d_filter.acceptType, this.d_filter.rejectTypes).filter(this.d_filter.filter);
        Set set = iEventRecord.getAddedObjs();
        Set set2 = iEventRecord.getRemovedObjs();
        this.addDisplays(set);
        this.removeDisplays(set2);
        this.updateDisplays(events, iEventRecord);
    }

    public void addDisplays(T ... TArray) {
        this.addDisplays((Collection<? extends T>)Arrays.asList(TArray));
    }

    @Override
    public void addDisplays(Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return;
        }
        ArrayList<D> arrayList = new ArrayList<D>(collection.size());
        for (T t : collection) {
            D d = this.createDisplay(t, this.isVisible(t), this.isSelected(t));
            if (d == null) continue;
            this.addDisplay(t, d);
            arrayList.add(d);
        }
        this.addDisplays(this.d_scenes, (Collection<? extends T>)collection, (Collection<D>)arrayList);
    }

    public void removeDisplays(T ... TArray) {
        this.removeDisplays((Collection<? extends T>)Arrays.asList(TArray));
    }

    @Override
    public void removeDisplays(Collection<? extends T> collection) {
        if (collection.isEmpty()) {
            return;
        }
        ArrayList<D> arrayList = new ArrayList<D>(collection.size());
        for (T t : collection) {
            D d = this.removeDisplay(t);
            if (d == null) continue;
            arrayList.add(d);
        }
        this.removeDisplays(this.d_scenes, (Collection<D>)arrayList);
        this.disposeDisplays(arrayList);
    }

    protected void addDisplay(T t, D d) {
        IPyroDisplay iPyroDisplay = (IPyroDisplay)this.d_displayMap.put(t, d);
        if (iPyroDisplay == null) {
            this.incrementCount(t.getClass());
        }
    }

    protected D removeDisplay(T t) {
        IPyroDisplay iPyroDisplay = (IPyroDisplay)this.d_displayMap.remove(t);
        if (iPyroDisplay != null) {
            this.decrementCount(t.getClass());
        }
        return (D)iPyroDisplay;
    }

    private void incrementCount(Class<?> clazz) {
        Count count = this.d_typeCounts.get(clazz);
        if (count == null) {
            count = new Count();
            this.d_typeCounts.put(clazz, count);
        }
        ++count.val;
    }

    private void decrementCount(Class<?> clazz) {
        Count count = this.d_typeCounts.get(clazz);
        if (count != null) {
            --count.val;
            if (count.val <= 0) {
                this.d_typeCounts.remove(clazz);
            }
        }
    }

    protected void updateDisplays(Events events, IEventRecord<T> iEventRecord) {
        Set<T> set = iEventRecord.getChangedObjs(PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_ENABLED_CHANGED);
        Set<T> set2 = iEventRecord.getChangedObjs(PyroMod.EVT_SEL);
        Set<T> set3 = this.getUpdateObjs(events, iEventRecord);
        if (!set3.isEmpty()) {
            IdentityHashSet<T> identityHashSet = new IdentityHashSet<T>(set);
            identityHashSet.removeAll(set3);
            set = identityHashSet;
            identityHashSet = new IdentityHashSet<T>(set2);
            identityHashSet.removeAll(set3);
            set2 = identityHashSet;
        }
        this.updateVisibility(set);
        this.updateSelection(set2);
        this.updateDisplays(set3);
        if (iEventRecord.isModified() || !set3.isEmpty()) {
            this.repaint();
        }
    }

    protected Set<? extends T> getUpdateObjs(Events events, IEventRecord<T> iEventRecord) {
        return iEventRecord.getChangedNotOfType(PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_SEL);
    }

    @Override
    public void updateDisplays(Collection<? extends T> collection) {
        for (T t : collection) {
            D d = this.getDisplay(t);
            if (d == null) continue;
            this.updateDisplay(t, d);
        }
    }

    protected void updateDisplay(T t, D d) {
        d.update();
        this.updateSelection(t, d);
        this.updateVisibility(t, d);
    }

    protected void updateVisibility(Collection<? extends T> collection) {
        for (T t : collection) {
            D d = this.getDisplay(t);
            if (d == null) continue;
            this.updateVisibility(t, d);
        }
    }

    protected void updateVisibility(T t, D d) {
        d.setVisible(this.isVisible(t));
    }

    protected void updateSelection(Collection<? extends T> collection) {
        for (T t : collection) {
            D d = this.getDisplay(t);
            if (d == null) continue;
            this.updateSelection(t, d);
        }
    }

    protected void updateSelection(T t, D d) {
        d.setSelected(this.isSelected(t));
    }

    protected boolean isSelected(T t) {
        return this.d_mediator.getSelectionModel().isSelected(t);
    }

    @Override
    public void setTransform(Matrix4d matrix4d) {
        for (RenderTarget renderTarget : RenderTarget.values()) {
            ((Optional)this.d_scenes.apply(renderTarget)).ifPresent(modelScene -> modelScene.setTransform(matrix4d));
        }
    }

    private static class Count {
        public int val = 0;

        private Count() {
        }

        public String toString() {
            return Integer.toString(this.val);
        }
    }

    public static interface TargetSceneMap
    extends Function<RenderTarget, Optional<ModelScene>> {
    }
}

