/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv;

import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.view.SectionBox;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.snappers.IGridSnapper;
import pyrosim.mv.snappers.ISnapper;
import pyrosim.mv.snappers.OriginSnapper;
import pyrosim.mv.snappers.SnapToGrid;
import pyrosim.mv.tools.IPyroFunc;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.IDisplayable;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.MultiFunc;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickConfig;
import thunderheadeng.scene3d.picking.IPickRoot;
import thunderheadeng.scene3d.picking.IPickSession;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.OrthoSnap;
import thunderheadeng.scene3d.picking.PolarSnap;
import thunderheadeng.util.Predicates;

public class PyroPickRoot
implements IPickRoot {
    private final PyroMod d_domain;
    private final ModelView d_mv;

    public PyroPickRoot(PyroMod pyroMod, ModelView modelView) {
        this.d_domain = pyroMod;
        this.d_mv = modelView;
    }

    @Override
    public IPickSession beginPicking() {
        return new Session();
    }

    private static Point3d getAngleSnapBasis(Tool tool) {
        IPyroFunc iPyroFunc;
        if (tool instanceof IPyroTool) {
            return ((IPyroTool)tool).getAngledSnapBasis();
        }
        if (tool instanceof CursorTool && (iPyroFunc = PyroPickRoot.getPyroFunc((CursorTool)tool)) != null) {
            return iPyroFunc.getAngledSnapBasis((CursorTool)tool);
        }
        return null;
    }

    private static IPyroFunc getPyroFunc(CursorTool cursorTool) {
        MultiFunc multiFunc;
        IToolFunction<CursorTool> iToolFunction = cursorTool.getFunction();
        if (iToolFunction instanceof IPyroFunc) {
            return (IPyroFunc)iToolFunction;
        }
        if (iToolFunction instanceof MultiFunc && (iToolFunction = (multiFunc = (MultiFunc)iToolFunction).getActiveFunc(cursorTool)) instanceof IPyroFunc) {
            return (IPyroFunc)iToolFunction;
        }
        return null;
    }

    private static int getClassPreference(Object object) {
        if (object instanceof IHandle) {
            return 0;
        }
        if (object instanceof HvacNode) {
            return 1;
        }
        if (object instanceof FlowMeasurer) {
            return 2;
        }
        if (object instanceof Vent) {
            return 3;
        }
        if (object instanceof IHole) {
            return 4;
        }
        return 5;
    }

    private class Session
    implements IPickSession {
        private final boolean d_wireframe;
        private final Camera d_camera;

        private Session() {
            this.d_wireframe = PyroPickRoot.this.d_mv.getCurrentRenderOptions().get(ISceneRenderOptions.DRAW_WIREFRAME);
            this.d_camera = PyroPickRoot.this.d_mv.getMainView().getCamera();
        }

        @Override
        public boolean isVisible(IPickConfig iPickConfig, Object object) {
            if (PyroPickRoot.this.d_mv.getManipMgr().isManipulating() && (object instanceof IHandle || PyroPickRoot.this.d_mv.getManipMgr().isManipulating(object))) {
                return false;
            }
            if (object instanceof IDisplayableGeomSrc) {
                boolean bl = !(object instanceof IPyroObject) || ((IPyroObject)object).isEnabled();
                IDisplayableGeomSrc iDisplayableGeomSrc = (IDisplayableGeomSrc)object;
                return iDisplayableGeomSrc.isVisible() && bl && !((PyroPickRoot)PyroPickRoot.this).d_mv.getDisplayManager().d_dispFilter.filter(object) || PyroPickRoot.this.d_domain.getSelectionModel().isSelected(iDisplayableGeomSrc);
            }
            if (object instanceof ISnapConstraint) {
                return true;
            }
            return true;
        }

        @Override
        public IPickConfig[] getPickConfigs() {
            return new IPickConfig[]{new GeomConfig(), new InfiniteConfig()};
        }

        @Override
        public void find(IPickConfig iPickConfig, ITest<AABox> iTest, IResult<IPickable> iResult) {
            IResult<IDisplayableGeomSrc> iResult2;
            Predicate predicate = Predicates.alwaysFalse();
            for (IPyroDisplayMgr<?> object22 : PyroPickRoot.this.d_mv.getClipManager().getClippedDisplayMgrs()) {
                predicate = Predicates.or(predicate, object22.getObjFilter().toArbitraryPredicate());
            }
            Predicate<Object> predicate2 = object -> object instanceof ISnapper && !this.isInfiniteSnapper((ISnapper)object);
            final Predicate predicate3 = predicate = Predicates.or(predicate, predicate2);
            if (iPickConfig instanceof GeomConfig) {
                final IResult<IPickable> iResult4 = iResult;
                iResult2 = new IResult<IDisplayableGeomSrc>(){

                    @Override
                    public void mark(IDisplayableGeomSrc iDisplayableGeomSrc, Containment containment) {
                        if (!(iDisplayableGeomSrc instanceof IPickable) || !predicate3.test(iDisplayableGeomSrc)) {
                            return;
                        }
                        IPickable iPickable = (IPickable)((Object)iDisplayableGeomSrc);
                        if (iPickable instanceof Vent) {
                            for (IDisplayable iDisplayable : PyroPickRoot.this.d_mv.getDisplayManager().getDisplayObjs((Vent)iDisplayableGeomSrc)) {
                                if (!(iDisplayable instanceof GeomDisplay) || !(((GeomDisplay)iDisplayable).getSource() instanceof IPickable)) continue;
                                iPickable = (IPickable)((Object)((GeomDisplay)iDisplayable).getSource());
                                break;
                            }
                        }
                        iResult4.mark(iPickable, containment);
                    }
                };
            } else {
                this.findAdditionalSnaps(iTest, iResult);
                final IResult<IPickable> iResult3 = iResult;
                iResult2 = new IResult<IDisplayableGeomSrc>(){

                    @Override
                    public void mark(IDisplayableGeomSrc iDisplayableGeomSrc, Containment containment) {
                        if (iDisplayableGeomSrc instanceof IPickable && !predicate3.test(iDisplayableGeomSrc)) {
                            iResult3.mark((IPickable)((Object)iDisplayableGeomSrc), containment);
                        }
                    }
                };
            }
            PyroPickRoot.this.d_domain.getGeomLocator().find(iTest, (IResult<? super IDisplayableGeomSrc>)iResult2, true);
        }

        private boolean isInfiniteSnapper(ISnapper iSnapper) {
            return iSnapper instanceof SnapToGrid || iSnapper instanceof OriginSnapper;
        }

        private void findAdditionalSnaps(ITest<AABox> iTest, IResult<IPickable> iResult) {
            Tool tool;
            Point3d point3d;
            boolean bl = this.d_camera instanceof OrthoCamera && !PyroPickRoot.this.d_mv.getManipMgr().isManipulating();
            boolean bl2 = true;
            if ((bl || bl2) && (point3d = PyroPickRoot.getAngleSnapBasis(tool = PyroPickRoot.this.d_mv.getToolManager().getCurrentTool())) != null) {
                Object object;
                if (bl2) {
                    object = new OrthoSnap(point3d);
                    iResult.mark((IPickable)object, Containment.INTERSECTS);
                }
                if (bl) {
                    Vector3d vector3d;
                    if (this.d_camera instanceof OrthoCamera) {
                        OrthoCamera orthoCamera = (OrthoCamera)this.d_camera;
                        object = orthoCamera.getViewVector();
                        ((Vector3d)object).normalize();
                        ((Tuple3d)object).negate();
                        vector3d = orthoCamera.getRightVector();
                        vector3d.normalize();
                    } else {
                        object = GeomConstants.VEC3D_ZPOS;
                        vector3d = GeomConstants.VEC3D_XPOS;
                    }
                    PolarSnap polarSnap = new PolarSnap(point3d, (Vector3d)object, vector3d, Math.toRadians(15.0), new double[0]);
                    iResult.mark(polarSnap, Containment.INTERSECTS);
                }
            }
        }

        @Override
        public void pickPoints(IPickable iPickable, IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
            iPickable.pickPoints(iIsectCollector, iIsectFilter, point3d, point3d2, vector3d, iTest);
        }

        @Override
        public void pickBox(IPickable iPickable, IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
            iPickable.pickBox(iBoxCollector, iIsectFilter, convexHull);
        }

        @Override
        public boolean isWireframe(IPickConfig iPickConfig, Object object) {
            if (object instanceof IHandle) {
                return false;
            }
            return this.d_wireframe || object instanceof IObstruction && ((IObstruction)object).getOptions(32) || object instanceof Vent && ((Vent)object).getOptions(1) || object instanceof SectionBox;
        }

        @Override
        public int compare(Object object, Object object2) {
            return PyroPickRoot.getClassPreference(object) - PyroPickRoot.getClassPreference(object2);
        }

        @Override
        public boolean isOcclusionTarget(Object object) {
            if (object instanceof IGridSnapper) {
                return this.d_camera instanceof PerspectiveCamera;
            }
            return !(object instanceof ISnapper) && !(object instanceof ISnapConstraint);
        }

        @Override
        public boolean isOcclusionSource(Object object) {
            return (!PyroPickRoot.this.d_mv.getManipMgr().isManipulating() || PyroPickRoot.this.d_mv.getManipMgr().getCurrentManipObj() != object) && !PyroPickRoot.this.d_mv.getTransformMgr().isTransforming(object) && !(object instanceof IHandle) && this.isOccluder(object);
        }

        private boolean isOccluder(Object object) {
            return TVEntryPoints.ep(object).isOccluder(PyroPickRoot.this.d_domain, object);
        }

        private class InfiniteConfig
        implements IPickConfig {
            private InfiniteConfig() {
            }

            @Override
            public ConvexHull getClippingRegion() {
                return new ConvexHull(new Plane3d[0]);
            }
        }

        private class GeomConfig
        implements IPickConfig {
            private GeomConfig() {
            }

            @Override
            public ConvexHull getClippingRegion() {
                return PyroPickRoot.this.d_mv.getClipManager().getClipRegion();
            }
        }
    }
}

