/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Accelerators;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.PyroSimColors;
import pyrosim.PyroSimSelectionModel;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.ModelImage;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.IHvacGeomComp;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.Slice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.tasks.ViewPropTask;
import pyrosim.domain.view.CameraState;
import pyrosim.domain.view.SectionBox;
import pyrosim.domain.view.View;
import pyrosim.domain.view.ViewMgr;
import pyrosim.domain.view.ViewMode;
import pyrosim.domain.zones.Zone;
import pyrosim.geom.Geometry;
import pyrosim.gui.FloorBGImageEditor;
import pyrosim.gui.ManageFloorsDlg;
import pyrosim.gui.MenuBuilder;
import pyrosim.gui.MouseSelectionLogic;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.CompositeComboBox;
import pyrosim.gui.tasks.ManageFloorsTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Sets;
import pyrosim.legacy_2012_1.thunderheadeng.gui.GridBagHelper;
import pyrosim.mv.GridVis;
import pyrosim.mv.PyroDrawProps;
import pyrosim.mv.PyroNativeProps;
import pyrosim.mv.PyroPickRoot;
import pyrosim.mv.displays.ClippingManager;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.displays.EventResult;
import pyrosim.mv.displays.LabelMgr;
import pyrosim.mv.gui.EditSnapToGridDlg;
import pyrosim.mv.gui.ToolPropertiesDlg;
import pyrosim.mv.manip.ManipHook;
import pyrosim.mv.manip.TransformMgr;
import pyrosim.mv.snappers.CompositeModelGridSnapper;
import pyrosim.mv.snappers.IGridSnapper;
import pyrosim.mv.snappers.OriginSnapper;
import pyrosim.mv.snappers.SnapToGrid;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DefaultIsectFilter;
import pyrosim.mv.tools.DrawAABoxGeomTool;
import pyrosim.mv.tools.DrawAARectangleTool;
import pyrosim.mv.tools.DrawExtrudedPolyTool;
import pyrosim.mv.tools.DrawGridCellTool;
import pyrosim.mv.tools.DrawGridGeomTool;
import pyrosim.mv.tools.DrawHvacDuctTool;
import pyrosim.mv.tools.DrawPlaneGeomTool;
import pyrosim.mv.tools.DrawPointTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.DrawRoomTool;
import pyrosim.mv.tools.DrawToolBridge;
import pyrosim.mv.tools.DrawWallGeomTool;
import pyrosim.mv.tools.IPyroTool;
import pyrosim.mv.tools.IToggleListener;
import pyrosim.mv.tools.ManipFunc;
import pyrosim.mv.tools.MeasureTool;
import pyrosim.mv.tools.MeshAutoAxisChooser;
import pyrosim.mv.tools.MirrorTool;
import pyrosim.mv.tools.Pyro3DSelector;
import pyrosim.mv.tools.RotateTool;
import pyrosim.mv.tools.SmokeViewNavigationFunc;
import pyrosim.mv.tools.SurfacePainterTool;
import pyrosim.mv.tools.SurfacePickerTool;
import pyrosim.mv.tools.SwitchingToolFunc;
import pyrosim.mv.tools.ToolMeta;
import pyrosim.mv.tools.ToolUtil;
import pyrosim.mv.tools.TranslateTool;
import pyrosim.mv.tools.constraint.IConstraintGen;
import pyrosim.mv.tools.constraint.NoConstraintGen;
import pyrosim.mv.tools.constraint.OffsetPointConstraint;
import pyrosim.mv.tools.constraint.WorkingPlaneConstraintGen;
import pyrosim.mv.tools.popupmenu.CameraMenuBuilder;
import pyrosim.mv.tools.popupmenu.IPopupMenuBuilder;
import pyrosim.mv.tools.popupmenu.SnapConstraintMenuBuilder;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.Util;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.SwingAnimSession;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.gui.AbstractComponentListener;
import thunderheadeng.gui.ActionGroup;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.DropDownButton;
import thunderheadeng.gui.MutuallyExclusiveAction;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.colorscheme.ColorChangedEvent;
import thunderheadeng.gui.colorscheme.ColorChangedListener;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiStatusBar;
import thunderheadeng.gui.guiStatusMessage;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.image.ImageManager;
import thunderheadeng.scene3d.IntermediateGraphicsXfer;
import thunderheadeng.scene3d.gui.BGImageDlg;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.AxesScene;
import thunderheadeng.scene3d.nativebuffered.BasicRenderer;
import thunderheadeng.scene3d.nativebuffered.BoundsCalculator;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.ClearableBackground;
import thunderheadeng.scene3d.nativebuffered.IRenderComponent;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.IRenderable;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.MultiSceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.Object3D;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.OverlayLayout;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.nativebuffered.QuickSaveRestoreLayer;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.scene3d.nativebuffered.RenderFile;
import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.SceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.CompositeFunc;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.DragFunc;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.MultiFunc;
import thunderheadeng.scene3d.navtools.NavtoolUtil;
import thunderheadeng.scene3d.navtools.OrbitFunc;
import thunderheadeng.scene3d.navtools.RoamFunc;
import thunderheadeng.scene3d.navtools.SelectionFunc;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.navtools.ZoomBoxFunc;
import thunderheadeng.scene3d.navtools.ZoomFunc;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.ATask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.DisposableObject;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Task;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class ModelView
implements ColorChangedListener,
IEventObserver,
IToolController {
    public static final UnitDouble DEFAULT_FOV = new UnitDouble(45.0, NonSI.DEGREE_ANGLE);
    public static final int SNAPPER_NONE = 0;
    public static final int SNAPPER_SKETCH_GRID = 1;
    public static final int SNAPPER_MODEL_GRIDS = 2;
    public static final int FILTER_OBSTRUCTIONS = 1;
    public static final int FILTER_HOLES = 2;
    public static final int FILTER_VENTS = 3;
    public static final int FILTER_INIT = 4;
    public static final int FILTER_PARTCLOUDS = 5;
    public static final int FILTER_DEVICES = 6;
    public static final int FILTER_HVAC = 7;
    public static final int FILTER_ZONES = 9;
    public static final int FILTER_STATISTICS = 10;
    public static final int FILTER_SLICES = 11;
    public static final int FILTER_LABELS = 13;
    public static final int FILTER_CAD = 14;
    public static final int FILTER_CAMERAS = 16;
    private final AxesScene d_axes = new AxesScene();
    private final ClearableBackground d_colorLayer = new ClearableBackground(true, true);
    private final ModelScene d_backgroundScene = new ModelScene();
    private final ModelScene d_gridScene = new ModelScene();
    private final ModelScene d_originScene = new ModelScene();
    private final GeomScenes d_mainScenes = new GeomScenes();
    private final ModelScene d_manipScene = new ModelScene();
    private final GeomScenes d_xformScenes = new GeomScenes();
    private final ModelScene d_manipToolScene = new ModelScene();
    private final BasicRenderer d_toolLayer = new BasicRenderer();
    private final RenderComponent d_renderComp = new RenderComponent();
    private final RenderFile d_renderFile = new RenderFile(this.d_renderComp);
    private final View d_mainView;
    private final MouseSelectionLogic d_selLogic;
    private final ClippingManager d_clipMgr;
    private final SwingAnimSession d_animSession;
    private final PyroMod d_mediator;
    private final PyroSimColors d_colors;
    private final OriginSnapper d_origin;
    private final SnapToGrid d_sketchGrid;
    private final CompositeModelGridSnapper d_modelGridSnapper;
    private IGridSnapper d_currentSnapper;
    private Floor d_currentFloor;
    private Floor d_allFloorsFloor;
    private final BooleanAction d_showGridDivsAction;
    private final BooleanAction d_showGridBoundaryAction;
    private final BooleanAction d_showGridOutlinesAction;
    private final BooleanAction d_showGuidesAction;
    private final BooleanAction d_showPointerAction;
    private final EditSnapSize d_editGridSizeAction;
    private final BooleanAction d_showOriginAction;
    private final BooleanAction d_showBackgroundImages;
    private final ConfigureBGImageAction d_configureBGImageAction;
    private final ManageFloorsAction d_manageFloorsAction;
    private final BooleanAction d_useSVNavAction;
    private final ResetToAllObjectsAction d_resetToAllAction;
    private final ResetToSelectedObjectsAction d_resetToSelectedAction;
    private final FillViewAction d_fillViewAction;
    private final ShowSolidOutlinesAction d_solidOutlinesAction;
    private final ShowRealisticAction d_realisticAction;
    private final ShowRealisticOutlinesAction d_realisticOutlinesAction;
    private final UseWireframeAction d_wireframeAction;
    private final UseWireframeAction d_solidAction;
    private final CutHolesAction d_cutHolesAction;
    private final MutuallyExclusiveAction d_noSnapperAction;
    private final MutuallyExclusiveAction d_sketchGridAction;
    private final MutuallyExclusiveAction d_modelGridsAction;
    private final FilterActionInfo[] d_clipFilterActions;
    private final FilterActionInfo[] d_filterActions;
    private final FilterActionInfo[] d_gridFilterActions;
    private JPanel d_3DPanel;
    private JPanel d_3DTopPanel;
    private final JToolBar d_viewOptionsToolbar;
    private final JToolBar d_floorToolbar;
    private final JToolBar d_editClipPlanesToolbar;
    private final JToolBar d_groupToolbar;
    private final JToolBar d_editToolbar;
    private final JToolBar d_createToolbar;
    private final JToolBar d_filterToolbar;
    private final guiStatusBar d_statusBar;
    private final guiLabel d_statusSelection;
    private final guiStatusMessage d_statusMessage;
    private final JComboBox d_floorBox;
    private final CompositeComboBox<IModelObj> d_groupBox;
    private final guiComboBox<Action> d_appearanceBox;
    private final ToolManager d_tools;
    private final ToolPropsAction d_toolPropsAction;
    private final GeomPicker d_snapper;
    private final ManipMgr d_manipMgr;
    private final ManipHook d_manipListener;
    private final TransformMgr d_xformMgr;
    private final NavToolInfo d_orbitTool;
    private final NavToolInfo d_modGameRoamTool;
    private final NavToolInfo d_dragTool;
    private final NavToolInfo d_zoomTool;
    private final NavToolInfo d_zoomBoxTool;
    private final DrawToolBridge d_drawToolBridge;
    private final ADrawTool d_newSlabObstTool;
    private final ADrawTool d_newSlabHoleTool;
    private final ADrawTool d_newWallObstTool;
    private final ADrawTool d_newWallHoleTool;
    private final ADrawTool d_newGridObstTool;
    private final ADrawTool d_newGridHoleTool;
    private final ADrawTool d_gridSplitterTool;
    private final ADrawTool d_newRoomTool;
    private final ADrawTool d_newVentTool;
    private final ADrawTool d_newZoneTool;
    private final ADrawTool d_newPartCloudTool;
    private final ADrawTool d_newPartLocTool;
    private final ADrawTool d_newDevcTool;
    private final ADrawTool d_newInitTool;
    private final ADrawTool d_newGridTool;
    private final ADrawTool d_draw3dSliceTool;
    private final ADrawTool d_drawPlanarSliceTool;
    private final ADrawTool d_newHvacNodeTool;
    private final ADrawTool d_newHvacDuctTool;
    private final SurfacePainterTool d_surfPainterTool;
    private final SurfacePickerTool d_surfPickerTool;
    private final MeasureTool d_measureTool;
    private final NavToolInfo d_manipTool3D;
    private final NavToolInfo d_manipTool2D;
    private final CursorTool d_translateTool;
    private final CursorTool d_rotateTool;
    private final CursorTool d_mirrorTool;
    private final DrawProps d_paintProps;
    private final DrawProps d_wallProps;
    private final DrawProps d_gridProps;
    private final DrawProps d_blockProps;
    private final DrawProps d_partLocProps;
    private final DrawProps d_slabProps;
    private final DrawProps d_ventProps;
    private final DrawProps d_devcProps;
    private final DrawProps d_hvacNodeProps;
    private final DrawProps d_hvacDuctProps;
    private final DrawProps[] d_allProps;
    private final ViewMode3D d_mode3d;
    private final ViewMode2D d_mode2d;
    private IViewMode d_currViewMode;
    private final PyroNativeProps d_nDrawProps;
    private final PyroDrawProps d_drawProps;
    private final ViewModifiedListener d_cameraModifiedListener;
    private Set<CameraChangeListener> d_cameraChangeListeners;
    private DisplayManager d_dispMgr;
    private static final List<NavToolInfo> NAV_TOOLS = new ArrayList<NavToolInfo>();
    private static final Icon s_lbOnIcon = PyroGuiUtil.loadPyroSimIcon("lightbulb16.png", 8);
    private static final Icon s_lbOffIcon = PyroGuiUtil.loadPyroSimIcon("lightbulb_off16.png", 8);
    private static final PerspectiveCamera s_perspCam = new PerspectiveCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.1, 10000.0, DEFAULT_FOV.get(NonSI.DEGREE_ANGLE));

    public ModelView(PyroMod pyroMod, PyroSimColors pyroSimColors) {
        IPopupMenuBuilder iPopupMenuBuilder;
        this.d_mainView = new View((IRenderSurface)this.d_renderComp, this.d_mainScenes.scene);
        this.d_animSession = new SwingAnimSession();
        this.d_origin = new OriginSnapper();
        this.d_allFloorsFloor = new Floor(Intl.intl("All Floors"));
        this.d_mediator = pyroMod;
        this.d_colors = pyroSimColors;
        this.d_3DPanel = new JPanel(new BorderLayout());
        this.d_3DTopPanel = new JPanel(new BorderLayout());
        this.d_3DTopPanel.add((Component)this.d_renderComp, "Center");
        this.d_3DPanel.add((Component)this.d_3DTopPanel, "Center");
        boolean bl = PyroPrefs.getBoolean(PyroPrefs.PREF_CUT_HOLES);
        this.d_nDrawProps = new PyroNativeProps();
        this.d_drawProps = new PyroDrawProps(this.d_nDrawProps, () -> this.d_dispMgr.getMergedGrids());
        this.d_drawProps.setCutHoles(bl);
        this.d_mode2d = new ViewMode2D(this);
        this.d_mode3d = new ViewMode3D();
        this.d_currViewMode = null;
        this.initDisplayManagers();
        this.d_clipMgr = new ClippingManager(pyroMod, this, this.d_dispMgr.d_dispFilter);
        this.d_cameraChangeListeners = new LinkedIdentityHashSet<CameraChangeListener>();
        this.d_cameraModifiedListener = new ViewModifiedListener();
        PyroPickRoot pyroPickRoot = new PyroPickRoot(this.d_mediator, this);
        this.d_snapper = new GeomPicker(pyroPickRoot, this.d_mainView);
        this.d_selLogic = new MouseSelectionLogic(this.d_mediator, this.d_renderComp);
        this.d_manipMgr = new ManipMgr(this.d_dispMgr);
        this.d_manipListener = new ManipHook(this.d_mediator, this, this.d_manipMgr, this.d_manipToolScene, this.d_dispMgr.d_dispFilter);
        this.d_paintProps = new DrawProps(this.d_mediator);
        this.d_wallProps = new DrawProps(this.d_mediator);
        this.d_gridProps = new DrawProps(this.d_mediator);
        this.d_blockProps = new DrawProps(this.d_mediator);
        this.d_partLocProps = new DrawProps(this.d_mediator);
        this.d_partLocProps.set(DrawProps.DROP_COUNT, new PartCloud.ConstDropletCount(1));
        this.d_slabProps = new DrawProps(this.d_mediator);
        this.d_ventProps = new DrawProps(this.d_mediator);
        this.d_devcProps = new DrawProps(this.d_mediator);
        this.d_hvacNodeProps = new DrawProps(this.d_mediator);
        this.d_hvacDuctProps = new DrawProps(this.d_mediator);
        this.d_allProps = new DrawProps[]{this.d_paintProps, this.d_wallProps, this.d_gridProps, this.d_blockProps, this.d_slabProps, this.d_ventProps, this.d_devcProps, this.d_hvacNodeProps, this.d_hvacDuctProps, this.d_partLocProps};
        this.d_sketchGrid = new SnapToGrid(this.d_mainView, PyroPrefs.getDouble(PyroPrefs.DefaultSnapSpacing));
        this.d_modelGridSnapper = new CompositeModelGridSnapper(this.d_dispMgr.d_gridDispMan);
        this.d_currentSnapper = this.d_sketchGrid;
        this.d_mediator.getGeomLocator().add(this.d_modelGridSnapper);
        this.d_mediator.getGeomLocator().add(this.d_sketchGrid);
        this.d_mediator.getGeomLocator().add(this.d_origin);
        this.d_showGridDivsAction = new FilterAction<GridVis.Divisions>(Intl.intl("Show Mesh Divisions"), (Icon)PyroGuiUtil.loadPyroSimIcon("gridlines16.png"), GridVis.Divisions.class, PyroPrefs.ShowGridProp);
        this.d_showGridBoundaryAction = new FilterAction<GridVis.Boundary>(Intl.intl("Show Mesh Boundaries"), (Icon)PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif"), GridVis.Boundary.class, PyroPrefs.ShowBoundaryProp);
        this.d_showGridOutlinesAction = new FilterAction<GridVis.Outline>(Intl.intl("Show Mesh Outlines"), (Icon)PyroGuiUtil.loadPyroSimIcon("boundary16.gif"), GridVis.Outline.class, PyroPrefs.ShowBoundaryLinesProp);
        this.d_showGuidesAction = new ShowGuidesAction(PyroPrefs.getBoolean(PyroPrefs.ShowGuidesProp));
        this.d_showPointerAction = new ShowSystemMouseAction(PyroPrefs.getBoolean(PyroPrefs.ShowSystemMouseProp));
        this.d_editGridSizeAction = new EditSnapSize();
        this.d_showOriginAction = new ShowOriginAction(PyroPrefs.getBoolean(PyroPrefs.ShowOriginProp));
        this.d_showBackgroundImages = new FilterAction<ModelImage>(Intl.intl("Show Background Images"), (Icon)PyroGuiUtil.loadPyroSimIcon("ConfigureBackgroundImage16.gif"), ModelImage.class, true);
        this.d_configureBGImageAction = new ConfigureBGImageAction();
        this.d_manageFloorsAction = new ManageFloorsAction();
        this.d_useSVNavAction = new UseSVNavigationAction(PyroPrefs.getBoolean(PyroPrefs.UseSVNavProp));
        this.d_resetToAllAction = new ResetToAllObjectsAction();
        this.d_resetToSelectedAction = new ResetToSelectedObjectsAction();
        this.d_fillViewAction = new FillViewAction();
        this.d_solidOutlinesAction = new ShowSolidOutlinesAction(false);
        this.d_realisticAction = new ShowRealisticAction(false);
        this.d_realisticOutlinesAction = new ShowRealisticOutlinesAction(false);
        this.d_wireframeAction = new UseWireframeAction(Intl.intl("Wireframe Rendering"), Intl.intl("Show Object Outlines Only"), false, "pyrosim/icons/wireframe.png", true);
        this.d_solidAction = new UseWireframeAction(Intl.intl("Solid Rendering"), Intl.intl("Show Objects as Solids"), true, "pyrosim/icons/solid.png", false);
        this.d_noSnapperAction = new SelectGridAction(0, false);
        this.d_sketchGridAction = new SelectGridAction(1, true);
        this.d_modelGridsAction = new SelectGridAction(2, false);
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add(this.d_noSnapperAction);
        actionGroup.add(this.d_sketchGridAction);
        actionGroup.add(this.d_modelGridsAction);
        this.d_cutHolesAction = new CutHolesAction();
        this.d_filterActions = new FilterActionInfo[]{new FilterActionInfo(new FDSPreviewAction()), new FilterActionInfo(new FilterAction<IObstruction>(Intl.intl("Show Obstructions"), (Icon)TVEntryPoints.ModelObjEP.ABLOCK_ICON, IObstruction.class, true)), new FilterActionInfo(new FilterAction<IHole>(Intl.intl("Show Holes"), (Icon)TVEntryPoints.ModelObjEP.AHOLE_ICON, IHole.class, true)), new FilterActionInfo(new FilterAction<Vent>(Intl.intl("Show Vents"), (Icon)TVEntryPoints.ModelObjEP.VENT_ICON, Vent.class, true)), new FilterActionInfo(new FilterAction<InitRegion>(Intl.intl("Show Init Regions"), (Icon)TVEntryPoints.ModelObjEP.INIT_REGION_ICON, InitRegion.class, true)), new FilterActionInfo(new FilterAction<PartCloud>(Intl.intl("Show Particle Clouds"), (Icon)TVEntryPoints.ModelObjEP.PART_CLOUD_ICON, PartCloud.class, true)), new FilterActionInfo(new FilterAction<IDevice>(Intl.intl("Show Devices"), (Icon)PyroGuiUtil.loadPyroSimIcon("sprk3.gif"), IDevice.class, true)), new FilterActionInfo(new FilterAction<IHvacGeomComp>(Intl.intl("Show HVAC Components"), (Icon)PyroGuiUtil.loadPyroSimIcon("hvac_fan16.png"), IHvacGeomComp.class, true)), null, new FilterActionInfo(new FilterAction<Zone>(Intl.intl("Show Zones"), (Icon)PyroGuiUtil.loadPyroSimIcon("zones16.png"), Zone.class, false)), new FilterActionInfo(new FilterAction<IMeasurementStat>(Intl.intl("Show Statistics Regions"), (Icon)PyroGuiUtil.loadPyroSimIcon("stat16.png"), IMeasurementStat.class, false)), new FilterActionInfo(new FilterAction<Slice>(Intl.intl("Show Slices"), (Icon)PyroGuiUtil.loadPyroSimIcon("slices16.png"), Slice.class, true)), null, new FilterActionInfo(new FilterAction<LabelMgr.Filter>(Intl.intl("Show Labels"), Intl.intl("LBL"), LabelMgr.Filter.class, true)), new FilterActionInfo(new FilterAction<GenericGeomSrc>(Intl.intl("Show Imported CAD Lines"), Intl.intl("CAD"), GenericGeomSrc.class, true)), null, new FilterActionInfo(new FilterAction<CameraState>(Intl.intl("Show Cameras"), TVEntryPoints.CameraStateEP.ICON, CameraState.class, Predicates.alwaysFalse(), cameraState -> this.d_mediator.getViews().getActiveView() != cameraState.getParent(), events -> events.getEvents(ViewMgr.class, new Class[0]).hasChangedObjs(ViewMgr.EVT_ACTIVE_VIEW) || events.getEvents(pyrosim.domain.view.View.class, new Class[0]).hasChangedObjs(pyrosim.domain.view.View.PROP_CAMERA) || events.getEvents(CameraState.class, new Class[0]).isModified(), false))};
        this.d_gridFilterActions = new FilterActionInfo[]{new FilterActionInfo(this.d_showGridDivsAction), new FilterActionInfo(this.d_showGridBoundaryAction), new FilterActionInfo(this.d_showGridOutlinesAction)};
        this.d_clipFilterActions = new FilterActionInfo[]{new FilterActionInfo(new FilterAction<ClippingManager.EnableClipping>(Intl.intl("Enable Section Boxes"), (Icon)null, ClippingManager.EnableClipping.class, true)), new FilterActionInfo(new FilterAction<SectionBox>(Intl.intl("Show Section Boxes"), null, SectionBox.class, Predicates.alwaysFalse(), sectionBox -> this.d_mediator.getViews().getActiveView() == sectionBox.getParent(), events -> events.getEvents(ViewMgr.class, new Class[0]).hasChangedObjs(ViewMgr.EVT_ACTIVE_VIEW), true))};
        this.d_clipFilterActions[0].action.putValue("AcceleratorKey", Accelerators.ENABLE_SECTION_BOXES);
        this.d_clipFilterActions[1].action.putValue("AcceleratorKey", Accelerators.SHOW_SECTION_BOXES);
        this.d_statusBar = new guiStatusBar();
        this.d_statusMessage = new guiStatusMessage();
        this.d_statusBar.setStatusMessage(this.d_statusMessage);
        this.d_statusSelection = new guiLabel("");
        this.d_statusBar.addNextPane(this.d_statusSelection, 0.0);
        this.d_statusBar.togglePane(1, false);
        this.d_floorBox = new JComboBox();
        this.d_floorBox.setRenderer(new FloorBoxRenderer());
        this.d_floorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = ModelView.this.d_floorBox.getSelectedItem();
                if (object != null && object != ModelView.this.d_currentFloor) {
                    if (object.equals(ModelView.this.d_allFloorsFloor)) {
                        ModelView.this.setFloor(null);
                    } else {
                        ModelView.this.setFloor((Floor)object);
                    }
                    ModelView.this.d_renderComp.repaint();
                }
            }
        });
        this.d_floorBox.setLightWeightPopupEnabled(false);
        this.d_groupBox = new CompositeComboBox<IModelObj>(this.d_mediator.getObstructions());
        this.d_groupBox.setLightWeightPopupEnabled(false);
        this.d_appearanceBox = new guiComboBox<Action>((T[])new Action[]{this.d_wireframeAction, this.d_solidAction, this.d_solidOutlinesAction, this.d_realisticAction, this.d_realisticOutlinesAction});
        this.d_appearanceBox.setRenderer(new PyroGuiUtil.ActionCellRenderer());
        this.d_appearanceBox.addActionListener(actionEvent -> this.d_appearanceBox.getSelectedItem().actionPerformed(actionEvent));
        this.d_tools = new ToolManager(this.getRenderComponent());
        this.d_drawToolBridge = new DrawToolBridge(this.d_mediator, this, this.d_dispMgr, this.d_tools);
        this.d_toolPropsAction = new ToolPropsAction();
        IPopupMenuBuilder iPopupMenuBuilder2 = iPopupMenuBuilder = new IPopupMenuBuilder(){

            @Override
            public void buildMenu(IPyroTool iPyroTool, MenuBuilder menuBuilder) {
                menuBuilder.addSeparator();
                ToolUtil.addColorSubmenu(ModelView.this.d_mediator, iPyroTool.getProps(), menuBuilder);
                menuBuilder.addSeparator();
            }
        };
        IPopupMenuBuilder iPopupMenuBuilder3 = new IPopupMenuBuilder(){

            @Override
            public void buildMenu(IPyroTool iPyroTool, MenuBuilder menuBuilder) {
                menuBuilder.addSeparator();
                ToolUtil.addSurfSubmenu(ModelView.this.d_mediator, iPyroTool.getProps(), Obstruction.getSurfaceFilter(), menuBuilder);
                ToolUtil.addColorSubmenu(ModelView.this.d_mediator, iPyroTool.getProps(), menuBuilder);
                menuBuilder.addSeparator();
            }
        };
        IPopupMenuBuilder iPopupMenuBuilder4 = new IPopupMenuBuilder(){

            @Override
            public void buildMenu(IPyroTool iPyroTool, MenuBuilder menuBuilder) {
                menuBuilder.addSeparator();
                ToolUtil.addSurfSubmenu(ModelView.this.d_mediator, iPyroTool.getProps(), Vent.getSurfaceFilter(), menuBuilder);
                ToolUtil.addColorSubmenu(ModelView.this.d_mediator, iPyroTool.getProps(), menuBuilder);
                menuBuilder.addSeparator();
            }
        };
        this.d_newGridTool = new DrawGridGeomTool((IToolController)this, this.d_gridProps);
        this.d_newGridTool.setMenuBuilder(iPopupMenuBuilder2);
        this.d_tools.addTool(this.d_newGridTool, Intl.intl("New Mesh"), Intl.intl("Draw a Mesh"), PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif"), true, new ToolMeta(true, DrawProps.ObjType.MESH));
        this.d_newWallObstTool = new DrawWallGeomTool((IToolController)this, this.d_wallProps);
        this.d_newWallObstTool.setMenuBuilder(iPopupMenuBuilder3);
        this.d_tools.addTool(this.d_newWallObstTool, Intl.intl("New Wall"), Intl.intl("Draw a Wall Obstruction"), PyroGuiUtil.loadPyroSimIcon("block16_2.gif"), true, new ToolMeta(true, DrawProps.ObjType.OBSTRUCTION));
        this.d_newWallHoleTool = new DrawWallGeomTool((IToolController)this, this.d_wallProps);
        this.d_newWallHoleTool.setMenuBuilder(iPopupMenuBuilder);
        this.d_tools.addTool(this.d_newWallHoleTool, Intl.intl("New Wall Hole"), Intl.intl("Draw a Wall Hole"), PyroGuiUtil.loadPyroSimIcon("wall_hole16.png"), true, new ToolMeta(true, DrawProps.ObjType.HOLE));
        this.d_newGridObstTool = new DrawGridCellTool(this, this.d_blockProps);
        this.d_newGridObstTool.setMenuBuilder(iPopupMenuBuilder3);
        this.d_tools.addTool(this.d_newGridObstTool, Intl.intl("New Block"), Intl.intl("Draw a Block Obstruction"), PyroGuiUtil.loadPyroSimIcon("cube16.png"), true, new ToolMeta(true, DrawProps.ObjType.OBSTRUCTION));
        this.d_newGridHoleTool = new DrawGridCellTool(this, this.d_blockProps);
        this.d_newGridHoleTool.setMenuBuilder(iPopupMenuBuilder);
        this.d_tools.addTool(this.d_newGridHoleTool, Intl.intl("New Block Hole"), Intl.intl("Draw a Block Hole"), PyroGuiUtil.loadPyroSimIcon("hole16.gif"), true, new ToolMeta(true, DrawProps.ObjType.HOLE));
        this.d_newSlabObstTool = new DrawExtrudedPolyTool((IToolController)this, this.d_slabProps);
        this.d_newSlabObstTool.setMenuBuilder(iPopupMenuBuilder3);
        this.d_tools.addTool(this.d_newSlabObstTool, Intl.intl("New Slab Obstruction"), Intl.intl("Draw a Slab Obstruction"), PyroGuiUtil.loadPyroSimIcon("floor16.png"), true, new ToolMeta(true, DrawProps.ObjType.OBSTRUCTION));
        this.d_newSlabHoleTool = new DrawExtrudedPolyTool((IToolController)this, this.d_slabProps);
        this.d_newSlabHoleTool.setMenuBuilder(iPopupMenuBuilder);
        this.d_tools.addTool(this.d_newSlabHoleTool, Intl.intl("New Slab Hole"), Intl.intl("Draw a Slab Hole"), PyroGuiUtil.loadPyroSimIcon("floor_hole.png"), true, new ToolMeta(true, DrawProps.ObjType.HOLE));
        this.d_newRoomTool = new DrawRoomTool((IToolController)this, this.d_wallProps);
        this.d_newRoomTool.setMenuBuilder(iPopupMenuBuilder3);
        this.d_tools.addTool(this.d_newRoomTool, Intl.intl("New Room"), Intl.intl("Draw a Room"), PyroGuiUtil.loadPyroSimIcon("room16_2.png"), true, new ToolMeta(true, DrawProps.ObjType.OBSTRUCTION));
        this.d_newZoneTool = new DrawAABoxGeomTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_newZoneTool, Intl.intl("New Zone"), Intl.intl("Draw a Zone"), PyroGuiUtil.loadPyroSimIcon("zones16.png"), true, new ToolMeta(true, DrawProps.ObjType.ZONE));
        this.d_newVentTool = new DrawAARectangleTool((IToolController)this, this.d_ventProps);
        this.d_newVentTool.setMenuBuilder(iPopupMenuBuilder4);
        DefaultIsectFilter defaultIsectFilter = DrawAARectangleTool.getDefaultFilter();
        defaultIsectFilter.geomType = DefaultIsectFilter.acceptGeomTypes(GeomType.FACE, GeomType.FACE_EDGE, GeomType.FACE_VERTEX);
        this.d_newVentTool.setSnapInfo(SnapMode.FILTERED_TWO_PASS, defaultIsectFilter);
        this.d_tools.addTool(this.d_newVentTool, Intl.intl("New Vent"), Intl.intl("Draw a Vent"), PyroGuiUtil.loadPyroSimIcon("vent16.gif"), true, new ToolMeta(true, DrawProps.ObjType.VENT));
        this.d_newPartCloudTool = new DrawAABoxGeomTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_newPartCloudTool, Intl.intl("New Particle Cloud"), Intl.intl("Draw a Particle Cloud"), PyroGuiUtil.loadPyroSimIcon("partCloud16.gif"), true, new ToolMeta(true, DrawProps.ObjType.PART_CLOUD));
        this.d_newPartLocTool = new DrawPointTool((IToolController)this, this.d_partLocProps);
        this.initPointTool(this.d_newPartLocTool, null, null);
        this.d_tools.addTool(this.d_newPartLocTool, Intl.intl("New Particle Location"), Intl.intl("Draw Particles at a Point"), PyroGuiUtil.loadPyroSimIcon("single_part16.gif"), true, new ToolMeta(true, DrawProps.ObjType.PART_CLOUD));
        this.d_draw3dSliceTool = new DrawAABoxGeomTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_draw3dSliceTool, Intl.intl("New 3D Slice"), Intl.intl("Draw a 3D Slice"), PyroGuiUtil.loadPyroSimIcon("slices3d.png"), true, new ToolMeta(true, DrawProps.ObjType.SLICE3D));
        this.d_newInitTool = new DrawAABoxGeomTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_newInitTool, Intl.intl("New Init Region"), Intl.intl("Draw an Init Region"), PyroGuiUtil.loadPyroSimIcon("init16.png"), true, new ToolMeta(true, DrawProps.ObjType.INIT_REGION));
        this.d_newDevcTool = new DrawPointTool((IToolController)this, this.d_devcProps);
        this.initDeviceToolMenuBuilder(this.d_newDevcTool);
        this.d_tools.addTool(this.d_newDevcTool, Intl.intl("New Device"), Intl.intl("Draw a Device"), PyroGuiUtil.loadPyroSimIcon("sprk3.gif"), true, new ToolMeta(true, DrawProps.ObjType.POINT_DEVC));
        this.d_newHvacNodeTool = new DrawPointTool((IToolController)this, this.d_hvacNodeProps);
        this.initPointTool(this.d_newHvacNodeTool, null, null);
        this.d_tools.addTool(this.d_newHvacNodeTool, Intl.intl("New HVAC Node"), Intl.intl("Draw an HVAC Node"), PyroGuiUtil.loadPyroSimIcon("hvac_node16.png"), true, new ToolMeta(true, DrawProps.ObjType.HVAC_NODE));
        this.d_newHvacDuctTool = new DrawHvacDuctTool((IToolController)this, this.d_hvacDuctProps);
        this.d_tools.addTool(this.d_newHvacDuctTool, Intl.intl("New HVAC Duct"), Intl.intl("Draw an HVAC Duct"), PyroGuiUtil.loadPyroSimIcon("hvac_duct16.png"), true, new ToolMeta(true, DrawProps.ObjType.HVAC_DUCT));
        this.d_surfPainterTool = new SurfacePainterTool(this.d_mediator, this, this.d_dispMgr, this.d_paintProps);
        this.d_tools.addTool(this.d_surfPainterTool, Intl.intl("Surface Painter"), Intl.intl("Paint Obstruction Surfaces"), PyroGuiUtil.loadPyroSimIcon("paint_bucket16.png"), true, new ToolMeta(true, null));
        this.d_surfPickerTool = new SurfacePickerTool(this.d_mediator, this, this.d_paintProps, this.d_paintProps, this.d_gridProps, this.d_devcProps, this.d_wallProps, this.d_blockProps, this.d_ventProps, this.d_slabProps, this.d_partLocProps);
        this.d_tools.addTool(this.d_surfPickerTool, Intl.intl("Surface Picker"), Intl.intl("Pick a Surface from an Obstruction"), PyroGuiUtil.loadPyroSimIcon("eye_dropper16.png"), true, new ToolMeta(true, null));
        this.d_drawPlanarSliceTool = new DrawPlaneGeomTool(this, this.d_blockProps, false, true, new MeshAutoAxisChooser(pyroMod, false));
        this.d_tools.addTool(this.d_drawPlanarSliceTool, Intl.intl("New Planar Slice"), Intl.intl("Draw a Planar Slice"), PyroGuiUtil.loadPyroSimIcon("slices16.png"), true, new ToolMeta(true, DrawProps.ObjType.SLICE));
        this.d_gridSplitterTool = new DrawPlaneGeomTool(this, this.d_wallProps, true, true, new MeshAutoAxisChooser(pyroMod, true));
        this.d_tools.addTool(this.d_gridSplitterTool, Intl.intl("Split Meshes"), Intl.intl("Split selected meshes along a grid division"), PyroGuiUtil.loadPyroSimIcon("splitmesh3_16.png"), true, new ToolMeta(false, DrawProps.ObjType.MESH_SPLIT));
        this.d_measureTool = new MeasureTool((IToolController)this, this.d_blockProps);
        this.d_tools.addTool(this.d_measureTool, Intl.intl("Measure"), Intl.intl("Measure"), PyroGuiUtil.loadPyroSimIcon("ruler16.png"), true, new ToolMeta(false, null));
        OrbitFunc orbitFunc = new OrbitFunc();
        DragFunc dragFunc = new DragFunc();
        ZoomFunc zoomFunc = new ZoomFunc();
        ZoomBoxFunc zoomBoxFunc = new ZoomBoxFunc();
        ManipFunc manipFunc = new ManipFunc(this, this.d_manipMgr, this.d_snapper, this.d_manipToolScene);
        SelectionFunc selectionFunc = new SelectionFunc(this.d_snapper, new Pyro3DSelector(this.d_selLogic));
        Function<IToolFunction, CursorTool> function = iToolFunction -> new CursorTool(this, (IToolFunction)iToolFunction);
        this.d_xformMgr = new TransformMgr(this.d_mediator, this.d_dispMgr, new DisplayManager(pyroMod, this, this.d_xformScenes.scene, null, this.d_xformScenes.patch, this.d_backgroundScene, this.d_gridScene, this.d_xformScenes.noclip, this.d_xformScenes.excludedNoClip));
        this.d_translateTool = new TranslateTool(this, this.d_xformMgr, this.d_manipToolScene, this.d_slabProps);
        this.d_tools.addTool(this.d_translateTool, Intl.intl("Move"), Intl.intl("Move Objects"), PyroGuiUtil.loadPyroSimIcon("move.png"), true, new ToolMeta(false, null));
        this.d_rotateTool = new RotateTool(this, this.d_xformMgr, this.d_manipToolScene, this.d_slabProps);
        this.d_tools.addTool(this.d_rotateTool, Intl.intl("Rotate"), Intl.intl("Rotate Objects"), PyroGuiUtil.loadPyroSimIcon("rotateObj.png"), true, new ToolMeta(false, null));
        this.d_mirrorTool = new MirrorTool(this, this.d_xformMgr, this.d_manipToolScene, this.d_slabProps);
        this.d_tools.addTool(this.d_mirrorTool, Intl.intl("Mirror"), Intl.intl("Mirror Objects"), PyroGuiUtil.loadPyroSimIcon("mirror16.png"), true, new ToolMeta(false, null));
        MultiFunc multiFunc = new MultiFunc(manipFunc, selectionFunc, orbitFunc, dragFunc);
        this.d_manipTool3D = new NavToolInfo(function.apply(multiFunc), View.NavTool.SELECT);
        this.d_tools.addTool(this.d_manipTool3D.tool, Intl.intl("Select/Manipulate"), Intl.intl("Select and Manipulate Objects"), PyroGuiUtil.loadTeciIcon("pointer16.gif"));
        MultiFunc multiFunc2 = new MultiFunc(manipFunc, selectionFunc, dragFunc, dragFunc);
        this.d_manipTool2D = new NavToolInfo(function.apply(multiFunc2), View.NavTool.SELECT);
        this.d_tools.addTool(this.d_manipTool2D.tool, Intl.intl("Select/Manipulate"), Intl.intl("Select and Manipulate Objects"), PyroGuiUtil.loadTeciIcon("pointer16.gif"));
        RoamFunc<CursorTool> roamFunc = new RoamFunc<CursorTool>(selectionFunc);
        this.d_modGameRoamTool = new NavToolInfo(function.apply(roamFunc), View.NavTool.ROAM);
        this.d_tools.addTool(this.d_modGameRoamTool.tool, Intl.intl("Roam"), Intl.intl("Roam"), RoamFunc.ICON);
        this.d_dragTool = new NavToolInfo(function.apply(dragFunc), View.NavTool.PAN);
        this.d_tools.addTool(this.d_dragTool.tool, Intl.intl("Drag"), Intl.intl("Pan View"), DragFunc.ICON);
        this.d_zoomTool = new NavToolInfo(function.apply(zoomFunc), View.NavTool.ZOOM);
        this.d_tools.addTool(this.d_zoomTool.tool, Intl.intl("Zoom"), Intl.intl("Zoom"), ZoomFunc.ICON);
        this.d_zoomBoxTool = new NavToolInfo(function.apply(zoomBoxFunc), View.NavTool.ZOOM_BOX);
        this.d_tools.addTool(this.d_zoomBoxTool.tool, Intl.intl("Zoom Box"), Intl.intl("Zoom Box"), ZoomBoxFunc.ICON);
        IToolFunction<CursorTool> iToolFunction2 = ModelView.makeSVNavFunc(selectionFunc);
        CompositeFunc compositeFunc = NavtoolUtil.newCompositeNav3DTool(orbitFunc, zoomFunc, dragFunc, selectionFunc);
        this.d_orbitTool = new NavToolInfo(function.apply(new SwitchingToolFunc(0, compositeFunc, iToolFunction2)), View.NavTool.ORBIT);
        this.d_tools.addTool(this.d_orbitTool.tool, Intl.intl("3D Orbit Navigation"), Intl.intl("3D Orbit Navigation"), OrbitFunc.ICON);
        this.d_tools.addToolChangeListener((tool, tool2) -> {
            Object object;
            this.updateCurrentTool();
            if (tool2 != null && (object = this.d_tools.getProps((Tool)tool2).meta) instanceof ToolMeta && ((ToolMeta)object).clearSelection) {
                EventQueue.invokeLater(() -> this.d_mediator.getSelectionModel().clearSelection());
            }
        });
        ((SwitchingToolFunc)this.d_orbitTool.tool.getFunction()).setCurrentFunc(this.d_useSVNavAction.isSelected() ? 1 : 0);
        this.d_floorToolbar = this.createFloorToolbar();
        this.d_editClipPlanesToolbar = this.createClipToolbar();
        this.d_groupToolbar = this.createGroupToolbar();
        this.d_editToolbar = this.createEditToolbar();
        this.d_createToolbar = this.createCreationToolbar();
        this.d_viewOptionsToolbar = this.createViewOptionsToolbar();
        this.d_filterToolbar = this.createFilterToolbar();
        this.d_tools.getToolbarButton(this.d_newPartCloudTool).setEnabled(this.d_mediator.getPartList().flatten().size() > 0);
        this.d_tools.getToolbarButton(this.d_newPartLocTool).setEnabled(this.d_mediator.getPartList().flatten().size() > 0);
        this.updateColors();
        this.setMode(ViewMode.MV_3D);
        this.resetFloorBox(true);
        this.updateGroupBox();
        this.updatePrefs();
        this.updateToolsThatTargetSelectedObjects();
        this.d_gridScene.addRenderableObjects(this.d_sketchGrid);
        this.d_originScene.addRenderableObjects(this.d_origin);
        this.d_renderComp.addComponentListener(new AbstractComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ModelView.this.d_renderComp.removeComponentListener(this);
                AABox aABox = ModelView.this.getModelSceneBounds();
                ModelView.this.d_mode2d.resetAllCameras(ModelView.this, aABox, true);
                ModelView.this.d_mode3d.resetAllCameras(ModelView.this, aABox, true);
                ModelView.this.d_renderComp.repaint();
            }
        });
        this.d_colors.addColorChangedListener(this);
        this.d_mediator.getEvents().addObserver(this);
        this.d_renderComp.addKeyListener(new GCListener());
        this.d_renderComp.addResourceInitListener(renderComponent -> this.detectVideoAdapter());
    }

    private void detectVideoAdapter() {
        if (PyroSim.getApp().isSafeMode()) {
            return;
        }
        String string = PyroPrefs.getString(PyroPrefs.VIDEO_ADAPTER);
        String string2 = this.d_renderComp.getRenderID();
        System.out.println("Detected Video Adapter = " + string2);
        int n = this.d_renderComp.getOpenGLInfo().build;
        if (n != -1) {
            System.out.println("Video Adapter Version = " + n);
        }
        if (!string2.equals(string) || this.d_renderComp.getAdapter() == IRenderSurface.Adapter.INTEL && n != PyroPrefs.getInt(PyroPrefs.ADAPTER_VERSION)) {
            this.loadDefaultPrefs(true);
        }
    }

    private void loadDefaultPrefs(boolean bl) {
        TeciProps teciProps = this.getDefaultPrefs();
        this.d_mediator.pauseUpdates();
        if (bl && !PyroPrefs.instance().partialEquals(teciProps)) {
            PyroSim.setPref(PyroPrefs.INTEL_WARNING_SHOWN, false, false);
        }
        PyroSim.setPrefs(teciProps, false);
        int n = this.d_renderComp.getOpenGLInfo().build;
        PyroSim.setPref(PyroPrefs.ADAPTER_VERSION, n, false);
        PyroSim.setPref(PyroPrefs.VIDEO_ADAPTER, this.d_renderComp.getRenderID(), true);
        this.d_mediator.resumeUpdates();
    }

    public TeciProps getDefaultPrefs() {
        String string = this.d_renderComp.getRenderID();
        System.out.print("Testing " + string + "...");
        int n = this.d_renderComp.testRenderCapabilities(31);
        TeciProps teciProps = new TeciProps();
        teciProps.set(PyroPrefs.PREF_DRAWCOLORBUFFER, Boolean.valueOf(ModelView.testCap(n, 2)));
        teciProps.set(PyroPrefs.PREF_USEVERTEXBUFFERS, Boolean.valueOf(ModelView.testCap(n, 4)));
        teciProps.set(PyroPrefs.PREF_SCENESHADERS, Boolean.valueOf(ModelView.testCap(n, 8)));
        System.out.printf("done (caps = %d)%n", n);
        return teciProps;
    }

    private static boolean testCap(int n, int n2) {
        return (n & n2) == n2;
    }

    public TeciProps getCompatibilityPrefs() {
        TeciProps teciProps = new TeciProps();
        teciProps.set(PyroPrefs.PREF_SCENESHADERS, Boolean.valueOf(false));
        return teciProps;
    }

    public void showIntelWarning(Runnable runnable) {
        this.d_renderComp.addResourceInitListener(renderComponent -> {
            if (this.d_renderComp.getAdapter() == IRenderSurface.Adapter.INTEL && !PyroPrefs.getBoolean(PyroPrefs.INTEL_WARNING_SHOWN)) {
                EventQueue.invokeLater(() -> guiUtil.showIntelWarning(this.d_renderComp, "PyroSim", () -> this.d_renderComp.getOpenGLInfo(), bl -> PyroSim.setPref(PyroPrefs.INTEL_WARNING_SHOWN, bl, false)));
            }
        });
    }

    protected void initDeviceToolMenuBuilder(IPyroTool iPyroTool) {
        final WorkingZConstraintGen workingZConstraintGen = new WorkingZConstraintGen();
        IConstraintGen iConstraintGen = new IConstraintGen(){

            @Override
            public ISnapConstraint getConstraint(IPyroTool iPyroTool) {
                if (iPyroTool.getProps().get(DrawProps.DEVC) instanceof IFreePointDevice) {
                    return workingZConstraintGen.getConstraint(iPyroTool);
                }
                return null;
            }
        };
        this.initPointTool(iPyroTool, Intl.intl("Lock Z by device type"), iConstraintGen);
    }

    protected void initPointTool(final IPyroTool iPyroTool, Object object, IConstraintGen iConstraintGen) {
        WorkingZConstraintGen workingZConstraintGen = new WorkingZConstraintGen();
        OffsetConstraintGen offsetConstraintGen = new OffsetConstraintGen();
        ArrayList<Pair<Object, IConstraintGen>> arrayList = new ArrayList<Pair<Object, IConstraintGen>>();
        if (iConstraintGen != null) {
            arrayList.add(new Pair<Object, IConstraintGen>(object, iConstraintGen));
        }
        arrayList.add(new Pair<String, WorkingZConstraintGen>(Intl.intl("Lock Z to drawing plane"), workingZConstraintGen));
        arrayList.add(new Pair<String, NoConstraintGen>(Intl.intl("Lock Z to snap location"), NoConstraintGen.INSTANCE));
        arrayList.add(new Pair<String, OffsetConstraintGen>(Intl.intl("Offset Z from snap location"), offsetConstraintGen));
        final SnapConstraintMenuBuilder snapConstraintMenuBuilder = new SnapConstraintMenuBuilder(arrayList);
        CameraMenuBuilder cameraMenuBuilder = new CameraMenuBuilder(null, snapConstraintMenuBuilder);
        iPyroTool.setMenuBuilder(cameraMenuBuilder);
        final IConstraintGen iConstraintGen2 = (IConstraintGen)((Pair)arrayList.get((int)0)).v2;
        iPyroTool.setConstraintGen(iConstraintGen2);
        iPyroTool.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IPyroTool iPyroTool) {
                if (!ModelView.isOrtho(iPyroTool.getView().getCamera())) {
                    snapConstraintMenuBuilder.toggleCurrentConstraint(iPyroTool);
                }
            }
        });
        this.addCameraChangeListener(new CameraChangeListener(){
            private IConstraintGen d_perspConstraint;
            {
                this.d_perspConstraint = iConstraintGen2;
            }

            @Override
            public void cameraChanged(Camera camera, Camera camera2) {
                if (ModelView.isOrtho(camera2) && !ModelView.isOrtho(camera)) {
                    this.d_perspConstraint = iPyroTool.getConstraintGen();
                    iPyroTool.setConstraintGen(WorkingPlaneConstraintGen.INSTANCE);
                } else if (!ModelView.isOrtho(camera2) && ModelView.isOrtho(camera)) {
                    assert (this.d_perspConstraint != null);
                    iPyroTool.setConstraintGen(this.d_perspConstraint);
                    this.d_perspConstraint = null;
                }
            }
        });
    }

    private static boolean isOrtho(Camera camera) {
        return camera instanceof OrthoCamera;
    }

    public JPanel getViewComponent() {
        return this.d_3DPanel;
    }

    public ToolManager getToolManager() {
        return this.d_tools;
    }

    public void cancelCurrentTool() {
        this.d_tools.cancelCurrentTool();
    }

    public ManipMgr getManipMgr() {
        return this.d_manipMgr;
    }

    public TransformMgr getTransformMgr() {
        return this.d_xformMgr;
    }

    public double getSketchGridSpacing() {
        return this.d_sketchGrid.getSpacing();
    }

    public void setSketchGridSpacing(double d) {
        this.d_sketchGrid.setSpacing(d);
    }

    public SnapToGrid getSketchGrid() {
        return this.d_sketchGrid;
    }

    @Override
    public ModelScene[] getToolScenes() {
        return new ModelScene[]{this.d_manipScene, null};
    }

    @Override
    public GeomPicker getSnapper() {
        return this.d_snapper;
    }

    private static QuickSaveRestoreLayer createQuickRestoreLayout() {
        PyroSim pyroSim = PyroSim.getApp();
        boolean bl = pyroSim.getPrefs().getBoolean(PyroPrefs.PREF_DRAWCOLORBUFFER);
        boolean bl2 = pyroSim.getPrefs().getBoolean(PyroPrefs.PREF_DRAWDEPTHBUFFER);
        QuickSaveRestoreLayer quickSaveRestoreLayer = new QuickSaveRestoreLayer();
        quickSaveRestoreLayer.setColorEnabled(bl);
        quickSaveRestoreLayer.setDepthEnabled(bl2);
        return quickSaveRestoreLayer;
    }

    private void initLayouts(IViewMode iViewMode) {
        OverlayLayout overlayLayout = new OverlayLayout();
        OverlayLayout overlayLayout2 = new OverlayLayout();
        iViewMode.initLayout(this, overlayLayout, true);
        iViewMode.initLayout(this, overlayLayout2, false);
        overlayLayout.add(this.d_axes, 13, 0.15f, 0.15f);
        overlayLayout.add(this.d_toolLayer);
        this.d_renderComp.getRootPanel().setLayoutManager(overlayLayout);
        this.d_renderFile.getRootPanel().setLayoutManager(overlayLayout2);
    }

    private static IToolFunction<CursorTool> makeSVNavFunc(SelectionFunc selectionFunc) {
        CompositeFunc<CursorTool> compositeFunc = new CompositeFunc<CursorTool>();
        compositeFunc.setToolEvents(new SmokeViewNavigationFunc(), 0, 1, 4);
        compositeFunc.setToolEvents(selectionFunc, 2, 8, 5);
        return compositeFunc;
    }

    private void updateToolsThatTargetSelectedObjects() {
        PyroSimSelectionModel pyroSimSelectionModel = this.d_mediator.getSelectionModel();
        Collection<IPyroGeomSrc> collection = pyroSimSelectionModel.flatten(IPyroGeomSrc.class);
        boolean bl = !collection.isEmpty();
        this.d_resetToSelectedAction.setEnabled(bl);
        this.d_tools.getToolAction(this.d_translateTool).setEnabled(bl);
        this.d_tools.getToolAction(this.d_rotateTool).setEnabled(bl);
        this.d_tools.getToolAction(this.d_mirrorTool).setEnabled(bl);
        this.d_tools.getToolbarButton(this.d_gridSplitterTool).setEnabled(!pyroSimSelectionModel.flatten(Grid.class).isEmpty());
    }

    private void initActiveView() {
        ViewMode viewMode = this.d_mediator.getViews().getActiveView().getViewMode().orElse(ViewMode.getDefault());
        this.updateActiveViewMode(viewMode);
        this.updateActiveViewCam();
    }

    private void updateActiveView() {
        this.d_mediator.getViews().getActiveView().getViewMode().ifPresent(viewMode -> {
            this.updateActiveViewMode((ViewMode)((Object)viewMode));
            this.updateActiveViewCam();
        });
    }

    public void setView(CameraState cameraState, View.NavTool navTool) {
        this.updateActiveViewMode(cameraState.getViewMode());
        this.setCameraState(cameraState);
        if (navTool != null) {
            this.setNavTool(navTool);
        }
    }

    public Task taskSaveViewState(PyroMod pyroMod, List<pyrosim.domain.view.View> list) {
        ViewMode viewMode = this.d_currViewMode == this.d_mode2d ? ViewMode.MV_2D : ViewMode.MV_3D;
        return this.taskSaveViewState(pyroMod, list, viewMode);
    }

    public Task taskSaveViewState(PyroMod pyroMod, List<pyrosim.domain.view.View> list, ViewMode viewMode) {
        AViewMode aViewMode;
        switch (viewMode) {
            case MV_2D: {
                aViewMode = this.d_mode2d;
                break;
            }
            default: {
                aViewMode = this.d_mode3d;
            }
        }
        CameraRecord cameraRecord = aViewMode.getCamera(this).capture();
        Tool tool = aViewMode.getNavTool(this);
        NavToolInfo navToolInfo2 = NAV_TOOLS.stream().filter(navToolInfo -> navToolInfo.tool == tool).findFirst().orElse(this.d_orbitTool);
        View.NavTool navTool = navToolInfo2.type;
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
        compositeTask.addTask(ViewPropTask.set(list, pyrosim.domain.view.View.PROP_CAMERA, (view, n) -> new CameraState(cameraRecord)));
        compositeTask.addTask(ViewPropTask.set(list, pyrosim.domain.view.View.PROP_NAV_TOOL, (view, n) -> navTool));
        return compositeTask;
    }

    private void updateActiveViewCam() {
        pyrosim.domain.view.View view = this.d_mediator.getViews().getActiveView();
        CameraState cameraState = view.get(pyrosim.domain.view.View.PROP_CAMERA);
        if (cameraState != null) {
            this.setCameraState(cameraState);
            View.NavTool navTool = view.get(pyrosim.domain.view.View.PROP_NAV_TOOL);
            if (navTool != null) {
                this.setNavTool(navTool);
            }
        }
    }

    private void setCameraState(CameraState cameraState) {
        if (((CameraRecord)cameraState.get()).frustum instanceof OrthoCamera.FrustumRecord) {
            PredefCam predefCam = null;
            for (PredefCam predefCam2 : PredefCam.values()) {
                if (!predefCam2.is2D()) continue;
                Vector3d vector3d = ((CameraRecord)cameraState.get()).up;
                Vector3d vector3d2 = Util3D.vectorN(((CameraRecord)cameraState.get()).loc, ((CameraRecord)cameraState.get()).ref);
                Vector3d vector3d3 = predefCam2.cam.getUpVector();
                Vector3d vector3d4 = predefCam2.cam.getViewVector();
                vector3d4.normalize();
                if (!vector3d.epsilonEquals(vector3d3, 1.0E-6) || !vector3d2.epsilonEquals(vector3d4, 1.0E-6)) continue;
                predefCam = predefCam2;
                break;
            }
            if (predefCam != null) {
                this.d_mode2d.setCamera(this, predefCam);
            }
        }
        this.d_mainView.getCamera().apply((CameraRecord)cameraState.get());
    }

    public void setNavTool(View.NavTool navTool) {
        NavToolInfo navToolInfo = null;
        Predicate<Tool> predicate = this.getCurrentViewMode().getToolFilter(this);
        for (NavToolInfo navToolInfo2 : NAV_TOOLS) {
            if (navToolInfo2.type != navTool || !predicate.test(navToolInfo2.tool)) continue;
            navToolInfo = navToolInfo2;
            break;
        }
        if (navToolInfo != null) {
            this.d_tools.setCurrentTool(navToolInfo.tool);
        }
    }

    private void updateActiveViewMode(ViewMode viewMode) {
        AViewMode aViewMode;
        switch (viewMode) {
            case MV_2D: {
                aViewMode = this.d_mode2d;
                break;
            }
            default: {
                aViewMode = this.d_mode3d;
            }
        }
        if (this.d_currViewMode != aViewMode) {
            this.cancelCurrentTool();
            if (this.d_currViewMode != null) {
                this.d_currViewMode.deactivate(this);
            }
            this.d_currViewMode = aViewMode;
            this.d_currViewMode.activate(this);
            this.d_renderComp.requestFocus();
        }
        this.clear3dPanels();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.getViewToolbar());
        jToolBar.addSeparator();
        jToolBar.add(this.getViewOptionsToolbar());
        jToolBar.addSeparator();
        jToolBar.add(this.getEditToolbar());
        jToolBar.addSeparator();
        jToolBar.add(this.getGroupToolbar());
        JToolBar jToolBar2 = new JToolBar();
        jToolBar2.setFloatable(false);
        jToolBar2.add(this.getFloorToolbar());
        jToolBar2.addSeparator();
        jToolBar2.add(this.getGridFilterToolbar());
        jToolBar2.addSeparator();
        jToolBar2.add(this.getFilterToolbar());
        guiPanel guiPanel2 = new guiPanel();
        guiPanel2.add((Component)jToolBar, "North");
        guiPanel2.add(new JSeparator(0));
        guiPanel2.add((Component)jToolBar2, "South");
        this.d_3DTopPanel.add((Component)guiPanel2, "North");
        this.d_3DPanel.add((Component)this.getStatusBar(), "South");
        this.getCreateToolbar().setOrientation(1);
        this.d_3DTopPanel.add((Component)this.getCreateToolbar(), "West");
        this.initAppearanceComboFromPrefs();
        this.d_3DPanel.validate();
        this.getRenderComponent().repaint();
        this.getRenderComponent().requestFocus();
    }

    private void clear3dPanels() {
        int n;
        Component[] componentArray = this.d_3DPanel.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            if (componentArray[n] == this.d_3DTopPanel) continue;
            this.d_3DPanel.remove(componentArray[n]);
        }
        componentArray = this.d_3DTopPanel.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            if (componentArray[n] == this.getRenderComponent()) continue;
            this.d_3DTopPanel.remove(componentArray[n]);
        }
    }

    private void initAppearanceComboFromPrefs() {
        boolean bl = this.getCurrentRenderOptions().get(ISceneRenderOptions.DRAW_WIREFRAME);
        boolean bl2 = this.getCurrentRenderOptions().get(ISceneRenderOptions.DRAW_OUTLINES);
        boolean bl3 = this.getCurrentRenderOptions().get(ISceneRenderOptions.DRAW_MATERIALS);
        guiAction guiAction2 = !bl && !bl2 && !bl3 ? this.d_solidAction : (!bl && bl2 && !bl3 ? this.d_solidOutlinesAction : (!bl && !bl2 && bl3 ? this.d_realisticAction : (!bl && bl2 && bl3 ? this.d_realisticOutlinesAction : (bl && !bl2 && !bl3 ? this.d_wireframeAction : this.d_realisticOutlinesAction))));
        this.d_appearanceBox.setSelectedItem(guiAction2);
    }

    private void initDisplayManagers() {
        this.d_dispMgr = new DisplayManager(this.d_mediator, this, this.d_mainScenes.scene, this.d_mainScenes.caps, this.d_mainScenes.patch, this.d_backgroundScene, this.d_gridScene, this.d_mainScenes.noclip, this.d_mainScenes.excludedNoClip);
    }

    public DisplayManager getDisplayManager() {
        return this.d_dispMgr;
    }

    public ViewMode3D getViewMode3d() {
        return this.d_mode3d;
    }

    public ViewMode2D getViewMode2d() {
        return this.d_mode2d;
    }

    public IViewMode getCurrentViewMode() {
        return this.d_currViewMode;
    }

    public ISceneRenderOptions get3DRenderOptions() {
        return this.d_mode3d.getRenderOptions(this);
    }

    public ISceneRenderOptions get2DRenderOptions() {
        return this.d_mode2d.getRenderOptions(this);
    }

    public ISceneRenderOptions getCurrentRenderOptions() {
        return this.d_currViewMode.getRenderOptions(this);
    }

    public PyroNativeProps getNativeDrawProps() {
        return this.d_nDrawProps;
    }

    public PyroDrawProps getDrawProps() {
        return this.d_drawProps;
    }

    @Override
    public Unit[] getLengthUnits() {
        return new Unit[]{SI.METER, PyroSim.getApp().getUnitSystem().getLengthUnit()};
    }

    @Override
    public RenderComponent getRenderComp() {
        return this.d_renderComp;
    }

    @Override
    public guiStatusMessage getStatusMessage() {
        return this.d_statusMessage;
    }

    private final JToolBar createViewOptionsToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.d_appearanceBox);
        Dimension dimension = jToolBar.getMaximumSize();
        this.d_appearanceBox.setMaximumSize(new Dimension(160, dimension.height));
        Utils.noToolBarFocus(jToolBar);
        return jToolBar;
    }

    private final JToolBar createFloorToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new guiLabel(Intl.intl("Show") + ": "));
        jToolBar.add(this.d_floorBox);
        jToolBar.add(this.getManageFloorsAction());
        int n = jToolBar.getComponent((int)(jToolBar.getComponentCount() - 1)).getPreferredSize().height;
        this.d_floorBox.setMaximumSize(new Dimension(this.d_floorBox.getPreferredSize().width, n));
        jToolBar.add(this.d_configureBGImageAction);
        jToolBar.add(ModelView.createToggleButton(this.d_showBackgroundImages));
        Utils.noToolBarFocus(jToolBar);
        return jToolBar;
    }

    private final JToolBar createClipToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        for (FilterActionInfo filterActionInfo : this.d_clipFilterActions) {
            jToolBar.add(ModelView.createToggleButton(filterActionInfo.action));
        }
        Utils.noToolBarFocus(jToolBar);
        return jToolBar;
    }

    private final JToolBar createGroupToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        Dimension dimension = jToolBar.getPreferredSize();
        jToolBar.add(new guiLabel(Intl.intl("Group") + ": "));
        jToolBar.add(this.d_groupBox);
        jToolBar.setPreferredSize(dimension);
        Utils.noToolBarFocus(jToolBar);
        return jToolBar;
    }

    private final JToolBar createEditToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.d_tools.getToolbarButton(this.d_manipTool3D.tool));
        jToolBar.add(this.d_tools.getToolbarButton(this.d_manipTool2D.tool));
        jToolBar.addSeparator();
        jToolBar.add(this.d_tools.getToolbarButton(this.d_orbitTool.tool));
        jToolBar.add(this.d_tools.getToolbarButton(this.d_modGameRoamTool.tool));
        jToolBar.add(this.d_tools.getToolbarButton(this.d_dragTool.tool));
        jToolBar.add(this.d_tools.getToolbarButton(this.d_zoomTool.tool));
        jToolBar.add(this.d_tools.getToolbarButton(this.d_zoomBoxTool.tool));
        jToolBar.add(this.d_resetToAllAction);
        jToolBar.add(this.d_resetToSelectedAction);
        jToolBar.add(this.d_fillViewAction);
        Utils.noToolBarFocus(jToolBar);
        return jToolBar;
    }

    private static JToggleButton createToggleButton(SelectableAction selectableAction) {
        String string;
        JToggleButton jToggleButton = new JToggleButton(selectableAction);
        Icon icon = (Icon)selectableAction.getValue("SmallIcon");
        if (icon != null) {
            jToggleButton.setText("");
        }
        if ((string = (String)selectableAction.getValue("ShortDescription")) == null && icon != null) {
            string = (String)selectableAction.getValue("Name");
        }
        jToggleButton.setToolTipText(string);
        jToggleButton.addItemListener(selectableAction);
        return jToggleButton;
    }

    private final JToolBar createCreationToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(new GridBagLayout());
        jToolBar.setFloatable(false);
        GridBagHelper gridBagHelper = new GridBagHelper(jToolBar, false, 1, 1);
        gridBagHelper.addFilledRow(new JSeparator(0));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_translateTool), this.d_tools.getToolbarButton(this.d_rotateTool));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_mirrorTool));
        gridBagHelper.addFilledRow(new JSeparator(0));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_newGridTool), this.d_tools.getToolbarButton(this.d_gridSplitterTool));
        gridBagHelper.addFilledRow(new JSeparator(0));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_newSlabObstTool), this.d_tools.getToolbarButton(this.d_newSlabHoleTool));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_newWallObstTool), this.d_tools.getToolbarButton(this.d_newWallHoleTool));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_newGridObstTool), this.d_tools.getToolbarButton(this.d_newGridHoleTool));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_newVentTool), this.d_tools.getToolbarButton(this.d_newRoomTool));
        gridBagHelper.addFilledRow(new JSeparator(0));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_newZoneTool), this.d_tools.getToolbarButton(this.d_newInitTool));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_newPartCloudTool), this.d_tools.getToolbarButton(this.d_newPartLocTool));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_drawPlanarSliceTool), this.d_tools.getToolbarButton(this.d_newDevcTool));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_draw3dSliceTool));
        gridBagHelper.addFilledRow(new JSeparator(0));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_newHvacNodeTool), this.d_tools.getToolbarButton(this.d_newHvacDuctTool));
        gridBagHelper.addFilledRow(new JSeparator(0));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_surfPainterTool), this.d_tools.getToolbarButton(this.d_surfPickerTool));
        gridBagHelper.addRow(this.d_tools.getToolbarButton(this.d_measureTool));
        gridBagHelper.addFilledRow(new JSeparator(0));
        JButton jButton = new JButton(this.d_toolPropsAction);
        jButton.setText("");
        gridBagHelper.addRow(jButton);
        gridBagHelper.finalizeRows();
        Utils.noToolBarFocus(jToolBar);
        return jToolBar;
    }

    private final JToolBar createFilterToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        for (FilterActionInfo filterActionInfo : this.d_filterActions) {
            if (filterActionInfo == null) {
                jToolBar.addSeparator();
                continue;
            }
            jToolBar.add(ModelView.createToggleButton(filterActionInfo.action));
        }
        Utils.noToolBarFocus(jToolBar);
        return jToolBar;
    }

    public final JToolBar createGridFilterToolbar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.d_currViewMode.initGridFilterToolbar(this, jToolBar);
        Utils.noToolBarFocus(jToolBar);
        return jToolBar;
    }

    public void setMode(ViewMode viewMode) {
        this.updateActiveViewMode(viewMode);
    }

    private void updatePrefs() {
        PyroSim pyroSim = (PyroSim)Application.getApp();
        this.initLayouts(this.d_currViewMode);
        boolean bl = pyroSim.getPrefs().getBoolean(PyroPrefs.PREF_USEVERTEXBUFFERS);
        Consumer<ModelScene> consumer = modelScene -> modelScene.forceImmediate(!bl);
        this.d_mainScenes.getRenderScenes().forEach(consumer);
        this.d_xformScenes.getRenderScenes().forEach(consumer);
        consumer.accept(this.d_manipScene);
        boolean bl2 = pyroSim.getPrefs().getBoolean(PyroPrefs.PREF_SCENESHADERS);
        this.d_mode2d.getRenderOptions(this).set(ISceneRenderOptions.SHADERS_ENABLED, bl2);
        this.d_mode3d.getRenderOptions(this).set(ISceneRenderOptions.SHADERS_ENABLED, bl2);
    }

    public RenderComponent getRenderComponent() {
        return this.d_renderComp;
    }

    public RenderFile getScreenshotGenerator() {
        return this.d_renderFile;
    }

    public ModelScene getMainScene() {
        return this.d_mainScenes.scene;
    }

    public ModelScene getPatchScene() {
        return this.d_mainScenes.patch;
    }

    public CutHolesAction getCutHolesAction() {
        return this.d_cutHolesAction;
    }

    @Override
    public PyroSimColors getColors() {
        return this.d_colors;
    }

    @Override
    public void colorChanged(ColorChangedEvent colorChangedEvent) {
        this.updateColors();
        this.d_renderComp.repaint();
    }

    public void updateColors() {
        Color color = this.d_colors.getColor(PyroSimColors.BACKGROUND_COLOR);
        this.d_colorLayer.setColor(color);
        float[] fArray = color.getComponents(new float[4]);
        this.d_axes.setBackgroundColor(new Color(fArray[0], fArray[1], fArray[2], 0.9f));
        this.d_axes.setAxisColor(this.d_colors.getColor(PyroSimColors.AXIS_COLOR));
        this.d_axes.setBoxColor(this.d_colors.getColor(PyroSimColors.AXIS_BOX_COLOR));
        this.d_axes.setTextColor(this.d_colors.getColor(PyroSimColors.AXIS_TEXT_COLOR));
        this.d_origin.setColor(this.d_colors.getColor(PyroSimColors.ORIGIN2D_COLOR));
        this.d_sketchGrid.setColors(this.d_colors.getColor(PyroSimColors.SNAP_TO_GRID_COLOR), this.d_colors.getColor(PyroSimColors.SNAP_TO_POINTS_COLOR));
        this.d_dispMgr.d_labelMan.updateColors(this.d_colors);
    }

    @Override
    public void update(Events events) {
        this.d_renderComp.pauseRender();
        this.d_nDrawProps.update(events);
        for (DrawProps n : this.d_allProps) {
            n.update(events);
        }
        EventResult eventResult = new EventResult();
        IEventRecord<ModelComposite> iEventRecord = events.getEvents(ModelComposite.class, new Class[0]);
        eventResult.d_groupBoxUpdateNeeded = eventResult.d_groupBoxUpdateNeeded | (iEventRecord.hasAddedObjs() || iEventRecord.hasRemovedObjs() || iEventRecord.hasChangedObjs() && !iEventRecord.areChangesExclusiveTo(PyroMod.EVT_SEL));
        IEventRecord<IPyroObject> iEventRecord2 = events.getEvents(IPyroObject.class, new Class[0]);
        boolean bl = eventResult.d_selectionChanged = iEventRecord2.hasAddedObjs() || iEventRecord2.hasRemovedObjs() || iEventRecord2.containsChange(PyroMod.EVT_SEL);
        if (eventResult.d_selectionChanged) {
            int iEventRecord3 = this.d_mediator.getSelectionModel().getSelection().size();
            if (iEventRecord3 == 0) {
                this.d_statusSelection.setText(" ");
            }
            this.d_statusBar.togglePane(1, iEventRecord3 > 0);
            if (iEventRecord3 > 0) {
                this.d_statusSelection.setText(String.format(Intl.intl("Selected: %d objects"), iEventRecord3));
            }
        }
        eventResult.d_floorBoxResetNeeded = eventResult.d_floorBoxResetNeeded | !events.getAffectedChannels(Floor.class, new Class[0]).isEmpty();
        for (EventChannel<Grid> eventChannel : events.getAffectedChannels(Grid.class, new Class[0])) {
            this.d_renderComp.repaint();
            if (!eventChannel.getAddedObjs().isEmpty() && this.d_mediator.getGridManager().flatten().size() == eventChannel.getAddedObjs().size()) {
                this.setActiveSnapper(2);
            }
            if (!eventChannel.containsChange(PyroMod.EVT_VISIBILITY_CHANGED)) continue;
            this.updateSketchGridVisibility();
        }
        for (EventChannel<Cloneable> eventChannel : events.getAffectedChannels(SnapToGrid.class, new Class[0])) {
            if (!eventChannel.containsChange(PyroMod.EVT_VISIBILITY_CHANGED)) continue;
            this.updateSketchGridVisibility();
            break;
        }
        for (EventChannel<Cloneable> eventChannel : events.getAffectedChannels(PyroMod.class, new Class[0])) {
            if (eventChannel.containsChange(PyroMod.EVT_UNITSYSTEM_CHANGED)) {
                this.d_floorBox.revalidate();
            }
            if (eventChannel.containsChange(PyroMod.EVT_MODEL_CHANGED)) {
                this.updateParticleOpts();
                this.d_renderComp.repaint();
                eventResult.d_selectionChanged = true;
                this.reset();
            }
            if (!eventChannel.containsChange(PyroMod.EVT_PREFS_CHANGED)) continue;
            this.updatePrefs();
            this.d_renderComp.repaint();
        }
        for (EventChannel<Cloneable> eventChannel : events.getAffectedChannels(Particle.class, new Class[0])) {
            if (!eventChannel.hasRemovedObjs() && !eventChannel.hasAddedObjs()) continue;
            this.updateParticleOpts();
        }
        this.d_modelGridSnapper.processEvents(events);
        if (this.d_mediator.getGridManager().flatten().isEmpty() && this.d_currentSnapper == this.d_modelGridSnapper) {
            this.setActiveSnapper(1);
        }
        this.d_clipMgr.processEvents(events);
        this.d_dispMgr.processEvents(events, eventResult);
        IEventRecord<Grid> iEventRecord3 = events.getEvents(Grid.class, new Class[0]);
        if (this.isFDSPreviewEnabled() && iEventRecord3.isModified()) {
            if (iEventRecord3.hasRemovedObjs() || !iEventRecord3.areChangesExclusiveTo(PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_PARENT_CHANGED)) {
                this.updateRasterizableObjs();
            } else if (iEventRecord3.hasAddedObjs()) {
                Set set = iEventRecord3.getAddedObjs();
                IdentityHashSet identityHashSet = new IdentityHashSet();
                for (Grid grid : set) {
                    AABox aABox = grid.getBounds();
                    CollResult collResult = new CollResult(FDSObject.class);
                    this.d_mediator.getGeomLocator().find(new AABoxTest(aABox, 1.0E-6), collResult, true);
                    identityHashSet.addAll(collResult.coll);
                }
                if (!identityHashSet.isEmpty()) {
                    this.d_dispMgr.updateDisplays((Collection<?>)identityHashSet);
                    this.d_renderComp.repaint();
                }
            }
        }
        if (eventResult.d_floorBoxResetNeeded) {
            this.resetFloorBox(false);
        }
        if (eventResult.d_groupBoxUpdateNeeded) {
            this.updateGroupBox();
        }
        if (eventResult.d_selectionChanged) {
            this.updateToolsThatTargetSelectedObjects();
        }
        this.d_cameraModifiedListener.update(events);
        this.d_renderComp.resumeRender();
    }

    public void updateParticleOpts() {
        Tool[] toolArray;
        boolean bl = !this.d_mediator.getPartList().flatten().isEmpty();
        for (Tool tool : toolArray = new Tool[]{this.d_newPartCloudTool, this.d_newPartLocTool}) {
            this.d_tools.getToolbarButton(tool).setEnabled(bl);
            if (bl || this.d_tools.getCurrentTool() != tool) continue;
            this.cancelCurrentTool();
        }
    }

    public static <T extends IPyroObject> boolean isCamResetNeeded(Composite<T> composite, Collection<? extends T> collection, Composite<?> ... compositeArray) {
        if (!collection.isEmpty() && composite.flatten().size() == collection.size()) {
            for (Composite<?> composite2 : compositeArray) {
                if (composite2.flatten().isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void reset() {
        this.d_dispMgr.removeAll();
        this.d_modelGridSnapper.removeAll();
        System.gc();
        this.resetFloorBox(true);
        this.updateGroupBox();
        for (FilterActionInfo filterActionInfo : this.d_clipFilterActions) {
            filterActionInfo.reset();
        }
        this.d_dispMgr.addAll();
        this.d_modelGridSnapper.addAll(this.d_mediator);
        this.applyFloorToProps(this.d_allFloorsFloor);
        this.initActiveView();
        System.gc();
    }

    public boolean isFDSPreviewEnabled() {
        for (FilterActionInfo filterActionInfo : this.d_filterActions) {
            if (!(filterActionInfo.action instanceof FDSPreviewAction)) continue;
            return ((FDSPreviewAction)filterActionInfo.action).isSelected();
        }
        return false;
    }

    private void updateSketchGridVisibility() {
        boolean bl = this.d_mainScenes.getCamera() instanceof OrthoCamera && this.d_currentSnapper == this.d_sketchGrid;
        this.d_sketchGrid.setVisibility(bl, bl);
    }

    private void updateOriginVisibility() {
        this.d_origin.setVisible(this.d_mainScenes.getCamera() instanceof OrthoCamera && this.d_showOriginAction.isSelected());
    }

    public void addCameraChangeListener(CameraChangeListener cameraChangeListener) {
        this.d_cameraChangeListeners.add(cameraChangeListener);
    }

    public void removeCameraChangeListener(CameraChangeListener cameraChangeListener) {
        this.d_cameraChangeListeners.remove(cameraChangeListener);
    }

    private void setMainCamera(Camera camera) {
        Camera camera2 = this.getMainView().getCamera();
        this.d_backgroundScene.setCamera(camera.createCopyCam());
        this.d_gridScene.setCamera(camera.createCopyCam());
        this.d_originScene.setCamera(camera.createCopyCam());
        this.d_mainScenes.setCamera(camera);
        this.d_xformScenes.setCamera(camera);
        this.d_xformScenes.scene.setCamera(camera.createCopyCam());
        this.d_manipScene.setCamera(camera.createCopyCam());
        this.d_manipToolScene.setCamera(camera.createCopyCam());
        this.d_axes.setBaseCamera(this.d_mainScenes.getCamera());
        this.d_dispMgr.d_gridDispMan.updateDisplays(this.d_mediator.getGridManager().flatten());
        this.d_dispMgr.d_floorDispMan.updateDisplays(this.d_mediator.getFloorManager().flatten());
        this.updateSketchGridVisibility();
        this.updateOriginVisibility();
        this.updateCurrentTool();
        this.updateSnapperVis();
        this.d_clipMgr.forceSceneClippingUpdate();
        this.initLayouts(this.d_currViewMode);
        for (CameraChangeListener cameraChangeListener : this.d_cameraChangeListeners) {
            cameraChangeListener.cameraChanged(camera2, camera);
        }
    }

    public View getMainView() {
        return this.d_mainView;
    }

    public int getCurrentSnapper() {
        if (this.d_mainScenes.getCamera() instanceof OrthoCamera) {
            if (this.d_currentSnapper == null) {
                return 0;
            }
            if (this.d_currentSnapper == this.d_sketchGrid) {
                return 1;
            }
            return 2;
        }
        return -1;
    }

    public IGridSnapper getCurrentSnapperObj() {
        if (this.d_mainScenes.getCamera() instanceof OrthoCamera) {
            return this.d_currentSnapper;
        }
        return this.d_modelGridSnapper;
    }

    public void setActiveSnapper(int n) {
        this.setActiveSnapper(n, true);
    }

    private void setActiveSnapper(int n, boolean bl) {
        if (n == 0) {
            this.d_currentSnapper = null;
            if (bl) {
                this.d_noSnapperAction.setSelected(true);
            }
        } else if (n == 1) {
            this.d_currentSnapper = this.d_sketchGrid;
            if (bl) {
                this.d_sketchGridAction.setSelected(true);
            }
        } else {
            this.d_currentSnapper = this.d_modelGridSnapper;
            if (bl) {
                this.d_modelGridsAction.setSelected(true);
            }
        }
        this.updateSnapperVis();
        this.d_editGridSizeAction.setEnabled(this.d_currentSnapper == this.d_sketchGrid);
        this.d_dispMgr.d_gridDispMan.updateDisplays(this.d_mediator.getGridManager().flatten());
        this.updateSketchGridVisibility();
        this.updateCurrentTool();
    }

    private void updateSnapperVis() {
        IGridSnapper iGridSnapper = this.getCurrentSnapperObj();
        this.d_sketchGrid.setVisible(iGridSnapper == this.d_sketchGrid);
        this.d_modelGridSnapper.setVisible(iGridSnapper == this.d_modelGridSnapper);
    }

    protected void applyFloorToProps(Floor floor) {
        this.d_devcProps.set(DrawProps.LOCATION, floor.getElevation().add(floor.getWallHeight().scale(0.5)));
        this.d_partLocProps.set(DrawProps.LOCATION, floor.getElevation().add(floor.getWallHeight().scale(0.5)));
        this.d_hvacNodeProps.set(DrawProps.LOCATION, floor.getElevation().add(floor.getWallHeight().sub(new UnitDouble(0.5, SI.METER))));
        UnitDouble unitDouble = floor == this.d_allFloorsFloor ? floor.getElevation() : floor.getSlabBottom();
        UnitDouble unitDouble2 = floor == this.d_allFloorsFloor ? floor.getWallHeight() : floor.getWallHeight().add(floor.getSlabThickness());
        this.d_gridProps.set(DrawProps.LOCATION, unitDouble);
        this.d_gridProps.set(DrawProps.HEIGHT, unitDouble2);
        this.d_wallProps.set(DrawProps.LOCATION, floor.getElevation());
        this.d_wallProps.set(DrawProps.HEIGHT, floor.getWallHeight());
        this.d_blockProps.set(DrawProps.LOCATION, floor.getElevation());
        this.d_blockProps.set(DrawProps.HEIGHT, floor.getWallHeight());
        this.d_slabProps.set(DrawProps.LOCATION, floor.getElevation().sub(floor.getSlabThickness()));
        this.d_slabProps.set(DrawProps.THICKNESS, floor.getSlabThickness());
        this.d_ventProps.set(DrawProps.LOCATION, floor.getElevation());
    }

    protected void setFloor(Floor floor) {
        this.d_currentFloor = floor;
        if (floor != null) {
            this.applyFloorToProps(floor);
        }
        this.d_dispMgr.d_floorDispMan.updateDisplays(this.d_mediator.getFloorManager().flatten());
        this.d_clipMgr.forceSceneClippingUpdate();
        this.d_dispMgr.d_gridDispMan.setActiveFloor(floor);
        this.d_modelGridSnapper.setActiveFloor(floor);
    }

    public Floor getCurrentFloor() {
        return this.d_currentFloor;
    }

    private void resetFloorBox(boolean bl) {
        Floor floor = (Floor)this.d_floorBox.getSelectedItem();
        ActionListener[] actionListenerArray = this.d_floorBox.getActionListeners();
        for (ActionListener actionListener : actionListenerArray) {
            this.d_floorBox.removeActionListener(actionListener);
        }
        FloorManager floorManager = this.d_mediator.getFloorManager();
        this.d_floorBox.removeAllItems();
        this.d_floorBox.addItem(this.d_allFloorsFloor);
        List<Floor> list = Util.sort(floorManager.flatten(), new Floor.CompareLevel());
        for (int i = list.size() - 1; i >= 0; --i) {
            this.d_floorBox.addItem(list.get(i));
        }
        if (this.d_editToolbar != null) {
            this.d_editToolbar.revalidate();
        }
        for (ActionListener actionListener : actionListenerArray) {
            this.d_floorBox.addActionListener(actionListener);
        }
        if (bl) {
            this.d_floorBox.setSelectedItem(this.d_allFloorsFloor);
        } else {
            boolean bl2;
            boolean bl3 = bl2 = floor != null ? floorManager.containsDeep(floor) : false;
            if (bl2) {
                this.d_floorBox.setSelectedItem(floor);
            } else {
                this.d_floorBox.setSelectedItem(this.d_allFloorsFloor);
            }
        }
        this.d_floorBox.setMaximumSize(this.d_floorBox.getPreferredSize());
    }

    private void updateGroupBox() {
        ModelComposite modelComposite = this.d_mediator.getObstructions();
        this.d_groupBox.setRoot(modelComposite);
        this.d_groupBox.setMaximumSize(this.d_groupBox.getPreferredSize());
        for (int i = 0; i < this.d_groupBox.getParent().getComponentCount(); ++i) {
            if (this.d_groupBox.getParent().getComponent(i) != this.d_groupBox) continue;
            Container container = this.d_groupBox.getParent();
            container.remove(i);
            container.add((Component)this.d_groupBox, i);
            break;
        }
    }

    public AABox getModelSceneBounds() {
        return this.getModelSceneBounds(true);
    }

    public AABox getModelSceneBounds(boolean bl) {
        BoundsCalculator boundsCalculator = new BoundsCalculator();
        this.d_mainScenes.getBounds(boundsCalculator, bl);
        boundsCalculator.add(this.d_backgroundScene);
        boundsCalculator.add(this.d_gridScene);
        return boundsCalculator.getBounds();
    }

    public void resetCurrentCamera() {
        this.d_currViewMode.resetCurrentCamera(this, this.getModelSceneBounds(false), true);
    }

    public void resetCurrentCamera(Collection<? extends Object3D> collection) {
        Object3D[] object3DArray = collection.toArray(new Object3D[collection.size()]);
        BoundsCalculator boundsCalculator = new BoundsCalculator();
        boundsCalculator.add(object3DArray);
        this.d_currViewMode.resetCurrentCamera(this, boundsCalculator.getBounds(), false);
    }

    public void fillCamera() {
        AABox aABox = this.getModelSceneBounds(false);
        this.fillCameras(aABox, this.d_mainView.getCamera());
    }

    public void fillCameras(AABox aABox, Camera ... cameraArray) {
        for (Camera camera : cameraArray) {
            AABox aABox2 = new AABox(aABox);
            camera.ensureValidForReset(aABox2, 5.0);
            camera.fillView(aABox2, this.d_renderComp.getWidth(), this.d_renderComp.getHeight());
        }
    }

    public void beginWaitCursor() {
        PyroSim.getApp().beginWaitCursor();
    }

    public void endWaitCursor() {
        PyroSim.getApp().endWaitCursor();
    }

    public ModelComposite getNewObstructionGroup() {
        return (ModelComposite)this.d_groupBox.getSelectedItem();
    }

    public MutuallyExclusiveAction getNoGridAction() {
        return this.d_noSnapperAction;
    }

    public MutuallyExclusiveAction getSketchGridAction() {
        return this.d_sketchGridAction;
    }

    public MutuallyExclusiveAction getModelGridsAction() {
        return this.d_modelGridsAction;
    }

    public guiStatusBar getStatusBar() {
        return this.d_statusBar;
    }

    public BooleanAction getShowGuidesAction() {
        return this.d_showGuidesAction;
    }

    public Collection<BooleanAction> getClipFilterActions() {
        return theUtil.map(Arrays.asList(this.d_clipFilterActions), filterActionInfo -> ((FilterActionInfo)filterActionInfo).action);
    }

    public BooleanAction getShowPointerAction() {
        return this.d_showPointerAction;
    }

    public EditSnapSize getEditSnapSizeAction() {
        return this.d_editGridSizeAction;
    }

    public BooleanAction getShowOriginAction() {
        return this.d_showOriginAction;
    }

    public ManageFloorsAction getManageFloorsAction() {
        return this.d_manageFloorsAction;
    }

    public BooleanAction getShowBGImagesAction() {
        return this.d_showBackgroundImages;
    }

    public BooleanAction getUseSVNavAction() {
        return this.d_useSVNavAction;
    }

    public ResetToAllObjectsAction getResetToAllAction() {
        return this.d_resetToAllAction;
    }

    public ResetToSelectedObjectsAction getResetToSelectedAction() {
        return this.d_resetToSelectedAction;
    }

    public FillViewAction getFillViewAction() {
        return this.d_fillViewAction;
    }

    public guiAction getSolidOutlinesAction() {
        return this.d_solidOutlinesAction;
    }

    public guiAction getRealisticAction() {
        return this.d_realisticAction;
    }

    public guiAction getRealisticOutlinesAction() {
        return this.d_realisticOutlinesAction;
    }

    public BooleanAction getDrawWireframeAction() {
        return this.d_wireframeAction;
    }

    public void savePreferences() {
        PyroPrefs.set(PyroPrefs.ShowGridProp, this.d_showGridDivsAction.isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowBoundaryProp, this.d_showGridBoundaryAction.isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowBoundaryLinesProp, this.d_showGridOutlinesAction.isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowSystemMouseProp, this.getShowPointerAction().isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowGuidesProp, this.getShowGuidesAction().isSelected(), false);
        PyroPrefs.set(PyroPrefs.ShowOriginProp, this.getShowOriginAction().isSelected(), false);
        PyroPrefs.set(PyroPrefs.UseSVNavProp, this.getUseSVNavAction().isSelected(), false);
        ISceneRenderOptions iSceneRenderOptions = this.d_mode2d.getRenderOptions(this);
        ISceneRenderOptions iSceneRenderOptions2 = this.d_mode3d.getRenderOptions(this);
        PyroPrefs.set(PyroPrefs.DrawWireframeProp2D, iSceneRenderOptions.get(ISceneRenderOptions.DRAW_WIREFRAME), false);
        PyroPrefs.set(PyroPrefs.DrawWireframeProp3D, iSceneRenderOptions2.get(ISceneRenderOptions.DRAW_WIREFRAME), false);
        PyroPrefs.set(PyroPrefs.ShowAppearancesProp2D, iSceneRenderOptions.get(ISceneRenderOptions.DRAW_MATERIALS), false);
        PyroPrefs.set(PyroPrefs.ShowAppearancesProp3D, iSceneRenderOptions2.get(ISceneRenderOptions.DRAW_MATERIALS), false);
        PyroPrefs.set(PyroPrefs.ShowOutlinesProp2D, iSceneRenderOptions.get(ISceneRenderOptions.DRAW_OUTLINES), false);
        PyroPrefs.set(PyroPrefs.ShowOutlinesProp3D, iSceneRenderOptions2.get(ISceneRenderOptions.DRAW_OUTLINES), false);
        PyroPrefs.set(PyroPrefs.UseSmoothLightingProp2D, iSceneRenderOptions.get(ISceneRenderOptions.SMOOTH_LIGHTING), false);
        PyroPrefs.set(PyroPrefs.UseSmoothLightingProp3D, iSceneRenderOptions2.get(ISceneRenderOptions.SMOOTH_LIGHTING), false);
        PyroPrefs.set(PyroPrefs.PREF_CUT_HOLES, this.d_drawProps.cutHoles(), false);
    }

    public JToolBar getViewOptionsToolbar() {
        return this.d_viewOptionsToolbar;
    }

    public JToolBar getFloorToolbar() {
        return this.d_floorToolbar;
    }

    public JToolBar getClipPlanesToolbar() {
        return this.d_editClipPlanesToolbar;
    }

    public JToolBar getGroupToolbar() {
        return this.d_groupToolbar;
    }

    public JToolBar getEditToolbar() {
        return this.d_editToolbar;
    }

    public JToolBar getViewToolbar() {
        return this.d_currViewMode.getCameraToolbar(this);
    }

    public JToolBar getCreateToolbar() {
        return this.d_createToolbar;
    }

    public JToolBar getFilterToolbar() {
        return this.d_filterToolbar;
    }

    public JToolBar getGridFilterToolbar() {
        return this.createGridFilterToolbar();
    }

    private static Icon newVisIcon(Icon icon, Icon icon2) {
        return icon == null ? null : new DecoratedIcon(icon, icon2, 3);
    }

    private void updateRasterizableObjs() {
        PyroSim.getApp().beginWaitCursor();
        Collection<FDSObject> collection = ((APyroObject)this.d_mediator.getObstructions()).flatten(FDSObject.class);
        this.d_dispMgr.d_geomDispMan.updateDisplays(collection);
        PyroSim.getApp().endWaitCursor();
    }

    private void updateCurrentTool() {
        Object object;
        Tool tool = this.d_tools.getCurrentTool();
        if (tool == this.d_modGameRoamTool.tool) {
            object = this.getModelSceneBounds();
            ((RoamFunc)this.d_modGameRoamTool.tool.getFunction()).setModelBounds((AABox)object);
        }
        if (tool instanceof CursorTool) {
            object = (CursorTool)tool;
            ((CursorTool)object).setGuidesVisible(this.d_showGuidesAction.isSelected());
            ((CursorTool)object).setPointerVisible(this.d_showPointerAction.isSelected());
            ((CursorTool)object).setView(this.getMainView());
            this.d_toolLayer.clear();
            this.d_toolLayer.add((IRenderable)object);
        }
    }

    public ClippingManager getClipManager() {
        return this.d_clipMgr;
    }

    public boolean isHoleCuttingEnabled() {
        return this.d_drawProps.cutHoles();
    }

    private static String getSnappingName(int n) {
        if (n == 0) {
            return Intl.intl("Disable Grid Snapping");
        }
        if (n == 1) {
            return Intl.intl("Snap to Sketch Grid");
        }
        return Intl.intl("Snap to Model Grids");
    }

    public Action getToolPropsAction() {
        return this.d_toolPropsAction;
    }

    private static OrthoCamera newOrthoCam() {
        return new OrthoCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.0, 10000.0, 10.0);
    }

    @Override
    public IAnimSession getAnimSession() {
        return this.d_animSession;
    }

    @Override
    public IDeviceManager getDevices() {
        return this.d_tools.getDevices();
    }

    public ModelViewFilterProps getFilterProps() {
        return new ModelViewFilterProps(this.d_filterActions[1].getState(), this.d_filterActions[2].getState(), this.d_filterActions[3].getState(), this.d_filterActions[4].getState(), this.d_filterActions[5].getState(), this.d_filterActions[6].getState(), this.d_filterActions[7].getState(), this.d_filterActions[9].getState(), this.d_filterActions[10].getState(), this.d_filterActions[11].getState(), this.d_filterActions[13].getState(), this.d_filterActions[14].getState(), this.d_filterActions[16].getState());
    }

    public void setViewFilters(ModelViewFilterProps modelViewFilterProps) {
        this.d_filterActions[1].setState(modelViewFilterProps.showObstructions);
        this.d_filterActions[2].setState(modelViewFilterProps.showHoles);
        this.d_filterActions[3].setState(modelViewFilterProps.showVents);
        this.d_filterActions[4].setState(modelViewFilterProps.showInit);
        this.d_filterActions[5].setState(modelViewFilterProps.showClouds);
        this.d_filterActions[6].setState(modelViewFilterProps.showDevices);
        this.d_filterActions[7].setState(modelViewFilterProps.showHvac);
        this.d_filterActions[9].setState(modelViewFilterProps.showZones);
        this.d_filterActions[10].setState(modelViewFilterProps.showStats);
        this.d_filterActions[11].setState(modelViewFilterProps.showSlices);
        this.d_filterActions[13].setState(modelViewFilterProps.showLabels);
        this.d_filterActions[14].setState(modelViewFilterProps.showCad);
        this.d_filterActions[16].setState(modelViewFilterProps.showCameras);
    }

    static /* synthetic */ OrthoCamera access$3100() {
        return ModelView.newOrthoCam();
    }

    public static class ModelViewFilterProps
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final boolean showObstructions;
        public final boolean showHoles;
        public final boolean showVents;
        public final boolean showInit;
        public final boolean showClouds;
        public final boolean showDevices;
        public final boolean showHvac;
        public final boolean showZones;
        public final boolean showStats;
        public final boolean showSlices;
        public final boolean showLabels;
        public final boolean showCad;
        public final boolean showCameras;

        public ModelViewFilterProps() {
            this(true, true, true, true, true, true, true, false, false, true, true, true, false);
        }

        public ModelViewFilterProps(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, boolean bl12, boolean bl13) {
            this.showObstructions = bl;
            this.showHoles = bl2;
            this.showVents = bl3;
            this.showInit = bl4;
            this.showClouds = bl5;
            this.showDevices = bl6;
            this.showHvac = bl7;
            this.showZones = bl8;
            this.showStats = bl9;
            this.showSlices = bl10;
            this.showLabels = bl11;
            this.showCad = bl12;
            this.showCameras = bl13;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ModelViewFilterProps)) {
                return false;
            }
            ModelViewFilterProps modelViewFilterProps = (ModelViewFilterProps)object;
            return this.showObstructions == modelViewFilterProps.showObstructions && this.showHoles == modelViewFilterProps.showHoles && this.showVents == modelViewFilterProps.showVents && this.showInit == modelViewFilterProps.showInit && this.showClouds == modelViewFilterProps.showClouds && this.showDevices == modelViewFilterProps.showDevices && this.showHvac == modelViewFilterProps.showHvac && this.showZones == modelViewFilterProps.showZones && this.showStats == modelViewFilterProps.showStats && this.showSlices == modelViewFilterProps.showSlices && this.showLabels == modelViewFilterProps.showLabels && this.showCad == modelViewFilterProps.showCad && this.showCameras == modelViewFilterProps.showCameras;
        }
    }

    private class ViewModifiedListener {
        public void update(Events events) {
            if (events.getEvents(PyroMod.class, new Class[0]).hasChangedObjs(PyroMod.EVT_MODEL_CHANGED)) {
                ModelView.this.initActiveView();
            } else if (pyrosim.domain.view.View.isCamChanged(ModelView.this.d_mediator, events)) {
                ModelView.this.updateActiveView();
            }
        }
    }

    private static class MouseButtons
    extends MouseAdapter {
        private final Set<Integer> d_pressedBtns = new HashSet<Integer>();

        private MouseButtons() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.d_pressedBtns.add(mouseEvent.getButton());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.d_pressedBtns.remove(mouseEvent.getButton());
        }

        public boolean getAnyPressed() {
            return !this.d_pressedBtns.isEmpty();
        }
    }

    public static class ViewMode2D
    extends AViewMode {
        private final Map<PredefCam, ChangeViewListener> d_cameraActionMap;
        private PredefCam d_currCam = PredefCam.TOP_2D;

        public ViewMode2D(ModelView modelView) {
            super(ViewMode2D.createRenderOptions());
            this.d_cameraActionMap = new IdentityHashMap<PredefCam, ChangeViewListener>();
            for (PredefCam predefCam : this.getCams()) {
                ChangeViewListener changeViewListener = new ChangeViewListener(modelView, predefCam);
                this.d_cameraActionMap.put(predefCam, changeViewListener);
            }
        }

        @Override
        public Camera getCamera(ModelView modelView) {
            return this.d_currCam.cam;
        }

        private static SceneRenderOptions createRenderOptions() {
            SceneRenderOptions sceneRenderOptions = new SceneRenderOptions();
            sceneRenderOptions.setLightingEnabled(true);
            sceneRenderOptions.setDrawWireframe(PyroPrefs.getBoolean(PyroPrefs.DrawWireframeProp2D));
            sceneRenderOptions.setShowMaterials(PyroPrefs.getBoolean(PyroPrefs.ShowAppearancesProp2D));
            sceneRenderOptions.setDrawOutlines(PyroPrefs.getBoolean(PyroPrefs.ShowOutlinesProp2D));
            sceneRenderOptions.setSmoothLightingEnabled(true);
            return sceneRenderOptions;
        }

        @Override
        public void initLayout(ModelView modelView, OverlayLayout overlayLayout, boolean bl) {
            OverlayLayout overlayLayout2;
            Cloneable cloneable;
            if (bl) {
                cloneable = ModelView.createQuickRestoreLayout();
                overlayLayout2 = new OverlayLayout();
                ((RenderPanel)cloneable).setLayoutManager(overlayLayout2);
                overlayLayout.add((IRenderComponent)((Object)cloneable));
            } else {
                overlayLayout2 = overlayLayout;
            }
            cloneable = new ArrayList();
            modelView.d_mainScenes.getRenderScenes((Collection<? super ModelScene>)((Object)cloneable));
            modelView.d_xformScenes.getRenderScenes((Collection<? super ModelScene>)((Object)cloneable));
            cloneable.add(modelView.d_manipScene);
            overlayLayout2.add(modelView.d_colorLayer);
            overlayLayout2.add(new BasicRenderer(modelView.d_backgroundScene));
            overlayLayout2.add(new BasicRenderer(modelView.d_gridScene.getCamera(), modelView.d_gridScene, modelView.d_originScene));
            overlayLayout2.add(new ClearableBackground(false, true));
            overlayLayout2.add(new BasicRenderer(modelView.d_mainScenes.getCamera(), theUtil.toArray(cloneable, IRenderable.class)));
            overlayLayout.add(new ClearableBackground(false, true));
            overlayLayout.add(new BasicRenderer(modelView.d_manipToolScene));
            cloneable.add(modelView.d_manipToolScene);
            BasicRenderer basicRenderer = new BasicRenderer(modelView.d_mainScenes.getCamera(), theUtil.toArray(cloneable, IRenderable.class));
            basicRenderer.setMode(BasicRenderer.Mode.Z_FIT_ONLY);
            overlayLayout.add(basicRenderer);
        }

        @Override
        public void initGridFilterToolbar(ModelView modelView, JToolBar jToolBar) {
            jToolBar.add(ModelView.createToggleButton(modelView.d_showGridOutlinesAction));
        }

        @Override
        public JToolBar createCameraToolbar(ModelView modelView) {
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            ArrayList<ChangeViewListener> arrayList = new ArrayList<ChangeViewListener>();
            for (PredefCam predefCam : this.getCams()) {
                arrayList.add(this.d_cameraActionMap.get((Object)predefCam));
                jToolBar.getInputMap(2).put(predefCam.hotkey, predefCam.name);
                jToolBar.getActionMap().put(predefCam.name, this.d_cameraActionMap.get((Object)predefCam));
            }
            jToolBar.add(new DropDownButton(arrayList){
                private static final long serialVersionUID = 1L;

                @Override
                protected Dimension getActionPreferredSize() {
                    Dimension dimension = super.getActionPreferredSize();
                    Dimension dimension2 = this.getMenu().getPreferredSize();
                    int n = dimension2.width - 20;
                    return new Dimension(n, dimension.height);
                }
            });
            Utils.noToolBarFocus(jToolBar);
            return jToolBar;
        }

        @Override
        protected Tool getDefaultTool(ModelView modelView) {
            return ((ModelView)modelView).d_manipTool2D.tool;
        }

        @Override
        public Predicate<Tool> getToolFilter(ModelView modelView) {
            return Filters.reject(((ModelView)modelView).d_manipTool3D.tool, ((ModelView)modelView).d_orbitTool.tool, ((ModelView)modelView).d_modGameRoamTool.tool);
        }

        @Override
        public void activate(ModelView modelView) {
            modelView.d_dispMgr.updateMode(this);
            super.activate(modelView);
            this.setCamera(modelView, this.d_currCam);
        }

        @Override
        public void deactivate(ModelView modelView) {
            this.setDrawingToolsEnabled(modelView, true);
            super.deactivate(modelView);
        }

        @Override
        public void resetAllCameras(ModelView modelView, AABox aABox, boolean bl) {
            ViewMode2D.resetCameras(modelView, aABox, bl, this.getCams());
        }

        @Override
        public void resetCurrentCamera(ModelView modelView, AABox aABox, boolean bl) {
            ViewMode2D.resetCameras(modelView, aABox, bl, this.d_currCam);
        }

        protected Collection<PredefCam> getCams() {
            return PredefCam.get(predefCam -> predefCam.is2D());
        }

        public void setCamera(ModelView modelView, PredefCam predefCam) {
            PredefCam predefCam2 = this.d_currCam;
            this.d_currCam = predefCam;
            boolean bl = predefCam == PredefCam.TOP_2D || predefCam == PredefCam.BOTTOM_2D;
            this.setDrawingToolsEnabled(modelView, bl);
            if (predefCam2 != predefCam) {
                modelView.cancelCurrentTool();
            }
            modelView.setMainCamera(predefCam.cam);
        }

        private void setDrawingToolsEnabled(ModelView modelView, boolean bl) {
            modelView.d_tools.getToolAction(modelView.d_newRoomTool).setEnabled(bl);
            modelView.d_tools.getToolAction(modelView.d_newWallObstTool).setEnabled(bl);
            modelView.d_tools.getToolAction(modelView.d_newWallHoleTool).setEnabled(bl);
        }

        private class ChangeViewListener
        extends guiAction {
            private static final long serialVersionUID = 3335086582751673628L;
            private final ModelView d_mv;
            private PredefCam d_camera;

            public ChangeViewListener(ModelView modelView, PredefCam predefCam) {
                super(predefCam.name, predefCam.icon);
                this.d_mv = modelView;
                this.putValue("ShortDescription", String.format(Intl.intl("Show %s View"), predefCam.name));
                this.d_camera = predefCam;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ViewMode2D.this.setCamera(this.d_mv, this.d_camera);
                this.d_mv.d_renderComp.repaint();
            }
        }
    }

    public static class ViewMode3D
    extends AViewMode {
        public ViewMode3D() {
            super(ViewMode3D.createRenderOptions());
        }

        private static SceneRenderOptions createRenderOptions() {
            SceneRenderOptions sceneRenderOptions = new SceneRenderOptions();
            sceneRenderOptions.setLightingEnabled(true);
            sceneRenderOptions.setDrawWireframe(PyroPrefs.getBoolean(PyroPrefs.DrawWireframeProp3D));
            sceneRenderOptions.setShowMaterials(PyroPrefs.getBoolean(PyroPrefs.ShowAppearancesProp3D));
            sceneRenderOptions.setDrawOutlines(PyroPrefs.getBoolean(PyroPrefs.ShowOutlinesProp3D));
            sceneRenderOptions.setSmoothLightingEnabled(true);
            return sceneRenderOptions;
        }

        @Override
        public Camera getCamera(ModelView modelView) {
            return s_perspCam;
        }

        @Override
        protected Tool getDefaultTool(ModelView modelView) {
            return ((ModelView)modelView).d_orbitTool.tool;
        }

        @Override
        public Predicate<Tool> getToolFilter(ModelView modelView) {
            return Filters.reject(((ModelView)modelView).d_manipTool2D.tool);
        }

        @Override
        public void activate(ModelView modelView) {
            modelView.setMainCamera(s_perspCam);
            modelView.d_dispMgr.updateMode(this);
            super.activate(modelView);
        }

        @Override
        public void deactivate(ModelView modelView) {
            super.deactivate(modelView);
        }

        @Override
        public void resetAllCameras(ModelView modelView, AABox aABox, boolean bl) {
            ViewMode3D.resetCameras(modelView, aABox, bl, PredefCam.TOP_3D);
        }

        @Override
        public void resetCurrentCamera(ModelView modelView, AABox aABox, boolean bl) {
            ViewMode3D.resetCameras(modelView, aABox, bl, PredefCam.TOP_3D);
        }

        @Override
        public void initLayout(ModelView modelView, OverlayLayout overlayLayout, boolean bl) {
            OverlayLayout overlayLayout2;
            Cloneable cloneable;
            if (bl) {
                cloneable = ModelView.createQuickRestoreLayout();
                overlayLayout2 = new OverlayLayout();
                ((RenderPanel)cloneable).setLayoutManager(overlayLayout2);
                overlayLayout.add((IRenderComponent)((Object)cloneable));
            } else {
                overlayLayout2 = overlayLayout;
            }
            cloneable = new ArrayList();
            modelView.d_mainScenes.getRenderScenes((Collection<? super ModelScene>)((Object)cloneable));
            modelView.d_xformScenes.getRenderScenes((Collection<? super ModelScene>)((Object)cloneable));
            cloneable.add(modelView.d_manipScene);
            overlayLayout2.add(modelView.d_colorLayer);
            overlayLayout2.add(new BasicRenderer(s_perspCam, theUtil.toArray(cloneable, IRenderable.class)));
            overlayLayout.add(new ClearableBackground(false, true));
            overlayLayout.add(new BasicRenderer(modelView.d_manipToolScene));
            cloneable.add(modelView.d_manipToolScene);
            BasicRenderer basicRenderer = new BasicRenderer(s_perspCam, theUtil.toArray(cloneable, IRenderable.class));
            basicRenderer.setMode(BasicRenderer.Mode.Z_FIT_ONLY);
            overlayLayout.add(basicRenderer);
        }

        protected Collection<PredefCam> getCams() {
            return PredefCam.get(predefCam -> predefCam.is3D());
        }

        @Override
        public void initGridFilterToolbar(ModelView modelView, JToolBar jToolBar) {
            jToolBar.add(ModelView.createToggleButton(modelView.d_showGridDivsAction));
            jToolBar.add(ModelView.createToggleButton(modelView.d_showGridBoundaryAction));
            jToolBar.add(ModelView.createToggleButton(modelView.d_showGridOutlinesAction));
        }

        @Override
        public JToolBar createCameraToolbar(ModelView modelView) {
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            ArrayList<ChangeViewListener> arrayList = new ArrayList<ChangeViewListener>();
            for (PredefCam predefCam : this.getCams()) {
                ChangeViewListener changeViewListener = new ChangeViewListener(modelView, predefCam);
                arrayList.add(changeViewListener);
                jToolBar.getInputMap(2).put(predefCam.hotkey, predefCam.name);
                jToolBar.getActionMap().put(predefCam.name, changeViewListener);
            }
            DropDownButton dropDownButton = new DropDownButton(arrayList){
                private static final long serialVersionUID = 1L;

                @Override
                protected Dimension getActionPreferredSize() {
                    Dimension dimension = super.getActionPreferredSize();
                    Dimension dimension2 = this.getMenu().getPreferredSize();
                    int n = dimension2.width - 20;
                    return new Dimension(n, dimension.height);
                }
            };
            jToolBar.add(dropDownButton);
            Utils.noToolBarFocus(jToolBar);
            return jToolBar;
        }

        private class ChangeViewListener
        extends guiAction {
            private static final long serialVersionUID = 3121322335873928157L;
            private final ModelView d_mv;
            private PredefCam d_camera;

            public ChangeViewListener(ModelView modelView, PredefCam predefCam) {
                super(predefCam.name, predefCam.icon);
                this.d_mv = modelView;
                this.putValue("ShortDescription", String.format(Intl.intl("Reset to %s View"), predefCam.name));
                this.d_camera = predefCam;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AABox aABox = this.d_mv.getModelSceneBounds();
                AViewMode.resetCameras(this.d_mv, aABox, true, this.d_camera);
                this.d_mv.d_renderComp.repaint();
            }
        }
    }

    public static abstract class AViewMode
    implements IViewMode {
        private final SceneRenderOptions d_renderOptions;
        private final SceneRenderOptions d_patchRenderOptions;
        private final SceneRenderOptions d_noclipRenderOptions;
        private Tool d_lastTool = null;
        private JToolBar d_toolbar = null;
        public static final boolean USE_NEGATIVE_POLYOFFSET = false;

        public AViewMode(SceneRenderOptions sceneRenderOptions) {
            this.d_renderOptions = sceneRenderOptions;
            this.d_patchRenderOptions = this.d_renderOptions.clone();
            this.d_noclipRenderOptions = new SceneRenderOptions();
            this.d_noclipRenderOptions.setDrawOutlines(true);
            this.updateOffset();
        }

        @Override
        public ISceneRenderOptions getRenderOptions(ModelView modelView) {
            return new MultiSceneRenderOptions(this.d_renderOptions, this.d_patchRenderOptions);
        }

        @Override
        public Tool getNavTool(ModelView modelView) {
            if (modelView.d_currViewMode == this) {
                return modelView.d_tools.getRootTool();
            }
            if (this.d_lastTool == null) {
                return this.getDefaultTool(modelView);
            }
            return this.d_lastTool;
        }

        @Override
        public void updateOffset() {
            this.d_renderOptions.set(ISceneRenderOptions.SOLID_POLYGON_OFFSET, new float[]{1.0f, 1.0f});
            this.d_renderOptions.set(ISceneRenderOptions.OUTLINE_POLYGON_OFFSET, new float[]{0.0f, 0.0f});
            this.d_patchRenderOptions.set(ISceneRenderOptions.SOLID_POLYGON_OFFSET, new float[]{0.5f, 0.5f});
            this.d_patchRenderOptions.set(ISceneRenderOptions.OUTLINE_POLYGON_OFFSET, new float[]{0.0f, 0.0f});
        }

        protected abstract JToolBar createCameraToolbar(ModelView var1);

        protected abstract Tool getDefaultTool(ModelView var1);

        @Override
        public void activate(ModelView modelView) {
            if (this.d_lastTool == null) {
                this.d_lastTool = this.getDefaultTool(modelView);
            }
            modelView.d_tools.setCurrentTool(this.d_lastTool);
            for (Tool tool : theUtil.filter(modelView.d_tools.getTools(), this.getToolFilter(modelView).negate())) {
                modelView.d_tools.getToolbarButton(tool).setVisible(false);
            }
            this.applyRenderOptions(modelView, this.d_renderOptions, this.d_patchRenderOptions, this.d_noclipRenderOptions);
            this.updateOffset();
        }

        @Override
        public void deactivate(ModelView modelView) {
            this.d_lastTool = modelView.d_tools.getCurrentTool();
            for (Tool tool : theUtil.filter(modelView.d_tools.getTools(), this.getToolFilter(modelView).negate())) {
                modelView.d_tools.getToolbarButton(tool).setVisible(true);
            }
        }

        private void applyRenderOptions(ModelView modelView, SceneRenderOptions sceneRenderOptions, SceneRenderOptions sceneRenderOptions2, SceneRenderOptions sceneRenderOptions3) {
            modelView.d_xformScenes.setDrawProps(sceneRenderOptions, sceneRenderOptions2, sceneRenderOptions3);
            modelView.d_mainScenes.setDrawProps(sceneRenderOptions, sceneRenderOptions2, sceneRenderOptions3);
            modelView.d_manipScene.setDrawProps(sceneRenderOptions);
            modelView.d_wireframeAction.setSelected(sceneRenderOptions.drawWireframe());
            modelView.d_solidAction.setSelected(!sceneRenderOptions.drawWireframe());
        }

        @Override
        public JToolBar getCameraToolbar(ModelView modelView) {
            if (this.d_toolbar == null) {
                this.d_toolbar = this.createCameraToolbar(modelView);
            }
            return this.d_toolbar;
        }

        protected static void resetCameras(ModelView modelView, AABox aABox, boolean bl, PredefCam ... predefCamArray) {
            AViewMode.resetCameras(modelView, aABox, bl, Arrays.asList(predefCamArray));
        }

        protected static void resetCameras(ModelView modelView, AABox aABox, boolean bl, Collection<PredefCam> collection) {
            for (PredefCam predefCam : collection) {
                AABox aABox2 = predefCam.cam.ensureValidForReset(new AABox(aABox), 5.0);
                predefCam.cam.reset(predefCam.resetZ, predefCam.resetY, aABox2, modelView.d_renderComp.getWidth(), modelView.d_renderComp.getHeight());
            }
        }
    }

    public static interface IViewMode {
        public Camera getCamera(ModelView var1);

        public Tool getNavTool(ModelView var1);

        public void activate(ModelView var1);

        public void deactivate(ModelView var1);

        public void resetCurrentCamera(ModelView var1, AABox var2, boolean var3);

        public void resetAllCameras(ModelView var1, AABox var2, boolean var3);

        public ISceneRenderOptions getRenderOptions(ModelView var1);

        public JToolBar getCameraToolbar(ModelView var1);

        public void initGridFilterToolbar(ModelView var1, JToolBar var2);

        public void initLayout(ModelView var1, OverlayLayout var2, boolean var3);

        public void updateOffset();

        public Predicate<Tool> getToolFilter(ModelView var1);
    }

    public static enum PredefCam {
        TOP_3D(Intl.intl("Reset to Top"), ModelView.access$3000(), GeomConstants.VEC3D_ZNEG, GeomConstants.VEC3D_YPOS, "ViewXY.gif", KeyStroke.getKeyStroke(53, 2)),
        BOTTOM_3D(Intl.intl("Reset to Bottom"), ModelView.access$3000(), GeomConstants.VEC3D_ZPOS, GeomConstants.VEC3D_YPOS, "ViewXY2.gif", KeyStroke.getKeyStroke(54, 2)),
        FRONT_3D(Intl.intl("Reset to Front"), ModelView.access$3000(), GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS, "ViewXZ.gif", KeyStroke.getKeyStroke(49, 2)),
        BACK_3D(Intl.intl("Reset to Back"), ModelView.access$3000(), GeomConstants.VEC3D_YNEG, GeomConstants.VEC3D_ZPOS, "ViewXZ2.gif", KeyStroke.getKeyStroke(50, 2)),
        LEFT_3D(Intl.intl("Reset to Left"), ModelView.access$3000(), GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_ZPOS, "ViewYZ.gif", KeyStroke.getKeyStroke(51, 2)),
        RIGHT_3D(Intl.intl("Reset to Right"), ModelView.access$3000(), GeomConstants.VEC3D_XNEG, GeomConstants.VEC3D_ZPOS, "ViewYZ2.gif", KeyStroke.getKeyStroke(52, 2)),
        TOP_2D(Intl.intl("Reset to Top"), ModelView.access$3100(), GeomConstants.VEC3D_ZNEG, GeomConstants.VEC3D_YPOS, "ViewXY.gif", KeyStroke.getKeyStroke(53, 2)),
        BOTTOM_2D(Intl.intl("Reset to Bottom"), ModelView.access$3100(), GeomConstants.VEC3D_ZPOS, GeomConstants.VEC3D_YPOS, "ViewXY2.gif", KeyStroke.getKeyStroke(54, 2)),
        FRONT_2D(Intl.intl("Reset to Front"), ModelView.access$3100(), GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS, "ViewXZ.gif", KeyStroke.getKeyStroke(49, 2)),
        BACK_2D(Intl.intl("Reset to Back"), ModelView.access$3100(), GeomConstants.VEC3D_YNEG, GeomConstants.VEC3D_ZPOS, "ViewXZ2.gif", KeyStroke.getKeyStroke(50, 2)),
        LEFT_2D(Intl.intl("Reset to Left"), ModelView.access$3100(), GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_ZPOS, "ViewYZ.gif", KeyStroke.getKeyStroke(51, 2)),
        RIGHT_2D(Intl.intl("Reset to Right"), ModelView.access$3100(), GeomConstants.VEC3D_XNEG, GeomConstants.VEC3D_ZPOS, "ViewYZ2.gif", KeyStroke.getKeyStroke(52, 2));

        public final String name;
        public final Camera cam;
        public final Vector3d resetZ;
        public final Vector3d resetY;
        public final Icon icon;
        public final KeyStroke hotkey;

        private PredefCam(String string2, Camera camera, Vector3d vector3d, Vector3d vector3d2, String string3, KeyStroke keyStroke) {
            this.name = string2;
            this.cam = camera;
            this.resetZ = vector3d;
            this.resetY = vector3d2;
            this.icon = PyroGuiUtil.loadTeciIcon(string3);
            this.hotkey = keyStroke;
        }

        public boolean is3D() {
            return this.cam instanceof PerspectiveCamera;
        }

        public boolean is2D() {
            return this.cam instanceof OrthoCamera;
        }

        public static Collection<PredefCam> get(Predicate<PredefCam> predicate) {
            return theUtil.filter(Arrays.asList(PredefCam.values()), predicate);
        }
    }

    private static class GCListener
    extends KeyAdapter {
        private GCListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 123) {
                long l = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
                long l2 = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                long l3 = l - l2;
                System.out.printf("in use before: %d MB%n", l3);
                System.gc();
                System.runFinalization();
                long l4 = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
                long l5 = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                long l6 = l4 - l5;
                long l7 = l3 - l6;
                System.out.printf("in use after: %d MB (freed %d MB)%n", l6, l7);
                System.out.printf("total: %d (%d) MB%n", l4, l5);
            }
        }
    }

    private class ToolPropsAction
    extends AbstractAction
    implements ToolManager.ToolChangeListener {
        private static final long serialVersionUID = 1858041037199422964L;

        public ToolPropsAction() {
            super(Intl.intl("Tool Properties..."), PyroGuiUtil.loadTeciIcon("Preferences16.gif"));
            this.putValue("ShortDescription", Intl.intl("Tool Properties"));
            ModelView.this.d_tools.addToolChangeListener(this);
        }

        public void updateStatus() {
            Set<DrawProps.Prop<?>> set = this.getPropSet(ModelView.this.d_tools.getCurrentTool());
            this.setEnabled(!set.isEmpty());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Tool tool = ModelView.this.d_tools.getCurrentTool();
            Set<DrawProps.Prop<?>> set = this.getPropSet(tool);
            if (!set.isEmpty()) {
                DrawProps drawProps = this.getProps(tool);
                guiDialog guiDialog2 = null;
                if (tool instanceof ADrawTool && !(tool instanceof MeasureTool)) {
                    ToolMeta toolMeta = this.getMeta(tool);
                    DrawProps.ObjType objType = toolMeta.objCreateType;
                    Class<? extends IGeom> clazz = ((ADrawTool)tool).getGeomType();
                    guiDialog2 = new ToolPropertiesDlg(PyroSim.getApp().getActiveFrame(), ModelView.this.d_mediator, ModelView.this.getMainView().getCamera(), DrawProps.getNameKey(objType), drawProps.getThicknessDesc(objType, clazz), drawProps.getSurfFilter(objType, clazz), drawProps, set);
                } else if (tool instanceof SurfacePainterTool) {
                    Predicate<Surface> predicate = SurfacePainterTool.getSurfFilter();
                    guiDialog2 = new ToolPropertiesDlg(PyroSim.getApp().getActiveFrame(), ModelView.this.d_mediator, ModelView.this.getMainView().getCamera(), null, null, predicate, drawProps, Sets.fromArrayHS(DrawProps.SURFACE, DrawProps.COLOR, DrawProps.SPECIFY_COLOR, DrawProps.SPECIFY_SURFACE));
                } else if (tool instanceof SurfacePickerTool) {
                    guiDialog2 = new ToolPropertiesDlg(PyroSim.getApp().getActiveFrame(), ModelView.this.d_mediator, ModelView.this.getMainView().getCamera(), null, null, Filters.acceptAll(Surface.class), drawProps, Sets.fromArrayHS(DrawProps.SPECIFY_COLOR, DrawProps.SPECIFY_SURFACE));
                }
                if (guiDialog2 != null && guiDialog2.doModal() == 1) {
                    ((ToolPropertiesDlg)guiDialog2).saveProps();
                    ModelView.this.d_drawToolBridge.updateProps();
                    ModelView.this.d_renderComp.repaint();
                }
            }
        }

        @Override
        public void toolWillChanged(Tool tool, Tool tool2) {
            this.updateStatus();
        }

        private DrawProps getProps(Tool tool) {
            return tool instanceof IPyroTool ? ((IPyroTool)tool).getProps() : null;
        }

        private ToolMeta getMeta(Tool tool) {
            if (tool != null) {
                ToolManager.ToolProps toolProps = ModelView.this.d_tools.getProps(tool);
                return toolProps.meta instanceof ToolMeta ? (ToolMeta)toolProps.meta : null;
            }
            return null;
        }

        private Set<DrawProps.Prop<?>> getPropSet(Tool tool) {
            DrawProps drawProps = this.getProps(tool);
            if (drawProps == null) {
                return Collections.EMPTY_SET;
            }
            if (tool instanceof ADrawTool && !(tool instanceof MeasureTool)) {
                ToolMeta toolMeta = this.getMeta(tool);
                DrawProps.ObjType objType = toolMeta.objCreateType;
                Class<? extends IGeom> clazz = ((ADrawTool)tool).getGeomType();
                Set<DrawProps.Prop<?>> set = drawProps.getPropTypes(objType, clazz);
                if (tool instanceof DrawGridGeomTool || tool instanceof DrawAABoxGeomTool) {
                    set.remove(DrawProps.THICKNESS);
                }
                return set;
            }
            if (tool instanceof SurfacePainterTool) {
                return Sets.fromArrayHS(DrawProps.SURFACE, DrawProps.COLOR, DrawProps.SPECIFY_COLOR, DrawProps.SPECIFY_SURFACE);
            }
            if (tool instanceof SurfacePickerTool) {
                return Sets.fromArrayHS(DrawProps.SPECIFY_COLOR, DrawProps.SPECIFY_SURFACE);
            }
            return Collections.EMPTY_SET;
        }
    }

    private class FloorBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -424172468799442485L;

        private FloorBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object != null) {
                String string;
                if (object == ModelView.this.d_allFloorsFloor) {
                    string = ModelView.this.d_allFloorsFloor.getName();
                } else {
                    Floor floor = (Floor)object;
                    Unit unit = ((PyroSim)Application.getApp()).getUnitSystem().getLengthUnit();
                    NumberFormat numberFormat = NumberFormat.getNumberInstance();
                    numberFormat.setMaximumFractionDigits(2);
                    string = String.format("%1$s (%2$s %3$s)", floor.getName(), numberFormat.format(floor.getElevation().getValue(unit)), unit.toString());
                }
                this.setText(string);
                ModelView.this.d_floorBox.setToolTipText(string);
            }
            return this;
        }
    }

    public static interface CameraChangeListener {
        public void cameraChanged(Camera var1, Camera var2);
    }

    public class SelectGridAction
    extends MutuallyExclusiveAction {
        private static final long serialVersionUID = -234522650277828853L;
        private final int d_grid;

        public SelectGridAction(int n, boolean bl) {
            super(ModelView.getSnappingName(n), bl);
            this.d_grid = n;
        }

        @Override
        protected void stateChanged() {
            if (!this.isSelected()) {
                return;
            }
            ModelView.this.setActiveSnapper(this.d_grid, false);
            ModelView.this.getRenderComponent().repaint();
        }
    }

    public class CutHolesAction
    extends BooleanAction {
        private static final long serialVersionUID = -1761223646899256562L;

        public CutHolesAction() {
            super(Intl.intl("Cut Holes From Obstructions"), ModelView.this.d_drawProps.cutHoles());
        }

        @Override
        protected void stateChanged() {
            PyroSim.getApp().beginWaitCursor();
            ModelView.this.d_drawProps.setCutHoles(this.isSelected());
            ModelView.this.d_mediator.updateGeomSearchesEnabled(ModelView.this.isHoleCuttingEnabled());
            ((ModelView)ModelView.this).d_dispMgr.d_geomDispMan.updateAll();
            ModelView.this.d_renderComp.repaint();
            PyroSim.getApp().endWaitCursor();
        }
    }

    private class EditModelImageAction
    extends DisposableObject
    implements FloorBGImageEditor.EditBGImageAction {
        private final IntermediateGraphicsXfer d_igx = new IntermediateGraphicsXfer();

        private EditModelImageAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean editFloor(Floor floor) {
            Object object;
            HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>> hashMap = new HashMap<BGImageDlg.Colors, IPropertySet.Prop<Color>>();
            hashMap.put(BGImageDlg.Colors.AXIS, PyroSimColors.AXIS_COLOR);
            hashMap.put(BGImageDlg.Colors.AXIS_BOX, PyroSimColors.AXIS_BOX_COLOR);
            hashMap.put(BGImageDlg.Colors.AXIS_TEXT, PyroSimColors.AXIS_TEXT_COLOR);
            hashMap.put(BGImageDlg.Colors.BACKGROUND, PyroSimColors.BACKGROUND_COLOR);
            hashMap.put(BGImageDlg.Colors.ORIGIN, PyroSimColors.ORIGIN2D_COLOR);
            ImageLoader imageLoader = new ImageLoader();
            BGImageDlg.ImageInfo imageInfo = null;
            if (floor.getBgImage() != null) {
                object = floor.getBgImage();
                imageInfo = new BGImageDlg.ImageInfo(((ModelImage)object).getImage(), ((ModelImage)object).getLWTransform(), ((ModelImage)object).getOpacity());
            }
            object = BGImageDlg.editImage(PyroSim.getApp().getActiveFrame(), ModelView.this.d_renderComp, PyroSim.getApp().getColorManager(), hashMap, imageLoader, PyroSim.getApp().getUnitSystem().getLengthUnit(), this.d_igx, imageInfo);
            try {
                if (object == null) {
                    boolean bl = false;
                    return bl;
                }
                ATask aTask = new ATask(false, (BGImageDlg.ImageInfo)object, floor){
                    final /* synthetic */ BGImageDlg.ImageInfo val$result;
                    final /* synthetic */ Floor val$f;
                    {
                        this.val$result = imageInfo;
                        this.val$f = floor;
                        super(bl);
                    }

                    @Override
                    public void undo() {
                    }

                    @Override
                    public void run() {
                        ModelImage modelImage = new ModelImage(this.val$result.image, this.val$result.xform, this.val$result.opacity);
                        this.val$f.setBgImage(modelImage);
                    }
                };
                ModelView.this.d_mediator.getTaskManager().exec(aTask, Intl.intl("Edit Background Image"));
                boolean bl = true;
                return bl;
            }
            finally {
                this.d_igx.dispose();
            }
        }

        @Override
        public void dispose() {
            this.d_igx.release();
        }
    }

    private static class ImageLoader
    implements BGImageDlg.IImageLoader {
        private static final String[] FILTERS = new String[]{"bmp", Intl.intl("BMP Files"), "gif", Intl.intl("GIF Files"), "jpg", Intl.intl("JPEG Files"), "jpeg", Intl.intl("JPEG Files"), "jif", Intl.intl("JPEG Files"), "jpe", Intl.intl("JPEG Files"), "png", Intl.intl("PNG Files"), "tif", Intl.intl("TIF Files"), "tga", Intl.intl("TARGA Files"), "targa", Intl.intl("TARGA Files")};

        private ImageLoader() {
        }

        @Override
        public File choose(Component component, File file) {
            return PyroSim.getFilenames().getOpenFile((Component)PyroSim.getApp().getActiveFrame(), file, FILTERS);
        }

        @Override
        public Pair<Image, BGImageXform> load(File file) throws IOException {
            String string = file.getAbsolutePath();
            try {
                IImage iImage = ImageManager.getImage(string);
                if (iImage == null) {
                    throw new IOException(Intl.intl("Could not load image."));
                }
                return new Pair<IImage, Object>(iImage, null);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException(Intl.intl("Unable to load image file, the file is too large."));
            }
        }
    }

    private class FillViewAction
    extends guiAction {
        private static final long serialVersionUID = 4134387244026864947L;

        public FillViewAction() {
            super(Intl.intl("Fill View"), PyroGuiUtil.loadPyroSimIcon("fillview16.gif"));
            this.putValue("ShortDescription", Intl.intl("Fill view without resetting view angle"));
            this.putValue("AcceleratorKey", Accelerators.FILL_VIEW);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelView.this.fillCamera();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ResetToSelectedObjectsAction
    extends guiAction {
        private static final long serialVersionUID = 6747950754014970066L;

        public ResetToSelectedObjectsAction() {
            super(Intl.intl("Reset View to Selected Objects"), PyroGuiUtil.loadPyroSimIcon("ZoomSelectedObjs16.gif"));
            this.putValue("ShortDescription", Intl.intl("Reset View to Visible, Selected Objects"));
            this.putValue("AcceleratorKey", Accelerators.RESET_SELECTED);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Collection<IPyroGeomSrc> collection = ModelView.this.d_mediator.getSelectionModel().flatten(IPyroGeomSrc.class);
            ArrayList<Object3D> arrayList = new ArrayList<Object3D>(collection.size());
            arrayList.addAll(theUtil.filter(ModelView.this.d_dispMgr.getDisplayObjs(collection), Object3D.class));
            if (arrayList.isEmpty()) {
                return;
            }
            ModelView.this.resetCurrentCamera(arrayList);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ResetToAllObjectsAction
    extends guiAction {
        private static final long serialVersionUID = 575148560236721658L;

        public ResetToAllObjectsAction() {
            super(Intl.intl("Reset View to All Objects"), PyroGuiUtil.loadTeciIcon("ZoomFit16.gif"));
            this.putValue("ShortDescription", Intl.intl("Reset View to All Visible Objects"));
            this.putValue("AcceleratorKey", Accelerators.RESET_VIEW);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelView.this.resetCurrentCamera();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ManageFloorsAction
    extends guiAction {
        private static final long serialVersionUID = -7923470282395880358L;

        public ManageFloorsAction() {
            super(Intl.intl("Manage Floors..."), PyroGuiUtil.loadPyroSimIcon("managefloors16_2.gif"));
            this.putValue("ShortDescription", Intl.intl("Define Floor Locations"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditModelImageAction editModelImageAction = new EditModelImageAction();
            ManageFloorsDlg manageFloorsDlg = new ManageFloorsDlg(Application.getApp().getMainFrame(), ModelView.this.d_mediator, editModelImageAction);
            editModelImageAction.release();
            if (manageFloorsDlg.doModal() == 1) {
                ManageFloorsTask manageFloorsTask = new ManageFloorsTask(manageFloorsDlg);
                ModelView.this.d_mediator.getTaskManager().exec(manageFloorsTask, Intl.intl("Edit Floors"));
            }
        }
    }

    private class ConfigureBGImageAction
    extends guiAction {
        private static final long serialVersionUID = -1736108326757489690L;

        public ConfigureBGImageAction() {
            super(Intl.intl("Configure Background Image") + "...", PyroGuiUtil.loadPyroSimIcon("ConfigureBackgroundImage16.gif"));
            this.putValue("ShortDescription", Intl.intl("Configure Background Image for the Current Floor"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ModelView.this.d_currentFloor != null) {
                EditModelImageAction editModelImageAction = new EditModelImageAction();
                editModelImageAction.editFloor(ModelView.this.d_currentFloor);
                editModelImageAction.release();
            } else if (JOptionPane.showConfirmDialog(PyroSim.getApp().getActiveFrame(), Intl.intl("Background images are unique to each floor.  Set background images using the Floor Manager."), Intl.intl("Configure Background Image"), 2) == 0) {
                ModelView.this.getManageFloorsAction().actionPerformed(actionEvent);
            }
        }
    }

    private class UseWireframeAction
    extends BooleanAction {
        private static final long serialVersionUID = -1071282092337624521L;
        private final boolean d_wireframe;

        public UseWireframeAction(String string, String string2, boolean bl, String string3, boolean bl2) {
            super(string, bl, new ImageIcon(ClassLoader.getSystemResource(string3)));
            this.putValue("ShortDescription", string2);
            this.d_wireframe = bl2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_WIREFRAME, this.d_wireframe);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_OUTLINES, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_MATERIALS, false);
            ModelView.this.getCurrentViewMode().updateOffset();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ShowRealisticOutlinesAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public ShowRealisticOutlinesAction(boolean bl) {
            super(Intl.intl("Realistic with Outlines"), new ImageIcon(ClassLoader.getSystemResource("pyrosim/icons/texturesOutline.png")));
            this.putValue("ShortDescription", Intl.intl("Show Objects Using Surface Appearance with Outlines"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_WIREFRAME, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_OUTLINES, true);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_MATERIALS, true);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ShowRealisticAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public ShowRealisticAction(boolean bl) {
            super(Intl.intl("Realistic"), PyroGuiUtil.loadPyroSimIcon("textures.png"));
            this.putValue("ShortDescription", Intl.intl("Show Objects Using Surface Appearances"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_WIREFRAME, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_OUTLINES, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_MATERIALS, true);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ShowSolidOutlinesAction
    extends guiAction {
        private static final long serialVersionUID = 1L;

        public ShowSolidOutlinesAction(boolean bl) {
            super(Intl.intl("Solid with Outlines"), new ImageIcon(ClassLoader.getSystemResource("pyrosim/icons/outlines.png")));
            this.putValue("ShortDescription", Intl.intl("Show Objects as Solids with Outlines"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_WIREFRAME, false);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_OUTLINES, true);
            ModelView.this.getCurrentRenderOptions().set(ISceneRenderOptions.DRAW_MATERIALS, false);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class UseSVNavigationAction
    extends BooleanAction {
        private static final long serialVersionUID = 1969470262773663277L;

        public UseSVNavigationAction(boolean bl) {
            super(Intl.intl("Use Smokeview-like Navigation"), bl);
        }

        @Override
        protected void stateChanged() {
            ((SwitchingToolFunc)((ModelView)ModelView.this).d_orbitTool.tool.getFunction()).setCurrentFunc(this.isSelected() ? 1 : 0);
        }
    }

    private class ShowSystemMouseAction
    extends BooleanAction {
        private static final long serialVersionUID = -8774518959151462077L;

        public ShowSystemMouseAction(boolean bl) {
            super(Intl.intl("Show System Mouse"), bl);
        }

        @Override
        protected void stateChanged() {
            ModelView.this.updateCurrentTool();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ShowGuidesAction
    extends BooleanAction {
        private static final long serialVersionUID = 5435063418982919330L;

        public ShowGuidesAction(boolean bl) {
            super(Intl.intl("Show Cursor Guides"), bl);
        }

        @Override
        protected void stateChanged() {
            ModelView.this.updateCurrentTool();
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class FDSPreviewAction
    extends FilterAction {
        private static final long serialVersionUID = 6411840680811353808L;

        public FDSPreviewAction() {
            super(Intl.intl("Preview FDS Blocks"), (Icon)PyroGuiUtil.loadPyroSimIcon("rasterized16.gif"), Filter.class, false);
        }

        @Override
        protected void stateChanged() {
            super.stateChanged();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FDSRasterization fDSRasterization = FDSPreviewAction.this.isSelected() ? ModelView.this.d_mediator.getRasterizations() : null;
                    ModelView.this.getDrawProps().setRasterizer(fDSRasterization);
                    ModelView.this.updateRasterizableObjs();
                    ModelView.this.getRenderComponent().repaint();
                }
            });
        }

        private final class Filter {
            private Filter() {
            }
        }
    }

    private class FilterAction<T>
    extends BooleanAction
    implements IEventObserver {
        private static final long serialVersionUID = -574190459864692128L;
        private final Class<T> d_filterType;
        private final Predicate<? super T> d_hideFilter;
        private final Predicate<? super T> d_showFilter;
        private final Icon d_visIcon;
        private final Icon d_hiddenIcon;
        private final Function<Events, Boolean> d_eventTester;

        public FilterAction(String string, String string2, Class<T> clazz, boolean bl) {
            this(string2, null, clazz, Predicates.alwaysFalse(), bl);
            this.putValue("ShortDescription", string);
        }

        public FilterAction(String string, Icon icon, Class<T> clazz, TypedProp<Boolean> typedProp) {
            this(string, icon, clazz, PyroPrefs.getBoolean(typedProp));
        }

        public FilterAction(String string, Icon icon, Class<T> clazz, boolean bl) {
            this(string, icon, clazz, Predicates.alwaysFalse(), bl);
        }

        public FilterAction(String string, Icon icon, Class<T> clazz, Predicate<? super T> predicate, boolean bl) {
            this(string, icon, clazz, predicate, Predicates.alwaysTrue(), null, bl);
        }

        public FilterAction(String string, Icon icon, Class<T> clazz, Predicate<? super T> predicate, Predicate<? super T> predicate2, Function<Events, Boolean> function, boolean bl) {
            super(string, bl, icon);
            this.d_visIcon = ModelView.newVisIcon(icon, s_lbOnIcon);
            this.d_hiddenIcon = ModelView.newVisIcon(icon, s_lbOffIcon);
            this.d_filterType = clazz;
            this.d_hideFilter = predicate;
            this.d_showFilter = predicate2;
            this.d_eventTester = function;
            if (this.d_eventTester != null) {
                PyroSim.getApp().getMediator().getEvents().addObserver(this);
            }
            this.updateIcon();
            this.updateState();
        }

        @Override
        public void update(Events events) {
            if (this.d_eventTester.apply(events).booleanValue()) {
                ((ModelView)ModelView.this).d_dispMgr.d_dispFilter.changed(this.d_filterType);
            }
        }

        private void updateState() {
            if (!this.isSelected()) {
                ((ModelView)ModelView.this).d_dispMgr.d_dispFilter.registerFilter(this.d_filterType, this.d_hideFilter);
            } else if (Predicates.alwaysTrue(this.d_showFilter)) {
                ((ModelView)ModelView.this).d_dispMgr.d_dispFilter.removeFilter(this.d_filterType);
            } else {
                ((ModelView)ModelView.this).d_dispMgr.d_dispFilter.registerFilter(this.d_filterType, this.d_showFilter);
            }
        }

        private void updateIcon() {
            if (this.isSelected()) {
                this.putValue("SmallIcon", this.d_visIcon);
            } else {
                this.putValue("SmallIcon", this.d_hiddenIcon);
            }
        }

        @Override
        protected void stateChanged() {
            PyroSim.getApp().beginWaitCursor();
            this.updateIcon();
            this.updateState();
            ModelView.this.getRenderComponent().repaint();
            PyroSim.getApp().endWaitCursor();
        }
    }

    private class ShowOriginAction
    extends BooleanAction {
        private static final long serialVersionUID = 2802752637431449227L;

        public ShowOriginAction(boolean bl) {
            super(Intl.intl("Show Origin"), bl);
        }

        @Override
        protected void stateChanged() {
            ModelView.this.updateOriginVisibility();
            ModelView.this.d_renderComp.repaint();
        }
    }

    public class EditSnapSize
    extends guiAction {
        private static final long serialVersionUID = -7765942993335129025L;

        public EditSnapSize() {
            super(Intl.intl("Set Sketch Grid Spacing") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditSnapToGridDlg editSnapToGridDlg = new EditSnapToGridDlg(Application.getApp().getActiveFrame(), ModelView.this.d_sketchGrid.getSpacing());
            if (editSnapToGridDlg.doModal() == 1) {
                ModelView.this.d_sketchGrid.setSpacing(editSnapToGridDlg.getSpacing());
                ModelView.this.d_renderComp.repaint();
            }
        }
    }

    private static class NavToolInfo {
        public final CursorTool tool;
        public final View.NavTool type;

        public NavToolInfo(CursorTool cursorTool, View.NavTool navTool) {
            this.tool = cursorTool;
            this.type = navTool;
            NAV_TOOLS.add(this);
        }
    }

    private static class FilterActionInfo {
        private final BooleanAction action;
        private final boolean initState;

        public FilterActionInfo(BooleanAction booleanAction) {
            this.action = booleanAction;
            this.initState = booleanAction.isSelected();
        }

        private void reset() {
            this.action.setSelected(this.initState);
        }

        public void setState(boolean bl) {
            this.action.setSelected(bl);
        }

        public boolean getState() {
            return this.action.isSelected();
        }
    }

    protected static class WorkingZConstraintGen
    implements IConstraintGen {
        protected WorkingZConstraintGen() {
        }

        @Override
        public ISnapConstraint getConstraint(IPyroTool iPyroTool) {
            double d = iPyroTool.getProps().get(DrawProps.LOCATION).getValue(Geometry.LU);
            Plane3d plane3d = new Plane3d(0.0, 0.0, 1.0, -d);
            return new PlanarConstraint(plane3d);
        }
    }

    protected static class OffsetConstraintGen
    implements IConstraintGen {
        protected OffsetConstraintGen() {
        }

        @Override
        public ISnapConstraint getConstraint(IPyroTool iPyroTool) {
            double d = iPyroTool.getProps().get(DrawProps.LOCATION).getValue(Geometry.LU);
            PlanarConstraint planarConstraint = new PlanarConstraint(new Plane3d(0.0, 0.0, 1.0, -d));
            return new OffsetPointConstraint(planarConstraint, new Vector3d(0.0, 0.0, d));
        }
    }

    private static enum PointToolConstraint {
        AUTO;

    }

    private static class GeomScenes {
        public final ModelScene scene = new ModelScene();
        public final ModelScene caps = new ModelScene();
        public final ModelScene patch = new ModelScene();
        public final ModelScene noclip = new ModelScene();
        public final ModelScene excludedNoClip = new ModelScene();

        private GeomScenes() {
        }

        public void setDrawProps(SceneRenderOptions sceneRenderOptions, SceneRenderOptions sceneRenderOptions2, SceneRenderOptions sceneRenderOptions3) {
            this.scene.setDrawProps(sceneRenderOptions);
            this.patch.setDrawProps(sceneRenderOptions2);
            this.caps.setDrawProps(sceneRenderOptions);
            this.noclip.setDrawProps(sceneRenderOptions3);
            this.excludedNoClip.setDrawProps(sceneRenderOptions3);
        }

        public Collection<ModelScene> getRenderScenes() {
            ArrayList<ModelScene> arrayList = new ArrayList<ModelScene>();
            this.getRenderScenes(arrayList);
            return arrayList;
        }

        public void getRenderScenes(Collection<? super ModelScene> collection) {
            collection.add(this.patch);
            collection.add(this.caps);
            collection.add(this.scene);
            collection.add(this.noclip);
            collection.add(this.excludedNoClip);
        }

        public Camera getCamera() {
            return this.scene.getCamera();
        }

        public void setCamera(Camera camera) {
            this.scene.setCamera(camera);
            this.caps.setCamera(camera.createCopyCam());
            this.patch.setCamera(camera.createCopyCam());
            this.noclip.setCamera(camera.createCopyCam());
            this.excludedNoClip.setCamera(camera.createCopyCam());
        }

        public void getBounds(BoundsCalculator boundsCalculator) {
            this.getBounds(boundsCalculator, true);
        }

        public void getBounds(BoundsCalculator boundsCalculator, boolean bl) {
            boundsCalculator.add(this.scene);
            boundsCalculator.add(this.caps);
            boundsCalculator.add(this.patch);
            boundsCalculator.add(this.noclip);
            if (bl) {
                boundsCalculator.add(this.excludedNoClip);
            }
        }
    }
}

