/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.util;

import java.awt.geom.Rectangle2D;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BGImageXform;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.image.Image;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredCollection;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Sets;
import pyrosim.legacy_2012_1.thunderheadeng.util.TypeFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.treeview.TVEntryPoint;
import pyrosim.legacy_2012_1.treeview.TVEntryPoints;
import pyrosim.legacy_2012_1.util.NamedSorter;

public class Util {
    public static void removeAllNotOfType(Collection<?> collection, Class<?> clazz) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj == null || clazz.isInstance(obj)) continue;
            iterator.remove();
        }
    }

    public static void removeNonNull(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) continue;
            iterator.remove();
        }
    }

    public static BGImageXform createDxfImageTransform(Image image, Rectangle2D rectangle2D, Unit unit, UnitDouble unitDouble) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        if (n == 0) {
            n = (int)rectangle2D.getWidth();
        }
        if (n2 == 0) {
            n2 = (int)rectangle2D.getHeight();
        }
        Point2d point2d = new Point2d(-rectangle2D.getMinX() / rectangle2D.getWidth() * (double)n, -rectangle2D.getMinY() / rectangle2D.getHeight() * (double)n2);
        return new BGImageXform(point2d, new Point3d(0.0, 0.0, unitDouble.getValue(SI.METER)), new Point2d(0.0, 0.0), new Point2d(n, 0.0), UnitDouble.convert(rectangle2D.getWidth(), unit, SI.METER), 0.0);
    }

    public static void assignFinalField(Object object, String string, Object object2) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = object.getClass().getField(string);
        field.setAccessible(true);
        field.set(object, object2);
        field.setAccessible(false);
    }

    public static <T> Collection<T> filter(Collection<?> collection, Class<T> clazz) {
        if (collection instanceof Set) {
            return Util.filter((Set)collection, clazz);
        }
        return new FilteredCollection<T>(collection, clazz);
    }

    public static <T> Set<T> filter(Set<?> set, Class<T> clazz) {
        return new FilteredSet<T>(set, clazz);
    }

    public static <T> Collection<T> filter(Collection<?> collection, Class<T> clazz, IObjectFilter<T> iObjectFilter) {
        if (collection instanceof Set) {
            return Util.filter((Set)collection, clazz, iObjectFilter);
        }
        return new FilteredCollection<T>(collection, clazz, iObjectFilter);
    }

    public static <T> Set<T> filter(Set<?> set, Class<T> clazz, IObjectFilter<T> iObjectFilter) {
        return new FilteredSet<T>(set, clazz, iObjectFilter);
    }

    public static <T extends IPyroObject> Collection<? extends T> getAllObjects(PyroMod pyroMod, Class<T> clazz, IObjectFilter<T> iObjectFilter, boolean bl) {
        Collection<T> collection;
        Composite composite = Util.getCategoryRoot(pyroMod, clazz);
        if (composite == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<T> collection2 = composite.flatten(clazz, iObjectFilter);
        if (bl && ExSpec.class.isAssignableFrom(clazz) && !(collection = Util.filter(Arrays.asList(ExSpecList.MIXFRAC_EXSPECS), clazz, iObjectFilter)).isEmpty()) {
            ArrayList<T> arrayList = new ArrayList<T>(collection2);
            arrayList.addAll(collection);
            collection2 = arrayList;
        }
        return collection2;
    }

    public static Composite getCategoryRoot(PyroMod pyroMod, Class<? extends IPyroObject> clazz) {
        for (IPyroObject iPyroObject : pyroMod.getMembers()) {
            if (!(iPyroObject instanceof Composite) || !((Composite)iPyroObject).getType().isAssignableFrom(clazz)) continue;
            return (Composite)iPyroObject;
        }
        return null;
    }

    public static String getCatName(IPyroObject iPyroObject) {
        return TVEntryPoints.ep(iPyroObject).getCategoryName();
    }

    public static String getName(IPyroObject iPyroObject) {
        TVEntryPoint<IPyroObject> tVEntryPoint = TVEntryPoints.ep(iPyroObject);
        return tVEntryPoint.getName(iPyroObject);
    }

    public static boolean canDelete(PyroMod pyroMod, Object object) {
        IPyroObject iPyroObject;
        if (object instanceof IPyroObject && (iPyroObject = ((IPyroObject)object).getParent()) != null) {
            return TVEntryPoints.ep(iPyroObject).canDelete(pyroMod, iPyroObject, object);
        }
        return false;
    }

    public static String validateName(PyroMod pyroMod, INamed iNamed, String string) throws Exception {
        Object DataT;
        if ((string = string.trim()).isEmpty()) {
            throw new Exception(Intl.intl("Empty names are not allowed."));
        }
        if (iNamed.getName().equals(string)) {
            return string;
        }
        TVEntryPoint<INamed> tVEntryPoint = TVEntryPoints.ep(iNamed);
        Object object = tVEntryPoint.getCategoryRoot(pyroMod, iNamed);
        if (object instanceof Composite && Util.isKeyedByName(pyroMod, object, iNamed) && (DataT = ((Composite)object).get(string)) != null) {
            String string2 = String.format(Intl.intl("The name, \"%s,\" is already in use."), string);
            throw new Exception(string2);
        }
        return string;
    }

    public static boolean isKeyedByName(PyroMod pyroMod, Object object) {
        if (object instanceof Composite) {
            return false;
        }
        Object object2 = TVEntryPoints.ep(object).getCategoryRoot(pyroMod, object);
        return object2 != null && TVEntryPoints.ep(object2).keysMembersByName(pyroMod, object2);
    }

    public static boolean isKeyedByName(PyroMod pyroMod, Object object, Object object2) {
        if (object2 instanceof Composite) {
            return false;
        }
        return object != null && TVEntryPoints.ep(object).keysMembersByName(pyroMod, object);
    }

    public static <T extends IPyroObject> List<T> sort(Composite<? extends T> composite) {
        return Util.sort(composite.flatten());
    }

    public static <T extends IPyroObject> List<T> sort(Collection<? extends T> collection) {
        ArrayList<? extends T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList, new NamedSorter());
        return arrayList;
    }

    public static <T> List<T> sort(Collection<? extends T> collection, Comparator<T> comparator) {
        ArrayList<? extends T> arrayList = new ArrayList<T>(collection);
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static <T> int indexOf(Collection<? extends T> collection, T t) {
        int n = 0;
        for (T t2 : collection) {
            if (t2 == t) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static <T> T[] matchPrimCount(IGeom iGeom, int n, T[] TArray, Class<T> clazz) {
        int n2 = iGeom.getNumPrims(n);
        if (TArray.length == n2) {
            return TArray;
        }
        assert (TArray.length == 1);
        Object[] objectArray = (Object[])Array.newInstance(clazz, n2);
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = TArray[0];
        }
        return objectArray;
    }

    public static boolean identityMapsEqual(Map<?, ?> map, Map<?, ?> map2) {
        if (map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object var4_4 = null;
            Object var5_5 = null;
            for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
                if (!entry.getKey().equals(entry2.getKey())) continue;
                var4_4 = entry2.getKey();
                var5_5 = entry2.getValue();
                break;
            }
            if (var4_4 == null) {
                return false;
            }
            if (theUtil.equal(entry.getValue(), var5_5)) continue;
            return false;
        }
        return true;
    }

    public static boolean identitySetsEqual(Set<?> set, Set<?> set2) {
        if (set.size() != set2.size()) {
            return false;
        }
        for (Object obj : set) {
            boolean bl = false;
            for (Object obj2 : set2) {
                if (!theUtil.equal(obj, obj2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public static boolean isExclusive(Collection<?> collection, Class<?> ... classArray) {
        if (classArray.length == 1) {
            return new FilteredCollection(collection, classArray[0]).isExclusive();
        }
        return new FilteredCollection<Object>(collection, Object.class, new TypeFilter(classArray)).isExclusive();
    }

    public static boolean isExclusive(Collection<?> collection, Class<?> clazz, IObjectFilter<?> iObjectFilter) {
        return new FilteredCollection(collection, clazz, iObjectFilter).isExclusive();
    }

    public static <T> Collection<T> filterExcluded(Collection<T> collection, Class<T> clazz, Set<?> set) {
        ExcludeFilter excludeFilter = new ExcludeFilter(set);
        return Util.filter(collection, clazz, excludeFilter);
    }

    public static class ExcludeFilter<T>
    implements IObjectFilter<T> {
        public final Set<?> toExclude;

        public ExcludeFilter(Object object) {
            this(Sets.fromArrayHS(object));
        }

        public ExcludeFilter(Set<?> set) {
            this.toExclude = set;
        }

        @Override
        public boolean shouldFilter(T t) {
            return this.toExclude.contains(t);
        }
    }
}

