/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import pyrosim.legacy_2012_1.util.ITransformer;
import pyrosim.legacy_2012_1.util.TransformIterator;

public class TransformedCollection<OType, TType>
extends AbstractCollection<TType> {
    private final Collection<OType> d_collection;
    private final ITransformer<OType, TType> d_transformer;
    private final ITransformer<TType, OType> d_invTransformer;
    private final Class<TType> d_transformedType;

    public TransformedCollection(Collection<OType> collection, ITransformer<OType, TType> iTransformer) {
        this(collection, iTransformer, null, null);
    }

    public TransformedCollection(Collection<OType> collection, ITransformer<OType, TType> iTransformer, ITransformer<TType, OType> iTransformer2, Class<TType> clazz) {
        this.d_collection = collection;
        this.d_transformer = iTransformer;
        this.d_invTransformer = iTransformer2;
        this.d_transformedType = clazz;
        assert (this.d_invTransformer == null || this.d_transformedType != null);
    }

    @Override
    public Iterator<TType> iterator() {
        return new TransformIterator<OType, TType>(this.d_collection.iterator(), this.d_transformer);
    }

    @Override
    public boolean add(TType TType) {
        if (this.d_invTransformer != null) {
            return this.d_collection.add(this.d_invTransformer.transform(TType));
        }
        return super.add(TType);
    }

    @Override
    public boolean remove(Object object) {
        if (this.d_invTransformer != null) {
            if (object == null) {
                return this.d_collection.remove(null);
            }
            if (this.d_transformedType.isInstance(object)) {
                return this.d_collection.remove(this.d_invTransformer.transform(object));
            }
            return false;
        }
        return super.remove(object);
    }

    @Override
    public boolean contains(Object object) {
        if (this.d_invTransformer != null) {
            if (object == null) {
                return this.d_collection.contains(null);
            }
            if (this.d_transformedType.isInstance(object)) {
                return this.d_collection.contains(this.d_invTransformer.transform(object));
            }
            return false;
        }
        return super.contains(object);
    }

    @Override
    public boolean isEmpty() {
        return this.d_collection.isEmpty();
    }

    @Override
    public int size() {
        return this.d_collection.size();
    }

    @Override
    public void clear() {
        this.d_collection.clear();
    }
}

