/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.util;

import java.util.Collection;
import java.util.HashSet;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IDOF;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class GeomUtil {
    public static IDOF getDOF(Collection<? extends IPyroGeomSrc> collection) {
        HashSet<IDOF> hashSet = new HashSet<IDOF>();
        for (IPyroGeomSrc iPyroGeomSrc : collection) {
            hashSet.add(iPyroGeomSrc.getGeom().getDOF());
        }
        return pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomUtil.groupDOFs(hashSet);
    }

    public static AABox getBounds(Collection<? extends IPyroGeomSrc> collection) {
        AABox aABox = new AABox();
        for (IPyroGeomSrc iPyroGeomSrc : collection) {
            iPyroGeomSrc.getGeom().getBoundingBox(aABox);
        }
        return aABox;
    }

    public static UnitAABox getUnitBounds(Collection<? extends IPyroGeomSrc> collection) {
        AABox aABox = GeomUtil.getBounds(collection);
        return new UnitAABox(aABox, Geometry.LU);
    }

    public static UnitPoint3D getCenter(Collection<? extends IPyroGeomSrc> collection) {
        Unit unit = Geometry.LU;
        AABox aABox = GeomUtil.getBounds(collection);
        Point3d point3d = aABox.getMin();
        Point3d point3d2 = aABox.getMax();
        point3d.add(point3d2);
        point3d.scale(0.5);
        return new UnitPoint3D(point3d, unit);
    }

    public static boolean isAligned(IDOF iDOF) {
        if (iDOF == IDOF.ALIGNED) {
            return true;
        }
        if (iDOF instanceof IDOF.CompositeDOF) {
            IDOF.CompositeDOF compositeDOF = (IDOF.CompositeDOF)iDOF;
            for (IDOF iDOF2 : compositeDOF.dofs) {
                if (!GeomUtil.isAligned(iDOF2)) continue;
                return true;
            }
        }
        return false;
    }
}

