/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.util;

import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Sets;

public class Filters {
    public static <T> IObjectFilter<T> acceptNone(T t) {
        return new AcceptNone(Sets.fromArrayHS(t));
    }

    public static <T> IObjectFilter<T> acceptNone(Set<T> set) {
        return new AcceptNone(set);
    }

    public static <T> IObjectFilter<T> acceptOnly(T t) {
        return new AcceptOnly(Sets.fromArrayHS(t));
    }

    public static <T> IObjectFilter<T> acceptOnly(Set<T> set) {
        return new AcceptOnly(set);
    }

    public static <T> IObjectFilter<T> invert(IObjectFilter<T> iObjectFilter) {
        if (iObjectFilter instanceof InvertFilter) {
            return ((InvertFilter)iObjectFilter).filter;
        }
        return new InvertFilter<T>(iObjectFilter);
    }

    public static <T> IObjectFilter<T> acceptAll() {
        return AcceptAllFilter.INSTANCE;
    }

    public static <T> IObjectFilter<T> merge(IObjectFilter<T> iObjectFilter, IObjectFilter<T> iObjectFilter2) {
        return Filters.merge(iObjectFilter, iObjectFilter2, Logic.ACCEPT_ALL);
    }

    public static <T> IObjectFilter<T> merge(IObjectFilter<T> iObjectFilter, IObjectFilter<T> iObjectFilter2, Logic logic) {
        if (iObjectFilter == iObjectFilter2) {
            return iObjectFilter;
        }
        if (iObjectFilter == null) {
            return iObjectFilter2;
        }
        if (iObjectFilter2 == null) {
            return iObjectFilter;
        }
        if (iObjectFilter instanceof AcceptAllFilter) {
            if (logic == Logic.ACCEPT_ALL) {
                return iObjectFilter2;
            }
            return iObjectFilter;
        }
        if (iObjectFilter2 instanceof AcceptAllFilter) {
            if (logic == Logic.ACCEPT_ALL) {
                return iObjectFilter;
            }
            return iObjectFilter2;
        }
        return new CompoundFilter<T>(iObjectFilter, iObjectFilter2, logic);
    }

    public static class CompoundFilter<T>
    implements IObjectFilter<T> {
        public final IObjectFilter<? super T> f1;
        public final IObjectFilter<? super T> f2;
        public final Logic logic;

        public CompoundFilter(IObjectFilter<? super T> iObjectFilter, IObjectFilter<? super T> iObjectFilter2) {
            this(iObjectFilter, iObjectFilter2, Logic.ACCEPT_ALL);
        }

        public CompoundFilter(IObjectFilter<? super T> iObjectFilter, IObjectFilter<? super T> iObjectFilter2, Logic logic) {
            this.f1 = iObjectFilter;
            this.f2 = iObjectFilter2;
            this.logic = logic;
        }

        @Override
        public boolean shouldFilter(T t) {
            switch (this.logic) {
                case ACCEPT_ALL: {
                    return this.f1.shouldFilter(t) || this.f2.shouldFilter(t);
                }
            }
            return this.f1.shouldFilter(t) && this.f2.shouldFilter(t);
        }
    }

    public static class InvertFilter<T>
    implements IObjectFilter<T> {
        public final IObjectFilter<T> filter;

        public InvertFilter(IObjectFilter<T> iObjectFilter) {
            this.filter = iObjectFilter;
        }

        @Override
        public boolean shouldFilter(T t) {
            return !this.filter.shouldFilter(t);
        }
    }

    public static class AcceptOnly<T>
    implements IObjectFilter<T> {
        public final Set<?> toInclude;

        public AcceptOnly(Set<?> set) {
            this.toInclude = set;
        }

        @Override
        public boolean shouldFilter(T t) {
            return !this.toInclude.contains(t);
        }
    }

    public static class AcceptNone<T>
    implements IObjectFilter<T> {
        public final Set<?> toExclude;

        public AcceptNone(Set<?> set) {
            this.toExclude = set;
        }

        @Override
        public boolean shouldFilter(T t) {
            return this.toExclude.contains(t);
        }
    }

    public static enum Logic {
        ACCEPT_ANY,
        ACCEPT_ALL;

    }
}

