/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.treeview;

import java.awt.Font;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import pyrosim.Intl;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.Floor;
import pyrosim.legacy_2012_1.domain.FloorManager;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.Hierarchy;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.SimParams;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.controls.ControlBridge;
import pyrosim.legacy_2012_1.domain.controls.ControlMgr;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.dependencies.DepUtil;
import pyrosim.legacy_2012_1.domain.dependencies.Dependency;
import pyrosim.legacy_2012_1.domain.devices.DeviceManager;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.measurers.Clock;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModelMgr;
import pyrosim.legacy_2012_1.domain.evac.Corr;
import pyrosim.legacy_2012_1.domain.evac.CorrList;
import pyrosim.legacy_2012_1.domain.evac.Door;
import pyrosim.legacy_2012_1.domain.evac.DoorList;
import pyrosim.legacy_2012_1.domain.evac.Entr;
import pyrosim.legacy_2012_1.domain.evac.EntrList;
import pyrosim.legacy_2012_1.domain.evac.Evac;
import pyrosim.legacy_2012_1.domain.evac.EvacList;
import pyrosim.legacy_2012_1.domain.evac.Evho;
import pyrosim.legacy_2012_1.domain.evac.EvhoList;
import pyrosim.legacy_2012_1.domain.evac.Evss;
import pyrosim.legacy_2012_1.domain.evac.EvssList;
import pyrosim.legacy_2012_1.domain.evac.Exit;
import pyrosim.legacy_2012_1.domain.evac.ExitList;
import pyrosim.legacy_2012_1.domain.evac.Pers;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.domain.geom.IHole;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.InitRegion;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.hvac.HvacComponent;
import pyrosim.legacy_2012_1.domain.hvac.HvacList;
import pyrosim.legacy_2012_1.domain.output.IMeasurementStat;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.output.IsosurfaceMgr;
import pyrosim.legacy_2012_1.domain.output.PlanarSlice;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.output.ProfList;
import pyrosim.legacy_2012_1.domain.output.ProfRec;
import pyrosim.legacy_2012_1.domain.output.Slice;
import pyrosim.legacy_2012_1.domain.output.SliceList;
import pyrosim.legacy_2012_1.domain.output.StatisticMgr;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.ParticleList;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.domain.tasks.AReplaceRefTask;
import pyrosim.legacy_2012_1.domain.tasks.AddTask;
import pyrosim.legacy_2012_1.domain.tasks.AutoRenameTask;
import pyrosim.legacy_2012_1.domain.tasks.ReorderObjectsTask;
import pyrosim.legacy_2012_1.domain.tasks.Tasks;
import pyrosim.legacy_2012_1.domain.zones.Leak;
import pyrosim.legacy_2012_1.domain.zones.Zone;
import pyrosim.legacy_2012_1.domain.zones.ZoneMgr;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ExtrudedPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.GeomGroup;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IProxyGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.WallGeom;
import pyrosim.legacy_2012_1.thunderheadeng.gui.DecoratedIcon;
import pyrosim.legacy_2012_1.thunderheadeng.util.AUndoableTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.treeview.TVEntryPoint;
import pyrosim.legacy_2012_1.util.Util;

public class TVEntryPoints {
    private static final Icon s_mgrIcon = PyroGuiUtil.loadPyroSimIcon("manager8.png", 8);
    private static final Map<Class, TVEntryPoint> s_entryPoints;
    private static final TVEntryPoint s_defEP;
    private static final ResultsNode RESULTS_NODE;

    public static <T> TVEntryPoint<T> ep(Class<T> clazz) {
        TVEntryPoint tVEntryPoint = s_entryPoints.get(clazz);
        if (tVEntryPoint == null) {
            tVEntryPoint = theUtil.findObjectForClass(s_entryPoints, clazz);
            if (tVEntryPoint == null) {
                tVEntryPoint = s_defEP;
            }
            s_entryPoints.put(clazz, tVEntryPoint);
        }
        return tVEntryPoint;
    }

    public static <T> TVEntryPoint<T> ep(T t) {
        if (t == null) {
            return null;
        }
        return TVEntryPoints.ep(t.getClass());
    }

    private static boolean isOwnParent(PyroMod pyroMod, Set<?> set, Composite composite) {
        for (IPyroObject iPyroObject = composite; iPyroObject != null; iPyroObject = iPyroObject.getParent()) {
            if (!set.contains(iPyroObject)) continue;
            return true;
        }
        return false;
    }

    private static boolean allOfType(Collection<?> collection, Class clazz) {
        for (Object obj : collection) {
            if (!(obj instanceof Composite ? !clazz.isAssignableFrom(((Composite)obj).getType()) : !clazz.isInstance(obj))) continue;
            return false;
        }
        return true;
    }

    private static Icon newMgrIcon(Icon icon) {
        return icon == null ? null : new DecoratedIcon(icon, s_mgrIcon, 3);
    }

    static /* synthetic */ Icon access$100(Icon icon) {
        return TVEntryPoints.newMgrIcon(icon);
    }

    static {
        s_defEP = new TVEntryPoint(Intl.intl("Object"));
        s_entryPoints = new HashMap<Class, TVEntryPoint>();
        s_entryPoints.put(PyroMod.class, new RootEP());
        s_entryPoints.put(Composite.class, new CompositeEP(null, false));
        s_entryPoints.put(MaterialManager.class, new MatlMgrEP());
        s_entryPoints.put(Material.class, new MatlEP());
        s_entryPoints.put(ReactionList.class, new ReacMgrEP());
        s_entryPoints.put(Reaction.class, new ReacEP());
        s_entryPoints.put(SurfaceManager.class, new SurfaceMgrEP());
        s_entryPoints.put(Surface.class, new SurfaceEP());
        s_entryPoints.put(DeviceManager.class, new DevcMgrEP());
        s_entryPoints.put(IDevice.class, new DevcEP());
        s_entryPoints.put(ControlMgr.class, new CtrlMgrEP());
        s_entryPoints.put(ControlBridge.class, new TVEntryPoint(Intl.intl("Control")));
        s_entryPoints.put(GridList.class, new GridMgrEP());
        s_entryPoints.put(Grid.class, new GridEP());
        s_entryPoints.put(ZoneMgr.class, new ZoneMgrEP());
        s_entryPoints.put(Zone.class, new ZoneEP());
        s_entryPoints.put(ModelComposite.class, new CompositeEP((Icon)PyroGuiUtil.loadPyroSimIcon("composite16_2.gif"), false));
        s_entryPoints.put(IModelObj.class, new ModelObjEP());
        s_entryPoints.put(SimParams.class, new SimParamsEP());
        s_entryPoints.put(Plot3d.class, new Plot3dEP());
        s_entryPoints.put(Leak.class, new LeakEP());
        s_entryPoints.put(ExSpecList.class, new ExSpecMgrEP());
        s_entryPoints.put(ExSpec.class, new TVEntryPoint(Intl.intl("Extra Species")));
        s_entryPoints.put(HvacList.class, new CompositeEP(null, true));
        s_entryPoints.put(HvacComponent.class, new TVEntryPoint(Intl.intl("HVAC Component")));
        s_entryPoints.put(ParticleList.class, new CompositeEP(null, true));
        s_entryPoints.put(Particle.class, new TVEntryPoint(Intl.intl("Particle")));
        s_entryPoints.put(HeatLinkModelMgr.class, new CompositeEP(null, true));
        s_entryPoints.put(HeatLinkModel.class, new TVEntryPoint(Intl.intl("Heat Detector Model")));
        s_entryPoints.put(SmokeLinkModelMgr.class, new CompositeEP(null, true));
        s_entryPoints.put(SmokeLinkModel.class, new TVEntryPoint(Intl.intl("Smoke Detector Model")));
        s_entryPoints.put(SprinklerLinkModelMgr.class, new CompositeEP(null, true));
        s_entryPoints.put(SprinklerLinkModel.class, new TVEntryPoint(Intl.intl("Sprinkler Link Model")));
        s_entryPoints.put(SprayModelMgr.class, new CompositeEP(null, true));
        s_entryPoints.put(SprayModel.class, new TVEntryPoint(Intl.intl("Spray Model")));
        s_entryPoints.put(CorrList.class, new CompositeEP(null, true));
        s_entryPoints.put(Corr.class, new TVEntryPoint(Intl.intl("Corridor")));
        s_entryPoints.put(DoorList.class, new CompositeEP(null, true));
        s_entryPoints.put(Door.class, new TVEntryPoint(Intl.intl("Door")));
        s_entryPoints.put(EntrList.class, new CompositeEP(null, true));
        s_entryPoints.put(Entr.class, new TVEntryPoint(Intl.intl("ENTR")));
        s_entryPoints.put(EvacList.class, new CompositeEP(null, true));
        s_entryPoints.put(Evac.class, new TVEntryPoint(Intl.intl("EVAC")));
        s_entryPoints.put(EvhoList.class, new CompositeEP(null, true));
        s_entryPoints.put(Evho.class, new TVEntryPoint(Intl.intl("EVHO")));
        s_entryPoints.put(EvssList.class, new CompositeEP(null, true));
        s_entryPoints.put(Evss.class, new TVEntryPoint(Intl.intl("EVSS")));
        s_entryPoints.put(ExitList.class, new CompositeEP(null, true));
        s_entryPoints.put(Exit.class, new TVEntryPoint(Intl.intl("Exit")));
        s_entryPoints.put(PersList.class, new CompositeEP(null, true));
        s_entryPoints.put(Pers.class, new TVEntryPoint(Intl.intl("PERS")));
        s_entryPoints.put(ResultsNode.class, new ResultsNodeEP());
        s_entryPoints.put(StatisticMgr.class, new StatMgrEP());
        s_entryPoints.put(IMeasurementStat.class, new StatisticEP());
        s_entryPoints.put(SliceList.class, new SliceMgrEP());
        s_entryPoints.put(Slice.class, new SliceEP());
        s_entryPoints.put(IsosurfaceMgr.class, new IsofMgrEP());
        s_entryPoints.put(Isosurface.class, new IsofEP());
        s_entryPoints.put(ProfList.class, new CompositeEP(null, true));
        s_entryPoints.put(ProfRec.class, new TVEntryPoint(Intl.intl("Material Profile")));
        s_entryPoints.put(FloorManager.class, new CompositeEP(null, true));
        s_entryPoints.put(Floor.class, new TVEntryPoint(Intl.intl("Floor")));
        RESULTS_NODE = new ResultsNode();
    }

    private static class ResultsNode {
        private ResultsNode() {
        }
    }

    public static class SliceEP
    extends TVEntryPoint<Slice> {
        private static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("slices16.png");

        public SliceEP() {
            super(ICON, Intl.intl("Slice"));
        }

        @Override
        public String getName(Slice slice) {
            if (slice instanceof PlanarSlice) {
                PlanarSlice planarSlice = (PlanarSlice)slice;
                String string = "";
                switch (planarSlice.getPlane()) {
                    case 0: {
                        string = Intl.intl("X");
                        break;
                    }
                    case 1: {
                        string = Intl.intl("Y");
                        break;
                    }
                    case 2: {
                        string = Intl.intl("Z");
                    }
                }
                string = string + " = " + Global.format(planarSlice.getLocation());
                string = string + ": " + planarSlice.getQuantity().getDescription();
                return string;
            }
            return super.getName(slice);
        }
    }

    public static class SliceMgrEP
    extends CompositeEP<SliceList> {
        private static final Icon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("slices16.png"));

        public SliceMgrEP() {
            super(ICON, false);
        }

        @Override
        public Object getTreeviewParent(PyroMod pyroMod, SliceList sliceList) {
            if (sliceList == pyroMod.getSlcfList()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(pyroMod, sliceList);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, SliceList sliceList, Object object) {
            for (Slice slice : pyroMod.getSlcfList().flatten()) {
                if (!slice.equals(object)) continue;
                return slice;
            }
            return null;
        }
    }

    public static class StatisticEP
    extends TVEntryPoint<IMeasurementStat> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("stat16.png");

        public StatisticEP() {
            super(ICON, Intl.intl("Statistic"));
        }
    }

    public static class StatMgrEP
    extends CompositeEP<StatisticMgr> {
        public static final Icon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("stat16.png"));

        public StatMgrEP() {
            super(ICON, true);
        }

        @Override
        public Object getTreeviewParent(PyroMod pyroMod, StatisticMgr statisticMgr) {
            if (statisticMgr == pyroMod.getMsrStatMgr()) {
                return RESULTS_NODE;
            }
            return super.getTreeviewParent(pyroMod, statisticMgr);
        }
    }

    public static class ResultsNodeEP
    extends TVEntryPoint<ResultsNode> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("composite16_2.gif");

        public ResultsNodeEP() {
            super(ICON, Intl.intl("Results"));
        }

        @Override
        public boolean isLeaf(PyroMod pyroMod, ResultsNode resultsNode) {
            return false;
        }

        @Override
        public boolean objectInModel(PyroMod pyroMod, ResultsNode resultsNode) {
            return true;
        }

        @Override
        public Object getTreeviewParent(PyroMod pyroMod, ResultsNode resultsNode) {
            return pyroMod;
        }

        @Override
        public boolean canRename(PyroMod pyroMod, ResultsNode resultsNode) {
            return false;
        }

        @Override
        public String getName(ResultsNode resultsNode) {
            return Intl.intl("Results");
        }

        @Override
        public Collection<?> getTreeviewChildren(PyroMod pyroMod, ResultsNode resultsNode) {
            return Arrays.asList(pyroMod.getMsrStatMgr(), pyroMod.getSlcfList());
        }
    }

    public static class ModelObjEP
    extends TVEntryPoint<IModelObj> {
        public static final Icon VENT_ICON = PyroGuiUtil.loadPyroSimIcon("vent16.gif");
        public static final Icon SLAB_ICON = PyroGuiUtil.loadPyroSimIcon("triangle.png");
        public static final Icon WALL_ICON = PyroGuiUtil.loadPyroSimIcon("block16_2.gif");
        public static final Icon INIT_REGION_ICON = PyroGuiUtil.loadPyroSimIcon("init16.png");
        public static final Icon PART_CLOUD_ICON = PyroGuiUtil.loadPyroSimIcon("partCloud16.gif");
        public static final Icon ABLOCK_ICON = PyroGuiUtil.loadPyroSimIcon("cube16.png");
        public static final Icon AHOLE_ICON = PyroGuiUtil.loadPyroSimIcon("hole16.gif");
        public static final Icon HOLE_ICON = PyroGuiUtil.loadPyroSimIcon("wall_hole16.png");
        public static final Icon GEOMGROUP_ICON = PyroGuiUtil.loadPyroSimIcon("geomgroup16.png");

        public ModelObjEP() {
            super(Intl.intl("Geometric Object"));
        }

        @Override
        public Icon getIcon(PyroMod pyroMod, IModelObj iModelObj) {
            IGeom iGeom = iModelObj.getGeom();
            while (iGeom instanceof IProxyGeom) {
                iGeom = ((IProxyGeom)iGeom).getBase();
            }
            if (iGeom instanceof AABoxGeom && iModelObj instanceof IObstruction) {
                return ABLOCK_ICON;
            }
            if (iGeom instanceof AABoxGeom && iModelObj instanceof IHole) {
                return AHOLE_ICON;
            }
            if (iGeom instanceof WallGeom && iModelObj instanceof IObstruction) {
                return WALL_ICON;
            }
            if (iGeom instanceof WallGeom && iModelObj instanceof IHole) {
                return HOLE_ICON;
            }
            if (iGeom instanceof ExtrudedPoly) {
                return SLAB_ICON;
            }
            if (iGeom instanceof GeomGroup) {
                return GEOMGROUP_ICON;
            }
            if (iModelObj instanceof InitRegion) {
                return INIT_REGION_ICON;
            }
            if (iModelObj instanceof PartCloud) {
                return PART_CLOUD_ICON;
            }
            if (iModelObj instanceof Vent) {
                return VENT_ICON;
            }
            return super.getIcon(pyroMod, iModelObj);
        }

        @Override
        public boolean mayBeReferenced(PyroMod pyroMod) {
            return false;
        }

        @Override
        public Object getCategoryRoot(PyroMod pyroMod, IModelObj iModelObj) {
            return pyroMod.getObstructions();
        }
    }

    public static class CompositeEP<T extends Composite>
    extends TVEntryPoint<T> {
        private final boolean d_isKeyedByName;

        public CompositeEP(Icon icon, boolean bl) {
            super(icon, Intl.intl("Group"));
            this.d_isKeyedByName = bl;
        }

        @Override
        public boolean isVisible(PyroMod pyroMod, T t) {
            if (((Composite)t).getMembers().isEmpty()) {
                return true;
            }
            for (IPyroObject iPyroObject : ((Composite)t).getMembers()) {
                if (!TVEntryPoints.ep(iPyroObject).isVisible(pyroMod, iPyroObject)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean keysMembersByName(PyroMod pyroMod, T t) {
            return this.d_isKeyedByName;
        }

        @Override
        public boolean isContainer(PyroMod pyroMod, T t, Object object) {
            return object instanceof IPyroObject && ((Composite)t).accept((IPyroObject)object);
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, T t, Object object) {
            return true;
        }

        @Override
        public Object getConflict(PyroMod pyroMod, T t, Object object) {
            if (!(object instanceof Composite) && this.keysMembersByName(pyroMod, t)) {
                return ((Composite)t).get(Util.getName((IPyroObject)object));
            }
            return null;
        }

        @Override
        public Task paste(PyroMod pyroMod, T t, Object object, Object object2, TVEntryPoint.ConflictResolution conflictResolution, DepSnapshot depSnapshot) {
            assert (object instanceof IPyroObject && ((Composite)t).accept((IPyroObject)object));
            assert (object2 == null || object2 instanceof IPyroObject && ((Composite)t).accept((IPyroObject)object2));
            if (object2 == null) {
                return new AddTask(t, new IPyroObject[]{(IPyroObject)object});
            }
            CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(pyroMod);
            if (conflictResolution == TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING) {
                for (Dependency dependency : depSnapshot.getDependents((IPyroObject)object2)) {
                    compositeTask.addTask(DepUtil.getReplacementTask(depSnapshot, dependency.source, (IPyroObject)object2, (IPyroObject)object));
                }
                compositeTask.addTask(Tasks.delete((IPyroObject)object2));
            } else {
                Object object3 = TVEntryPoints.ep(object).getCategoryRoot(pyroMod, object);
                assert (object3 instanceof Composite);
                if (object instanceof INamed) {
                    compositeTask.addTask(new AutoRenameTask((Composite)object3, new INamed[]{(INamed)object}));
                }
            }
            compositeTask.addTask(new AddTask(t, new IPyroObject[]{(IPyroObject)object}));
            return compositeTask;
        }

        @Override
        public boolean canDrop(PyroMod pyroMod, T t, Set<?> set, Object object) {
            if (!(object instanceof Composite)) {
                return false;
            }
            IPyroObject iPyroObject = Hierarchy.getCategoryRoot((Composite)object);
            if (iPyroObject == null) {
                return false;
            }
            return Hierarchy.isDescendent(iPyroObject, t) && !TVEntryPoints.isOwnParent(pyroMod, set, t);
        }

        @Override
        public void drop(PyroMod pyroMod, T t, int n, Collection<?> collection) {
            ReorderObjectsTask reorderObjectsTask = new ReorderObjectsTask((Composite<? extends IPyroObject>)t, n, (Collection<? extends IPyroObject>)Util.filter(collection, IPyroObject.class));
            pyroMod.getTaskManager().exec(reorderObjectsTask, Intl.intl("Reorder Objects"));
        }
    }

    public static class ZoneEP
    extends TVEntryPoint<Zone> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("zones16.png");

        public ZoneEP() {
            super(ICON, Intl.intl("Zone"));
        }

        @Override
        public boolean canRename(PyroMod pyroMod, Zone zone) {
            return !zone.isOuter();
        }

        @Override
        public Font getBaseFont(PyroMod pyroMod, Zone zone) {
            return zone.isOuter() ? s_bold : super.getBaseFont(pyroMod, zone);
        }
    }

    public static class ZoneMgrEP
    extends CompositeEP<ZoneMgr> {
        public static final Icon ICON = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("zones16.png"));

        public ZoneMgrEP() {
            super(ICON, true);
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, ZoneMgr zoneMgr, Object object) {
            return object instanceof Zone && !((Zone)object).isOuter();
        }
    }

    public static class GridEP
    extends TVEntryPoint<Grid> {
        private static Icon ICON = PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif");
        private static Icon ICON_EVAC = PyroGuiUtil.loadPyroSimIcon("3dgrid_evac16.gif");

        public GridEP() {
            super(Intl.intl("Mesh"));
        }

        @Override
        public Icon getIcon(PyroMod pyroMod, Grid grid) {
            return grid.getEvacuation() ? ICON_EVAC : ICON;
        }
    }

    public static class GridMgrEP
    extends CompositeEP<GridList> {
        public static final Icon ICON_GRID = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("3dgrid_smooth16.gif"));

        public GridMgrEP() {
            super(ICON_GRID, true);
        }
    }

    public static class CtrlMgrEP
    extends CompositeEP<ControlMgr> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("or16.png");

        public CtrlMgrEP() {
            super(ICON, true);
        }
    }

    public static class ExSpecMgrEP
    extends CompositeEP<ExSpecList> {
        public ExSpecMgrEP() {
            super(null, true);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, ExSpecList exSpecList, Object object) {
            if (((ExSpec)object).isMixFracOnly()) {
                return ((ExSpec)object).getMFSpec().spec;
            }
            return super.getConflict(pyroMod, exSpecList, object);
        }
    }

    public static class DevcEP
    extends TVEntryPoint<IDevice> {
        public DevcEP() {
            super(Intl.intl("Device"));
        }

        @Override
        public Icon getIcon(PyroMod pyroMod, IDevice iDevice) {
            return iDevice.getIcon();
        }
    }

    public static class DevcMgrEP
    extends CompositeEP<DeviceManager> {
        public static final Icon ICON_DEVICE = PyroGuiUtil.loadPyroSimIcon("sprk3.gif");

        public DevcMgrEP() {
            super(ICON_DEVICE, true);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, DeviceManager deviceManager, Object object) {
            if (Clock.isClock((IPyroObject)object)) {
                return Clock.INSTANCE;
            }
            return super.getConflict(pyroMod, deviceManager, object);
        }
    }

    public static class SurfaceEP
    extends TVEntryPoint<Surface> {
        public static final Icon DEF_ICON = PyroGuiUtil.loadPyroSimIcon("surf2a.gif");

        public SurfaceEP() {
            super(Intl.intl("Surface"));
        }

        @Override
        public Font getBaseFont(PyroMod pyroMod, Surface surface) {
            if (surface == pyroMod.getSimParams().getMisc().getSurfDefault()) {
                return s_bold;
            }
            return super.getBaseFont(pyroMod, surface);
        }

        @Override
        public boolean canRename(PyroMod pyroMod, Surface surface) {
            return !surface.isPredefined();
        }

        @Override
        public Icon getIcon(PyroMod pyroMod, Surface surface) {
            Icon icon = surface.getIcon(DEF_ICON.getIconWidth(), DEF_ICON.getIconHeight());
            return icon == null ? DEF_ICON : icon;
        }
    }

    public static class SurfaceMgrEP
    extends CompositeEP<SurfaceManager> {
        public static final Icon ICON_SURFDB = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("surf2a.gif"));

        public SurfaceMgrEP() {
            super(ICON_SURFDB, true);
        }

        @Override
        public boolean canDelete(PyroMod pyroMod, SurfaceManager surfaceManager, Object object) {
            return !(object instanceof Surface) || !((Surface)object).isPredefined();
        }
    }

    public static class LeakEP
    extends TVEntryPoint<Leak> {
        public LeakEP() {
            super(Intl.intl("Zone Leak"));
        }

        @Override
        public String getName(Leak leak) {
            return String.format(Intl.intl("Leak: %s -> %s (%s)"), leak.zone1.getName(), leak.zone2.getName(), Global.format(leak.area));
        }
    }

    public static class IsofEP
    extends TVEntryPoint<Isosurface> {
        public IsofEP() {
            super(Intl.intl("Isosurface"));
        }

        @Override
        public String getName(Isosurface isosurface) {
            return isosurface.getQuantity().getDescription();
        }
    }

    public static class IsofMgrEP
    extends CompositeEP<IsosurfaceMgr> {
        public IsofMgrEP() {
            super(null, false);
        }

        @Override
        public Object getConflict(PyroMod pyroMod, IsosurfaceMgr isosurfaceMgr, Object object) {
            for (Isosurface isosurface : pyroMod.getIsofList().flatten()) {
                if (!isosurface.equals(object)) continue;
                return isosurface;
            }
            return null;
        }
    }

    public static class MatlEP
    extends TVEntryPoint<Material> {
        public static final Icon ICON = PyroGuiUtil.loadPyroSimIcon("surf.png");

        public MatlEP() {
            super(ICON, Intl.intl("Material"));
        }
    }

    public static class MatlMgrEP
    extends CompositeEP<MaterialManager> {
        public static final Icon ICON_MATLDB = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("surf.png"));

        public MatlMgrEP() {
            super(ICON_MATLDB, true);
        }
    }

    public static class Plot3dEP
    extends TVEntryPoint<Plot3d> {
        public Plot3dEP() {
            super(Intl.intl("Plot3d Output"));
        }

        @Override
        public String getName(Plot3d plot3d) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod pyroMod, Plot3d plot3d) {
            return pyroMod.getPlot3d() == plot3d;
        }

        public Task paste(final PyroMod pyroMod, Composite<? extends IPyroObject> composite, final Plot3d plot3d, final Plot3d plot3d2, TVEntryPoint.ConflictResolution conflictResolution) {
            return new AUndoableTask(){

                @Override
                public void run() {
                    pyroMod.setPL3DRecord(plot3d);
                }

                @Override
                public void undo() {
                    pyroMod.setPL3DRecord(plot3d2);
                }
            };
        }
    }

    public static class SimParamsEP
    extends TVEntryPoint<SimParams> {
        public SimParamsEP() {
            super(Intl.intl("Simulation Parameters"));
        }

        @Override
        public String getName(SimParams simParams) {
            return this.getCategoryName();
        }

        @Override
        public boolean objectInModel(PyroMod pyroMod, SimParams simParams) {
            return pyroMod.getSimParams() == simParams;
        }

        public Task paste(final PyroMod pyroMod, Composite<? extends IPyroObject> composite, final SimParams simParams, final SimParams simParams2, TVEntryPoint.ConflictResolution conflictResolution) {
            return new AUndoableTask(){

                @Override
                public void run() {
                    pyroMod.setSimParams(simParams);
                }

                @Override
                public void undo() {
                    pyroMod.setSimParams(simParams2);
                }
            };
        }
    }

    public static class ReacEP
    extends TVEntryPoint<Reaction> {
        private static Icon ICON = PyroGuiUtil.loadPyroSimIcon("reaction16.gif");

        public ReacEP() {
            super(ICON, Intl.intl("Reaction"));
        }

        @Override
        public Font getBaseFont(PyroMod pyroMod, Reaction reaction) {
            if (reaction.isActive()) {
                return s_bold;
            }
            return super.getBaseFont(pyroMod, reaction);
        }

        @Override
        public String getDisplayName(Reaction reaction) {
            String string = super.getDisplayName(reaction);
            if (reaction.isActive()) {
                string = String.format(Intl.intl("%s (Active)"), string);
            }
            return string;
        }
    }

    public static class ReacMgrEP
    extends CompositeEP<ReactionList> {
        public static final Icon ICON_REACT = TVEntryPoints.access$100(PyroGuiUtil.loadPyroSimIcon("reaction16.gif"));

        public ReacMgrEP() {
            super(ICON_REACT, true);
        }
    }

    public static class RootEP
    extends TVEntryPoint<PyroMod> {
        public RootEP() {
            super(Intl.intl("PyroSim Model"));
        }

        @Override
        public String getName(PyroMod pyroMod) {
            return "";
        }

        @Override
        public boolean objectInModel(PyroMod pyroMod, PyroMod pyroMod2) {
            return pyroMod2 == pyroMod;
        }

        @Override
        public boolean isLeaf(PyroMod pyroMod, PyroMod pyroMod2) {
            return false;
        }

        @Override
        public Collection<?> getTreeviewChildren(PyroMod pyroMod, PyroMod pyroMod2) {
            return Arrays.asList(pyroMod2.getGridManager(), pyroMod2.getZoneMgr(), pyroMod2.getReactions(), pyroMod2.getMaterialMgr(), pyroMod2.getSurfaceMgr(), pyroMod2.getDevices(), pyroMod2.getControls(), RESULTS_NODE, pyroMod2.getObstructions());
        }

        @Override
        public boolean isContainer(PyroMod pyroMod, PyroMod pyroMod2, Object object) {
            if (!(object instanceof IPyroObject)) {
                return false;
            }
            for (IPyroObject iPyroObject : pyroMod2.getMembers()) {
                if (!iPyroObject.getClass().isInstance(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getConflict(PyroMod pyroMod, PyroMod pyroMod2, Object object) {
            return object instanceof Plot3d || object instanceof SimParams;
        }

        @Override
        public Task paste(final PyroMod pyroMod, PyroMod pyroMod2, Object object, Object object2, TVEntryPoint.ConflictResolution conflictResolution, DepSnapshot depSnapshot) {
            assert (conflictResolution == TVEntryPoint.ConflictResolution.OVERWRITE_EXISTING);
            if (object instanceof Plot3d) {
                return new AReplaceRefTask<Plot3d>(object2, object){

                    @Override
                    protected void set(Plot3d plot3d) {
                        pyroMod.setPL3DRecord(plot3d);
                    }
                };
            }
            if (object instanceof SimParams) {
                return new AReplaceRefTask<SimParams>(object2, object){

                    @Override
                    protected void set(SimParams simParams) {
                        pyroMod.setSimParams(simParams);
                    }
                };
            }
            return super.paste(pyroMod, pyroMod2, object, object2, conflictResolution, depSnapshot);
        }
    }
}

