/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.treeview;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.legacy_2012_1.PyroMod;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroGeomSrc;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.tasks.SetNameTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.EmptyTask;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import pyrosim.legacy_2012_1.treeview.TVEntryPoints;
import pyrosim.legacy_2012_1.util.Util;

public class TVEntryPoint<T> {
    protected static final Font s_plain = new Font("Sans Serif", 0, 11);
    protected static final Font s_bold = new Font("Sans Serif", 1, 11);
    protected static final Font s_italic = new Font("Sans Serif", 2, 11);
    protected static final Font s_italicBold = s_italic.deriveFont(1);
    private final Icon d_icon;
    private final String d_categoryName;

    public TVEntryPoint(String string) {
        this(null, string);
    }

    public TVEntryPoint(Icon icon, String string) {
        this.d_icon = icon;
        this.d_categoryName = string;
    }

    public String getCategoryName() {
        return this.d_categoryName;
    }

    public String getName(T t) {
        if (t instanceof INamed) {
            return ((INamed)t).getName();
        }
        return t.toString();
    }

    public String getDisplayName(T t) {
        return this.getName(t);
    }

    public void setName(PyroMod pyroMod, T t, String string) {
        if (t instanceof INamed) {
            try {
                string = Util.validateName(pyroMod, (INamed)t, string);
                SetNameTask setNameTask = new SetNameTask((INamed)t, string);
                pyroMod.getTaskManager().exec(setNameTask, Intl.intl("Rename"));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(PyroSim.getApp().getActiveFrame(), exception.getLocalizedMessage(), Intl.intl("Invalid Name"), 0);
            }
        }
    }

    public boolean objectInModel(PyroMod pyroMod, T t) {
        if (!(t instanceof IPyroObject)) {
            return false;
        }
        return ((IPyroObject)t).getDomain() == pyroMod;
    }

    public Object getTreeviewParent(PyroMod pyroMod, T t) {
        if (t instanceof IPyroObject) {
            return ((IPyroObject)t).getParent();
        }
        return null;
    }

    public boolean canRename(PyroMod pyroMod, T t) {
        return t instanceof INamed;
    }

    public Icon getIcon(PyroMod pyroMod, T t) {
        return this.d_icon;
    }

    public Font getBaseFont(PyroMod pyroMod, T t) {
        return s_plain;
    }

    public Font getFont(PyroMod pyroMod, T t) {
        Font font = this.getBaseFont(pyroMod, t);
        if (!this.isEnabled(pyroMod, t)) {
            HashMap hashMap = new HashMap(font.getAttributes());
            hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            font = font.deriveFont(hashMap);
        }
        return font;
    }

    public boolean isVisible(PyroMod pyroMod, T t) {
        if (t instanceof IPyroGeomSrc) {
            return ((IPyroGeomSrc)t).isVisible();
        }
        return true;
    }

    public boolean isEnabled(PyroMod pyroMod, T t) {
        if (t instanceof IPyroObject) {
            return ((IPyroObject)t).isEnabled();
        }
        return true;
    }

    public boolean isLeaf(PyroMod pyroMod, T t) {
        if (t instanceof IPyroObject) {
            return ((IPyroObject)t).getMembers().isEmpty();
        }
        return false;
    }

    public Object getPasteLocation(PyroMod pyroMod, T t) {
        return this.getCategoryRoot(pyroMod, t);
    }

    public boolean showInTree(PyroMod pyroMod, T t) {
        T t2 = t;
        Object object = this.getTreeviewParent(pyroMod, t);
        if (object != null) {
            TVEntryPoint<Object> tVEntryPoint = TVEntryPoints.ep(object);
            if (object == pyroMod) {
                return tVEntryPoint.getTreeviewChildren(pyroMod, object).contains(t2);
            }
            return tVEntryPoint.showInTree(pyroMod, object);
        }
        return false;
    }

    public boolean mayBeReferenced(PyroMod pyroMod) {
        return true;
    }

    public Object getCategoryRoot(PyroMod pyroMod, T t) {
        for (IPyroObject iPyroObject : pyroMod.getMembers()) {
            if (!TVEntryPoints.ep(iPyroObject).isContainer(pyroMod, iPyroObject, t)) continue;
            return iPyroObject;
        }
        return null;
    }

    public Collection<?> getTreeviewChildren(PyroMod pyroMod, T t) {
        if (t instanceof IPyroObject) {
            return ((IPyroObject)t).getMembers();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isContainer(PyroMod pyroMod, T t, Object object) {
        return false;
    }

    public boolean keysMembersByName(PyroMod pyroMod, T t) {
        return false;
    }

    public boolean canDelete(PyroMod pyroMod, T t, Object object) {
        return false;
    }

    public boolean preserveIndexOnDelete(PyroMod pyroMod, T t, Object object) {
        return true;
    }

    public Object getConflict(PyroMod pyroMod, T t, Object object) {
        return null;
    }

    public Task paste(PyroMod pyroMod, T t, Object object, Object object2, ConflictResolution conflictResolution, DepSnapshot depSnapshot) {
        return EmptyTask.INSTANCE;
    }

    public boolean canDrop(PyroMod pyroMod, T t, Set<?> set, Object object) {
        return false;
    }

    public void drop(PyroMod pyroMod, T t, int n, Collection<?> collection) {
    }

    public static enum ConflictResolution {
        OVERWRITE_EXISTING,
        RENAME_NEW;

    }
}

