/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Disposable;

public class theUtil {
    private static final float[] R = new float[]{0.4f, 0.6f};
    private static final float[] G = new float[]{0.4f, 0.6f};
    private static final float[] B = new float[]{0.5f, 0.8f};
    private static final Random DEF_RAND = new Random();

    public static boolean equal(Object object, Object object2) {
        return object == null ? object2 == null : object == object2 || object.equals(object2);
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static int hashCode(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public static int hashCode(boolean bl) {
        return bl ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public static <T> Collection<T> cast(Collection<?> collection, Collection<T> collection2, Class<T> clazz) {
        for (Object obj : collection) {
            collection2.add(clazz.cast(obj));
        }
        return collection2;
    }

    public static Vector3d projectToPlane(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d(vector3d2);
        double d = vector3d.dot(vector3d3);
        Vector3d vector3d4 = new Vector3d(vector3d);
        vector3d4.scale(-d);
        vector3d3.add(vector3d4);
        return vector3d3;
    }

    public static double angleBetweenNPIToPPI(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        double d = vector3d2.angle(vector3d3);
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d2, vector3d3);
        double d2 = vector3d4.dot(vector3d);
        if (d2 >= 0.0) {
            return d;
        }
        return -d;
    }

    public static double angleBetween0To2PI(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        double d = theUtil.angleBetweenNPIToPPI(vector3d, vector3d2, vector3d3);
        if (d >= 0.0) {
            return d;
        }
        return Math.PI * 2 + d;
    }

    public static UnitDouble roundAngle(UnitDouble unitDouble, UnitDouble unitDouble2, Unit unit) {
        double d = unitDouble.getValue(SI.RADIAN);
        double d2 = unitDouble2.getValue(SI.RADIAN);
        long l = Math.round(Math.PI * 2 / d2);
        long l2 = Math.round(Math.abs(d) / d2) % l;
        if (d < 0.0) {
            l2 = -l2;
        }
        double d3 = unitDouble2.getValueNoUnit() * (double)l2;
        double d4 = UnitDouble.convert(d3, unitDouble2.getUnit(), unit);
        return new UnitDouble(d4, unit);
    }

    public static Point3d p4dTo3d(Point4d point4d) {
        double d = 1.0 / point4d.w;
        return new Point3d(point4d.x * d, point4d.y * d, point4d.z * d);
    }

    public static void acquire(Disposable disposable) {
        if (disposable != null) {
            disposable.acquire();
        }
    }

    public static void acquire(Disposable[] disposableArray) {
        if (disposableArray != null) {
            for (int i = 0; i < disposableArray.length; ++i) {
                if (disposableArray[i] == null) continue;
                disposableArray[i].acquire();
            }
        }
    }

    public static <T> void acquire(Collection<T> collection) {
        if (collection != null) {
            for (T t : collection) {
                theUtil.acquire(t);
            }
        }
    }

    public static void acquire(Object object) {
        if (object instanceof Disposable) {
            ((Disposable)object).acquire();
        }
    }

    public static void acquire(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Disposable)) continue;
                ((Disposable)objectArray[i]).acquire();
            }
        }
    }

    public static void release(Disposable disposable) {
        if (disposable != null) {
            disposable.release();
        }
    }

    public static void release(Disposable[] disposableArray) {
        if (disposableArray != null) {
            for (int i = 0; i < disposableArray.length; ++i) {
                if (disposableArray[i] == null) continue;
                disposableArray[i].release();
            }
        }
    }

    public static <T> void release(Collection<T> collection) {
        if (collection != null) {
            for (T t : collection) {
                theUtil.release(t);
            }
        }
    }

    public static void release(Object object) {
        if (object instanceof Disposable) {
            ((Disposable)object).release();
        }
    }

    public static void release(Object[] objectArray) {
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Disposable)) continue;
                ((Disposable)objectArray[i]).release();
            }
        }
    }

    public static String getFileExtension(File file) {
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(".");
        if (n >= 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return "";
    }

    public static int binarySearch(double[] dArray, double d, DoubleComparator doubleComparator) {
        return theUtil.binarySearch(dArray, d, 0, dArray.length - 1, doubleComparator);
    }

    private static int binarySearch(double[] dArray, double d, int n, int n2, DoubleComparator doubleComparator) {
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            double d2 = dArray[n3];
            int n4 = doubleComparator.compare(d2, d);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static <T> int binarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        return theUtil.binarySearch(list, t, 0, list.size() - 1, comparator);
    }

    public static <T> int binarySearch(List<? extends T> list, T t, int n, int n2, Comparator<? super T> comparator) {
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            T t2 = list.get(n3);
            int n4 = comparator.compare(t2, t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static <T extends Number> int[] toIntArray(Collection<T> collection) {
        if (collection == null) {
            return new int[0];
        }
        int[] nArray = new int[collection.size()];
        int n = 0;
        for (Number number : collection) {
            nArray[n++] = number.intValue();
        }
        return nArray;
    }

    public static Integer[] toIntArray(int ... nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public static <T extends Number> double[] toDoubleArray(Collection<T> collection) {
        if (collection == null) {
            return new double[0];
        }
        double[] dArray = new double[collection.size()];
        int n = 0;
        for (Number number : collection) {
            dArray[n++] = number.doubleValue();
        }
        return dArray;
    }

    public static <T extends Number> double[] toDoubleArray(Double[] doubleArray) {
        return theUtil.toDoubleArray(Arrays.asList(doubleArray));
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        assert (clazz != null);
        if (collection == null) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, collection.size());
        return collection.toArray(objectArray);
    }

    public static <T> T serialCopy(T t) throws IOException, NotSerializableException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(t);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return (T)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            assert (false);
            throw new IOException(classNotFoundException.getLocalizedMessage());
        }
    }

    public static double doubleResolution(double d) {
        long l = Double.doubleToLongBits(d);
        return Double.longBitsToDouble(++l) - d;
    }

    public static float floatResolution(float f) {
        int n = Float.floatToIntBits(f);
        return Float.intBitsToFloat(++n) - f;
    }

    public static int[] randomList(int n, int n2) {
        return theUtil.randomList(n, n2, new Random());
    }

    public static int[] randomList(int n, int n2, Random random) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n2 - n + 1);
        for (int i = n; i <= n2; ++i) {
            arrayList.add(i);
        }
        Collections.shuffle(arrayList, random);
        return theUtil.toIntArray(arrayList);
    }

    public static <T> List<T> randomize(Collection<? extends T> collection) {
        return theUtil.randomize(collection, new Random());
    }

    public static <T> List<T> randomize(Collection<? extends T> collection, Random random) {
        ArrayList<? extends T> arrayList = new ArrayList<T>(collection);
        Collections.shuffle(arrayList, random);
        return arrayList;
    }

    public static <T> Collection<T> sort(Comparator<T> comparator, T ... TArray) {
        return theUtil.sort(comparator, Arrays.asList(TArray));
    }

    public static <T> Collection<T> sort(Comparator<T> comparator, Collection<? extends T> collection) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        treeSet.addAll(collection);
        return treeSet;
    }

    public static <T> T findObjectForClass(Map<Class, T> map, Class clazz) {
        if (clazz == null) {
            return null;
        }
        T t = map.get(clazz);
        if (t != null) {
            return t;
        }
        t = theUtil.findObjectForClass(map, clazz.getSuperclass());
        if (t != null) {
            return t;
        }
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            t = theUtil.findObjectForClass(map, clazz2);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T> Collection<T> findObjectsForClass(Map<Class, T> map, Class clazz, Collection<T> collection) {
        for (Map.Entry<Class, T> entry : map.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            collection.add(entry.getValue());
        }
        return collection;
    }

    public static <T> Collection<T> findObjectsForLowerClass(Map<Class, T> map, Class clazz, Collection<T> collection) {
        for (Map.Entry<Class, T> entry : map.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey())) continue;
            collection.add(entry.getValue());
        }
        return collection;
    }

    public static <T> T[] append(Class<T> clazz, T[] TArray, T ... TArray2) {
        int n;
        Object[] objectArray = (Object[])Array.newInstance(clazz, TArray.length + TArray2.length);
        for (n = 0; n < TArray.length; ++n) {
            objectArray[n] = TArray[n];
        }
        while (n < objectArray.length) {
            objectArray[n] = TArray2[n - TArray.length];
            ++n;
        }
        return objectArray;
    }

    public static int[] append(int[] nArray, int ... nArray2) {
        int n;
        int[] nArray3 = new int[nArray.length + nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = nArray[n];
        }
        while (n < nArray3.length) {
            nArray3[n] = nArray2[n - nArray.length];
            ++n;
        }
        return nArray3;
    }

    public static Color newRandomColor() {
        return theUtil.newRandomColor(DEF_RAND, R[0], R[1], G[0], G[1], B[0], B[1]);
    }

    public static Color newRandomColor(float f, float f2, float f3, float f4, float f5, float f6) {
        return theUtil.newRandomColor(DEF_RAND, f, f2, f3, f4, f5, f6);
    }

    public static Color newRandomColor(Random random, float f, float f2, float f3, float f4, float f5, float f6) {
        return new Color(theUtil.randomFloat(random, f, f2), theUtil.randomFloat(random, f3, f4), theUtil.randomFloat(random, f5, f6));
    }

    private static float randomFloat(Random random, float f, float f2) {
        float f3 = f2 - f;
        return random.nextFloat() * f3 + f;
    }

    public static final boolean le(double d, double d2, double d3) {
        return d - d2 <= d3;
    }

    public static final boolean le0(double d, double d2) {
        return d <= d2;
    }

    public static final boolean ge(double d, double d2, double d3) {
        return d - d2 >= -d3;
    }

    public static final boolean ge0(double d, double d2) {
        return d >= -d2;
    }

    public static final boolean lt(double d, double d2, double d3) {
        return d - d2 < -d3;
    }

    public static final boolean lt0(double d, double d2) {
        return d < -d2;
    }

    public static final boolean gt(double d, double d2, double d3) {
        return d - d2 > d3;
    }

    public static final boolean gt0(double d, double d2) {
        return d > d2;
    }

    public static final boolean eq(double d, double d2, double d3) {
        return Math.abs(d - d2) <= d3;
    }

    public static final boolean eq0(double d, double d2) {
        return Math.abs(d) <= d2;
    }

    public static int compare(double d, double d2, double d3) {
        if (Math.abs(d - d2) <= d3) {
            return 0;
        }
        if (d > d2) {
            return 1;
        }
        return -1;
    }

    public static <T> boolean containsEquiv(T t, T ... TArray) {
        for (T t2 : TArray) {
            if (!t2.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T t, T ... TArray) {
        for (T t2 : TArray) {
            if (t2 != t) continue;
            return true;
        }
        return false;
    }

    public static byte toCCb(float f) {
        return (byte)(f * 255.0f);
    }

    public static float toCCf(byte by) {
        int n = 0xFF & by;
        return (float)n / 255.0f;
    }

    public static long randomSeed(Random random) {
        double d = -9.223372036854776E18 + random.nextDouble() * 1.8446744073709552E19;
        return (long)d;
    }

    public static <T> List<? extends T> toList(Iterable<? extends T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        return (List)theUtil.toCollection(new ArrayList(), iterable);
    }

    public static <T> Set<? extends T> toSet(Iterable<? extends T> iterable) {
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        return (Set)theUtil.toCollection(new HashSet(), iterable);
    }

    public static <T> Collection<? extends T> toCollection(Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        return theUtil.toCollection(new ArrayList(), iterable);
    }

    private static <T> Collection<? extends T> toCollection(Collection<T> collection, Iterable<? extends T> iterable) {
        for (T t : iterable) {
            collection.add(t);
        }
        return collection;
    }

    public static double lerp(double d, double d2, double d3) {
        return (d2 - d) * d3 + d;
    }

    public static void assignFinalField(Object object, String string, Object object2) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = object.getClass().getDeclaredField(string);
        boolean bl = field.isAccessible();
        field.setAccessible(true);
        field.set(object, object2);
        if (!bl) {
            field.setAccessible(false);
        }
    }

    public static interface DoubleComparator {
        public int compare(double var1, double var3);
    }
}

