/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import pyrosim.legacy_2012_1.thunderheadeng.util.Events;
import pyrosim.legacy_2012_1.thunderheadeng.util.IEventObserver;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Sets;

public class EventsTest
extends TestCase {
    private final A a1 = new A();
    private final A a2 = new A();
    private final AA aa1 = new AA();
    private final AA aa2 = new AA();
    private final AB ab1 = new AB();
    private final AB ab2 = new AB();
    private final B b1 = new B();
    private final B b2 = new B();
    private final BA ba1 = new BA();
    private final BA ba2 = new BA();
    private final BB bb1 = new BB();
    private final BB bb2 = new BB();
    private final Object EVT1 = new Object();
    private final Object EVT2 = new Object();
    private final Object EVT3 = new Object();
    private Events events;

    protected void setUp() throws Exception {
        this.events = new Events();
    }

    public void testCompositeRecords() {
        final IdentityHashSet<Object> identityHashSet = Sets.fromArrayIHS(this.a1, this.a2, this.aa1, this.ab1, this.ab2, this.b1, this.bb1, this.bb2);
        this.events.addObserver(new IEventObserver(){

            @Override
            public void update(Events events) {
                Assert.assertFalse((boolean)events.getEvents(BA.class, new Class[0]).isModified());
                Assert.assertTrue((boolean)events.getEvents(Object.class, new Class[0]).isModified());
                Assert.assertEquals((int)8, (int)events.getEvents(Object.class, new Class[0]).getAddedObjs().size());
                Assert.assertTrue((boolean)events.getEvents(Object.class, new Class[0]).getAddedObjs().contains(EventsTest.this.ab1));
                Assert.assertTrue((boolean)events.getEvents(Object.class, new Class[0]).getAddedObjs().contains(EventsTest.this.a1));
                Assert.assertFalse((boolean)events.getEvents(Object.class, new Class[0]).getAddedObjs().contains(EventsTest.this.ba1));
                Assert.assertTrue((boolean)events.getEvents(A.class, new Class[0]).isModified());
                Assert.assertEquals((int)5, (int)events.getEvents(A.class, new Class[0]).getAddedObjs().size());
                Assert.assertTrue((boolean)events.getEvents(A.class, new Class[0]).getAddedObjs().contains(EventsTest.this.a1));
                Assert.assertTrue((boolean)events.getEvents(A.class, new Class[0]).getAddedObjs().contains(EventsTest.this.a2));
                Assert.assertTrue((boolean)events.getEvents(A.class, new Class[0]).getAddedObjs().contains(EventsTest.this.aa1));
                Assert.assertTrue((boolean)events.getEvents(A.class, new Class[0]).getAddedObjs().contains(EventsTest.this.ab1));
                Assert.assertTrue((boolean)events.getEvents(A.class, new Class[0]).getAddedObjs().contains(EventsTest.this.ab2));
                Assert.assertFalse((boolean)events.getEvents(A.class, new Class[0]).getAddedObjs().contains(EventsTest.this.b1));
                Assert.assertFalse((boolean)events.getEvents(A.class, new Class[0]).getAddedObjs().contains(EventsTest.this.bb1));
                Assert.assertFalse((boolean)events.getEvents(A.class, new Class[0]).getAddedObjs().contains(EventsTest.this.ba2));
                Assert.assertTrue((boolean)events.getEvents(B.class, new Class[0]).isModified());
                Assert.assertTrue((boolean)events.getEvents(BB.class, new Class[0]).isModified());
                Assert.assertEquals((int)2, (int)events.getEvents(BB.class, new Class[0]).getAddedObjs().size());
                Assert.assertTrue((boolean)events.getEvents(BB.class, new Class[0]).getAddedObjs().contains(EventsTest.this.bb1));
                Assert.assertTrue((boolean)events.getEvents(BB.class, new Class[0]).getAddedObjs().contains(EventsTest.this.bb2));
                IdentityHashSet identityHashSet2 = new IdentityHashSet();
                for (Object object : events.getEvents(Object.class, new Class[0]).getAddedObjs()) {
                    identityHashSet2.add(object);
                }
                Assert.assertEquals((Object)identityHashSet, identityHashSet2);
            }
        });
        this.events.pause();
        for (Object e : identityHashSet) {
            this.events.added(e);
        }
        this.events.resume();
    }

    private static class BB
    extends B {
        private BB() {
        }
    }

    private static class BA
    extends B {
        private BA() {
        }
    }

    private static class AB
    extends A {
        private AB() {
        }
    }

    private static class AA
    extends A {
        private AA() {
        }
    }

    private static class B {
        private B() {
        }
    }

    private static class A {
        private A() {
        }
    }
}

