/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UncUtil {
    public static boolean isShared(String string) throws IOException {
        return UncUtil.isShared(string, UncUtil.buildSharedMap());
    }

    public static boolean isShared(String string, Map<String, String> map) {
        Set<String> set;
        Iterator<String> iterator;
        if (!string.contains("\\")) {
            string = string + "\\";
        }
        if ((iterator = (set = map.keySet()).iterator()).hasNext()) {
            String string2 = iterator.next();
            if (string.startsWith(string2)) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public static boolean isInAdminShare(String string) throws IOException {
        return UncUtil.isInAdminShare(string, UncUtil.buildSharedMap());
    }

    public static boolean isInAdminShare(String string, Map<String, String> map) {
        Set<String> set = map.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList, new LengthSorter());
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = map.get(arrayList.get(i));
            if (!string.startsWith((String)arrayList.get(i))) continue;
            return string2.contains("$");
        }
        return false;
    }

    public static String convertToUnc(String string) throws IOException {
        return UncUtil.convertToUnc(string, UncUtil.buildSharedMap());
    }

    public static String convertToUnc(String string, Map<String, String> map) {
        String string2;
        String string3;
        int n;
        if (!string.contains("\\")) {
            string = string + "\\";
        }
        Set<String> set = map.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList, new LengthSorter());
        for (n = 0; n < arrayList.size(); ++n) {
            string3 = (String)arrayList.get(n);
            string2 = map.get(string3);
            if (!string.startsWith(string3) || string2.contains("$")) continue;
            string = string.replace(string3, string2);
            return string;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            string3 = (String)arrayList.get(n);
            string2 = map.get(string3);
            if (!string.startsWith(string3)) continue;
            string = string.replace(string3, string2);
            return string;
        }
        return string;
    }

    public static Map<String, String> buildSharedMap() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = UncUtil.getHostname();
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec("net share");
        InputStream inputStream = process.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string2 = null;
        while (null != (string2 = bufferedReader.readLine())) {
            object4 = string2.split("\\s+");
            if (((String[])object4).length < 2) continue;
            object3 = object4[0];
            if (!((String)object3).endsWith("\\")) {
                object3 = (String)object3 + "\\";
            }
            if (!((String)(object2 = object4[1])).contains(":")) continue;
            if (!((String)object2).endsWith("\\")) {
                object2 = (String)object2 + "\\";
            }
            object = String.format("\\\\%s\\%s", string, object3);
            hashMap.put((String)object2, (String)object);
        }
        object4 = runtime.exec("net use");
        object3 = ((Process)object4).getInputStream();
        object2 = new InputStreamReader((InputStream)object3);
        object = new BufferedReader((Reader)object2);
        string2 = null;
        while (null != (string2 = ((BufferedReader)object).readLine())) {
            String[] stringArray;
            if (string2.equals("\\s") || (stringArray = string2.split("\\s+")).length <= 1 || !stringArray[1].contains(":")) continue;
            if (!stringArray[2].endsWith("\\")) {
                hashMap.put(stringArray[1] + "\\", stringArray[2] + "\\");
                continue;
            }
            hashMap.put(stringArray[1] + "\\", stringArray[2]);
        }
        return hashMap;
    }

    private static String getHostname() throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostName();
        return string;
    }

    public static void main(String[] stringArray) {
        String string = "C:\\Users\\spare\\Desktop\\MyGreatStuff\\woot.text";
        try {
            if (UncUtil.isShared(string)) {
                System.out.println("This folder is shared! Lucky you.");
            } else {
                System.out.println("This folder isn't shared.");
            }
            if (UncUtil.isInAdminShare(string)) {
                System.out.println("Oops. This requires admin access. Are you famous enough?");
            } else {
                System.out.println("This folder is shared with everyone; you're good to go!");
            }
            String string2 = UncUtil.convertToUnc(string);
            if (string2.equals(string)) {
                System.out.println("The conversion didn't work. Boo.");
            } else {
                System.out.printf("Wowzers! You converted %s to UNC. It now says: %s", string, string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static class LengthSorter
    implements Comparator<Object> {
        private LengthSorter() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null && object2 != null) {
                return -1;
            }
            if (object != null && object2 == null) {
                return 1;
            }
            return object.toString().compareToIgnoreCase(object2.toString());
        }
    }
}

