/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Observable;
import java.util.Stack;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.util.Task;
import thunderheadeng.gui.Application;

public class TaskManager
extends Observable {
    private final Stack<DescribedTask> d_undo = new Stack();
    private final Stack<DescribedTask> d_redo = new Stack();

    public String describeUndo() {
        return this.d_undo.isEmpty() || this.d_undo.peek().desc == null ? Intl.intl("Undo") : String.format(Intl.intl("Undo %s"), this.d_undo.peek().desc);
    }

    public String describeRedo() {
        return this.d_redo.isEmpty() || this.d_redo.peek().desc == null ? Intl.intl("Redo") : String.format(Intl.intl("Redo %s"), this.d_redo.peek().desc);
    }

    public void clearHistory() {
        this.d_undo.clear();
        this.d_redo.clear();
    }

    public void clearRedoHistory() {
        this.d_redo.clear();
    }

    public void clearUndoHistory() {
        this.d_undo.clear();
    }

    public void exec(Task task, String string) {
        this.exec(new DescribedTask(task, string), false);
    }

    private void exec(DescribedTask describedTask, boolean bl) {
        if (!bl) {
            this.d_redo.clear();
        }
        if (describedTask.task.canUndo()) {
            this.d_undo.push(describedTask);
        } else {
            this.d_undo.clear();
        }
        switch (describedTask.task.getEst()) {
            case 0: {
                this.runShort(describedTask.task);
                break;
            }
            case 1: {
                this.runMed(describedTask.task);
                break;
            }
            case 2: {
                this.runLong(describedTask.task);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    private void runShort(Task task) {
        task.run();
    }

    private void runMed(Task task) {
        Application.getApp().beginWaitCursor();
        task.run();
        Application.getApp().endWaitCursor();
    }

    private void runLong(Task task) {
        task.run();
    }

    private void undoShort(Task task) {
        task.undo();
    }

    private void undoMed(Task task) {
        Application.getApp().beginWaitCursor();
        task.undo();
        Application.getApp().endWaitCursor();
    }

    private void undoLong(Task task) {
        task.undo();
    }

    public boolean canUndo() {
        return !this.d_undo.empty();
    }

    public void undo() {
        assert (this.canUndo());
        DescribedTask describedTask = this.d_undo.pop();
        assert (describedTask.task.canUndo());
        this.d_redo.push(describedTask);
        switch (describedTask.task.getEst()) {
            case 0: {
                this.undoShort(describedTask.task);
                break;
            }
            case 1: {
                this.undoMed(describedTask.task);
                break;
            }
            case 2: {
                this.undoLong(describedTask.task);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public boolean canRedo() {
        return !this.d_redo.empty();
    }

    public void redo() {
        assert (this.canRedo());
        DescribedTask describedTask = this.d_redo.pop();
        this.exec(describedTask, true);
    }

    private static class DescribedTask {
        public final Task task;
        public final String desc;

        public DescribedTask(Task task, String string) {
            this.task = task;
            this.desc = string;
        }
    }
}

