/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftValue> hash = new HashMap<K, SoftValue>();
    private final ReferenceQueue queue = new ReferenceQueue();

    @Override
    public V get(Object object) {
        V v = null;
        SoftReference softReference = this.hash.get(object);
        if (softReference != null && (v = (V)softReference.get()) == null) {
            this.hash.remove(object);
        }
        return v;
    }

    private void processQueue() {
        SoftValue softValue;
        while ((softValue = (SoftValue)this.queue.poll()) != null) {
            this.hash.remove(softValue.key);
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public V put(K k, V v) {
        this.processQueue();
        this.hash.put(k, new SoftValue(v, k, this.queue));
        return v;
    }

    @Override
    public V remove(Object object) {
        this.processQueue();
        this.hash.remove(object);
        return null;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class SoftValue
    extends SoftReference {
        private final Object key;

        private SoftValue(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.key = object2;
        }
    }
}

