/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util.Queue;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import pyrosim.legacy_2012_1.thunderheadeng.util.Queue.FixEnumImpl;
import pyrosim.legacy_2012_1.thunderheadeng.util.Queue.QNodeImpl;
import pyrosim.legacy_2012_1.thunderheadeng.util.Queue.Queue;

public class QImpl
implements Queue {
    protected int num_elem = 0;
    protected QNodeImpl head_node;
    protected QNodeImpl tail_node;
    private int max_size;

    public QImpl() {
        this(Integer.MAX_VALUE);
    }

    public QImpl(int n) {
        this.max_size = n;
        this.head_node = null;
        this.tail_node = null;
    }

    public void setMaxSize(int n) {
        this.max_size = n;
    }

    public int getMaxSize() {
        return this.max_size;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("----" + this.num_elem + " elements in Queue-----\n");
        System.out.println("----" + this.num_elem + " elements in Queue-----\n");
        Enumeration enumeration = this.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(n++ + ": " + enumeration.nextElement() + "\n");
        }
        stringBuffer.append("--------End of Queue-------\n");
        return stringBuffer.toString();
    }

    @Override
    public synchronized Object lastElement() throws NoSuchElementException {
        if (this.tail_node == null) {
            throw new NoSuchElementException();
        }
        return this.tail_node.elem;
    }

    @Override
    public synchronized Object firstElement() throws NoSuchElementException {
        if (this.head_node == null) {
            throw new NoSuchElementException();
        }
        return this.head_node.elem;
    }

    @Override
    public synchronized void insertFirst(Object object) {
        if (this.head_node == null) {
            this.head_node = this.tail_node = new QNodeImpl(object);
        } else {
            QNodeImpl qNodeImpl;
            this.head_node.prev = qNodeImpl = new QNodeImpl(object, null, this.head_node);
            this.head_node = qNodeImpl;
        }
        ++this.num_elem;
        while (this.num_elem > this.max_size) {
            this.removeLast();
        }
    }

    @Override
    public synchronized void insertLast(Object object) {
        if (this.head_node == null) {
            this.head_node = this.tail_node = new QNodeImpl(object);
        } else {
            QNodeImpl qNodeImpl;
            this.tail_node.next = qNodeImpl = new QNodeImpl(object, this.tail_node, null);
            this.tail_node = qNodeImpl;
        }
        ++this.num_elem;
        while (this.num_elem > this.max_size) {
            this.removeFirst();
        }
    }

    @Override
    public synchronized Object removeFirst() throws NoSuchElementException {
        if (this.head_node == null) {
            throw new NoSuchElementException();
        }
        Object object = this.head_node.elem;
        --this.num_elem;
        if (this.head_node == this.tail_node) {
            this.tail_node = null;
            this.head_node = null;
        } else {
            QNodeImpl qNodeImpl = this.head_node.next;
            qNodeImpl.prev = null;
            this.head_node = qNodeImpl;
        }
        return object;
    }

    @Override
    public synchronized Object removeLast() throws NoSuchElementException {
        if (this.head_node == null) {
            throw new NoSuchElementException();
        }
        Object object = this.tail_node.elem;
        --this.num_elem;
        if (this.head_node == this.tail_node) {
            this.tail_node = null;
            this.head_node = null;
        } else {
            QNodeImpl qNodeImpl = this.tail_node.prev;
            qNodeImpl.next = null;
            this.tail_node = qNodeImpl;
        }
        return object;
    }

    @Override
    public synchronized int size() {
        return this.num_elem;
    }

    @Override
    public synchronized Enumeration elements() {
        int n = this.num_elem;
        FixEnumImpl fixEnumImpl = new FixEnumImpl(n);
        QNodeImpl qNodeImpl = this.head_node;
        for (int i = 0; i < n; ++i) {
            fixEnumImpl.addMember(qNodeImpl.elem);
            qNodeImpl = qNodeImpl.next;
        }
        return fixEnumImpl;
    }

    @Override
    public void clear() {
        this.num_elem = 0;
        this.head_node = null;
        this.tail_node = null;
    }

    @Override
    public synchronized Object clone() {
        QImpl qImpl = new QImpl();
        int n = this.num_elem;
        QNodeImpl qNodeImpl = this.head_node;
        for (int i = 0; i < n; ++i) {
            qImpl.insertLast(qNodeImpl.elem);
            qNodeImpl = qNodeImpl.next;
        }
        return qImpl;
    }
}

