/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObservable;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObserver;

public class ObservableProxy
implements IObservable {
    private final IObservable d_owner;
    private boolean d_changed;
    private int d_pauseCounter;
    private List<Object> d_observers;

    public ObservableProxy(IObservable iObservable) {
        this.d_owner = iObservable;
        this.d_pauseCounter = 0;
        this.d_changed = false;
        this.d_observers = null;
    }

    @Override
    public synchronized void addObserver(IObserver iObserver, boolean bl) {
        Object object;
        Object object2 = object = bl ? new WeakReference<IObserver>(iObserver) : iObserver;
        if (this.d_observers == null) {
            this.d_observers = new ArrayList<Object>(5);
        }
        this.d_observers.add(object);
    }

    @Override
    public synchronized void deleteObserver(IObserver iObserver) {
        if (this.d_observers != null) {
            Iterator<Object> iterator = this.d_observers.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof WeakReference) {
                    WeakReference weakReference = (WeakReference)object;
                    Object t = weakReference.get();
                    if (t != null && t != iObserver) continue;
                    iterator.remove();
                    break;
                }
                if (object != iObserver) continue;
                iterator.remove();
                break;
            }
            if (this.d_observers.isEmpty()) {
                this.d_observers = null;
            }
        }
    }

    public synchronized int countObservers() {
        return this.d_observers.size();
    }

    private synchronized void fireNotification(Object object) {
        if (this.d_observers != null) {
            Object[] objectArray;
            for (Object object2 : objectArray = this.d_observers.toArray(new Object[this.d_observers.size()])) {
                if (object2 instanceof WeakReference) {
                    WeakReference weakReference = (WeakReference)object2;
                    IObserver iObserver = (IObserver)weakReference.get();
                    if (iObserver == null) continue;
                    iObserver.update(this.d_owner, object);
                    continue;
                }
                ((IObserver)object2).update(this.d_owner, object);
            }
        }
    }

    public void pause() {
        ++this.d_pauseCounter;
    }

    public boolean resume() {
        --this.d_pauseCounter;
        assert (this.d_pauseCounter >= 0);
        return this.tryFireNotification(null);
    }

    protected boolean tryFireNotification() {
        return this.tryFireNotification(null);
    }

    protected boolean tryFireNotification(Object object) {
        if (this.d_pauseCounter == 0 && this.d_changed) {
            this.fireNotification(object);
            this.d_changed = false;
            return true;
        }
        return false;
    }

    public void setChanged(boolean bl) {
        this.d_changed = bl;
        this.tryFireNotification();
    }
}

