/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.IHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.JavaHasher;

public class ListSet<T>
extends AbstractSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IHasher<T> d_hasher;
    private final List<T> d_elements;

    public ListSet() {
        this(JavaHasher.INSTANCE);
    }

    public ListSet(int n) {
        this(n, JavaHasher.INSTANCE);
    }

    public ListSet(T ... TArray) {
        this((IHasher<T>)JavaHasher.INSTANCE, TArray);
    }

    public ListSet(Collection<? extends T> collection) {
        this((IHasher<? extends T>)JavaHasher.INSTANCE, collection);
    }

    public ListSet(IHasher<T> iHasher) {
        this.d_elements = new ArrayList<T>();
        this.d_hasher = iHasher;
    }

    public ListSet(int n, IHasher<T> iHasher) {
        this.d_elements = new ArrayList<T>(n);
        this.d_hasher = iHasher;
    }

    public ListSet(IHasher<T> iHasher, T ... TArray) {
        this.d_elements = Arrays.asList(TArray);
        this.d_hasher = iHasher;
    }

    public ListSet(IHasher<T> iHasher, Collection<? extends T> collection) {
        this.d_elements = new ArrayList<T>(collection);
        this.d_hasher = iHasher;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_hasher.getClass().equals(IdentityHasher.class)) {
            this.d_hasher = IdentityHasher.INSTANCE;
        } else if (this.d_hasher.getClass().equals(JavaHasher.class)) {
            this.d_hasher = JavaHasher.INSTANCE;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (this.size() != set.size()) {
            return false;
        }
        for (T t : this.d_elements) {
            boolean bl = false;
            for (Object e : set) {
                if (!this.d_hasher.equal(t, e)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (T t : this.d_elements) {
            n += this.d_hasher.hash(t);
        }
        return n;
    }

    @Override
    public boolean add(T t) {
        if (!this.contains(t)) {
            return this.d_elements.add(t);
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        for (int i = 0; i < this.d_elements.size(); ++i) {
            T t = this.d_elements.get(i);
            if (!this.d_hasher.equal(t, object)) continue;
            this.d_elements.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        for (T t : this.d_elements) {
            if (!this.d_hasher.equal(t, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.d_elements.clear();
    }

    @Override
    public Object[] toArray() {
        return this.d_elements.toArray();
    }

    @Override
    public <T2> T2[] toArray(T2[] T2Array) {
        return this.d_elements.toArray(T2Array);
    }

    @Override
    public Iterator<T> iterator() {
        return this.d_elements.iterator();
    }

    @Override
    public int size() {
        return this.d_elements.size();
    }
}

