/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Random;
import junit.framework.TestCase;
import pyrosim.legacy_2012_1.thunderheadeng.util.Global;

public class GlobalTest
extends TestCase {
    public void testFormat0() {
        String string = Global.format(0.0);
        GlobalTest.assertEquals((String)"0.0", (String)string);
    }

    public void testFormat1() {
        System.out.println(Global.format(1.0));
        System.out.println(Global.format(10.0));
        System.out.println(Global.format(100.0));
        System.out.println(Global.format(1000.0));
        System.out.println(Global.format(10000.0));
        System.out.println(Global.format(100000.0));
        System.out.println(Global.format(1000000.0));
        System.out.println(Global.format(1.0E7));
        System.out.println();
        System.out.println(Global.format(1.0));
        System.out.println(Global.format(0.1));
        System.out.println(Global.format(0.01));
        System.out.println(Global.format(0.001));
        System.out.println(Global.format(1.0E-4));
        System.out.println(Global.format(1.0E-5));
        System.out.println(Global.format(1.0E-6));
        System.out.println(Global.format(1.0E-7));
    }

    public void testFormat2() {
        System.out.println(Global.format(2.0));
        System.out.println(Global.format(20.0));
        System.out.println(Global.format(200.0));
        System.out.println(Global.format(2000.0));
        System.out.println(Global.format(20000.0));
        System.out.println(Global.format(200000.0));
        System.out.println(Global.format(2000000.0));
        System.out.println(Global.format(2.0E7));
        System.out.println();
        System.out.println(Global.format(2.0));
        System.out.println(Global.format(0.2));
        System.out.println(Global.format(0.02));
        System.out.println(Global.format(0.002));
        System.out.println(Global.format(2.0E-4));
        System.out.println(Global.format(2.0E-5));
        System.out.println(Global.format(2.0E-6));
        System.out.println(Global.format(2.0E-7));
    }

    public void testFormat6() {
        System.out.println(Global.format(2.0E-6));
        System.out.println(Global.format(2.1E-6));
        System.out.println(Global.format(2.2E-6));
        System.out.println(Global.format(2.3E-6));
        System.out.println(Global.format(3.0E-6));
        System.out.println(Global.format(4.0E-6));
        System.out.println(Global.format(5.0E-6));
        System.out.println(Global.format(6.0E-6));
    }

    public void test_fixedWidthRoundingError() {
        String string = Global.formatFixedWidth(99.999, 5);
        GlobalTest.assertEquals((String)"100.0", (String)string);
        string = Global.formatSci(9.99E15, 6);
        GlobalTest.assertEquals((String)"1.0E16", (String)string);
    }

    public void test_negativeZero() {
        String string = Global.formatFixedWidth(-0.0, 5);
        GlobalTest.assertEquals((String)"  0.0", (String)string);
        string = Global.format(-0.0);
        GlobalTest.assertEquals((String)"0.0", (String)string);
    }

    private void evalValue(double d, int n, String string) {
        double d2;
        double d3;
        if (!Double.isInfinite(d) && !Double.isNaN(d) && (d3 = Math.abs(d / 10.0)) < Math.abs(d - (d2 = Double.parseDouble(string)))) {
            System.out.printf("Error on n=%s, length=%s%n", d, n);
            System.out.printf("%s%n", string);
            GlobalTest.assertEquals((double)d, (double)d2, (double)d3);
        }
    }

    private void evalLength(double d, int n, String string) {
        if (string.length() != n) {
            System.out.printf("Error on n=%s, length=%s%n", d, n);
            System.out.printf("1...5....0....5....0%n", new Object[0]);
            System.out.printf("%s%n", string);
            GlobalTest.assertEquals((int)n, (int)string.length());
        }
    }

    private void evalAgainstAllThreeMethodsEx(double d, int ... nArray) {
        for (int n : nArray) {
            this.evalLength(d, n, Global.formatFloat(d, n));
            this.evalLength(d, n, Global.formatSci(d, n));
            this.evalLength(d, n, Global.formatFixedWidth(d, n));
            this.evalValue(d, n, Global.formatFixedWidth(d, n));
        }
    }

    private void evalAgainstAllThreeMethods(double d, int ... nArray) {
        for (int n : nArray) {
            this.evalLength(d, n, Global.formatFloat(d, n));
            this.evalLength(d, n, Global.formatSci(d, n));
            this.evalLength(d, n, Global.formatFixedWidth(d, n));
        }
    }

    public void test_doStrangeValuesCrash() {
        int[] nArray = new int[]{8, 10, 15};
        this.evalAgainstAllThreeMethodsEx(-0.0, nArray);
        this.evalAgainstAllThreeMethodsEx(0.0, nArray);
        this.evalAgainstAllThreeMethodsEx(1.0, nArray);
        this.evalAgainstAllThreeMethodsEx(-1.0, nArray);
        this.evalAgainstAllThreeMethods(Double.MAX_VALUE, nArray);
        this.evalAgainstAllThreeMethods(-1.7976931348623157E308, nArray);
        this.evalAgainstAllThreeMethods(Double.MIN_VALUE, nArray);
        this.evalAgainstAllThreeMethods(-4.9E-324, nArray);
        this.evalAgainstAllThreeMethods(Double.POSITIVE_INFINITY, nArray);
        this.evalAgainstAllThreeMethods(Double.NEGATIVE_INFINITY, nArray);
        this.evalAgainstAllThreeMethods(Double.NaN, nArray);
        for (int i = 0; i < 35; ++i) {
            double d = 1.0 * Math.pow(10.0, i);
            this.evalAgainstAllThreeMethodsEx(d, nArray);
            d = -1.0 * Math.pow(10.0, i);
            this.evalAgainstAllThreeMethodsEx(d, nArray);
            d = 1.0 * Math.pow(10.0, -i);
            this.evalAgainstAllThreeMethodsEx(d, nArray);
            d = -1.0 * Math.pow(10.0, -i);
            this.evalAgainstAllThreeMethodsEx(d, nArray);
            d = 1.0 * Math.pow(10.0, i) - 0.01;
            this.evalAgainstAllThreeMethodsEx(d, nArray);
            d = -1.0 * Math.pow(10.0, i) + 0.01;
            this.evalAgainstAllThreeMethodsEx(d, nArray);
            d = 1.0 * Math.pow(10.0, -i);
            d -= d / 100.0;
            this.evalAgainstAllThreeMethodsEx(d, nArray);
            d = -1.0 * Math.pow(10.0, -i);
            d -= d / 100.0;
            this.evalAgainstAllThreeMethodsEx(d, nArray);
        }
    }

    public void test_printSciFormat10Digit() {
        Random random = new Random(1L);
        int n = 1000;
        int n2 = -64;
        int n3 = 64;
        double d = 0.001;
        int n4 = 10;
        Global.formatSci(0.0, n4);
        Global.formatSci(1.0, n4);
        Global.formatSci(-1.0, n4);
        Global.formatSci(Double.MAX_VALUE, n4);
        Global.formatSci(-1.7976931348623157E308, n4);
        Global.formatSci(Double.MIN_VALUE, n4);
        Global.formatSci(-4.9E-324, n4);
        Global.formatSci(Double.POSITIVE_INFINITY, n4);
        Global.formatSci(Double.NEGATIVE_INFINITY, n4);
        Global.formatSci(Double.NaN, n4);
        for (int i = n2; i < n3; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                double d3 = random.nextDouble();
                d3 *= (double)(random.nextBoolean() ? 1 : -1);
                String string = Global.formatSci(d3 *= Math.pow(10.0, i), n4);
                GlobalTest.assertEquals((int)n4, (int)string.length());
                double d4 = Double.parseDouble(string);
                double d5 = Math.abs((d4 - d3) / d3);
                d2 = Math.max(d2, d5);
                if (d5 > d) {
                    System.out.printf("exp=%d, n0=%g, n1=%s, relErr=%g\n", i, d3, string, d5);
                }
                GlobalTest.assertTrue((String)("relErr > " + d), (d5 < d ? 1 : 0) != 0);
            }
            System.out.printf("exp=%d, maxErr=%g%%\n", i, d2 / 100.0);
        }
    }

    public void test_printSciFormat15Digit() {
        Random random = new Random(1L);
        int n = 1000;
        int n2 = -64;
        int n3 = 64;
        double d = 1.0E-8;
        int n4 = 15;
        for (int i = n2; i < n3; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                double d3 = random.nextDouble();
                d3 *= (double)(random.nextBoolean() ? 1 : -1);
                String string = Global.formatSci(d3 *= Math.pow(10.0, i), n4);
                GlobalTest.assertEquals((int)n4, (int)string.length());
                double d4 = Double.parseDouble(string);
                double d5 = Math.abs((d4 - d3) / d3);
                d2 = Math.max(d2, d5);
                if (d5 > d) {
                    System.out.printf("exp=%d, n0=%g, n1=%s, relErr=%g\n", i, d3, string, d5);
                }
                GlobalTest.assertTrue((String)("relErr > " + d), (d5 < d ? 1 : 0) != 0);
            }
            System.out.printf("exp=%d, maxErr=%g%%\n", i, d2 / 100.0);
        }
    }

    public void test_printFloatFormat10Digit() {
        Random random = new Random(1L);
        int n = 1000;
        int n2 = -4;
        int n3 = 6;
        double d = 0.01;
        int n4 = 10;
        for (int i = n2; i < n3; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                double d3 = random.nextDouble();
                if (d3 < 0.1) {
                    --j;
                    continue;
                }
                d3 *= (double)(random.nextBoolean() ? 1 : -1);
                String string = Global.formatFloat(d3 *= Math.pow(10.0, i), n4);
                GlobalTest.assertEquals((int)n4, (int)string.length());
                double d4 = Double.parseDouble(string);
                double d5 = Math.abs((d4 - d3) / d3);
                d2 = Math.max(d2, d5);
                if (d5 > d) {
                    System.out.printf("exp=%d, n0=%g, n1=%s, relErr=%g\n", i, d3, string, d5);
                }
                GlobalTest.assertTrue((String)("relErr > " + d), (d5 < d ? 1 : 0) != 0);
            }
            System.out.printf("exp=%d, maxErr=%g%%\n", i, d2 / 100.0);
        }
    }

    public void test_printFloatFormat15Digit() {
        Random random = new Random(1L);
        int n = 1000;
        int n2 = -8;
        int n3 = 13;
        double d = 0.001;
        int n4 = 15;
        for (int i = n2; i < n3; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                double d3 = random.nextDouble();
                if (d3 < 0.1) {
                    --j;
                    continue;
                }
                d3 *= (double)(random.nextBoolean() ? 1 : -1);
                String string = Global.formatFloat(d3 *= Math.pow(10.0, i), n4);
                GlobalTest.assertEquals((int)n4, (int)string.length());
                double d4 = Double.parseDouble(string);
                double d5 = Math.abs((d4 - d3) / d3);
                d2 = Math.max(d2, d5);
                if (d5 > d) {
                    System.out.printf("exp=%d, n0=%g, n1=%s, relErr=%g\n", i, d3, string, d5);
                }
                GlobalTest.assertTrue((String)("relErr > " + d), (d5 < d ? 1 : 0) != 0);
            }
            System.out.printf("exp=%d, maxErr=%g%%\n", i, d2 / 100.0);
        }
    }

    public void test_print() {
        Random random = new Random(1L);
        int n = 20;
        int n2 = -64;
        int n3 = 64;
        int n4 = 10;
        System.out.println();
        System.out.println("10 Digit Formatter Starting...");
        System.out.println("1234567890");
        for (int i = n2; i < n3; ++i) {
            for (int j = 0; j < n; ++j) {
                double d = random.nextDouble();
                if (d < 0.1) {
                    --j;
                    continue;
                }
                d *= (double)(random.nextBoolean() ? 1 : -1);
                String string = Global.formatFixedWidth(d *= Math.pow(10.0, i), n4);
                System.out.print(string + ", " + d + "  ");
                System.out.println(string.length() == n4 ? "" : "<----- ERROR");
                GlobalTest.assertEquals((int)n4, (int)string.length());
            }
        }
    }

    public static void test_giveEmHellTenDigit() {
        Random random = new Random(1L);
        int n = 1000;
        int n2 = -64;
        int n3 = 64;
        double d = 0.001;
        System.out.println("Give 'em hell, starting.");
        for (int i = n2; i < n3; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                double d3 = random.nextDouble();
                d3 *= (double)(random.nextBoolean() ? 1 : -1);
                if (j == 0) {
                    d3 = 1.0;
                }
                if (j == 1) {
                    d3 = -1.0;
                }
                String string = Global.formatFixedWidth(d3 *= Math.pow(10.0, i), 10);
                double d4 = Double.parseDouble(string);
                double d5 = Math.abs((d4 - d3) / d3);
                d2 = Math.max(d2, d5);
                if (d5 > d) {
                    System.out.printf("exp=%d, n0=%g, n1=%s, relErr=%g\n", i, d3, string, d5);
                }
                GlobalTest.assertTrue((String)("relErr > " + d), (d5 < d ? 1 : 0) != 0);
            }
            System.out.printf("exp=%d, maxErr=%g%%\n", i, d2 / 100.0);
        }
    }

    public static void test_giveEmHell() {
        Random random = new Random(1L);
        int n = 1000;
        int n2 = -64;
        int n3 = 64;
        double d = 1.0E-5;
        System.out.println("Give 'em hell, starting.");
        for (int i = n2; i < n3; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                double d3 = random.nextDouble();
                d3 *= (double)(random.nextBoolean() ? 1 : -1);
                if (j == 0) {
                    d3 = 1.0;
                }
                if (j == 1) {
                    d3 = -1.0;
                }
                String string = Global.format(d3 *= Math.pow(10.0, i));
                double d4 = Double.parseDouble(string);
                double d5 = Math.abs((d4 - d3) / d3);
                d2 = Math.max(d2, d5);
                if (d5 > d) {
                    System.out.printf("exp=%d, n0=%g, n1=%g, relErr=%g\n", i, d3, d4, d5);
                }
                GlobalTest.assertTrue((String)("relErr > " + d), (d5 < d ? 1 : 0) != 0);
            }
            System.out.printf("exp=%d, maxErr=%g%%\n", i, d2 / 100.0);
        }
    }

    public static void test_printEasyNumbers() {
        System.out.println();
        System.out.println("Print Easy Numbers");
        System.out.println("1***5****0");
        System.out.println(Global.formatFixedWidth(0.0, 10));
        System.out.println(Global.formatFixedWidth(1.0, 10));
        System.out.println(Global.formatFixedWidth(-1.0, 10));
        System.out.println(Global.formatFixedWidth(0.1, 10));
        System.out.println(Global.formatFixedWidth(-0.1, 10));
        System.out.println(Global.formatFixedWidth(1.1E-5, 10));
        System.out.println(Global.formatFixedWidth(9.0E-6, 10));
        System.out.println(Global.formatFixedWidth(1.0E-5, 10));
        System.out.println(Global.formatFixedWidth(1.0E-6, 10));
        System.out.println(Global.formatFixedWidth(1.0E-7, 10));
        System.out.println(Global.formatFixedWidth(-1.0E-5, 10));
        System.out.println(Global.formatFixedWidth(-1.0E-6, 10));
        System.out.println(Global.formatFixedWidth(-1.0E-7, 10));
    }
}

