/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.util.Formatter;

public class Global {
    public static String s_engLenFormat = "ft;in;";
    public static final int NUM_DISPLAY_SIG_DIGS = 6;
    public static final Formatter FORMATTER = new Formatter();
    private static Map<Unit, String> s_unitDisplays = new HashMap<Unit, String>();

    public static String formatFixedWidth(double d, int n) {
        return FORMATTER.formatFixedWidth(d, n);
    }

    public static String formatFloat(double d, int n) {
        return FORMATTER.formatFloat(d, n);
    }

    public static String formatSci(double d, int n) {
        return FORMATTER.formatSci(d, n);
    }

    public static String format(double d) {
        return Global.format(d, 6);
    }

    public static String format(double d, int n) {
        return FORMATTER.format(d, n);
    }

    public static String formatGraph(double d) {
        DecimalFormat decimalFormat = new DecimalFormat();
        if (Math.abs(d) == 0.0) {
            decimalFormat.applyPattern("##0.0");
        } else if (Math.abs(d) < 9999.0 && Math.abs(d) >= 100.0) {
            decimalFormat.applyPattern("###0.0");
        } else if (Math.abs(d) < 100.0 && Math.abs(d) >= 1.0) {
            decimalFormat.applyPattern("#0.00");
        } else if (Math.abs(d) < 1.0 && Math.abs(d) > 0.099) {
            decimalFormat.applyPattern("#.000");
        } else {
            decimalFormat.applyPattern("0.0##E00");
        }
        return decimalFormat.format(d);
    }

    public static double parseDouble(String string) throws ParseException {
        Number number;
        int n;
        NumberFormat numberFormat = NumberFormat.getInstance();
        ParsePosition parsePosition = new ParsePosition(0);
        String string2 = string.toUpperCase();
        if (string2.startsWith("+") && string2.length() > 1) {
            string2 = string2.substring(1);
        }
        if ((n = string2.indexOf("E+")) > 0 && string2.length() > n + 1) {
            string2 = string2.substring(0, n) + "E" + string2.substring(n + 2, string2.length());
        }
        if ((number = numberFormat.parse(string2.toUpperCase(), parsePosition)) == null || parsePosition.getIndex() != string2.length()) {
            String string3 = String.format(Intl.intl("Unparseable number: %s"), string);
            throw new ParseException(string3, parsePosition.getIndex());
        }
        return number.doubleValue();
    }

    public static UnitDouble parseUnitDouble(String string) throws ParseException {
        return Global.parseUnitDouble(string, null);
    }

    public static UnitDouble parseUnitDouble(String string, Unit unit) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            if (unit == null) {
                unit = Unit.ONE;
            }
            return new UnitDouble(Global.parseDouble(stringTokenizer.nextToken()), unit);
        }
        double d = Global.parseDouble(stringTokenizer.nextToken());
        String string2 = stringTokenizer.nextToken();
        try {
            Unit unit2 = Unit.valueOf(string2);
            if (unit != null && !UnitDouble.areCompatible(unit2, unit)) {
                String string3 = String.format(Intl.intl("Invalid unit: \"%1$s\" is incompatible with \"%2$s\"."), string2, unit.toString());
                throw new ParseException(string3, 0);
            }
            return new UnitDouble(d, unit2);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Throwable throwable) {
            String string4 = String.format(Intl.intl("Unrecognized unit: %s"), string2);
            throw new ParseException(string4, 0);
        }
    }

    public static String format(UnitDouble unitDouble) {
        return Global.format(unitDouble.getValueNoUnit(), unitDouble.getUnit());
    }

    public static String format(double d, Unit unit) {
        return Global.format(d) + " " + unit;
    }

    static {
        s_unitDisplays.put(NonSI.FOOT, "'");
        s_unitDisplays.put(NonSI.INCH, "\"");
    }
}

