/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class FilteredIterator<T>
implements Iterator<T> {
    private static final Object CURR_END = new Object();
    private static final Object CURR_UNDETERMINED = new Object();
    private final Map<T, Boolean> d_filterCache;
    private final Iterator<?> d_it;
    private IObjectFilter<T> d_filter;
    private int d_skippedCount = 0;
    private Object d_curr;
    private final Class<T> d_type;

    public FilteredIterator(Collection<?> collection, Class<T> clazz) {
        this(collection.iterator(), clazz);
    }

    public FilteredIterator(Collection<?> collection, Class<T> clazz, IObjectFilter<T> iObjectFilter) {
        this(collection.iterator(), clazz, iObjectFilter);
    }

    public FilteredIterator(Collection<?> collection, Class<T> clazz, IObjectFilter<T> iObjectFilter, Map<T, Boolean> map) {
        this(collection.iterator(), clazz, iObjectFilter, map);
    }

    public FilteredIterator(Iterator<?> iterator, Class<T> clazz) {
        this(iterator, clazz, new AcceptAllFilter());
    }

    public FilteredIterator(Iterator<?> iterator, Class<T> clazz, IObjectFilter<T> iObjectFilter) {
        this(iterator, clazz, iObjectFilter, null);
    }

    public FilteredIterator(Iterator<?> iterator, Class<T> clazz, IObjectFilter<T> iObjectFilter, Map<T, Boolean> map) {
        this.d_it = iterator;
        this.d_filter = iObjectFilter;
        this.d_type = clazz;
        this.d_filterCache = map;
        this.d_curr = CURR_UNDETERMINED;
    }

    public int getSkippedCount() {
        return this.d_skippedCount;
    }

    private boolean shouldFilter(T t) {
        if (this.d_filterCache != null) {
            Boolean bl = this.d_filterCache.get(t);
            if (bl == null) {
                bl = this.d_filter.shouldFilter(t);
                this.d_filterCache.put(t, bl);
            }
            return bl;
        }
        return this.d_filter.shouldFilter(t);
    }

    protected Object curr() {
        if (this.d_curr == CURR_UNDETERMINED) {
            while (this.d_it.hasNext()) {
                Object obj = this.d_it.next();
                if (this.d_type.isInstance(obj) && !this.shouldFilter(this.d_type.cast(obj))) {
                    this.d_curr = obj;
                    return this.d_curr;
                }
                ++this.d_skippedCount;
            }
            this.d_curr = CURR_END;
        }
        return this.d_curr;
    }

    @Override
    public boolean hasNext() {
        return this.curr() != CURR_END;
    }

    @Override
    public T next() {
        Object object = this.curr();
        if (this.d_curr != CURR_END) {
            this.d_curr = CURR_UNDETERMINED;
        }
        return object != CURR_END ? (T)this.d_type.cast(object) : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

