/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.FilteredIterator;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class FilteredCollection<T>
extends AbstractCollection<T> {
    private final Map<T, Boolean> d_filterCache;
    private int d_size = -1;
    private final Class<T> d_type;
    private final Collection<?> d_objs;
    private IObjectFilter<T> d_filter;
    private Boolean d_cachedEmpty = null;
    private Boolean d_cachedExclusive = null;

    public FilteredCollection(Collection<?> collection, Class<T> clazz) {
        this(collection, clazz, false);
    }

    public FilteredCollection(Collection<?> collection, Class<T> clazz, boolean bl) {
        this(collection, clazz, new AcceptAllFilter(), bl);
    }

    public FilteredCollection(Collection<?> collection, Class<T> clazz, IObjectFilter<T> iObjectFilter) {
        this(collection, clazz, iObjectFilter, false);
    }

    public FilteredCollection(Collection<?> collection, Class<T> clazz, IObjectFilter<T> iObjectFilter, boolean bl) {
        this.d_objs = collection;
        this.d_filter = iObjectFilter;
        this.d_type = clazz;
        this.d_filterCache = bl ? new IdentityHashMap() : null;
    }

    public boolean isExclusive() {
        if (this.d_cachedExclusive == null) {
            Iterator iterator = this.iterator();
            while (((FilteredIterator)iterator).hasNext() && ((FilteredIterator)iterator).getSkippedCount() <= 0) {
                ((FilteredIterator)iterator).next();
            }
            this.d_cachedExclusive = ((FilteredIterator)iterator).getSkippedCount() == 0;
        }
        return this.d_cachedExclusive;
    }

    @Override
    public boolean contains(Object object) {
        return this.d_type.isInstance(object) && !this.d_filter.shouldFilter(this.d_type.cast(object)) && super.contains(object);
    }

    @Override
    public FilteredIterator<T> iterator() {
        return new FilteredIterator<T>(this.d_objs, this.d_type, this.d_filter, this.d_filterCache);
    }

    @Override
    public int size() {
        if (this.d_size == -1) {
            this.d_size = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ++this.d_size;
                iterator.next();
            }
        }
        return this.d_size;
    }

    @Override
    public boolean isEmpty() {
        if (this.d_cachedEmpty == null) {
            Iterator iterator;
            this.d_cachedEmpty = this.d_size == -1 ? Boolean.valueOf(!(iterator = this.iterator()).hasNext()) : Boolean.valueOf(this.d_size == 0);
        }
        return this.d_cachedEmpty;
    }
}

