/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pyrosim.legacy_2012_1.thunderheadeng.util.Events;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;

public class FilterMgr {
    public static final IObjectFilter FILTER_ALL = FilterAll.INSTANCE;
    private final Events d_events;
    private final Map<Class, IObjectFilter> d_filters = new HashMap<Class, IObjectFilter>();
    private final Map<Class, IObjectFilter> d_cachedFilters = new HashMap<Class, IObjectFilter>();

    public FilterMgr(Events events) {
        this.d_events = events;
    }

    protected void changed(Class clazz) {
        this.d_cachedFilters.clear();
        if (this.d_events != null) {
            this.d_events.changed(this, clazz);
        }
    }

    public <T> void registerFilter(Class<T> clazz, IObjectFilter<? extends T> iObjectFilter) {
        IObjectFilter<? extends T> iObjectFilter2;
        assert (iObjectFilter != null) : "Filter must not be null. To remove a filter, use the method, removeFilter.";
        if (iObjectFilter.equals(FILTER_ALL) && !iObjectFilter.equals(iObjectFilter2 = this.d_filters.put(clazz, iObjectFilter))) {
            this.changed(clazz);
            return;
        }
        iObjectFilter2 = this.d_filters.get(clazz);
        if (iObjectFilter2 instanceof CompositeFilter) {
            if (((CompositeFilter)iObjectFilter2).add(iObjectFilter)) {
                this.changed(clazz);
            }
        } else if (iObjectFilter2 != null && !iObjectFilter.equals(iObjectFilter2)) {
            CompositeFilter compositeFilter = new CompositeFilter(iObjectFilter2, iObjectFilter);
            this.d_filters.put(clazz, compositeFilter);
            this.changed(clazz);
        } else {
            this.d_filters.put(clazz, iObjectFilter);
            this.changed(clazz);
        }
    }

    public <T> void filterAllOfType(Class<T> clazz) {
        this.registerFilter(clazz, FilterAll.INSTANCE);
    }

    public <T> void removeFilter(Class<T> clazz, IObjectFilter<T> iObjectFilter) {
        IObjectFilter iObjectFilter2 = this.d_filters.get(clazz);
        if (iObjectFilter2 instanceof CompositeFilter) {
            CompositeFilter compositeFilter = (CompositeFilter)iObjectFilter2;
            if (compositeFilter.remove(iObjectFilter)) {
                if (compositeFilter.d_filters.size() == 1) {
                    this.d_filters.put(clazz, (IObjectFilter)compositeFilter.d_filters.get(0));
                }
                this.changed(clazz);
            }
        } else if (iObjectFilter.equals(iObjectFilter2)) {
            this.d_filters.remove(clazz);
            this.changed(clazz);
        }
    }

    public boolean isFilteringAllOf(Class clazz) {
        IObjectFilter iObjectFilter = this.getFilter(clazz);
        return iObjectFilter instanceof FilterAll;
    }

    public boolean filter(Object object) {
        IObjectFilter iObjectFilter = this.getFilter(object.getClass());
        if (iObjectFilter == null) {
            return false;
        }
        return iObjectFilter.shouldFilter(object);
    }

    private IObjectFilter getFilter(Class clazz) {
        if (this.d_cachedFilters.containsKey(clazz)) {
            return this.d_cachedFilters.get(clazz);
        }
        IObjectFilter iObjectFilter = this.calculateFilter(clazz);
        this.d_cachedFilters.put(clazz, iObjectFilter);
        return iObjectFilter;
    }

    private IObjectFilter calculateFilter(Class clazz) {
        IObjectFilter iObjectFilter = this.d_filters.get(clazz);
        if (iObjectFilter != null) {
            return iObjectFilter;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (iObjectFilter = this.calculateFilter(clazz2)) != null) {
            return iObjectFilter;
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            iObjectFilter = this.calculateFilter(clazz3);
            if (iObjectFilter == null) continue;
            return iObjectFilter;
        }
        return null;
    }

    public void reset() {
        this.d_filters.clear();
        if (this.d_events != null) {
            this.d_events.changed(this, new Object[0]);
        }
    }

    private static class FilterAll<T>
    implements IObjectFilter<T> {
        public static final FilterAll INSTANCE = new FilterAll();

        private FilterAll() {
        }

        @Override
        public boolean shouldFilter(T t) {
            return true;
        }
    }

    private static class CompositeFilter<T>
    implements IObjectFilter<T> {
        private final List<IObjectFilter<T>> d_filters;

        public CompositeFilter(IObjectFilter<T> ... iObjectFilterArray) {
            this.d_filters = new ArrayList<IObjectFilter<T>>(Arrays.asList(iObjectFilterArray));
        }

        public boolean add(IObjectFilter<T> iObjectFilter) {
            int n = this.d_filters.indexOf(iObjectFilter);
            if (n < 0) {
                this.d_filters.add(iObjectFilter);
                return true;
            }
            return false;
        }

        public boolean remove(IObjectFilter<T> iObjectFilter) {
            return this.d_filters.remove(iObjectFilter);
        }

        @Override
        public boolean shouldFilter(T t) {
            for (IObjectFilter<T> iObjectFilter : this.d_filters) {
                if (!iObjectFilter.shouldFilter(t)) continue;
                return true;
            }
            return false;
        }
    }
}

