/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.AEventRec;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeEvtRec;
import pyrosim.legacy_2012_1.thunderheadeng.util.EventChannel;
import pyrosim.legacy_2012_1.thunderheadeng.util.IEventObserver;
import pyrosim.legacy_2012_1.thunderheadeng.util.IEventRecord;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.WeakHashSet;

public class Events {
    public static final Object EVT_GENERAL = "Events.EVT_GENERAL";
    private final Set<IEventObserver> d_observers = new WeakHashSet<IEventObserver>();
    private final Map<Class, EventChannel> d_typeChannelMap = new HashMap<Class, EventChannel>();
    private final Map<Class, Set<EventChannel>> d_superclassChannelMap = new HashMap<Class, Set<EventChannel>>();
    private int d_pauseCounter = 0;
    private boolean d_listening = true;
    private int d_lastListeningPos = 0;
    private boolean d_changed = false;
    private boolean d_identityObjHashes;
    private static final IEventRecord EMPTY_EVENT_REC = new AEventRec(){

        @Override
        public boolean isModified() {
            return false;
        }

        @Override
        public Set getAddedObjs() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set getRemovedObjs() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set getChanges() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set getChangedObjs(Object ... objectArray) {
            return Collections.EMPTY_SET;
        }

        @Override
        public boolean isChanged(Object object) {
            return false;
        }

        @Override
        public boolean containsChange(Object object) {
            return false;
        }
    };
    private boolean d_tryFireLock = false;

    public Events() {
        this(true);
    }

    public Events(boolean bl) {
        this.d_identityObjHashes = bl;
    }

    public boolean isListening() {
        return this.d_listening;
    }

    public void addObserver(IEventObserver iEventObserver) {
        this.d_observers.add(iEventObserver);
    }

    public void removeObserver(IEventObserver iEventObserver) {
        this.d_observers.remove(iEventObserver);
    }

    public void clearObservers() {
        this.d_observers.clear();
    }

    public void resetEvents() {
        this.d_typeChannelMap.clear();
        this.d_superclassChannelMap.clear();
    }

    public boolean isChannelAffected(Class clazz) {
        return !this.isAffected(clazz);
    }

    public boolean isAffected(Class clazz) {
        return !this.getAffectedChannels(clazz, new Class[0]).isEmpty();
    }

    public <T> Set<EventChannel<? extends T>> getAffectedChannels(Class<T> clazz, Class ... classArray) {
        IdentityHashSet<EventChannel<T>> identityHashSet = new IdentityHashSet<EventChannel<T>>();
        Set<EventChannel> set = this.d_superclassChannelMap.get(clazz);
        if (set != null) {
            for (EventChannel eventChannel : set) {
                if (!eventChannel.isModified()) continue;
                identityHashSet.add(eventChannel);
            }
        }
        for (Class clazz2 : classArray) {
            Set<EventChannel> set2 = this.d_superclassChannelMap.get(clazz2);
            if (set2 == null) continue;
            identityHashSet.removeAll(set2);
        }
        return identityHashSet;
    }

    public <T> IEventRecord<T> getEvents(Class<T> clazz, Class ... classArray) {
        Set<EventChannel<T>> set = this.getAffectedChannels(clazz, classArray);
        if (set.isEmpty()) {
            return EMPTY_EVENT_REC;
        }
        return set.size() == 1 ? (IEventRecord)set.iterator().next() : new CompositeEvtRec<T>(set);
    }

    public void pause() {
        this.pause(true);
    }

    public void pause(boolean bl) {
        ++this.d_pauseCounter;
        if (!this.d_listening) {
            return;
        }
        this.d_listening = bl;
        if (this.d_listening) {
            this.d_lastListeningPos = this.d_pauseCounter;
        }
    }

    public boolean resume() {
        assert (this.d_pauseCounter > 0);
        if (this.d_pauseCounter > this.d_lastListeningPos) {
            --this.d_pauseCounter;
            if (this.d_pauseCounter == this.d_lastListeningPos) {
                this.d_listening = true;
            }
            return false;
        }
        --this.d_pauseCounter;
        --this.d_lastListeningPos;
        return this.tryFireNotification();
    }

    public boolean willFireOnResume() {
        return this.d_pauseCounter == 1 && this.d_changed;
    }

    private boolean tryFireNotification() {
        if (this.d_pauseCounter == 0 && this.d_changed) {
            if (this.d_tryFireLock) {
                return false;
            }
            this.d_tryFireLock = true;
            this.fireNotification();
            for (EventChannel eventChannel : this.d_typeChannelMap.values()) {
                eventChannel.eventDispatched();
            }
            this.d_changed = false;
            this.d_tryFireLock = false;
            return true;
        }
        return false;
    }

    protected void fireNotification() {
        for (IEventObserver iEventObserver : this.d_observers) {
            iEventObserver.update(this);
        }
    }

    public Collection<EventChannel> getChannels() {
        return this.d_typeChannelMap.values();
    }

    public boolean added(Object object) {
        if (!this.d_listening) {
            return false;
        }
        return this.tryChange(this.getSpecificChannel(object).added(object));
    }

    public boolean added(Object ... objectArray) {
        if (!this.d_listening) {
            return false;
        }
        boolean bl = false;
        for (Object object : objectArray) {
            if (!this.getSpecificChannel(object).added(object)) continue;
            bl = true;
        }
        return this.tryChange(bl);
    }

    public boolean added(Collection<?> collection) {
        if (!this.d_listening) {
            return false;
        }
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.getSpecificChannel(obj).added(obj);
        }
        return this.tryChange(bl);
    }

    public boolean removed(Object object) {
        if (!this.d_listening) {
            return false;
        }
        return this.tryChange(this.getSpecificChannel(object).removed(object));
    }

    public boolean removed(Object ... objectArray) {
        if (!this.d_listening) {
            return false;
        }
        boolean bl = false;
        for (Object object : objectArray) {
            if (!this.getSpecificChannel(object).removed(object)) continue;
            bl = true;
        }
        return this.tryChange(bl);
    }

    public boolean removed(Collection<?> collection) {
        if (!this.d_listening) {
            return false;
        }
        boolean bl = false;
        for (Object obj : collection) {
            if (!this.getSpecificChannel(obj).removed(obj)) continue;
            bl = true;
        }
        return this.tryChange(bl);
    }

    public boolean changed(Object object, Object ... objectArray) {
        if (!this.d_listening) {
            return false;
        }
        return this.tryChange(this.getSpecificChannel(object).changed(object, objectArray));
    }

    public boolean changed(Collection<?> collection, Object ... objectArray) {
        if (!this.d_listening) {
            return false;
        }
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.getSpecificChannel(obj).changed(obj, objectArray);
        }
        return this.tryChange(bl);
    }

    private EventChannel getSpecificChannel(Object object) {
        Class<?> clazz = object.getClass();
        EventChannel eventChannel = this.d_typeChannelMap.get(clazz);
        if (eventChannel == null) {
            eventChannel = new EventChannel(clazz, this.d_identityObjHashes);
            this.d_typeChannelMap.put(clazz, eventChannel);
            this.associateSuperclassesWithChannel(clazz, eventChannel);
        }
        return eventChannel;
    }

    private void associateSuperclassesWithChannel(Class clazz, EventChannel eventChannel) {
        if (clazz == null) {
            return;
        }
        Set<EventChannel> set = this.d_superclassChannelMap.get(clazz);
        if (set == null) {
            set = new IdentityHashSet<EventChannel>();
            this.d_superclassChannelMap.put(clazz, set);
        }
        set.add(eventChannel);
        this.associateSuperclassesWithChannel(clazz.getSuperclass(), eventChannel);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            this.associateSuperclassesWithChannel(clazz2, eventChannel);
        }
    }

    private boolean tryChange(boolean bl) {
        if (bl) {
            this.d_changed = true;
            return this.tryFireNotification();
        }
        return false;
    }
}

