/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.AEventRec;
import pyrosim.legacy_2012_1.thunderheadeng.util.Events;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;

public class EventChannel<ObjT>
extends AEventRec<ObjT> {
    public static final Object EVT_GENERAL = Events.EVT_GENERAL;
    private final Set<ObjT> d_adds;
    private final Set<ObjT> d_removes;
    private final Map<Object, Set<ObjT>> d_changeMap;
    private final Class<ObjT> d_type;
    private final boolean d_identityObjHash;

    public EventChannel(Class<ObjT> clazz, boolean bl) {
        this.d_type = clazz;
        this.d_identityObjHash = bl;
        this.d_adds = bl ? new LinkedIdentityHashSet() : new LinkedHashSet();
        this.d_removes = bl ? new LinkedIdentityHashSet() : new LinkedHashSet();
        this.d_changeMap = new LinkedHashMap<Object, Set<ObjT>>();
    }

    public Class<ObjT> getObjectType() {
        return this.d_type;
    }

    public boolean handlesSubType(Class clazz) {
        return clazz.isAssignableFrom(this.d_type);
    }

    protected Set<ObjT> newObjSet() {
        return this.d_identityObjHash ? new IdentityHashSet() : new HashSet();
    }

    public boolean added(ObjT ObjT) {
        if (!this.d_removes.remove(ObjT)) {
            this.d_adds.add(ObjT);
            return true;
        }
        return this.changed(ObjT, new Object[0]);
    }

    public boolean added(ObjT ... ObjTArray) {
        boolean bl = false;
        for (ObjT ObjT : ObjTArray) {
            if (!this.added(ObjT)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean added(Collection<? extends ObjT> collection) {
        boolean bl = false;
        for (ObjT ObjT : collection) {
            if (!this.added(ObjT)) continue;
            bl = true;
        }
        return bl;
    }

    private void removeChangesTo(ObjT ObjT) {
        Iterator<Map.Entry<Object, Set<ObjT>>> iterator = this.d_changeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Set<ObjT>> entry = iterator.next();
            Set<ObjT> set = entry.getValue();
            if (!set.remove(ObjT) || !set.isEmpty()) continue;
            iterator.remove();
        }
    }

    private void addChangeTo(ObjT ObjT, Object object) {
        Set<ObjT> set = this.d_changeMap.get(object);
        if (set == null) {
            set = this.newObjSet();
            this.d_changeMap.put(object, set);
        }
        set.add(ObjT);
    }

    public boolean removed(ObjT ObjT) {
        if (!this.d_adds.remove(ObjT)) {
            this.removeChangesTo(ObjT);
            this.d_removes.add(ObjT);
            return true;
        }
        return false;
    }

    public boolean removed(ObjT ... ObjTArray) {
        boolean bl = false;
        for (ObjT ObjT : ObjTArray) {
            bl |= this.removed(ObjT);
        }
        return bl;
    }

    public boolean removed(Collection<? extends ObjT> collection) {
        boolean bl = false;
        for (ObjT ObjT : collection) {
            bl |= this.removed(ObjT);
        }
        return bl;
    }

    public boolean changed(ObjT ObjT, Object ... objectArray) {
        if (!this.d_adds.contains(ObjT) && !this.d_removes.contains(ObjT)) {
            if (objectArray.length == 0) {
                this.addChangeTo(ObjT, EVT_GENERAL);
            } else {
                for (Object object : objectArray) {
                    this.addChangeTo(ObjT, object);
                }
            }
            return true;
        }
        return false;
    }

    public boolean changed(Collection<? extends ObjT> collection, Object ... objectArray) {
        boolean bl = false;
        for (ObjT ObjT : collection) {
            bl |= this.changed(ObjT, objectArray);
        }
        return bl;
    }

    @Override
    public Set<ObjT> getAddedObjs() {
        return Collections.unmodifiableSet(this.d_adds);
    }

    @Override
    public Set<ObjT> getRemovedObjs() {
        return Collections.unmodifiableSet(this.d_removes);
    }

    @Override
    public Set<Object> getChanges() {
        return Collections.unmodifiableSet(this.d_changeMap.keySet());
    }

    @Override
    public Set<ObjT> getChangedObjs(Object ... objectArray) {
        if (this.d_changeMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (objectArray.length == 0) {
            if (this.d_changeMap.size() == 1) {
                return this.d_changeMap.values().iterator().next();
            }
            Set<ObjT> set = this.newObjSet();
            for (Set<ObjT> set2 : this.d_changeMap.values()) {
                set.addAll(set2);
            }
            return set;
        }
        if (objectArray.length == 1) {
            Set<ObjT> set = this.d_changeMap.get(objectArray[0]);
            if (set == null) {
                return Collections.EMPTY_SET;
            }
            return set;
        }
        Set<ObjT> set = this.newObjSet();
        for (Object object : objectArray) {
            Set<ObjT> set3 = this.d_changeMap.get(object);
            if (set3 == null) continue;
            set.addAll(set3);
        }
        return set;
    }

    @Override
    public boolean isChanged(Object object) {
        for (Set<ObjT> set : this.d_changeMap.values()) {
            if (!set.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsChange(Object object) {
        return this.d_changeMap.containsKey(object);
    }

    protected void eventDispatched() {
        this.d_adds.clear();
        this.d_removes.clear();
        this.d_changeMap.clear();
    }

    public String toString() {
        return "EventChannel of " + this.d_type;
    }
}

