/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import junit.framework.TestCase;
import pyrosim.legacy_2012_1.thunderheadeng.util.DigitalSignal;

public class DigitalSignalTest
extends TestCase {
    private DigitalSignal d_signal;

    public DigitalSignalTest(String string) {
        super(string);
    }

    protected void setUp() {
        this.d_signal = new DigitalSignal(10.0, 60);
        this.d_signal.setRangeHigh(10, 30);
        this.d_signal.setRangeLow(15, 18);
        this.d_signal.setRangeHigh(57, 58);
    }

    public void testEquals() {
        DigitalSignal digitalSignal = new DigitalSignal(3.0, 15);
        DigitalSignal digitalSignal2 = new DigitalSignal(3.0, 15);
        DigitalSignal digitalSignal3 = new DigitalSignal(3.0, 15);
        DigitalSignal digitalSignal4 = new DigitalSignal(5.0, 15);
        DigitalSignal digitalSignal5 = new DigitalSignal(3.0, 20);
        digitalSignal.setSample(6, true);
        digitalSignal.setSample(14, true);
        digitalSignal2.setSample(6, true);
        digitalSignal2.setSample(14, true);
        digitalSignal3.setSample(5, true);
        digitalSignal3.setSample(14, true);
        digitalSignal4.setSample(6, true);
        digitalSignal4.setSample(14, true);
        digitalSignal5.setSample(6, true);
        digitalSignal5.setSample(14, true);
        DigitalSignalTest.assertEquals((Object)digitalSignal, (Object)digitalSignal2);
        DigitalSignalTest.assertEquals((Object)digitalSignal2, (Object)digitalSignal);
        DigitalSignalTest.assertTrue((!digitalSignal.equals(digitalSignal3) ? 1 : 0) != 0);
        DigitalSignalTest.assertTrue((!digitalSignal.equals(digitalSignal4) ? 1 : 0) != 0);
        DigitalSignalTest.assertTrue((!digitalSignal.equals(digitalSignal5) ? 1 : 0) != 0);
        DigitalSignalTest.assertTrue((!digitalSignal.equals(new Object()) ? 1 : 0) != 0);
    }

    public void testClone() {
        DigitalSignal digitalSignal = (DigitalSignal)this.d_signal.clone();
        DigitalSignalTest.assertEquals((Object)digitalSignal, (Object)this.d_signal);
    }

    public void testSampleToTime() {
        double d = this.d_signal.sampleToTime(7);
        DigitalSignalTest.assertEquals((double)d, (double)70.0, (double)0.0);
    }

    public void testTimeToSample() {
        DigitalSignalTest.assertEquals((int)this.d_signal.timeToSample(70.0), (int)7);
        DigitalSignalTest.assertEquals((int)this.d_signal.timeToSample(79.0), (int)7);
    }

    public void testGetNumSamples() {
        DigitalSignalTest.assertEquals((int)60, (int)this.d_signal.getNumSamples());
    }

    public void testGetSampleInterval() {
        DigitalSignalTest.assertEquals((double)10.0, (double)this.d_signal.getSampleInterval(), (double)0.0);
    }

    public void testGetDuration() {
        DigitalSignalTest.assertEquals((double)600.0, (double)this.d_signal.getDuration(), (double)0.0);
    }

    public void testEvaluateSample() {
        DigitalSignalTest.assertEquals((double)0.0, (double)this.d_signal.evaluateSample(9), (double)0.0);
        DigitalSignalTest.assertEquals((double)1.0, (double)this.d_signal.evaluateSample(10), (double)0.0);
        DigitalSignalTest.assertEquals((double)0.0, (double)this.d_signal.evaluateSample(15), (double)0.0);
        DigitalSignalTest.assertEquals((double)0.0, (double)this.d_signal.evaluateSample(17), (double)0.0);
        DigitalSignalTest.assertEquals((double)1.0, (double)this.d_signal.evaluateSample(18), (double)0.0);
        DigitalSignalTest.assertEquals((double)0.0, (double)this.d_signal.evaluateSample(56), (double)0.0);
        DigitalSignalTest.assertEquals((double)1.0, (double)this.d_signal.evaluateSample(57), (double)0.0);
        DigitalSignalTest.assertEquals((double)0.0, (double)this.d_signal.evaluateSample(58), (double)0.0);
    }

    public void testEvaluate() {
        DigitalSignalTest.assertEquals((double)this.d_signal.evaluateSample(0), (double)this.d_signal.evaluate(this.d_signal.sampleToTime(0)), (double)0.0);
        DigitalSignalTest.assertEquals((double)this.d_signal.evaluateSample(1), (double)this.d_signal.evaluate(this.d_signal.sampleToTime(1)), (double)0.0);
        DigitalSignalTest.assertEquals((double)this.d_signal.evaluateSample(24), (double)this.d_signal.evaluate(this.d_signal.sampleToTime(24)), (double)0.0);
        DigitalSignalTest.assertEquals((double)this.d_signal.evaluateSample(59), (double)this.d_signal.evaluate(this.d_signal.sampleToTime(59)), (double)0.0);
    }

    public void testGetTransitions() {
        int[] nArray = this.d_signal.getTransitions();
        DigitalSignalTest.assertEquals((int)6, (int)nArray.length);
        DigitalSignalTest.assertEquals((int)10, (int)nArray[0]);
        DigitalSignalTest.assertEquals((int)15, (int)nArray[1]);
        DigitalSignalTest.assertEquals((int)18, (int)nArray[2]);
        DigitalSignalTest.assertEquals((int)30, (int)nArray[3]);
        DigitalSignalTest.assertEquals((int)57, (int)nArray[4]);
        DigitalSignalTest.assertEquals((int)58, (int)nArray[5]);
    }

    public void testIntegrate() {
        DigitalSignalTest.assertEquals((double)180.0, (double)this.d_signal.integrate(), (double)0.0);
        DigitalSignalTest.assertEquals((double)180.0, (double)this.d_signal.integrate(0, 60), (double)0.0);
        DigitalSignalTest.assertEquals((double)30.0, (double)this.d_signal.integrate(28, 58), (double)0.0);
        DigitalSignalTest.assertEquals((double)160.0, (double)this.d_signal.integrate(11, 43), (double)0.0);
    }

    public void testInvert() {
        double d = this.d_signal.integrate();
        DigitalSignalTest.assertEquals((double)(600.0 - d), (double)this.d_signal.invert().integrate(), (double)0.0);
    }

    public void testAdd() {
        DigitalSignal digitalSignal = (DigitalSignal)this.d_signal.clone();
        DigitalSignalTest.assertEquals((double)600.0, (double)this.d_signal.add(digitalSignal.invert()).integrate(), (double)0.0);
    }

    public void testMultiply() {
    }

    public void testResample() {
    }

    public void testSetRange() {
    }

    public void testSetRangeHigh() {
    }

    public void testSetRangeLow() {
    }

    public void testSetSample() {
    }

    public void testSetTransitions() {
    }

    public void testSet() {
    }

    public void testSetRangeOfSamples() {
    }
}

