/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import junit.framework.TestCase;
import pyrosim.legacy_2012_1.thunderheadeng.util.Diff;

public class DiffTest
extends TestCase {
    public void test_one_deletion() {
        String string = "abc";
        String string2 = "ac";
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string3 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string3);
        DiffTest.assertEquals((String)"  ", (String)string3);
    }

    public void test_two_deletion() {
        String string = "abbc";
        String string2 = "ac";
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string3 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string3);
        DiffTest.assertEquals((String)"  ", (String)string3);
    }

    public void test_two_separate_deletion() {
        String string = "abbc axxc";
        String string2 = "ac ac";
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string3 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string3);
        DiffTest.assertEquals((String)"     ", (String)string3);
    }

    public void test_one_substitution() {
        String string = "abc";
        String string2 = "axc";
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string3 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string3);
        DiffTest.assertEquals((String)" ^ ", (String)string3);
    }

    public void test_one_insertion() {
        String string = "ac";
        String string2 = "abc";
        DiffTest.assertEquals((int)1, (int)Diff.getEditDistance(string, string2));
        DiffTest.assertEquals((int)1, (int)Diff.getEditDistance("ab", "abc"));
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string3 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string3);
        DiffTest.assertEquals((String)" ^ ", (String)string3);
    }

    public void test_two_insertion() {
        String string = "ac";
        String string2 = "abbc";
        DiffTest.assertEquals((int)2, (int)Diff.getEditDistance(string, string2));
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string3 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string3);
        DiffTest.assertEquals((String)" ^^ ", (String)string3);
    }

    public void test_surfAddFields() {
        String string = "&SURF ID='SURF', COLOR='GRAY 80', ADIABATIC=.TRUE./";
        String string2 = "&SURF ID='SURF', COLOR='GRAY 80', HRRPUA=500.00, E_COEFFICIENT=0.3000/";
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string3 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string3);
        DiffTest.assertEquals((int)string2.length(), (int)string3.length());
        DiffTest.assertTrue((boolean)string3.startsWith("                                  "));
    }

    public void test_surfSRSRS() {
        String string = "&SURF ID='SURF', COLOR='GRAY 80', TMP_FRONT=21.00, EMISSIVITY=0.80, HRRPUA=500.00, E_COEFFICIENT=0.1000/";
        String string2 = "&SURF ID='SURF', COLOR='WHITE', TMP_FRONT=21.00, EMISSIVITY=0.80, MLRPUA=0.2000, E_COEFFICIENT=0.1000/";
        String string3 = "                        ^^^^^                                     ^^       ^^                         ";
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string4 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string4);
        DiffTest.assertEquals((int)string2.length(), (int)string4.length());
        DiffTest.assertEquals((String)string3, (String)string4);
    }

    public void test_matlSwitch() {
        String string = "&MATL ID='MAT02', SPECIFIC_HEAT=1.00, CONDUCTIVITY=0.1000, DENSITY=502.00/";
        String string2 = "&MATL ID='MAT', SPECIFIC_HEAT=1.00, CONDUCTIVITY=0.1000, DENSITY=500.00/";
        String string3 = "                                                                   ^    ";
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string4 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string4);
        DiffTest.assertEquals((int)string2.length(), (int)string4.length());
        DiffTest.assertEquals((String)string3, (String)string4);
    }

    public void test_matlSwitch2() {
        String string = "&MATL ID='MAT', SPECIFIC_HEAT=1.00, CONDUCTIVITY=0.1000, DENSITY=500.00/";
        String string2 = "&MATL ID='MAT02', SPECIFIC_HEAT=1.00, CONDUCTIVITY=0.1000, DENSITY=502.00/";
        String string3 = "             ^^                                                      ^    ";
        Diff.Op[] opArray = Diff.diff(string, string2);
        String string4 = Diff.diffToStr(opArray);
        System.out.println(string);
        System.out.println(string2);
        System.out.println(string4);
        DiffTest.assertEquals((int)string2.length(), (int)string4.length());
        DiffTest.assertEquals((String)string3, (String)string4);
    }
}

