/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Arrays;
import java.util.Iterator;

public class CompositeIterator<E>
implements Iterator<E> {
    private Iterator<? extends Iterable<? extends E>> d_collIt;
    private Iterator<? extends E> d_currIt;

    public CompositeIterator(Iterable<? extends E> ... iterableArray) {
        this((Iterable<Iterable<? extends E>>)Arrays.asList(iterableArray));
    }

    public CompositeIterator(Iterable<? extends Iterable<? extends E>> iterable) {
        this.d_collIt = iterable.iterator();
        this.d_currIt = null;
    }

    protected void update() {
        if (this.d_currIt != null && this.d_currIt.hasNext()) {
            return;
        }
        this.d_currIt = null;
        while (this.d_collIt.hasNext()) {
            Iterator<E> iterator = this.d_collIt.next().iterator();
            if (!iterator.hasNext()) continue;
            this.d_currIt = iterator;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        this.update();
        return this.d_currIt != null;
    }

    @Override
    public E next() {
        this.update();
        return this.d_currIt == null ? null : (E)this.d_currIt.next();
    }

    @Override
    public void remove() {
        this.update();
        if (this.d_currIt != null) {
            this.d_currIt.remove();
        }
    }
}

