/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.AEventRec;
import pyrosim.legacy_2012_1.thunderheadeng.util.CompositeIterator;
import pyrosim.legacy_2012_1.thunderheadeng.util.IEventRecord;

public class CompositeEvtRec<ObjT>
extends AEventRec<ObjT> {
    private final List<? extends IEventRecord<? extends ObjT>> d_channels;
    private Set<Object> d_cachedChanges;

    public CompositeEvtRec(Collection<? extends IEventRecord<? extends ObjT>> collection) {
        this.d_channels = collection instanceof List ? (List<Object>)collection : new ArrayList<IEventRecord<? extends ObjT>>(collection);
    }

    @Override
    public boolean isModified() {
        for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
            if (!iEventRecord.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ObjT> getAddedObjs() {
        return new CompAddSet();
    }

    @Override
    public Set<ObjT> getRemovedObjs() {
        return new CompRemoveSet();
    }

    @Override
    public Set<Object> getChanges() {
        if (this.d_cachedChanges == null) {
            this.d_cachedChanges = new LinkedHashSet<Object>();
            for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
                this.d_cachedChanges.addAll(iEventRecord.getChanges());
            }
        }
        return this.d_cachedChanges;
    }

    @Override
    public Set<ObjT> getChangedObjs(Object ... objectArray) {
        return new CompChangedObjsSet(objectArray);
    }

    @Override
    public boolean isChanged(Object object) {
        for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
            if (!iEventRecord.isChanged(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsChange(Object object) {
        for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
            if (!iEventRecord.containsChange(object)) continue;
            return true;
        }
        return false;
    }

    private class CompChangedObjsSet
    extends CompositeSet<ObjT> {
        private final Object[] d_changes;

        public CompChangedObjsSet(Object[] objectArray) {
            this.d_changes = objectArray;
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> iEventRecord) {
            return iEventRecord.getChangedObjs(this.d_changes);
        }
    }

    private class CompRemoveSet
    extends CompositeSet<ObjT> {
        private CompRemoveSet() {
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> iEventRecord) {
            return iEventRecord.getRemovedObjs();
        }
    }

    private class CompAddSet
    extends CompositeSet<ObjT> {
        private CompAddSet() {
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> iEventRecord) {
            return iEventRecord.getAddedObjs();
        }
    }

    private abstract class CompositeSet<E>
    extends AbstractSet<E> {
        private final Map<IEventRecord<? extends ObjT>, Set<? extends E>> d_cachedSets = new IdentityHashMap();

        protected abstract Set<? extends E> getSet(IEventRecord<? extends ObjT> var1);

        protected Set<? extends E> getCachedSet(IEventRecord<? extends ObjT> iEventRecord) {
            Set<Object> set = this.d_cachedSets.get(iEventRecord);
            if (set == null) {
                set = this.getSet(iEventRecord);
                this.d_cachedSets.put(iEventRecord, set);
            }
            return set;
        }

        @Override
        public Iterator<E> iterator() {
            ArrayList<Set<E>> arrayList = new ArrayList<Set<E>>(CompositeEvtRec.this.d_channels.size());
            for (IEventRecord iEventRecord : CompositeEvtRec.this.d_channels) {
                arrayList.add(this.getCachedSet(iEventRecord));
            }
            return new CompositeIterator(arrayList);
        }

        @Override
        public int size() {
            int n = 0;
            for (IEventRecord iEventRecord : CompositeEvtRec.this.d_channels) {
                n += this.getCachedSet(iEventRecord).size();
            }
            return n;
        }

        @Override
        public boolean contains(Object object) {
            for (IEventRecord iEventRecord : CompositeEvtRec.this.d_channels) {
                if (!this.getCachedSet(iEventRecord).contains(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            for (IEventRecord iEventRecord : CompositeEvtRec.this.d_channels) {
                if (this.getCachedSet(iEventRecord).isEmpty()) continue;
                return false;
            }
            return true;
        }
    }
}

