/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.List;
import junit.framework.TestCase;
import pyrosim.legacy_2012_1.thunderheadeng.util.CSVLineParser;

public class CSVLineParserTest
extends TestCase {
    public void test_csvUsageWithNoQuotes() {
        String string = "steve, fran, 4, 92.8, a horse, is a \"horse, of\" cores";
        List<String> list = CSVLineParser.parse(string, ",", "");
        CSVLineParserTest.assertEquals((int)7, (int)list.size());
        CSVLineParserTest.assertEquals((String)"steve", (String)list.get(0));
        CSVLineParserTest.assertEquals((String)"fran", (String)list.get(1));
        CSVLineParserTest.assertEquals((String)"4", (String)list.get(2));
        CSVLineParserTest.assertEquals((String)"92.8", (String)list.get(3));
        CSVLineParserTest.assertEquals((String)"a horse", (String)list.get(4));
        CSVLineParserTest.assertEquals((String)"is a \"horse", (String)list.get(5));
        CSVLineParserTest.assertEquals((String)"of\" cores", (String)list.get(6));
    }

    public void test_forUseWithReactionsParsing() {
        String string = "0.2 brick 0.4 \"air gap\" 0.2 brick";
        List<String> list = CSVLineParser.parse(string, " ,;", "\"");
        CSVLineParserTest.assertEquals((int)6, (int)list.size());
        CSVLineParserTest.assertEquals((String)"0.2", (String)list.get(0));
        CSVLineParserTest.assertEquals((String)"brick", (String)list.get(1));
        CSVLineParserTest.assertEquals((String)"0.4", (String)list.get(2));
        CSVLineParserTest.assertEquals((String)"air gap", (String)list.get(3));
        CSVLineParserTest.assertEquals((String)"0.2", (String)list.get(4));
        CSVLineParserTest.assertEquals((String)"brick", (String)list.get(5));
    }

    public void test_emptyStringsArePeopleToo() {
        String string = "0.2 \"\" 0.1";
        List<String> list = CSVLineParser.parse(string, " ,", "\"");
        CSVLineParserTest.assertEquals((int)3, (int)list.size());
        CSVLineParserTest.assertEquals((String)"0.2", (String)list.get(0));
        CSVLineParserTest.assertEquals((String)"", (String)list.get(1));
        CSVLineParserTest.assertEquals((String)"0.1", (String)list.get(2));
    }

    public void test_embeddedQuoteChar1() {
        String string = "\"charlie's mojo\"";
        List<String> list = CSVLineParser.parse(string, " ", "\"'");
        CSVLineParserTest.assertEquals((int)1, (int)list.size());
        CSVLineParserTest.assertEquals((String)"charlie's mojo", (String)list.get(0));
    }

    public void test_embeddedQuoteChar2() {
        String string = "0.2 \"monkey's uncle\" 0.3 'go, fish!'";
        List<String> list = CSVLineParser.parse(string, " ,", "\"'");
        CSVLineParserTest.assertEquals((int)4, (int)list.size());
        CSVLineParserTest.assertEquals((String)"0.2", (String)list.get(0));
        CSVLineParserTest.assertEquals((String)"monkey's uncle", (String)list.get(1));
        CSVLineParserTest.assertEquals((String)"0.3", (String)list.get(2));
        CSVLineParserTest.assertEquals((String)"go, fish!", (String)list.get(3));
    }
}

