/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Collection;
import junit.framework.TestCase;
import pyrosim.legacy_2012_1.thunderheadeng.util.Bag;
import pyrosim.legacy_2012_1.thunderheadeng.util.IdentityHashSet;

public class BagTest
extends TestCase {
    private final Integer ONEa = new Integer(1);
    private final Integer ONEb = new Integer(1);
    private Collection d_bag;

    public void setUp() {
        this.d_bag = new Bag();
    }

    public void test_containsFunctionUsingTwoDifferentInstancesOfTheSameInteger() {
        BagTest.assertTrue((boolean)this.d_bag.add(this.ONEa));
        BagTest.assertTrue((boolean)this.d_bag.contains(this.ONEa));
        BagTest.assertFalse((boolean)this.d_bag.contains(this.ONEb));
        BagTest.assertEquals((int)1, (int)this.d_bag.size());
    }

    public void test_addTheSameInstanceOfAnIntegerTwice() {
        BagTest.assertTrue((boolean)this.d_bag.add(this.ONEa));
        BagTest.assertFalse((boolean)this.d_bag.add(this.ONEa));
        BagTest.assertTrue((boolean)this.d_bag.contains(this.ONEa));
        BagTest.assertEquals((int)1, (int)this.d_bag.size());
    }

    public void test_twoDifferentInstancesOfTheSameInteger() {
        BagTest.assertTrue((boolean)this.d_bag.add(this.ONEa));
        BagTest.assertTrue((boolean)this.d_bag.add(this.ONEb));
        BagTest.assertTrue((boolean)this.d_bag.contains(this.ONEa));
        BagTest.assertTrue((boolean)this.d_bag.contains(this.ONEb));
        BagTest.assertEquals((int)2, (int)this.d_bag.size());
    }

    public void test_add100Integers() {
        for (int i = 0; i < 100; ++i) {
            BagTest.assertTrue((boolean)this.d_bag.add(i));
        }
        BagTest.assertEquals((int)100, (int)this.d_bag.size());
    }

    public void test_addTwoDifferntInstancesOfTheSameIntegerThenRemove() {
        BagTest.assertTrue((boolean)this.d_bag.add(this.ONEa));
        BagTest.assertTrue((boolean)this.d_bag.add(this.ONEb));
        BagTest.assertEquals((int)2, (int)this.d_bag.size());
        BagTest.assertTrue((boolean)this.d_bag.remove(this.ONEa));
        BagTest.assertFalse((boolean)this.d_bag.remove(this.ONEa));
        BagTest.assertTrue((boolean)this.d_bag.contains(this.ONEb));
        BagTest.assertEquals((int)1, (int)this.d_bag.size());
        BagTest.assertTrue((boolean)this.d_bag.remove(this.ONEb));
        BagTest.assertFalse((boolean)this.d_bag.remove(this.ONEb));
        BagTest.assertEquals((int)0, (int)this.d_bag.size());
    }

    public void test_add100RandomIntegersThenPrintThemOut() {
        int n;
        for (n = 0; n < 100; ++n) {
            BagTest.assertTrue((boolean)this.d_bag.add(new Integer((int)(Math.random() * 100.0))));
        }
        BagTest.assertEquals((int)this.d_bag.size(), (int)100);
        n = 0;
        for (Object e : this.d_bag) {
            ++n;
            BagTest.assertTrue((boolean)this.d_bag.contains(e));
            System.out.println(e);
        }
        BagTest.assertEquals((int)100, (int)n);
    }

    public void test_performanceOf500KObjects() {
        long l = System.nanoTime();
        for (int i = 0; i < 500000; ++i) {
            this.d_bag.add(new Object());
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        System.out.println("[Bag] 500K Objects added in :" + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        Object var7_5 = null;
        int n = 0;
        for (Object e : this.d_bag) {
            if (n == 250000) {
                var7_5 = e;
                break;
            }
            ++n;
        }
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[Bag] 250Kth Object found in: " + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        BagTest.assertTrue((boolean)this.d_bag.contains(var7_5));
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[Bag] 250Kth Object contains test in: " + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        BagTest.assertTrue((boolean)this.d_bag.remove(var7_5));
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[Bag] 250Kth Object removed in: " + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        BagTest.assertFalse((boolean)this.d_bag.contains(var7_5));
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[Bag] 250Kth Object (not) contains test in: " + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        this.d_bag.clear();
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[Bag] 499999 Objects cleared in: " + (double)l3 / 1000000.0 + " ms");
        System.out.println();
    }

    public void test_performanceOf500KObjectsOnIdentityHashSet() {
        IdentityHashSet<Object> identityHashSet = new IdentityHashSet<Object>();
        long l = System.nanoTime();
        for (int i = 0; i < 500000; ++i) {
            identityHashSet.add(new Object());
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        System.out.println("[theHashSet] 500K Objects added in :" + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        Object var8_6 = null;
        int n = 0;
        for (Object t : identityHashSet) {
            if (n == 250000) {
                var8_6 = t;
                break;
            }
            ++n;
        }
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[theHashSet] 250Kth Object found in: " + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        BagTest.assertTrue((boolean)identityHashSet.contains(var8_6));
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[theHashSet] 250Kth Object contains test in: " + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        BagTest.assertTrue((boolean)identityHashSet.remove(var8_6));
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[theHashSet] 250Kth Object removed in: " + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        BagTest.assertFalse((boolean)identityHashSet.contains(var8_6));
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[theHashSet] 250Kth Object (not) contains test in: " + (double)l3 / 1000000.0 + " ms");
        l = System.nanoTime();
        identityHashSet.clear();
        l2 = System.nanoTime();
        l3 = l2 - l;
        System.out.println("[theHashSet] 499999 Objects cleared in: " + (double)l3 / 1000000.0 + " ms");
        System.out.println();
    }
}

