/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import pyrosim.legacy_2012_1.thunderheadeng.util.DiscreteSignal;

public class AnalogSignal
extends DiscreteSignal {
    private static final long serialVersionUID = -3212429753705173290L;
    private double d_sampleInterval;
    private double[] d_data;

    protected AnalogSignal() {
    }

    @Override
    public DiscreteSignal newSignal(double d, int n) {
        return new AnalogSignal(d, n);
    }

    public AnalogSignal(double d, int n) {
        this.d_sampleInterval = d;
        this.d_data = new double[n];
    }

    public AnalogSignal(double d, double[] dArray) {
        this.d_sampleInterval = d;
        this.d_data = dArray;
    }

    public Object clone() {
        AnalogSignal analogSignal = new AnalogSignal(this.getSampleInterval(), this.getNumSamples());
        System.arraycopy(this.d_data, 0, analogSignal.d_data, 0, this.d_data.length);
        return analogSignal;
    }

    @Override
    public int getNumSamples() {
        return this.d_data.length;
    }

    @Override
    public double getSampleInterval() {
        return this.d_sampleInterval;
    }

    @Override
    public void setSample(int n, double d) {
        this.d_data[n] = d;
    }

    @Override
    public double evaluateSample(int n) {
        return this.d_data[n];
    }

    @Override
    public double[] toArray() {
        return this.d_data;
    }

    @Override
    public void resample(double d) {
        if (d == this.d_sampleInterval) {
            return;
        }
        int n = (int)Math.ceil((double)this.getNumSamples() * this.d_sampleInterval / d);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            int n2 = (int)Math.floor((double)i * this.d_sampleInterval / d);
            dArray[i] = this.evaluateSample(n2);
        }
        this.d_sampleInterval = d;
        this.d_data = dArray;
    }
}

