/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.vecmath.Point3i;
import pyrosim.legacy_2012_1.thunderheadeng.util.MergedCell;

public class AdjacencyMerger {
    public static <T> Collection<MergedCell<T>> mergeCells(T[] TArray, IMergeQuery<T> iMergeQuery) {
        ArrayList<MergedCell<T>> arrayList = new ArrayList<MergedCell<T>>();
        for (int i = 0; i < TArray.length; ++i) {
            T t = TArray[i];
            arrayList.add(new MergedCell<T>(t, i, i, 0, 0, 0, 0));
        }
        return AdjacencyMerger.mergeCells(arrayList, iMergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells(T[][] TArray, IMergeQuery<T> iMergeQuery) {
        ArrayList<MergedCell<T>> arrayList = new ArrayList<MergedCell<T>>();
        for (int i = 0; i < TArray.length; ++i) {
            T[] TArray2 = TArray[i];
            for (int j = 0; j < TArray2.length; ++j) {
                T t = TArray2[j];
                arrayList.add(new MergedCell<T>(t, j, j, i, i, 0, 0));
            }
        }
        return AdjacencyMerger.mergeCells(arrayList, iMergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells(T[][][] TArray, IMergeQuery<T> iMergeQuery) {
        ArrayList<MergedCell<T>> arrayList = new ArrayList<MergedCell<T>>();
        for (int i = 0; i < TArray.length; ++i) {
            T[][] TArray2 = TArray[i];
            for (int j = 0; j < TArray2.length; ++j) {
                T[] TArray3 = TArray2[j];
                for (int k = 0; k < TArray3.length; ++k) {
                    T t = TArray3[k];
                    arrayList.add(new MergedCell<T>(t, k, k, j, j, i, i));
                }
            }
        }
        return AdjacencyMerger.mergeCells(arrayList, iMergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells2(Map<Point3i, T> map, IMergeQuery<T> iMergeQuery) {
        ArrayList<MergedCell<T>> arrayList = new ArrayList<MergedCell<T>>();
        for (Map.Entry<Point3i, T> entry : map.entrySet()) {
            Point3i point3i = entry.getKey();
            arrayList.add(new MergedCell<T>(entry.getValue(), point3i.x, point3i.x, point3i.y, point3i.y, point3i.z, point3i.z));
        }
        return AdjacencyMerger.mergeCells(arrayList, iMergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells3(Map<T, Collection<Point3i>> map, IMergeQuery<T> iMergeQuery) {
        ArrayList<MergedCell<T>> arrayList = new ArrayList<MergedCell<T>>();
        for (Map.Entry<T, Collection<Point3i>> entry : map.entrySet()) {
            for (Point3i point3i : entry.getValue()) {
                arrayList.add(new MergedCell<T>(entry.getKey(), point3i.x, point3i.x, point3i.y, point3i.y, point3i.z, point3i.z));
            }
        }
        return AdjacencyMerger.mergeCells(arrayList, iMergeQuery);
    }

    public static <T> Collection<MergedCell<T>> mergeCells(Collection<MergedCell<T>> collection, IMergeQuery<T> iMergeQuery) {
        Collection<MergedCell<T>> collection2 = AdjacencyMerger.mergeCells(collection, new PointComp(), new ZRunComp(), new ZRunMerger(), iMergeQuery, Dir.Z);
        collection = null;
        Collection<MergedCell<T>> collection3 = AdjacencyMerger.mergeCells(collection2, null, new XZRunComp(), new XZRunMerger(), iMergeQuery, Dir.X);
        collection2 = null;
        Collection<MergedCell<T>> collection4 = AdjacencyMerger.mergeCells(collection3, null, null, new XYZRunMerger(), iMergeQuery, Dir.Y);
        collection3 = null;
        return collection4;
    }

    private static <T> Collection<MergedCell<T>> mergeCells(Collection<MergedCell<T>> collection, Comparator<MergedCell<T>> comparator, Comparator<MergedCell<T>> comparator2, Merger<T> merger, IMergeQuery<T> iMergeQuery, Dir dir) {
        Collection<MergedCell<MergedCell>> collection2;
        if (comparator != null) {
            collection2 = new TreeSet<MergedCell<T>>(comparator);
            collection2.addAll(collection);
        } else {
            collection2 = collection;
        }
        MergedCell[] mergedCellArray = collection2.toArray(new MergedCell[collection2.size()]);
        AbstractCollection abstractCollection = comparator2 != null ? new TreeSet<MergedCell<T>>(comparator2) : new ArrayList();
        int n = 0;
        while (n < mergedCellArray.length) {
            T t;
            MergedCell mergedCell;
            int n2;
            MergedCell mergedCell2 = mergedCellArray[n];
            MergedCell<T> mergedCell3 = merger.init(mergedCell2);
            for (n2 = n + 1; n2 < mergedCellArray.length && merger.areCellsAdjacent(mergedCell3, mergedCell = mergedCellArray[n2]) && (t = iMergeQuery.merge(mergedCell3.val, mergedCell.val, dir)) != null; ++n2) {
                mergedCell3 = merger.merge(mergedCell3, mergedCell);
                mergedCell3.val = t;
            }
            abstractCollection.add(mergedCell3);
            n = n2;
        }
        return abstractCollection;
    }

    private static class XYZRunMerger<T>
    implements Merger<T> {
        private XYZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell<T> mergedCell, MergedCell<T> mergedCell2) {
            return mergedCell.x1 == mergedCell2.x1 && mergedCell.x2 == mergedCell2.x2 && mergedCell.z1 == mergedCell2.z1 && mergedCell.z2 == mergedCell2.z2 && mergedCell.y2 == mergedCell2.y1 - 1;
        }

        @Override
        public MergedCell<T> init(MergedCell<T> mergedCell) {
            return new MergedCell(mergedCell.val, mergedCell.x1, mergedCell.x2, mergedCell.y1, mergedCell.y1, mergedCell.z1, mergedCell.z2);
        }

        @Override
        public MergedCell<T> merge(MergedCell<T> mergedCell, MergedCell<T> mergedCell2) {
            mergedCell.y2 = mergedCell2.y1;
            return mergedCell;
        }
    }

    private static class XZRunMerger<T>
    implements Merger<T> {
        private XZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell<T> mergedCell, MergedCell<T> mergedCell2) {
            return mergedCell.y1 == mergedCell2.y1 && mergedCell.z1 == mergedCell2.z1 && mergedCell.z2 == mergedCell2.z2 && mergedCell.x2 == mergedCell2.x1 - 1;
        }

        @Override
        public MergedCell<T> init(MergedCell<T> mergedCell) {
            return new MergedCell(mergedCell.val, mergedCell.x1, mergedCell.x1, mergedCell.y1, mergedCell.y1, mergedCell.z1, mergedCell.z2);
        }

        @Override
        public MergedCell<T> merge(MergedCell<T> mergedCell, MergedCell<T> mergedCell2) {
            mergedCell.x2 = mergedCell2.x1;
            return mergedCell;
        }
    }

    private static class ZRunMerger<T>
    implements Merger<T> {
        private ZRunMerger() {
        }

        @Override
        public boolean areCellsAdjacent(MergedCell<T> mergedCell, MergedCell<T> mergedCell2) {
            return mergedCell.x1 == mergedCell2.x1 && mergedCell.y1 == mergedCell2.y1 && mergedCell.z2 == mergedCell2.z1 - 1;
        }

        @Override
        public MergedCell<T> init(MergedCell<T> mergedCell) {
            return new MergedCell(mergedCell.val, mergedCell.x1, mergedCell.x1, mergedCell.y1, mergedCell.y1, mergedCell.z1, mergedCell.z1);
        }

        @Override
        public MergedCell<T> merge(MergedCell<T> mergedCell, MergedCell<T> mergedCell2) {
            mergedCell.z2 = mergedCell2.z1;
            return mergedCell;
        }
    }

    private static class XZRunComp<T>
    implements Comparator<MergedCell<T>> {
        private XZRunComp() {
        }

        @Override
        public int compare(MergedCell<T> mergedCell, MergedCell<T> mergedCell2) {
            int n = mergedCell.x1 - mergedCell2.x1;
            if (n != 0) {
                return n;
            }
            int n2 = mergedCell.x2 - mergedCell.x1 + 1;
            int n3 = mergedCell2.x2 - mergedCell2.x1 + 1;
            int n4 = n2 - n3;
            if (n4 != 0) {
                return n4;
            }
            int n5 = mergedCell.z1 - mergedCell2.z1;
            if (n5 != 0) {
                return n5;
            }
            int n6 = mergedCell.z2 - mergedCell.z1 + 1;
            int n7 = mergedCell2.z2 - mergedCell2.z1 + 1;
            int n8 = n6 - n7;
            if (n8 != 0) {
                return n8;
            }
            return mergedCell.y1 - mergedCell2.y1;
        }
    }

    private static class ZRunComp<T>
    implements Comparator<MergedCell<T>> {
        private ZRunComp() {
        }

        @Override
        public int compare(MergedCell<T> mergedCell, MergedCell<T> mergedCell2) {
            int n = mergedCell.y1 - mergedCell2.y1;
            if (n != 0) {
                return n;
            }
            int n2 = mergedCell.z1 - mergedCell2.z1;
            if (n2 != 0) {
                return n2;
            }
            int n3 = mergedCell.z2 - mergedCell.z1 + 1;
            int n4 = mergedCell2.z2 - mergedCell2.z1 + 1;
            int n5 = n3 - n4;
            if (n5 != 0) {
                return n5;
            }
            return mergedCell.x1 - mergedCell2.x1;
        }
    }

    private static class PointComp<T>
    implements Comparator<MergedCell<T>> {
        private PointComp() {
        }

        @Override
        public int compare(MergedCell<T> mergedCell, MergedCell<T> mergedCell2) {
            int n = mergedCell.y1 - mergedCell2.y1;
            if (n != 0) {
                return n;
            }
            int n2 = mergedCell.x1 - mergedCell2.x1;
            if (n2 != 0) {
                return n2;
            }
            return mergedCell.z1 - mergedCell2.z1;
        }
    }

    private static interface Merger<T> {
        public MergedCell<T> init(MergedCell<T> var1);

        public boolean areCellsAdjacent(MergedCell<T> var1, MergedCell<T> var2);

        public MergedCell<T> merge(MergedCell<T> var1, MergedCell<T> var2);
    }

    public static interface IMergeQuery<T> {
        public T merge(T var1, T var2, Dir var3);
    }

    public static enum Dir {
        X,
        Y,
        Z;

    }
}

