/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import pyrosim.Intl;
import pyrosim.legacy_2012_1.thunderheadeng.util.ValueRange;

public abstract class AbstractValueRange<T extends Comparable>
implements ValueRange<T> {
    private T d_min;
    private T d_max;
    private boolean d_minInclusive;
    private boolean d_maxInclusive;
    private boolean d_checkMin = false;
    private boolean d_checkMax = false;

    public abstract String format(Object var1);

    protected AbstractValueRange(T t, T t2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.d_min = t;
        this.d_max = t2;
        this.d_minInclusive = bl3;
        this.d_maxInclusive = bl4;
        this.d_checkMin = bl;
        this.d_checkMax = bl2;
    }

    @Override
    public boolean isMinInclusive() {
        return this.d_minInclusive;
    }

    @Override
    public boolean isMaxInclusive() {
        return this.d_maxInclusive;
    }

    @Override
    public T getMinValue() {
        return this.d_min;
    }

    @Override
    public void setMinValue(T t) {
        this.d_min = t;
    }

    @Override
    public T getMaxValue() {
        return this.d_max;
    }

    @Override
    public void setMaxValue(T t) {
        this.d_max = t;
    }

    @Override
    public boolean checksMin() {
        return this.d_checkMin;
    }

    @Override
    public boolean checksMax() {
        return this.d_checkMax;
    }

    @Override
    public boolean checkValue(T t) {
        boolean bl = true;
        boolean bl2 = true;
        if (this.d_checkMin) {
            if (this.d_minInclusive) {
                bl = t.compareTo(this.d_min) >= 0;
            } else {
                boolean bl3 = bl = t.compareTo(this.d_min) > 0;
            }
        }
        if (this.d_checkMax) {
            bl2 = this.d_maxInclusive ? t.compareTo(this.d_max) <= 0 : t.compareTo(this.d_max) < 0;
        }
        return bl && bl2;
    }

    @Override
    public boolean shouldFilter(T t) {
        return !this.checkValue(t);
    }

    protected T clampMinIncl(T t) {
        return this.d_min;
    }

    protected T clampMinUnincl(T t) {
        return null;
    }

    protected T clampMaxIncl(T t) {
        return this.d_max;
    }

    protected T clampMaxUnincl(T t) {
        return null;
    }

    @Override
    public T clampValue(T t) {
        int n;
        if (this.d_checkMin) {
            n = t.compareTo(this.d_min);
            if (this.d_minInclusive && n < 0) {
                return this.clampMinIncl(t);
            }
            if (!this.d_minInclusive && n <= 0) {
                return this.clampMinUnincl(t);
            }
        }
        if (this.d_checkMax) {
            n = t.compareTo(this.d_max);
            if (this.d_maxInclusive && n > 0) {
                return this.clampMaxIncl(t);
            }
            if (!this.d_maxInclusive && n >= 0) {
                return this.clampMaxUnincl(t);
            }
        }
        return t;
    }

    public String describeError(String string) {
        return String.format(Intl.intl("%s must be %s"), string, this.toString());
    }

    @Override
    public String describeRange() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.d_checkMin && this.d_checkMax) {
            if (this.d_minInclusive && this.d_maxInclusive) {
                return String.format(Intl.intl("The value must lie in the range: %s <= x <= %s"), this.format(this.d_min), this.format(this.d_max));
            }
            if (this.d_minInclusive) {
                return String.format(Intl.intl("The value must lie in the range: %s <= x < %s"), this.format(this.d_min), this.format(this.d_max));
            }
            if (this.d_maxInclusive) {
                return String.format(Intl.intl("The value must lie in the range: %s < x <= %s"), this.format(this.d_min), this.format(this.d_max));
            }
            return String.format(Intl.intl("The value must lie in the range: %s < x < %s"), this.format(this.d_min), this.format(this.d_max));
        }
        if (this.d_checkMin) {
            if (this.d_minInclusive) {
                return String.format(Intl.intl("The value must lie in the range: x >= %s"), this.format(this.d_min));
            }
            return String.format(Intl.intl("The value must lie in the range: x > %s"), this.format(this.d_min));
        }
        if (this.d_checkMax) {
            if (this.d_maxInclusive) {
                return String.format(Intl.intl("The value must lie in the range: x <= %s"), this.format(this.d_max));
            }
            return String.format(Intl.intl("The value must lie in the range: x < %s"), this.format(this.d_max));
        }
        return Intl.intl("Any value is allowed.");
    }
}

