/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.units;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.AABox;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.LineSeg3D;
import pyrosim.legacy_2012_1.thunderheadeng.units.GeomUtil;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;

public class UnitLineSeg3D
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public final double p1x;
    public final double p1y;
    public final double p1z;
    public final double p2x;
    public final double p2y;
    public final double p2z;
    public final Unit unit;

    public UnitLineSeg3D(double d, double d2, double d3, double d4, double d5, double d6, Unit unit) {
        this.p1x = d;
        this.p1y = d2;
        this.p1z = d3;
        this.p2x = d4;
        this.p2y = d5;
        this.p2z = d6;
        this.unit = unit;
    }

    public UnitLineSeg3D(Point3d point3d, Point3d point3d2, Unit unit) {
        this(point3d.x, point3d.y, point3d.z, point3d2.x, point3d2.y, point3d2.z, unit);
    }

    public UnitLineSeg3D(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2) {
        this(unitPoint3D.getPoint3dValue(unitPoint3D.getUnit()), unitPoint3D2.getPoint3dValue(unitPoint3D.getUnit()), unitPoint3D.getUnit());
    }

    public UnitLineSeg3D(LineSeg3D lineSeg3D, Unit unit) {
        this(lineSeg3D.getP1(), lineSeg3D.getP2(), unit);
    }

    public Point3d getP1(Unit unit) {
        Converter converter = this.unit.getConverterTo(unit);
        return new Point3d(converter.convert(this.p1x), converter.convert(this.p1y), converter.convert(this.p1z));
    }

    public Point3d getP2(Unit unit) {
        Converter converter = this.unit.getConverterTo(unit);
        return new Point3d(converter.convert(this.p2x), converter.convert(this.p2y), converter.convert(this.p2z));
    }

    public UnitPoint3D getP1() {
        return new UnitPoint3D(this.p1x, this.p1y, this.p1z, this.unit);
    }

    public UnitPoint3D getP2() {
        return new UnitPoint3D(this.p2x, this.p2y, this.p2z, this.unit);
    }

    public LineSeg3D getValue(Unit unit) {
        Converter converter = this.unit.getConverterTo(unit);
        return new LineSeg3D(new Point3d(converter.convert(this.p1x), converter.convert(this.p1y), converter.convert(this.p1z)), new Point3d(converter.convert(this.p2x), converter.convert(this.p2y), converter.convert(this.p2z)));
    }

    public UnitLineSeg3D transform(Matrix4d matrix4d) {
        UnitPoint3D unitPoint3D = GeomUtil.xform(matrix4d, this.getP1());
        UnitPoint3D unitPoint3D2 = GeomUtil.xform(matrix4d, this.getP2());
        return new UnitLineSeg3D(unitPoint3D, unitPoint3D2);
    }

    public Object clone() {
        try {
            UnitLineSeg3D unitLineSeg3D = (UnitLineSeg3D)super.clone();
            return unitLineSeg3D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnitLineSeg3D)) {
            return false;
        }
        UnitLineSeg3D unitLineSeg3D = (UnitLineSeg3D)object;
        return this.getP1().equals(unitLineSeg3D.getP1()) && this.getP2().equals(unitLineSeg3D.getP2());
    }

    public int hashCode() {
        return -2089245877 + this.getP1().hashCode() + this.getP2().hashCode();
    }

    public UnitAABox getBounds() {
        AABox aABox = new AABox();
        this.getBounds(aABox, SI.METER);
        return new UnitAABox(aABox, SI.METER);
    }

    public void getBounds(AABox aABox, Unit unit) {
        aABox.add(this.getP1(unit), this.getP2(unit));
    }
}

