/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.units;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jscience.physics.units.ConversionException;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class UnitDouble
implements Serializable,
Comparable,
ILegacy_2012_1 {
    static final long serialVersionUID = 1L;
    private final double d_value;
    private final Unit d_unit;

    public UnitDouble(double d, Unit unit) throws ConversionException {
        this.d_value = d;
        this.d_unit = unit;
    }

    @Override
    public thunderheadeng.units.UnitDouble fromLegacy(LegacyDictionary_2012_1 legacyDictionary_2012_1) {
        return new thunderheadeng.units.UnitDouble(this.d_value, this.d_unit);
    }

    public UnitDouble reinterpret(Unit unit) {
        return this.isCompatible(unit) ? this : new UnitDouble(this.d_value, unit);
    }

    public UnitDouble convert(Unit unit) throws ConversionException {
        return UnitDouble.from(this.d_value, this.d_unit, unit);
    }

    public static UnitDouble from(double d, Unit unit, Unit unit2) {
        return new UnitDouble(UnitDouble.convert(d, unit, unit2), unit2);
    }

    public static UnitDouble maxValue(Unit unit) {
        return new UnitDouble(Double.MAX_VALUE, unit);
    }

    public static UnitDouble maxNegValue(Unit unit) {
        return new UnitDouble(-1.7976931348623157E308, unit);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.d_value);
    }

    public boolean isCompatible(Unit unit) {
        return UnitDouble.areCompatible(this.d_unit, unit);
    }

    public double getValue(Unit unit) throws ConversionException {
        double d = 0.0;
        if (this.d_unit == unit) {
            d = this.d_value;
        } else if (UnitDouble.areCompatible(this.d_unit, unit)) {
            d = this.d_unit.getConverterTo(unit).convert(this.d_value);
        } else {
            throw UnitDouble.formatError(this.d_unit, unit);
        }
        return d;
    }

    public double getValueNoUnit() {
        return this.d_value;
    }

    public Unit getUnit() {
        return this.d_unit;
    }

    public static double convert(double d, Unit unit, Unit unit2) throws ConversionException {
        if (unit.equals(unit2)) {
            return d;
        }
        if (UnitDouble.areCompatible(unit, unit2)) {
            return unit.getConverterTo(unit2).convert(d);
        }
        throw UnitDouble.formatError(unit, unit2);
    }

    public UnitDouble diff(UnitDouble unitDouble) {
        if (this.d_unit == unitDouble.d_unit) {
            double d = Math.abs(this.d_value - unitDouble.d_value);
            return new UnitDouble(d, this.d_unit);
        }
        if (this.d_unit == null && unitDouble.d_unit != null) {
            double d = Math.abs(this.d_value - unitDouble.d_value);
            return new UnitDouble(d, unitDouble.d_unit);
        }
        if (this.d_unit != null && unitDouble.d_unit == null) {
            double d = Math.abs(this.d_value - unitDouble.d_value);
            return new UnitDouble(d, this.d_unit);
        }
        if (this.d_unit == null && unitDouble.d_unit == null) {
            double d = Math.abs(this.d_value - unitDouble.d_value);
            return new UnitDouble(d, null);
        }
        Unit unit = unitDouble.getUnit();
        Converter converter = unit.getConverterTo(this.d_unit);
        double d = converter.convert(unitDouble.d_value);
        double d2 = Math.abs(this.d_value - d);
        return new UnitDouble(d2, this.d_unit);
    }

    public UnitDouble add(UnitDouble unitDouble) throws ConversionException {
        return this.add(unitDouble.d_value, unitDouble.d_unit);
    }

    protected UnitDouble add(double d, Unit unit) throws ConversionException {
        double d2;
        if (this.d_unit == unit) {
            d2 = this.d_value + d;
        } else if (UnitDouble.areCompatible(this.d_unit, unit)) {
            d2 = this.d_value + unit.getConverterTo(this.d_unit).convert(d);
        } else {
            throw UnitDouble.formatError(this.d_unit, unit);
        }
        return new UnitDouble(d2, this.d_unit);
    }

    public UnitDouble sub(UnitDouble unitDouble) throws ConversionException {
        return this.add(-unitDouble.d_value, unitDouble.d_unit);
    }

    public UnitDouble multiply(UnitDouble unitDouble) {
        return new UnitDouble(this.d_value * unitDouble.d_value, this.d_unit.multiply(unitDouble.d_unit));
    }

    public UnitDouble divide(UnitDouble unitDouble) {
        return new UnitDouble(this.d_value / unitDouble.d_value, this.d_unit.divide(unitDouble.d_unit));
    }

    public UnitDouble scale(double d) {
        return new UnitDouble(this.d_value * d, this.d_unit);
    }

    public UnitDouble abs() {
        return new UnitDouble(Math.abs(this.d_value), this.d_unit);
    }

    public UnitDouble negate() {
        return new UnitDouble(-this.d_value, this.d_unit);
    }

    public static UnitDouble min(UnitDouble unitDouble, UnitDouble unitDouble2) throws ConversionException {
        UnitDouble unitDouble3;
        Unit unit;
        Unit unit2 = unitDouble.getUnit();
        if (unit2 == (unit = unitDouble2.getUnit())) {
            unitDouble3 = unitDouble.getValue(unit2) < unitDouble2.getValue(unit) ? unitDouble : unitDouble2;
        } else if (UnitDouble.areCompatible(unit2, unit)) {
            unitDouble3 = unitDouble.getValue(unit2) < unit.getConverterTo(unit2).convert(unitDouble2.getValue(unit)) ? unitDouble : unitDouble2;
        } else {
            throw UnitDouble.formatError(unit2, unit);
        }
        return unitDouble3;
    }

    public static UnitDouble max(UnitDouble unitDouble, UnitDouble unitDouble2) throws ConversionException {
        UnitDouble unitDouble3;
        Unit unit;
        Unit unit2 = unitDouble.getUnit();
        if (unit2 == (unit = unitDouble2.getUnit())) {
            unitDouble3 = unitDouble.getValue(unit2) > unitDouble2.getValue(unit) ? unitDouble : unitDouble2;
        } else if (UnitDouble.areCompatible(unit2, unit)) {
            unitDouble3 = unitDouble.getValue(unit2) > unit.getConverterTo(unit2).convert(unitDouble2.getValue(unit)) ? unitDouble : unitDouble2;
        } else {
            throw UnitDouble.formatError(unit2, unit);
        }
        return unitDouble3;
    }

    public int compareTo(Object object) throws ConversionException {
        int n;
        UnitDouble unitDouble = (UnitDouble)object;
        Unit unit = unitDouble.getUnit();
        if (this.d_unit == unit) {
            n = Double.compare(this.d_value, unitDouble.d_value);
        } else if (UnitDouble.areCompatible(this.d_unit, unit)) {
            n = Double.compare(this.d_value, unit.getConverterTo(this.d_unit).convert(unitDouble.d_value));
        } else {
            throw UnitDouble.formatError(this.d_unit, unit);
        }
        return n;
    }

    private static ConversionException formatError(Unit unit, Unit unit2) {
        String string = String.format(Intl.intl("Cannot convert from %1$s to %2$s."), unit, unit2);
        throw new ConversionException(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof UnitDouble)) {
            return false;
        }
        UnitDouble unitDouble = (UnitDouble)object;
        if (!UnitDouble.areCompatible(this.d_unit, unitDouble.d_unit)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return UnitDouble.hashCode(this.d_value, this.d_unit);
    }

    public static int hashCode(double d, Unit unit) {
        Unit unit2 = unit.getSystemUnit();
        double d2 = unit.getConverterTo(unit2).convert(d);
        return theUtil.hashCode(d2);
    }

    public boolean tolEquals(UnitDouble unitDouble) {
        if (unitDouble == null) {
            return false;
        }
        double d = this.d_value;
        double d2 = UnitDouble.convert(unitDouble.getValue(unitDouble.getUnit()), unitDouble.getUnit(), this.getUnit());
        double d3 = Math.abs(d - d2);
        if (d3 == 0.0) {
            return true;
        }
        double d4 = Math.abs(Math.min(d, d2) / 1000000.0);
        return d3 <= d4;
    }

    public boolean epsilonEquals(UnitDouble unitDouble, double d) {
        if (unitDouble == null) {
            return false;
        }
        double d2 = this.d_value;
        double d3 = UnitDouble.convert(unitDouble.getValue(unitDouble.getUnit()), unitDouble.getUnit(), this.getUnit());
        return Math.abs(d2 - d3) <= d;
    }

    public String format(NumberFormat numberFormat) {
        return numberFormat.format(this.d_value) + " " + this.d_unit;
    }

    public String toString() {
        return this.d_value + " " + this.d_unit;
    }

    public static boolean areCompatible(Unit unit, Unit unit2) {
        if (!unit.isCompatible(unit2)) {
            return false;
        }
        try {
            unit.getConverterTo(unit2);
        }
        catch (ConversionException conversionException) {
            return false;
        }
        return true;
    }
}

